START TRANSACTION;
INSERT INTO `role` (`roleid`,`name`,`type`,`readonly`) values ('1','User role','1','0');
INSERT INTO `role` (`roleid`,`name`,`type`,`readonly`) values ('2','Admin role','2','0');
INSERT INTO `role` (`roleid`,`name`,`type`,`readonly`) values ('3','Super admin role','3','1');
INSERT INTO `role` (`roleid`,`name`,`type`,`readonly`) values ('4','Guest role','1','0');
INSERT INTO `users` (`userid`,`alias`,`name`,`surname`,`passwd`,`url`,`autologin`,`autologout`,`refresh`,`rows_per_page`,`roleid`) values ('1','Admin','Zabbix','Administrator','$2y$10$92nDno4n0Zm7Ej7Jfsz8WukBfgSS/U0QkIuu8WkJPihXBb2A1UrEK','','1','0','30s','50','3');
INSERT INTO `users` (`userid`,`alias`,`name`,`surname`,`passwd`,`url`,`autologin`,`autologout`,`refresh`,`rows_per_page`,`roleid`) values ('2','guest','','','$2y$10$89otZrRNmde97rIyzclecuk6LwKAsHN0BcvoOKGjbT.BwMBfm7G06','','0','15m','30s','50','4');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('1','Templates','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('2','Linux servers','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('4','Zabbix servers','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('5','Discovered hosts','1','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('6','Virtual machines','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('7','Hypervisors','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('8','Templates/Modules','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('9','Templates/Network devices','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('10','Templates/Operating systems','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('11','Templates/Server hardware','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('12','Templates/Applications','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('13','Templates/Databases','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('14','Templates/Virtualization','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('15','Templates/Telephony','0','0');
INSERT INTO `hstgrp` (`groupid`,`name`,`internal`,`flags`) values ('16','Templates/SAN','0','0');
INSERT INTO `drules` (`druleid`,`proxy_hostid`,`name`,`iprange`,`delay`,`status`) values ('2',NULL,'Local network','192.168.0.1-254','1h','1');
INSERT INTO `dchecks` (`dcheckid`,`druleid`,`type`,`key_`,`snmp_community`,`ports`,`snmpv3_securityname`,`snmpv3_securitylevel`,`snmpv3_authpassphrase`,`snmpv3_privpassphrase`,`uniq`,`snmpv3_authprotocol`,`snmpv3_privprotocol`,`snmpv3_contextname`,`host_source`,`name_source`) values ('2','2','9','system.uname','','10050','','0','','','0','0','0','','1','0');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('1','0','Email','mail.example.com','example.com','zabbix@example.com','','','','','0','25','0','0','0','0','','1','3','10s','0','','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('3','2','SMS','','','','','/dev/ttyS0','','','0','25','0','0','0','0','','1','3','10s','1','','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('4','0','Email (HTML)','mail.example.com','example.com','zabbix@example.com','','','','','0','25','0','0','0','0','','1','3','10s','1','','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('5','4','Mattermost','','','','','','','','0','25','0','0','0','0','','1','1','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', \'#7499FF\', \'#FFC859\',\r\n    \'#FFA059\', \'#E97659\', \'#E45959\'\r\n];\r\n\r\nvar RESOLVE_COLOR = \'#009900\';\r\n\r\nvar SEND_MODE_HANDLERS = {\r\n    alarm: handlerAlarm,\r\n    event: handlerEvent\r\n};\r\n\r\nif (!String.prototype.format) {\r\n    String.prototype.format = function() {\r\n        var args = arguments;\r\n\r\n        return this.replace(/{(\\d+)}/g, function(match, number) {\r\n            return number in args\r\n                ? args[number]\r\n                : match\r\n            ;\r\n        });\r\n    };\r\n}\r\n\r\nfunction isEventProblem(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 0\r\n    ;\r\n}\r\n\r\nfunction isEventUpdate(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 1\r\n    ;\r\n}\r\n\r\nfunction isEventResolve(params) {\r\n    return params.event_value == 0;\r\n}\r\n\r\nfunction getPermalink(mattermost_url, team_name, postid) {\r\n    return \'{0}/{1}/pl/{2}\'.format(\r\n        mattermost_url.replace(/\\/+$/, \'\'),\r\n        team_name,\r\n        postid\r\n    );\r\n}\r\n\r\nfunction getChannel(send_to) {\r\n    switch (true) {\r\n        case /.+\\/#.+/.test(send_to):\r\n            return getChannelByName(send_to);\r\n\r\n        case /@.+/.test(send_to):\r\n            return getDirectChannel(send_to);\r\n\r\n        default:\r\n            return getChannelByID(send_to);\r\n    }\r\n}\r\n\r\nfunction getChannelByName(send_to) {\r\n    var team_chan = send_to\r\n        .trim()\r\n        .split(\'/#\');\r\n\r\n    var resp = JSON.parse(req.Get(\r\n        Mattermost.channel_byname.format(team_chan[0], team_chan[1]),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    if (req.Status() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getDirectChannel(send_to) {\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var teamUser = send_to\r\n            .trim()\r\n            .split(\'/@\'),\r\n        bot = getBotUser(),\r\n        user = getUserByName(teamUser[1]);\r\n\r\n    var resp = JSON.parse(req.Post(\r\n        Mattermost.direct_channel,\r\n        JSON.stringify([bot.id, user.id])\r\n    )\r\n    );\r\n\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.Status() != 201) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    resp.team_name = teamUser[0];\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getChannelByID(channelID) {\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.Get(\r\n        Mattermost.get_channel.format(channelID),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.Status() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getBotUser() {\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.Get(\r\n        Mattermost.bot_user,\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.Status() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getUserByName(userName) {\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.Get(\r\n        Mattermost.user_byname.format(userName),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.Status() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getTeamByID(teamID) {\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.Get(\r\n        Mattermost.get_team.format(teamID),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.Log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.Status() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction createProblemURL(zabbix_url, triggerid, eventid, event_source) {\r\n    var problem_url = \'\';\r\n    if (event_source === \'0\') {\r\n        problem_url = \'{0}/tr_events.php?triggerid={1}&eventid={2}\'\r\n            .format(\r\n                zabbix_url,\r\n                triggerid,\r\n                eventid\r\n            );\r\n    }\r\n    else {\r\n        problem_url = zabbix_url;\r\n    }\r\n\r\n    return problem_url;\r\n}\r\n\r\nfunction getTagValue(event_tags, key) {\r\n    var pattern = new RegExp(\'(\' + key + \':.+)\');\r\n    var tagValue = event_tags\r\n        .split(\',\')\r\n        .filter(function (v) {\r\n            return v.match(pattern);\r\n        })\r\n        .map(function (v) {\r\n            return v.split(\':\')[1];\r\n        })[0]\r\n        || 0;\r\n\r\n    return tagValue;\r\n}\r\n\r\nfunction handlerAlarm(req, params) {\r\n    var channel = getChannel(params.send_to);\r\n    var fields = {\r\n        channel_id: channel.id,\r\n        props: {}\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        var team_name = channel.team_name\r\n            ? channel.team_name\r\n            : getTeamByID(channel.team_id).name;\r\n\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.Post(\r\n            Mattermost.post_message,\r\n            JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.Status() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n        result.tags.__mattermost_post_id = resp.id;\r\n        result.tags.__mattermost_channel_id = channel.id;\r\n        result.tags.__mattermost_channel_name = channel.name;\r\n        result.tags.__mattermost_message_link = getPermalink(\r\n            params.mattermost_url,\r\n            team_name,\r\n            resp.id\r\n        );\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.root_id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n\r\n        if (params.event_source === \'0\') {}\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                true\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(\r\n            Mattermost.post_message, JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.Status() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.channel_id = getTagValue(params.event_tags, \'mattermost_channel_id\');\r\n        fields.id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var post_id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n\r\n        resp = JSON.parse(req.Put(\r\n            Mattermost.chat_update.format(post_id),\r\n            JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.Status() != 200) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n    }\r\n}\r\n\r\nfunction handlerEvent(req, params) {\r\n    var channel = getChannel(params.send_to);\r\n    var fields = {\r\n        channel_id: channel.id,\r\n        props: {}\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        var team_name = channel.team_name\r\n            ? channel.team_name\r\n            : getTeamByID(channel.team_id).name;\r\n\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.Post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.Status() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n        result.tags.__mattermost_channel_name = channel.name;\r\n        result.tags.__mattermost_message_link = getPermalink(\r\n            params.mattermost_url,\r\n            team_name,\r\n            resp.id\r\n        );\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                false\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.Status() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_recovery_date,\r\n                params.event_recovery_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.Status() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n    }\r\n}\r\n\r\nfunction createMessage(\r\n    event_severity_color,\r\n    event_date,\r\n    event_time,\r\n    problem_url,\r\n    isShort\r\n) {\r\n    var message = {\r\n        fallbac: params.alert_subject,\r\n        title: params.alert_subject,\r\n        color: event_severity_color,\r\n        title_link: problem_url,\r\n        footer: problem_url,\r\n\r\n        fields: [\r\n            {\r\n                title: \'Host\',\r\n                value: \'{0} [{1}]\'.format(params.host_name, params.host_ip),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Event time\',\r\n                value: \'{0} {1}\'.format(event_date, event_time),\r\n                short: true\r\n            }\r\n        ],\r\n    };\r\n\r\n    \r\n    if (params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Severity\',\r\n                value: params.event_severity,\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Opdata\',\r\n                value: params.event_opdata,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (!isShort && params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Event tags\',\r\n                value: \'`{0}`\'.format(params.event_tags.replace(/__.+?:(.+?,|.+)/g, \'\') || \'None\'),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Trigger description\',\r\n                value: params.trigger_description,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (params.event_source !== \'0\' || params.event_update_status === \'1\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Details\',\r\n                value: params.alert_message,\r\n                short: false\r\n            }\r\n        );\r\n    }\r\n\r\n    return message;\r\n}\r\n\r\nfunction validateParams(params) {\r\n    if (typeof params.bot_token !== \'string\' || params.bot_token.trim() === \'\') {\r\n        throw \'Field "bot_token" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.event_id)) {\r\n        throw \'Field "event_id" is not a number\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\') {\r\n        params.event_nseverity = \'0\';\r\n        params.event_severity = \'Not classified\';\r\n        params.event_update_status = \'0\';\r\n        params.send_mode = \'event\';\r\n    }\r\n\r\n    if (params.event_source === \'1\' || params.event_source === \'2\') {\r\n        params.event_value = \'1\';\r\n    }\r\n\r\n    if (params.event_source === \'1\') {\r\n        params.host_name = params.discovery_host_dns;\r\n        params.host_ip = params.discovery_host_ip;\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    if (typeof params.event_severity !== \'string\' || params.event_severity.trim() === \'\') {\r\n        throw \'Field "event_severity" cannot be empty\';\r\n    }\r\n\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (typeof params.host_ip !== \'string\' || params.host_ip.trim() === \'\') {\r\n        throw \'Field "host_ip" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.host_name !== \'string\' || params.host_name.trim() === \'\') {\r\n        throw \'Field "host_name" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.mattermost_url !== \'string\' || params.mattermost_url.trim() === \'\') {\r\n        throw \'Field "mattermost_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.mattermost_url)) {\r\n        throw \'Field "mattermost_url" must contain a schema\';\r\n    }\r\n\r\n    if ([\'alarm\', \'event\'].indexOf(params.send_mode) === -1) {\r\n        throw \'Incorrect "send_mode" parameter given: \' + params.send_mode + \'\\nMust be "alarm" or "event".\';\r\n    }\r\n\r\n    if (typeof params.send_to !== \'string\' || params.send_to.trim() === \'\') {\r\n        throw \'Field "send_to" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.trigger_id) && params.event_source === \'0\') {\r\n        throw \'field "trigger_id" is not a number\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\') {\r\n        throw \'Field "zabbix_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {\r\n        throw \'Field "zabbix_url" must contain a schema\';\r\n    }\r\n\r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    validateParams(params);\r\n\r\n    var req = new CurlHttpRequest(),\r\n        fields = {},\r\n        result = {tags: {}};\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.AddHeader(\'Content-Type: application/json; charset=utf-8\');\r\n    req.AddHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    params.mattermost_url = params.mattermost_url.replace(/\\/+$/, \'\');\r\n    params.zabbix_url = params.zabbix_url.replace(/\\/+$/, \'\');\r\n\r\n    var APIEndpoint = params.mattermost_url + \'/api/v4/\';\r\n\r\n    var Mattermost = {\r\n        post_message: APIEndpoint + \'posts\',\r\n        get_channel: APIEndpoint + \'channels/{0}\',\r\n        get_team: APIEndpoint + \'teams/{0}\',\r\n        chat_update: APIEndpoint + \'posts/{0}\',\r\n        direct_channel: APIEndpoint + \'channels/direct\',\r\n        channel_byname: APIEndpoint + \'teams/name/{0}/channels/name/{1}\',\r\n        user_byname: APIEndpoint + \'users/username/{0}\',\r\n        bot_user: APIEndpoint + \'users/me\'\r\n\r\n    };\r\n\r\n    params.send_mode = params.send_mode.toLowerCase();\r\n    params.send_mode = params.send_mode in SEND_MODE_HANDLERS\r\n        ? params.send_mode\r\n        : \'alarm\';\r\n\r\n    SEND_MODE_HANDLERS[params.send_mode](req, params);\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(4, \'[ Mattermost Webhook ] Mattermost notification failed: \' + error);\r\n    throw \'Mattermost notification failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__mattermost_message_link}','Open in Mattermost: {EVENT.TAGS.__mattermost_channel_name}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('6','4','Opsgenie','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Media = {\r\n    params: {},\r\n    name: \'\',\r\n    labels: [],\r\n    HTTPProxy: \'\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Media.params = params;\r\n        Media.params.api += Media.params.api.endsWith(\'/\') ? \'\' : \'/\';\r\n        Media.params.web += Media.params.web.endsWith(\'/\') ? \'\' : \'/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        if (typeof HTTPProxy !== \'undefined\' && HTTPProxy.trim() !== \'\') {\r\n            Media.HTTPProxy = HTTPProxy;\r\n        }\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n                && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag === \'string\') {\r\n                        label = (tag.tag + (typeof tag.value !== \'undefined\'\r\n                                && tag.value !== \'\' ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        Media.labels.push(label);\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse "event_tags_json" param\');\r\n            }\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data, allow_404) {\r\n        if (typeof(allow_404) === \'undefined\') {\r\n            allow_404 = false;\r\n        }\r\n\r\n        [\'api\', \'token\'].forEach(function (field) {\r\n            if (typeof Media.params !== \'object\' || typeof Media.params[field] === \'undefined\'\r\n                    || Media.params[field] === \'\') {\r\n                throw \'Required \' + Media.name + \' param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Media.params.api + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: \' + Media.params.token);\r\n        request.SetProxy(Media.HTTPProxy);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse response.\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if ((request.Status() < 200 || request.Status() >= 300)\r\n                && (!allow_404 || request.Status() !== 404)) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null) {\r\n                if (typeof response.errors === \'object\' && Object.keys(response.errors).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errors);\r\n                }\r\n                else if (typeof response.errorMessages === \'object\' && Object.keys(response.errorMessages).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errorMessages);\r\n                }\r\n                else if (typeof response.message === \'string\') {\r\n                    message += \': \' + response.message;\r\n                }\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getAlertId: function (requestId) {\r\n        do {\r\n            resp = Media.request(\'get\', \'requests/\' + requestId, undefined, true);\r\n        }\r\n        while (typeof resp.response !== \'object\' || typeof resp.response.data === \'undefined\'\r\n                || resp.response.data.success === false);\r\n\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.data === \'undefined\') {\r\n            throw \'Cannot get \' + Media.name + \' issue ID. Check debug log for more information.\';\r\n        }\r\n\r\n        return resp;\r\n    }\r\n};\r\n\r\ntry {\r\n    var result = {tags: {}},\r\n        params = JSON.parse(value),\r\n        media = {},\r\n        fields = {},\r\n        resp = {},\r\n        responders = [],\r\n        tags = [],\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\',\r\n            \'opsgenie_api\',\r\n            \'opsgenie_web\',\r\n            \'opsgenie_token\'\r\n        ],\r\n        severities = [\r\n            \'not_classified\',\r\n            \'information\',\r\n            \'warning\',\r\n            \'average\',\r\n            \'high\',\r\n            \'disaster\',\r\n            \'resolved\',\r\n            \'default\'\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n            if (key.startsWith(\'opsgenie_\')) {\r\n                media[key.substring(9)] = params[key];\r\n            }\r\n        });\r\n\r\n    // Possible values of event_source:\r\n    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check event_value for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_update_status only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_id for a numeric value.\r\n    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {\r\n        throw \'Incorrect "event_id" parameter given: \' + params.event_id + \'\\nMust be a positive number.\';\r\n    }\r\n\r\n    if ((params.event_source === \'1\' || params.event_source === \'2\')  && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for Trigger and Internal actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity]];\r\n    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n    Media.name = \'Opsgenie\';\r\n    Media.setParams(media);\r\n    Media.params.token = \'GenieKey \' + Media.params.token;\r\n    Media.setProxy(params.HTTPProxy);\r\n    Media.setTags(params.event_tags_json); // Set Media.labels\r\n\r\n    // Create an issue.\r\n    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).\r\n    // Numeric value of of the problem update status. Possible values:\r\n    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)\r\n            || (params.event_source == 3 && params.event_value == 1)\r\n            || params.event_source == 1 || params.event_source == 2) {\r\n        fields.message = params.alert_subject;\r\n        fields.alias = params.event_id;\r\n        fields.description = params.alert_message;\r\n        fields.priority = priority;\r\n        fields.source = \'Zabbix\';\r\n\r\n        if (params.event_source === \'0\') {\r\n            fields.details = {\r\n                \'Zabbix server\': params.zbxurl,\r\n                Problem: params.zbxurl + \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id\r\n            };\r\n        }\r\n        else {\r\n            fields.details = {\'Zabbix server\': params.zbxurl};\r\n        }\r\n\r\n        if (typeof params.opsgenie_teams === \'string\') {\r\n            responders = params.opsgenie_teams.split(\',\');\r\n            fields.responders = responders.map(function(team) {\r\n                return {type: \'team\', name: team.trim()};\r\n            });\r\n        }\r\n\r\n        fields.tags = Media.labels;\r\n        if (typeof params.opsgenie_tags === \'string\') {\r\n            tags = params.opsgenie_tags.split(\',\');\r\n            tags.forEach(function(item) {\r\n                fields.tags.push(item.trim());\r\n            });\r\n        }\r\n\r\n        resp = Media.request(\'post\', \'\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.result === \'undefined\') {\r\n            throw \'Cannot create \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (resp.status === 202) {\r\n            resp = Media.getAlertId(resp.response.requestId);\r\n            if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {\r\n                result.tags.__zbx_ops_issuekey = resp.response.data.alertId;\r\n                result.tags.__zbx_ops_issuelink = Media.params.web + \'alert/detail/\' + resp.response.data.alertId;\r\n            }\r\n        }\r\n        else {\r\n            throw Media.name + \' response code is unexpected. Check debug log for more information.\';\r\n        }\r\n    }\r\n    // Update a created issue.\r\n    else {\r\n        fields.user = (params.event_value != 0) ? params.zbxuser : \'\';\r\n        fields.note = params.alert_message;\r\n\r\n        resp = Media.request(\'post\', params.event_id + \'/notes?identifierType=alias\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.result === \'undefined\') {\r\n            throw \'Cannot update \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (resp.status === 202) {\r\n            resp = Media.getAlertId(resp.response.requestId);\r\n        }\r\n        else {\r\n            throw Media.name + \' response code is unexpected. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ \' + Media.name + \' Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_ops_issuelink}','Opsgenie: {EVENT.TAGS.__zbx_ops_issuekey}','Please refer to https://docs.opsgenie.com/docs/alert-api and https://www.zabbix.com/documentation/current/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd dedicated user with media type "Opsgenie".\r\nChange the values of the variables opsgenie_api (https://api.opsgenie.com/v2/alerts or https://api.eu.opsgenie.com/v2/alerts),\r\nopsgenie_web (for example, https://myzabbix.app.opsgenie.com), opsgenie_token.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('7','4','PagerDuty','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','try {\r\n\r\n    var params = JSON.parse(value),\r\n        req = new CurlHttpRequest(),\r\n        fields = {},\r\n        resp = \'\';\r\n\r\n    // Correspondence between the PagerDuty and Zabbix severity level\r\n    var severityMapping = [\r\n        \'info\',    // Not classified\r\n        \'info\',    // Information\r\n        \'warning\', // Warning\r\n        \'warning\', // Average\r\n        \'error\',   // High\r\n        \'critical\' // Disaster\r\n    ];\r\n\r\n    if (!severityMapping[params.severity]) {\r\n        params.severity = \'0\';\r\n    }\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if (isNaN(parseInt(params.eventid)) || params.eventid < 1) {\r\n        throw \'incorrect value for variable "eventid". The value must be a positive number.\';\r\n    }\r\n    if (params.eventname.length < 1) {\r\n        throw \'incorrect value for variable "eventname". The value must be a non-empty string.\';\r\n    }\r\n    if (isNaN(parseInt(params.severity)) || (params.severity < 0 && params.severity > 5)) {\r\n        throw \'incorrect value for variable "severity". The value must be a number 0..5.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.eventvalue !== \'0\' && params.eventvalue !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "eventvalue" parameter given: "\' + params.eventvalue + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\') {\r\n        if (params.hostname.length < 1) {\r\n            throw \'incorrect value for variable "hostname". The value must be a non-empty string.\';\r\n        }\r\n        if (isNaN(parseInt(params.triggerid)) || params.triggerid < 1) {\r\n            throw \'incorrect value for variable "triggerid". The value must be a positive number.\';\r\n        }\r\n        if (params.eventack != \'Yes\' && params.eventack != \'No\') {\r\n            throw \'incorrect value for variable "eventack". The value must be Yes or No.\';\r\n        }\r\n        if (isNaN(parseInt(params.eventupdate)) || (params.eventupdate < 0 || params.eventupdate > 1)) {\r\n            throw \'incorrect value for variable "eventupdate". The value must be 0 or 1.\';\r\n        }\r\n    }\r\n\r\n\r\n\r\n    req.AddHeader(\'Content-Type: application/json\');\r\n\r\n    fields.routing_key = params.token;\r\n    fields.dedup_key = params.eventid;\r\n\r\n    if (((params.eventvalue == 1) && (params.eventupdate == 0)) || params.event_source !== \'0\') {\r\n        fields.event_action = \'trigger\';\r\n        fields.payload = {\r\n            summary: params.eventname,\r\n            source: (params.event_source === \'1\') ? \'Discovery\' : params.hostname + \' : \' + params.hostip,\r\n            severity: severityMapping[params.severity],\r\n        };\r\n        \r\n        if (params.event_source === \'0\') {\r\n            fields.payload.custom_details = {\r\n                \'Event date\': params.eventdate,\r\n                \'Event time\': params.eventtime,\r\n                \'Trigger description\': params.triggerdesc,\r\n                \'Trigger opdata\': params.triggeropdata,\r\n                \'Event tags\': params.eventtags,\r\n                \'Event host\': params.hostname,\r\n                \'Event host ip\': params.hostip\r\n            };\r\n            fields.links = [{\r\n                href: params.url + \'/tr_events.php?triggerid=\' + params.triggerid + \'&eventid=\' + params.eventid,\r\n                text: \'Event link\'\r\n            }];\r\n        }\r\n        else {\r\n            fields.payload.custom_details = {\r\n                \'Alert message\': params.alert_message\r\n            };\r\n        }\r\n\r\n        fields.client = \'Zabbix\';\r\n        fields.client_url = params.url;\r\n    }\r\n    else if ((params.eventvalue == 1) && (params.eventupdate == 1) && (params.eventack == \'Yes\'))\r\n        fields.event_action = \'acknowledge\';\r\n    else if (params.eventvalue == 0)\r\n        fields.event_action = \'resolve\';\r\n    else\r\n        throw \'incorrect values. Update message without ack will not be sent.\';\r\n\r\n    Zabbix.Log(4, \'[PagerDuty Webhook] Sending request:\' + JSON.stringify(fields));\r\n    resp = req.Post(\'https://events.pagerduty.com/v2/enqueue\',\r\n        JSON.stringify(fields)\r\n    );\r\n    Zabbix.Log(4, \'[PagerDuty Webhook] Receiving response:\' + resp);\r\n\r\n    try {\r\n        resp = JSON.parse(resp);\r\n    }\r\n    catch (error) {\r\n        throw \'incorrect response. PagerDuty returned a non-JSON object.\';\r\n    }\r\n\r\n    if (req.Status() != 202) {\r\n        if (typeof resp === \'object\' && typeof resp.errors === \'object\' && typeof resp.errors[0] === \'string\') {\r\n            throw resp.errors[0];\r\n        }\r\n        else {\r\n            throw \'Unknown error.\';\r\n        }\r\n    }\r\n\r\n    if (resp.status != \'success\') {\r\n        throw \'Unknown error.\';\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[PagerDuty Webhook] Notification failed : \' + error);\r\n    throw \'PagerDuty notification failed : \' + error;\r\n}','30s','0','0','','','Please refer to https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2 and https://www.zabbix.com/documentation/current/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "PagerDuty" and place the integration key in the "token" parameter to integrate into the service.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('8','4','Pushover','','','','','','','','0','25','0','0','0','0','','0','3','10s','1','try {\r\n    var params = JSON.parse(value),\r\n        request = new CurlHttpRequest(),\r\n        data,\r\n        response,\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'priority_\' + severities[params.event_nseverity].name] || params.priority_default;\r\n\r\n    if (isNaN(priority) || priority < -2 || priority > 2) {\r\n        throw \'"priority" should be -2..2\';\r\n    }\r\n\r\n    if (params.event_source === \'0\' && isNaN(params.triggerid)) {\r\n        throw \'field "triggerid" is not a number\';\r\n    }\r\n\r\n    if (isNaN(params.eventid)) {\r\n        throw \'field "eventid" is not a number\';\r\n    }\r\n\r\n    if (typeof params.message !== \'string\' || params.message.trim() === \'\') {\r\n        throw \'field "message" cannot be empty\';\r\n    }\r\n\r\n    data = {\r\n        token: params.token,\r\n        user: params.user,\r\n        title: params.title,\r\n        message: params.message,\r\n        url: (params.event_source === \'0\') \r\n            ? params.url + \'/tr_events.php?triggerid=\' + params.triggerid + \'&eventid=\' + params.eventid\r\n            : params.url,\r\n        url_title: params.url_title,\r\n        priority: priority\r\n    };\r\n\r\n    if (priority == 2) {\r\n        if (isNaN(params.retry) || params.retry < 30) {\r\n            throw \'field "retry" should be a number with value of at least 30 if "priority" is set to 2\';\r\n        }\r\n\r\n        if (isNaN(params.expire) || params.expire > 10800) {\r\n            throw \'field "expire" should be a number with value of at most 10800 if "priority" is set to 2\';\r\n        }\r\n\r\n        data.retry = params.retry;\r\n        data.expire = params.expire;\r\n    }\r\n\r\n    data = JSON.stringify(data);\r\n    Zabbix.Log(4, \'[ Pushover Webhook ] Sending request: \' + params.endpoint + \'\\n\' + data);\r\n\r\n    request.AddHeader(\'Content-Type: application/json\');\r\n    response = request.Post(params.endpoint, data);\r\n\r\n    Zabbix.Log(4, \'[ Pushover Webhook ] Received response with status code \' + request.Status() + \'\\n\' + response);\r\n\r\n    if (response !== null) {\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.Log(4, \'[ Pushover Webhook ] Failed to parse response received from Pushover\');\r\n            response = null;\r\n        }\r\n    }\r\n\r\n    if (request.Status() != 200 || response === null || typeof response !== \'object\' || response.status !== 1) {\r\n        if (response !== null && typeof response === \'object\' && typeof response.errors === \'object\'\r\n                && typeof response.errors[0] === \'string\') {\r\n            throw response.errors[0];\r\n        }\r\n        else {\r\n            throw \'Unknown error. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(4, \'[ Pushover Webhook ] Pushover notification failed: \' + error);\r\n    throw \'Pushover notification failed: \' + error;\r\n}','30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/pushover\r\n\r\nSet token parameter with to your Pushover application key.\r\nWhen assigning Pushover media to the Zabbix user - add user key into send to field.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('9','4','Slack','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', \'#7499FF\', \'#FFC859\',\r\n    \'#FFA059\', \'#E97659\', \'#E45959\'\r\n];\r\n\r\nvar RESOLVE_COLOR = \'#009900\';\r\n\r\nvar SLACK_MODE_HANDLERS = {\r\n    alarm: handlerAlarm,\r\n    event: handlerEvent\r\n};\r\n\r\n\r\nif (!String.prototype.format) {\r\n    String.prototype.format = function() {\r\n        var args = arguments;\r\n\r\n        return this.replace(/{(\\d+)}/g, function(match, number) {\r\n            return number in args\r\n                ? args[number]\r\n                : match\r\n            ;\r\n        });\r\n    };\r\n}\r\n\r\nfunction isEventProblem(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 0\r\n    ;\r\n}\r\n\r\nfunction isEventUpdate(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 1\r\n    ;\r\n}\r\n\r\nfunction isEventResolve(params) {\r\n    return params.event_value == 0;\r\n}\r\n\r\nfunction getPermalink(channelId, messageTimestamp) {\r\n    var req = new CurlHttpRequest();\r\n\r\n    req.AddHeader(\'Content-Type: application/x-www-form-urlencoded; charset=utf-8\');\r\n\r\n    var resp = JSON.parse(req.Get(\r\n        \'{0}?token={1}&channel={2}&message_ts={3}\'.format(\r\n            Slack.getPermalink,\r\n            params.bot_token,\r\n            channelId,\r\n            messageTimestamp\r\n        )\r\n    ));\r\n\r\n    if (req.Status != 200 && !resp.ok) {\r\n        throw resp.error;\r\n    }\r\n\r\n    return resp.permalink;\r\n}\r\n\r\nfunction createProblemURL(zabbix_url, triggerid, eventid, event_source) {\r\n    var problem_url = \'\';\r\n    if (event_source === \'0\') {\r\n        problem_url = \'{0}/tr_events.php?triggerid={1}&eventid={2}\'\r\n            .format(\r\n                zabbix_url,\r\n                triggerid,\r\n                eventid\r\n            );\r\n    }\r\n    else {\r\n        problem_url = zabbix_url;\r\n    }\r\n\r\n    return problem_url;\r\n}\r\n\r\nfunction getTagValue(event_tags, key) {\r\n    var pattern = new RegExp(\'(\' + key + \':.+)\');\r\n    var tag_value = event_tags\r\n        .split(\',\')\r\n        .filter(function (v) {\r\n            return v.match(pattern);\r\n        })\r\n        .map(function (v) {\r\n            return v.split(\':\')[1];\r\n        })[0]\r\n        || 0;\r\n\r\n    return tag_value;\r\n}\r\n\r\nfunction handlerAlarm(params) {\r\n    var fields = {\r\n        channel: params.channel,\r\n        as_user: params.slack_as_user,\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.Status != 200 && !resp.ok) {\r\n            throw resp.error;\r\n        }\r\n\r\n        result.tags.__message_ts = resp.ts;\r\n        result.tags.__channel_id = resp.channel;\r\n        result.tags.__channel_name = params.channel;\r\n        result.tags.__message_link = getPermalink(resp.channel, resp.ts);\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.thread_ts = getTagValue(params.event_tags, \'message_ts\');\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                true\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));\r\n        if (req.Status != 200 && !resp.ok) {\r\n            throw resp.error;\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.channel = getTagValue(params.event_tags, \'channel_id\');\r\n        fields.text = \'\';\r\n        fields.ts = getTagValue(params.event_tags, \'message_ts\');\r\n        fields.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Slack.chatUpdate, JSON.stringify(fields)));\r\n        if (req.Status != 200 && !resp.ok) {\r\n            throw resp.error;\r\n        }\r\n    }\r\n}\r\n\r\nfunction handlerEvent(params) {\r\n    var fields = {\r\n        channel: params.channel,\r\n        as_user: params.slack_as_user\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.Status != 200 && !resp.ok) {\r\n            throw resp.error;\r\n        }\r\n\r\n        result.tags.__channel_name = params.channel;\r\n        result.tags.__message_link = getPermalink(resp.channel, resp.ts);\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                false\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.Status != 200 && !resp.ok) {\r\n            throw resp.error;\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_recovery_date,\r\n                params.event_recovery_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.Post(Slack.postMessage, JSON.stringify(fields)));\r\n\r\n        if (req.Status != 200 && !resp.ok) {\r\n            throw resp.error;\r\n        }\r\n    }\r\n}\r\n\r\nfunction createMessage(\r\n    event_severity_color,\r\n    event_date,\r\n    event_time,\r\n    problem_url,\r\n    isShort,\r\n    messageText\r\n) {\r\n    var message = {\r\n        fallback: params.alert_subject,\r\n        title: params.alert_subject,\r\n        color: event_severity_color,\r\n        title_link: problem_url,\r\n        pretext: messageText || \'\',\r\n\r\n        fields: [\r\n            {\r\n                title: \'Host\',\r\n                value: \'{0} [{1}]\'.format(params.host_name, params.host_conn),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Event time\',\r\n                value: \'{0} {1}\'.format(event_date, event_time),\r\n                short: true\r\n            }\r\n        ],\r\n    };\r\n\r\n    if (params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Severity\',\r\n                value: params.event_severity,\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Opdata\',\r\n                value: params.event_opdata,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (!isShort  && params.event_source === \'0\') {\r\n        message[\'actions\'] = [\r\n            {\r\n                type: \'button\',\r\n                text: \'Open in Zabbix\',\r\n                url: problem_url\r\n            }\r\n        ];\r\n\r\n        message.fields.push(\r\n            {\r\n                title: \'Event tags\',\r\n                value: params.event_tags.replace(/__.+?:(.+?,|.+)/g, \'\') || \'None\',\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Trigger description\',\r\n                value: params.trigger_description,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (params.event_source !== \'0\' || params.event_update_status === \'1\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Details\',\r\n                value: params.alert_message,\r\n                short: false\r\n            }\r\n        );\r\n    }\r\n\r\n    return message;\r\n}\r\n\r\nfunction validateParams(params) {\r\n    if (typeof params.bot_token !== \'string\' || params.bot_token.trim() === \'\') {\r\n        throw \'Field "bot_token" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.channel !== \'string\' || params.channel.trim() === \'\') {\r\n        throw \'Field "channel" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.event_id)) {\r\n        throw \'Field "event_id" is not a number\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\') {\r\n        params.event_nseverity = \'0\';\r\n        params.event_severity = \'Not classified\';\r\n        params.event_update_status = \'0\';\r\n        params.slack_mode = \'event\';\r\n    }\r\n\r\n    if (params.event_source === \'1\' || params.event_source === \'2\') {\r\n        params.event_value = \'1\';\r\n    }\r\n\r\n    if (params.event_source === \'1\') {\r\n        params.host_name = params.discovery_host_dns;\r\n        params.host_ip = params.discovery_host_ip;\r\n    }\r\n\r\n    if (!~[0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity))) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    if (typeof params.event_severity !== \'string\' || params.event_severity.trim() === \'\') {\r\n        throw \'Field "event_severity" cannot be empty\';\r\n    }\r\n\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (typeof params.host_conn !== \'string\' || params.host_conn.trim() === \'\') {\r\n        throw \'Field "host_conn" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.host_name !== \'string\' || params.host_name.trim() === \'\') {\r\n        throw \'Field "host_name" cannot be empty\';\r\n    }\r\n\r\n    if (!~[\'true\', \'false\'].indexOf(params.slack_as_user.toLowerCase())) {\r\n        throw \'Incorrect "slack_as_user" parameter given: \' + params.slack_as_user + \'\\nMust be "true" or "false".\';\r\n    }\r\n\r\n    if (!~[\'alarm\', \'event\'].indexOf(params.slack_mode)) {\r\n        throw \'Incorrect "slack_mode" parameter given: \' + params.slack_mode + \'\\nMust be "alarm" or "event".\';\r\n    }\r\n\r\n    if (isNaN(params.trigger_id) && params.event_source === \'0\') {\r\n        throw \'field "trigger_id" is not a number\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\') {\r\n        throw \'Field "zabbix_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {\r\n        throw \'Field "zabbix_url" must contain a schema\';\r\n    }\r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    validateParams(params);\r\n\r\n    var req = new CurlHttpRequest(),\r\n        result = {tags: {}};\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.AddHeader(\'Content-Type: application/json; charset=utf-8\');\r\n    req.AddHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    var slack_endpoint = \'https://slack.com/api/\';\r\n\r\n    var Slack = {\r\n        postMessage: slack_endpoint + \'chat.postMessage\',\r\n        getPermalink: slack_endpoint + \'chat.getPermalink\',\r\n        chatUpdate: slack_endpoint + \'chat.update\'\r\n    };\r\n\r\n    params.slack_mode = params.slack_mode.toLowerCase();\r\n    params.slack_mode = params.slack_mode in SLACK_MODE_HANDLERS\r\n        ? params.slack_mode\r\n        : \'alarm\';\r\n\r\n    SLACK_MODE_HANDLERS[params.slack_mode](params);\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(4, \'[ Slack Webhook ] Slack notification failed : \' + error);\r\n    throw \'Slack notification failed : \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__message_link}','Open in Slack: {EVENT.TAGS.__channel_name}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('10','4','Discord','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', // Not classified.\r\n    \'#7499FF\', // Information.\r\n    \'#FFC859\', // Warning.\r\n    \'#FFA059\', // Average.\r\n    \'#E97659\', // High.\r\n    \'#E45959\', // Disaster.\r\n    \'#009900\'  // Resolved.\r\n];\r\n\r\nfunction stringTruncate(str, len) {\r\n    return str.length > len ? str.substring(0, len - 3) + \'...\' : str;\r\n}\r\n\r\ntry {\r\n    Zabbix.Log(4, \'[ Discord Webhook ] Executed with params: \' + value);\r\n\r\n    var params = JSON.parse(value);\r\n\r\n    if (!params.discord_endpoint) {\r\n        throw \'Cannot get discord_endpoint\';\r\n    }\r\n    else {\r\n        params.discord_endpoint = params.discord_endpoint.replace(\'/api/\', \'/api/v7/\') + \'?wait=True\';\r\n    }\r\n\r\n    params.zabbix_url = (params.zabbix_url.endsWith(\'/\'))\r\n        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Set params to true for non trigger-based events.\r\n    if (params.event_source !== \'0\') {\r\n        params.use_default_message = \'true\';\r\n        params.event_nseverity = \'0\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: "\' + params.event_value + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: "\' + params.event_update_status + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value == 0) {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (!SEVERITY_COLORS[params.event_nseverity]) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    var color = parseInt(SEVERITY_COLORS[params.event_nseverity].replace(\'#\', \'\'), 16),\r\n        fields = [],\r\n        body = {\r\n            embeds: [\r\n                {\r\n                    color: color || 0,\r\n                    url: (params.event_source === \'0\')\r\n                        ? params.zabbix_url + \'/tr_events.php?triggerid=\' + params.trigger_id +\r\n                            \'&eventid=\' + params.event_id\r\n                        : params.zabbix_url\r\n                }\r\n            ]\r\n        };\r\n\r\n    // Default message from {ALERT.MESSAGE}.\r\n    if (params.use_default_message.toLowerCase() == \'true\') {\r\n        body.embeds[0].title = stringTruncate(params.alert_subject, 256);\r\n        body.embeds[0].description = stringTruncate(params.alert_message, 2048);\r\n    }\r\n    else {\r\n        fields.push(\r\n            {\r\n                name: \'Host\',\r\n                value: params.host_name + \' [\' + params.host_ip + \']\'\r\n            }\r\n        );\r\n\r\n        // Resolved message.\r\n        if (params.event_value == 0 && params.event_update_status == 0) {\r\n            body.embeds[0].title = stringTruncate(\'OK: \' + params.event_name, 256);\r\n            fields.push(\r\n                {\r\n                    name: \'Recovery time\',\r\n                    value: params.event_recovery_time + \' \' + params.event_recovery_date,\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        // Problem message.\r\n        else if (params.event_value == 1 && params.event_update_status == 0) {\r\n            body.embeds[0].title = stringTruncate(\'PROBLEM: \' + params.event_name, 256);\r\n            fields.push(\r\n                {\r\n                    name: \'Event time\',\r\n                    value: params.event_time + \' \' + params.event_date,\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        // Update message.\r\n        else if (params.event_update_status == 1) {\r\n            body.embeds[0].title = stringTruncate(\'UPDATE: \' + params.event_name, 256);\r\n            body.embeds[0].description = params.event_update_user + \' \' + params.event_update_action + \'.\';\r\n\r\n            if (params.event_update_message) {\r\n                body.embeds[0].description += \' Comment:\\n>>> \' + params.event_update_message;\r\n            }\r\n\r\n            body.embeds[0].description = stringTruncate(body.embeds[0].description, 2048);\r\n\r\n            fields.push(\r\n                {\r\n                    name: \'Event update time\',\r\n                    value: params.event_update_time + \' \' + params.event_update_date,\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        fields.push(\r\n            {\r\n                name: \'Severity\',\r\n                value: params.event_severity,\r\n                inline: \'True\'\r\n            }\r\n        );\r\n\r\n        if (params.event_opdata) {\r\n            fields.push(\r\n                {\r\n                    name: \'Operational data\',\r\n                    value: stringTruncate(params.event_opdata, 1024),\r\n                    inline: \'True\'\r\n                }\r\n            );\r\n        }\r\n\r\n        if (params.event_value == 1 && params.event_update_status == 0 && params.trigger_description) {\r\n            fields.push(\r\n                {\r\n                    name: \'Trigger description\',\r\n                    value: stringTruncate(params.trigger_description, 1024)\r\n                }\r\n            );\r\n        }\r\n\r\n        body.embeds[0].footer = {\r\n            text: \'Event ID: \' + params.event_id\r\n        };\r\n\r\n        if (params.event_tags) {\r\n            body.embeds[0].footer.text += \'\\nEvent tags: \' + params.event_tags;\r\n        }\r\n        body.embeds[0].footer.text = stringTruncate(body.embeds[0].footer.text, 2048);\r\n    }\r\n\r\n    if (fields.length > 0) {\r\n        body.embeds[0].fields = fields;\r\n    }\r\n\r\n    var req = new CurlHttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.AddHeader(\'Content-Type: application/json\');\r\n\r\n    var resp = req.Post(params.discord_endpoint, JSON.stringify(body)),\r\n        data = JSON.parse(resp);\r\n\r\n    Zabbix.Log(4, \'[ Discord Webhook ] JSON: \' + JSON.stringify(body));\r\n    Zabbix.Log(4, \'[ Discord Webhook ] Response: \' + resp);\r\n\r\n    if (data.id) {\r\n        return resp;\r\n    }\r\n    else {\r\n        var message = ((typeof data.message === \'string\') ? data.message : \'Unknown error\');\r\n\r\n        Zabbix.Log(3, \'[ Discord Webhook ] FAILED with response: \' + resp);\r\n        throw message + \'. For more details check zabbix server log.\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Discord Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('11','4','SIGNL4','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','// SIGNL4 Webhook\r\ntry {\r\n    var response,\r\n        payload,\r\n        params = JSON.parse(value),\r\n        endpoint = \'https://connect.signl4.com/webhook/\',\r\n        request = new CurlHttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if (typeof params.teamsecret === \'string\' && params.teamsecret.trim() !== \'\') {\r\n        endpoint += params.teamsecret;\r\n        delete params.teamsecret;\r\n    }\r\n    else {\r\n        throw \'The team secret of your SIGNL4 team cannot be empty.\';\r\n    }\r\n\r\n    if (typeof params.Severity === \'string\' && params.Severity === \'{EVENT.SEVERITY}\') {\r\n        params.Severity = \'Not classified\';\r\n    }\r\n\r\nif (typeof params.User === \'string\' && params.User === \'{USER.FULLNAME}\') {\r\n        params.User = \'\';\r\n    }\r\n\r\nif (typeof params.Event_Update_Action === \'string\' && params.Event_Update_Action === \'{EVENT.UPDATE.ACTION}\') {\r\n        params.Event_Update_Action = \'\';\r\n    }\r\n\r\n// Assemble X-S4-ExternalID for two-way integration\r\n// Format: "ZabbixEventID: 222 ZabbixURL: https://your-zabbix-server/zabbix/"\r\nparams[\'X-S4-ExternalID\'] = \'ZabbixEventID: \' + params.Event_ID;\r\nif (typeof params.Zabbix_URL === \'string\' && params.Zabbix_URL.indexOf(\'http\') == 0) {\r\n// Make sure the URL ends with \'/\'\r\nif (params.Zabbix_URL.charAt(params.Zabbix_URL.length - 1) != \'/\') {\r\nparams.Zabbix_URL = params.Zabbix_URL + \'/\';\r\n}\r\n\r\nparams[\'X-S4-ExternalID\'] = params[\'X-S4-ExternalID\'] + \' ZabbixURL: \' +  params.Zabbix_URL;\r\n\r\n// Add Link parameter\r\nparams[\'Link\'] = params.Zabbix_URL + "tr_events.php?triggerid="+params.Trigger_ID + "&eventid=" + params.Event_ID;\r\n}\r\n\r\n// Check if this is a new problem or a recovery\r\nif (params.Trigger_Status == \'OK\') {\r\nparams[\'X-S4-Status\'] = \'resolved\';\r\n}\r\nelse {\r\nparams[\'X-S4-Status\'] = \'new\';\r\n}\r\n\r\n    payload = JSON.stringify(params);\r\n    Zabbix.Log(4, \'[ SIGNL4 Webhook ] Sending request: \' + payload);\r\n\r\n    request.AddHeader(\'Content-Type: application/json\');\r\n    response = request.Post(endpoint, \'payload=\' + payload);\r\n\r\n    Zabbix.Log(4, \'[ SIGNL4 Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response\r\n    );\r\n\r\n    if (request.Status() !== 201) {\r\n        throw \'Request failed with status code \' + request.Status() +\r\n                \'. Check debug log for more information.\';\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(4, \'[ SIGNL4 Webhook ] ERROR: \' + error);\r\n\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','SIGNL4 is a mobile alert notification app for powerful alerting, alert management and mobile assignment of work items. It offers alerting via app push, SMS and voice calls including escalations, tracking, and duty scheduling.\r\n\r\nGet the app at https://www.signl4.com.\r\n\r\nFind out more including an integration video here: https://www.signl4.com/blog/portfolio_item/zabbix-mobile-alert-notification-duty-schedule-escalation/');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('12','4','Jira','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Jira = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Jira.params = params;\r\n        if (typeof Jira.params.url === \'string\') {\r\n            if (!Jira.params.url.endsWith(\'/\')) {\r\n                Jira.params.url += \'/\';\r\n            }\r\n\r\n            Jira.params.url += \'rest/api/latest/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Jira.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n            && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                Jira.labels = [];\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\'\r\n                        && !tag.tag.startsWith(\'__zbx\')) {\r\n                        label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        if (label.length < 256) {\r\n                            Jira.labels.push(label);\r\n                        }\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                // Code is not missing here.\r\n            }\r\n        }\r\n    },\r\n\r\n    escapeMarkup: function (str) {\r\n        var length = str.length,\r\n            result = \'\',\r\n            markup = [\'{\', \'|\', \'}\', \'~\', \'_\', \'\\\\\', \'[\', \']\', \'^\', \'<\', \'>\', \'?\', \'!\', \'#\', \'+\', \'*\', \'&\'];\r\n\r\n        for (var i = 0; i < length; i++) {\r\n            var char = str[i];\r\n\r\n            result += (markup.indexOf(char) !== -1) ? (\'&#\' + str[i].charCodeAt() + \';\') : char;\r\n        }\r\n\r\n        return result;\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Jira.getSchema(),\r\n                path = [\'projects\', 0, \'issuetypes\', 0, \'fields\'],\r\n                field;\r\n\r\n            while ((field = path.shift()) !== undefined) {\r\n                schema = schema[field];\r\n                if (typeof schema === \'undefined\') {\r\n                    schema = null;\r\n                    break;\r\n                }\r\n            }\r\n\r\n            if (schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        if (typeof schema[field] === \'object\' && typeof schema[field].schema === \'object\') {\r\n                            switch (schema[field].schema.type) {\r\n                                case \'number\':\r\n                                    data.fields[field] = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'datetime\':\r\n                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n                                        data.fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    break;\r\n\r\n                                case \'option\':\r\n                                    data.fields[field] = {value: fields[field]};\r\n                                    break;\r\n\r\n                                case \'array\':\r\n                                    if (schema[field].schema.items === \'option\') {\r\n                                        data.fields[field] = [{value: fields[field]}];\r\n                                    }\r\n                                    else {\r\n                                        data.fields[field] = [fields[field]];\r\n                                    }\r\n                                    break;\r\n\r\n                                default:\r\n                                    data.fields[field] = fields[field];\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.Log(4, \'[ Jira Webhook ] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'user\', \'password\', \'project_key\', \'issue_type\'].forEach(function (field) {\r\n            if (typeof Jira.params !== \'object\' || typeof Jira.params[field] === \'undefined\'\r\n                || Jira.params[field] === \'\' ) {\r\n                throw \'Required Jira param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Jira.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(Jira.params.user + \':\' + Jira.params.password));\r\n\r\n        if (typeof Jira.HTTPProxy !== \'undefined\' && Jira.HTTPProxy !== \'\') {\r\n            request.SetProxy(Jira.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Webhook ] Sending request: \' + url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Webhook ] Received response with status code \' + request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Jira Webhook ] Failed to parse response received from Jira\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Jira.request(\'get\', \'issue/createmeta?expand=projects.issuetypes.fields&projectKeys=\' +\r\n            encodeURIComponent(Jira.params.project_key) + \'&issuetypeNames=\' +\r\n            encodeURIComponent(Jira.params.issue_type));\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(summary, description, fields) {\r\n        var data = {\r\n            fields: {\r\n                project: {\r\n                    key: Jira.params.project_key\r\n                },\r\n                issuetype: {\r\n                    name: Jira.params.issue_type\r\n                },\r\n                summary: summary,\r\n                description: description\r\n            }\r\n        };\r\n\r\n        if (Jira.labels && Jira.labels.length > 0) {\r\n            data.fields.labels = Jira.labels;\r\n        }\r\n        var result = Jira.request(\'post\', \'issue\', Jira.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.key === \'undefined\') {\r\n            throw \'Cannot create Jira issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.key;\r\n    },\r\n\r\n    updateIssue: function(summary, fields, update) {\r\n        var data = {fields: {}};\r\n\r\n        if (summary) {\r\n            data.fields.summary = summary;\r\n        }\r\n\r\n        Jira.request(\'put\', \'issue/\' + encodeURIComponent(Jira.params.issue_key), Jira.addCustomFields(data, fields));\r\n        Jira.commentIssue(update);\r\n    },\r\n\r\n    commentIssue: function(update) {\r\n        var data = {};\r\n\r\n        if (typeof update === \'string\') {\r\n            data.body = update;\r\n            Jira.request(\'post\', \'issue/\' + encodeURIComponent(Jira.params.issue_key) + \'/comment\', data);\r\n        }\r\n        else if (update.status === \'1\') {\r\n            data.body = update.user + \' \' + update.action + \'.\';\r\n\r\n            if (update.message) {\r\n                data.body += \'\\nMessage: {quote}\' + Jira.escapeMarkup(update.message) + \'{quote}\';\r\n            }\r\n\r\n            Jira.request(\'post\', \'issue/\' + encodeURIComponent(Jira.params.issue_key) + \'/comment\', data);\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        jira = {},\r\n        update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'summary\', \'event_recovery_value\', \'event_source\', \'event_value\'];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'jira_\')) {\r\n                jira[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Jira.setParams(jira);\r\n    Jira.setProxy(params.HTTPProxy);\r\n    Jira.setTags(params.event_tags_json);\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Jira.createIssue(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\' && !jira.issue_key.startsWith(jira.project_key)) {\r\n        var key = Jira.createIssue(params.alert_subject,\r\n            (Object.keys(fields).length ? params.trigger_description : params.alert_message), fields);\r\n\r\n\r\n        result.tags.__zbx_jira_issuekey = key;\r\n        result.tags.__zbx_jira_issuelink = params.jira_url +\r\n            (params.jira_url.endsWith(\'/\') ? \'\' : \'/\') + \'browse/\' + key;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (!jira.issue_key.startsWith(jira.project_key)) {\r\n            throw \'Incorrect Issue key given: \' + jira.issue_key;\r\n        }\r\n        Jira.updateIssue(params.alert_subject, fields,\r\n            ((params.event_value === \'0\' && !Object.keys(fields).length)\r\n                ? params.alert_message : update));\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Jira Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('13','4','Jira with CustomFields','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Jira = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Jira.params = params;\r\n        if (typeof Jira.params.url === \'string\') {\r\n            if (!Jira.params.url.endsWith(\'/\')) {\r\n                Jira.params.url += \'/\';\r\n            }\r\n\r\n            Jira.params.url += \'rest/api/latest/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Jira.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n            && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                Jira.labels = [];\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\' ) {\r\n                        label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        if (label.length < 256) {\r\n                            Jira.labels.push(label);\r\n                        }\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                // Code is not missing here.\r\n            }\r\n        }\r\n    },\r\n\r\n    escapeMarkup: function (str) {\r\n        var length = str.length,\r\n            result = \'\',\r\n            markup = [\'{\', \'|\', \'}\', \'~\', \'_\', \'\\\\\', \'[\', \']\', \'^\', \'<\', \'>\', \'?\', \'!\', \'#\', \'+\', \'*\', \'&\'];\r\n\r\n        for (var i = 0; i < length; i++) {\r\n            var char = str[i];\r\n\r\n            result += (markup.indexOf(char) !== -1) ? (\'&#\' + str[i].charCodeAt() + \';\') : char;\r\n        }\r\n\r\n        return result;\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Jira.getSchema(),\r\n                path = [\'projects\', 0, \'issuetypes\', 0, \'fields\'],\r\n                field;\r\n\r\n            while ((field = path.shift()) !== undefined) {\r\n                schema = schema[field];\r\n                if (typeof schema === \'undefined\') {\r\n                    schema = null;\r\n                    break;\r\n                }\r\n            }\r\n\r\n            if (schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        data.fields[field] = fields[field];\r\n\r\n                        if (typeof schema[field] === \'object\' && typeof schema[field].schema === \'object\'\r\n                            && (schema[field].schema.type === \'number\' || schema[field].schema.type === \'datetime\')) {\r\n                            switch (schema[field].schema.type) {\r\n                                case \'number\':\r\n                                    data.fields[field] = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'datetime\':\r\n                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n                                        data.fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    else {\r\n                                        delete data.fields[field];\r\n                                    }\r\n                                    break;\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.Log(4, \'[ Jira Webhook ] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'user\', \'password\', \'project_key\', \'issue_type\'].forEach(function (field) {\r\n            if (typeof Jira.params !== \'object\' || typeof Jira.params[field] === \'undefined\'\r\n                || Jira.params[field] === \'\' ) {\r\n                throw \'Required Jira param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Jira.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(Jira.params.user + \':\' + Jira.params.password));\r\n\r\n        if (typeof Jira.HTTPProxy !== \'undefined\' && Jira.HTTPProxy !== \'\') {\r\n            request.SetProxy(Jira.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Webhook ] Sending request: \' + url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Webhook ] Received response with status code \' + request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Jira Webhook ] Failed to parse response received from Jira\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Jira.request(\'get\', \'issue/createmeta?expand=projects.issuetypes.fields&projectKeys=\' +\r\n                Jira.params.project_key + \'&issuetypeNames=\' + Jira.params.issue_type);\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(summary, description, fields) {\r\n        var data = {\r\n            fields: {\r\n                project: {\r\n                    key: Jira.params.project_key\r\n                },\r\n                issuetype: {\r\n                    name: Jira.params.issue_type\r\n                },\r\n                summary: summary,\r\n                description: description\r\n            }\r\n        };\r\n\r\n        if (Jira.labels && Jira.labels.length > 0) {\r\n            data.fields.labels = Jira.labels;\r\n        }\r\n        var result = Jira.request(\'post\', \'issue\', Jira.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.key === \'undefined\') {\r\n            throw \'Cannot create Jira issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.key;\r\n    },\r\n\r\n    updateIssue: function(summary, fields, update) {\r\n        var data = {fields: {}};\r\n\r\n        if (summary) {\r\n            data.fields.summary = summary;\r\n        }\r\n\r\n        Jira.request(\'put\', \'issue/\' + Jira.params.issue_key, Jira.addCustomFields(data, fields));\r\n        Jira.commentIssue(update);\r\n    },\r\n\r\n    commentIssue: function(update) {\r\n        var data = {};\r\n\r\n        if (typeof update === \'string\') {\r\n            data.body = update;\r\n            Jira.request(\'post\', \'issue/\' + Jira.params.issue_key + \'/comment\', data);\r\n        }\r\n        else if (update.status === \'1\') {\r\n            data.body = update.user + \' \' + update.action + \'.\';\r\n\r\n            if (update.message) {\r\n                data.body += \'\\nMessage: {quote}\' + Jira.escapeMarkup(update.message) + \'{quote}\';\r\n            }\r\n\r\n            Jira.request(\'post\', \'issue/\' + Jira.params.issue_key + \'/comment\', data);\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        jira = {},\r\n        update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'summary\', \'event_recovery_value\', \'event_source\', \'event_value\'];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'jira_\')) {\r\n                jira[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Jira.setParams(jira);\r\n    Jira.setProxy(params.HTTPProxy);\r\n    Jira.setTags(params.event_tags_json);\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Jira.createIssue(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\' && !jira.issue_key.startsWith(jira.project_key)) {\r\n        var key = Jira.createIssue(params.alert_subject,\r\n            (Object.keys(fields).length ? params.trigger_description : params.alert_message), fields);\r\n\r\n\r\n        result.tags.__zbx_jira_issuekey = key;\r\n        result.tags.__zbx_jira_issuelink = params.jira_url +\r\n            (params.jira_url.endsWith(\'/\') ? \'\' : \'/\') + \'browse/\' + key;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (!jira.issue_key.startsWith(jira.project_key)) {\r\n            throw \'Incorrect Issue key given: \' + jira.issue_key;\r\n        }\r\n        Jira.updateIssue(params.alert_subject, fields,\r\n            ((params.event_value === \'0\' && !Object.keys(fields).length)\r\n                ? params.alert_message : update));\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Jira Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('14','4','MS Teams','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', // Not classified.\r\n    \'#7499FF\', // Information.\r\n    \'#FFC859\', // Warning.\r\n    \'#FFA059\', // Average.\r\n    \'#E97659\', // High.\r\n    \'#E45959\', // Disaster.\r\n    \'#009900\', // Resolved.\r\n    \'#000000\'  // Default.\r\n];\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    if (typeof params.teams_endpoint !== \'string\' || params.teams_endpoint.trim() === \'\') {\r\n        throw \'Cannot get teams_endpoint\';\r\n    }\r\n    else if (!params.teams_endpoint.startsWith(\'http\')) {\r\n        throw \'Invalid MS Teams webhook URL: \' + params.teams_endpoint;\r\n    }\r\n\r\n    params.zabbix_url = (params.zabbix_url.endsWith(\'/\'))\r\n        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Set "use_default_message" to true for non trigger-based events.\r\n    if (params.event_source !== \'0\') {\r\n        params.use_default_message = \'true\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: "\' + params.event_value + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: "\' + params.event_update_status + \'".\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value == 0) {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (!SEVERITY_COLORS[params.event_nseverity]) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    var request = new CurlHttpRequest(),\r\n        facts = [],\r\n        body = {\r\n            themeColor: SEVERITY_COLORS[params.event_nseverity].replace(\'#\', \'\'),\r\n            summary: \'Zabbix\',\r\n            sections: [\r\n                {\r\n                    markdown: \'false\',\r\n                    activityTitle: params.alert_subject,\r\n                    activitySubtitle: \'On \' + params.host_name + \' [\' + params.host_ip + \']\',\r\n                    text: (params.use_default_message.toLowerCase() == \'true\')\r\n                        ? params.alert_message\r\n                        : params.trigger_description\r\n                }\r\n            ],\r\n            potentialAction: [\r\n                {\r\n                    \'@type\': \'OpenUri\',\r\n                    name: (params.event_source === \'0\')\r\n                        ? \'Event Info\'\r\n                        : \'Zabbix Home\',\r\n                    targets: [\r\n                        {\r\n                            os: \'default\',\r\n                            uri: (params.event_source === \'0\')\r\n                                ? params.zabbix_url + \'/tr_events.php?triggerid=\' +\r\n                                    params.trigger_id + \'&eventid=\' + params.event_id\r\n                                : params.zabbix_url\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        };\r\n\r\n    if (params.use_default_message.toLowerCase() !== \'true\') {\r\n        // Problem message.\r\n        if (params.event_value === \'1\' && params.event_update_status === \'0\') {\r\n            facts.push({\r\n                name: \'Event time\',\r\n                value: params.event_time + \' \' + params.event_date\r\n            });\r\n        }\r\n        // Update message.\r\n        else if (params.event_update_status === \'1\') {\r\n            body.sections[0].text = params.event_update_user + \' \' + params.event_update_action + \'.\';\r\n\r\n            if (params.event_update_message) {\r\n                body.sections[0].text += \'<br>Message:<br>\' + params.event_update_message;\r\n            }\r\n\r\n            facts.push({\r\n                name: \'Event update time\',\r\n                value: params.event_update_time + \' \' + params.event_update_date\r\n            });\r\n        }\r\n        // Resolved message.\r\n        else {\r\n            facts.push({\r\n                name: \'Recovery time\',\r\n                value: params.event_recovery_time + \' \' + params.event_recovery_date\r\n            });\r\n        }\r\n\r\n        if (params.event_severity && params.event_severity !== \'{EVENT.SEVERITY}\') {\r\n            facts.push({\r\n                name: \'Severity\',\r\n                value: params.event_severity\r\n            });\r\n        }\r\n\r\n\r\n        if (params.event_opdata && params.event_opdata !== \'{EVENT.OPDATA}\') {\r\n            facts.push({\r\n                name: \'Operational data\',\r\n                value: params.event_opdata\r\n            });\r\n        }\r\n\r\n        if (params.event_tags && params.event_tags !== \'{EVENT.TAGS}\') {\r\n            facts.push({\r\n                name: \'Event tags\',\r\n                value: params.event_tags\r\n            });\r\n        }\r\n\r\n        Object.keys(params)\r\n            .forEach(function (key) {\r\n                if (key.startsWith(\'fact_\') && params[key] !== \'\') {\r\n                    facts.push({\r\n                        name: key.substring(5),\r\n                        value: params[key]\r\n                    });\r\n                }\r\n                else if (key.startsWith(\'openUri_\') && params[key] !== \'\' && !params[key].startsWith(\'{\')) {\r\n                    body.potentialAction.push({\r\n                        \'@type\': \'OpenUri\',\r\n                        name: key.substring(8),\r\n                        targets: [\r\n                            {\r\n                                os: \'default\',\r\n                                uri: params[key]\r\n                            }\r\n                        ]\r\n                    });\r\n                }\r\n            });\r\n        body.sections[0].facts = facts;\r\n    }\r\n\r\n    body.sections[0].text = body.sections[0].text.replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n\r\n    request.AddHeader(\'Content-Type: application/json\');\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy !== \'\') {\r\n        request.SetProxy(params.HTTPProxy);\r\n    }\r\n\r\n    Zabbix.Log(4, \'[ MS Teams Webhook ] JSON: \' + JSON.stringify(body));\r\n\r\n    var response = request.Post(params.teams_endpoint, JSON.stringify(body));\r\n\r\n    Zabbix.Log(4, \'[ MS Teams Webhook ] Response: \' + response);\r\n\r\n    if (response === \'1\') {\r\n        return \'OK\';\r\n    }\r\n    else {\r\n        Zabbix.Log(4, \'[ MS Teams Webhook ] FAILED with response: \' + response);\r\n        throw response;\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ MS Teams Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('15','4','Redmine','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Redmine = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Redmine.params = params;\r\n        if (typeof Redmine.params.url === \'string\') {\r\n            if (!Redmine.params.url.endsWith(\'/\')) {\r\n                Redmine.params.url += \'/\';\r\n            }\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Redmine.getSchema();\r\n\r\n            if (schema) {\r\n                data.issue.custom_fields = [];\r\n\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        for (var idx in schema.custom_fields) {\r\n                            if (schema.custom_fields[idx].id != field) {\r\n                                continue;\r\n                            }\r\n\r\n                            var field_value;\r\n\r\n                            switch (schema.custom_fields[idx].field_format) {\r\n                                case \'string\':\r\n                                    field_value = fields[field];\r\n                                    break;\r\n\r\n                                case \'int\':\r\n                                    field_value = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'float\':\r\n                                    field_value = parseFloat(fields[field]);\r\n                                    break;\r\n\r\n                                case \'date\':\r\n                                    if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/)) {\r\n                                        field_value = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    break;\r\n                            }\r\n\r\n                            if (field_value !== undefined) {\r\n                                data.issue.custom_fields.push({id: field, value: field_value});\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.Log(4, \'[ Redmine Webhook ] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'access_key\'].forEach(function (field) {\r\n            if (typeof Redmine.params !== \'object\' || typeof Redmine.params[field] === \'undefined\'\r\n                || Redmine.params[field] === \'\' ) {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Redmine.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        if (typeof Redmine.HTTPProxy === \'string\' && Redmine.HTTPProxy.trim() !== \'\') {\r\n            request.SetProxy(Redmine.HTTPProxy);\r\n        }\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'X-Redmine-API-Key: \' + Redmine.params.access_key);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Redmine Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Redmine Webhook ] Received response with status code \' + request.Status() + \': \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Redmine Webhook ] Failed to parse response received from Redmine\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getProjectID: function(name) {\r\n        var result = Redmine.request(\'get\', \'projects.json\'),\r\n            project_id;\r\n\r\n        if (result.response) {\r\n            var projects = result.response.projects || [];\r\n\r\n            for (var i in projects) {\r\n                if (projects[i].name === name) {\r\n                    project_id = projects[i].id;\r\n                    break;\r\n                }\r\n            }\r\n        }\r\n        else {\r\n            Zabbix.Log(4, \'[ Redmine Webhook ] Failed to retrieve project data.\');\r\n        }\r\n\r\n        if (typeof project_id === \'undefined\') {\r\n            throw \'Cannot find project with name: \' + name;\r\n        }\r\n\r\n        return project_id;\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Redmine.request(\'get\', \'custom_fields.json\');\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(subject, description, priority, fields) {\r\n        var project_id = /^\\d+$/.test(Redmine.params.project)\r\n                ? Redmine.params.project\r\n                : Redmine.getProjectID(Redmine.params.project),\r\n            data = {\r\n                issue: {\r\n                    project_id: project_id,\r\n                    tracker_id: Redmine.params.tracker_id,\r\n                    subject: subject,\r\n                    description: description\r\n                }\r\n            },\r\n            result;\r\n\r\n        if (priority) {\r\n            data.issue.priority_id = priority;\r\n        }\r\n\r\n        result = Redmine.request(\'post\', \'issues.json\', Redmine.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.issue.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Redmine issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.issue.id;\r\n    },\r\n\r\n    updateIssue: function(note, fields) {\r\n        var data = {\r\n            issue: {\r\n                notes: note || \'\'\r\n            }\r\n        };\r\n\r\n        Redmine.request(\'put\', \'issues/\' + Redmine.params.issue_key + \'.json\', Redmine.addCustomFields(data, fields));\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_redmine = {},\r\n        params_fields = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'tracker_id\', \'project\',\r\n            \'event_source\', \'event_value\',  \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'redmine_\')) {\r\n                params_redmine[key.substring(8)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                params_fields[key.substring(12)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\'\r\n        && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\'\r\n                && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.redmine_issue_key)) || parseInt(params.redmine_issue_key) < 1 )) {\r\n        throw \'Incorrect "redmine_issue_key" parameter given: \' + params.redmine_issue_key +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    Redmine.setParams(params_redmine);\r\n    Redmine.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\'\r\n        && params.event_value !== \'0\') {\r\n        Redmine.createIssue(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        var issue_id = Redmine.createIssue(params.alert_subject,\r\n            params.alert_subject + \'\\n\' + params.alert_message + \'\\n\' +\r\n            params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\',\r\n            priority,\r\n            params_fields);\r\n\r\n        result.tags.__zbx_redmine_issue_id = issue_id;\r\n        result.tags.__zbx_redmine_issuelink = params.redmine_url +\r\n            (params.redmine_url.endsWith(\'/\') ? \'\' : \'/\') + \'issues/\' + issue_id;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        Redmine.updateIssue(params.alert_subject + \'\\n\' + params.alert_message, params_fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Redmine Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_redmine_issuelink}','Redmine: issue #{EVENT.TAGS.__zbx_redmine_issue_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('16','4','Telegram','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Telegram = {\r\n    token: null,\r\n    to: null,\r\n    message: null,\r\n    proxy: null,\r\n    parse_mode: null,\r\n\r\n    sendMessage: function() {\r\n        var params = {\r\n            chat_id: Telegram.to,\r\n            text: Telegram.message,\r\n            disable_web_page_preview: true,\r\n            disable_notification: false\r\n        },\r\n        data,\r\n        response,\r\n        request = new CurlHttpRequest(),\r\n        url = \'https://api.telegram.org/bot\' + Telegram.token + \'/sendMessage\';\r\n\r\n        if (Telegram.parse_mode !== null) {\r\n            params[\'parse_mode\'] = Telegram.parse_mode;\r\n        }\r\n\r\n        if (Telegram.proxy) {\r\n            request.SetProxy(Telegram.proxy);\r\n        }\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        data = JSON.stringify(params);\r\n\r\n        // Remove replace() function if you want to see the exposed token in the log file.\r\n        Zabbix.Log(4, \'[Telegram Webhook] URL: \' + url.replace(Telegram.token, \'<TOKEN>\'));\r\n        Zabbix.Log(4, \'[Telegram Webhook] params: \' + data);\r\n        response = request.Post(url, data);\r\n        Zabbix.Log(4, \'[Telegram Webhook] HTTP code: \' + request.Status());\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            response = null;\r\n        }\r\n\r\n        if (request.Status() !== 200 || typeof response.ok !== \'boolean\' || response.ok !== true) {\r\n            if (typeof response.description === \'string\') {\r\n                throw response.description;\r\n            }\r\n            else {\r\n                throw \'Unknown error. Check debug log for more information.\'\r\n            }\r\n        }\r\n    }\r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    if (typeof params.Token === \'undefined\') {\r\n        throw \'Incorrect value is given for parameter "Token": parameter is missing\';\r\n    }\r\n\r\n    Telegram.token = params.Token;\r\n\r\n    if (params.HTTPProxy) {\r\n        Telegram.proxy = params.HTTPProxy;\r\n    } \r\n\r\n    if ([\'Markdown\', \'HTML\', \'MarkdownV2\'].indexOf(params.ParseMode) !== -1) {\r\n        Telegram.parse_mode = params.ParseMode;\r\n    }\r\n\r\n    Telegram.to = params.To;\r\n    Telegram.message = params.Subject + \'\\n\' + params.Message;\r\n    Telegram.sendMessage();\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(4, \'[Telegram Webhook] notification failed: \' + error);\r\n    throw \'Sending failed: \' + error + \'.\';\r\n}','10s','0','0','','','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/telegram\r\n\r\n1. Register bot: send "/newbot" to @BotFather and follow instructions\r\n2. Copy and paste the obtained token into the "Token" field above\r\n3. If you want to send personal notifications, you need to get chat id of the user you want to send messages to:\r\n    3.1. Send "/getid" to "@myidbot" in Telegram messenger\r\n    3.2. Copy returned chat id and save it in the "Telegram Webhook" media for the user\r\n    3.3. Ask the user to send "/start" to your bot (Telegram bot won\'t send anything to the user without it)\r\n4. If you want to send group notifications, you need to get group id of the group you want to send messages to:\r\n    4.1. Add "@myidbot" to your group\r\n    4.2. Send "/getgroupid@myidbot" in your group\r\n    4.3. Copy returned group id save it in the "Telegram Webhook" media for the user you created for  group notifications\r\n    4.4. Send "/start@your_bot_name_here" in your group (Telegram bot won\'t send anything to the group without it)');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('17','4','Zendesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Zendesk = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Zendesk.params = params;\r\n        if (typeof Zendesk.params.url === \'string\') {\r\n            if (!Zendesk.params.url.endsWith(\'/\')) {\r\n                Zendesk.params.url += \'/\';\r\n            }\r\n            Zendesk.params.url += \'api/v2/\';\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Zendesk.getSchema(),\r\n                arr = [],\r\n                i,\r\n                n;\r\n\r\n            if (schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        for (i = 0, n = schema.ticket_fields.length; i < n; i++) {\r\n                            if (schema.ticket_fields[i].id == field\r\n                                && [\'text\', \'integer\', \'date\'].indexOf(schema.ticket_fields[i].type) !== -1){\r\n\r\n                                switch (schema.ticket_fields[i].type) {\r\n                                    case \'integer\':\r\n                                        fields[field] = parseInt(fields[field]);\r\n                                        break;\r\n                                    case \'date\':\r\n                                        if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/) !== null) {\r\n                                            fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                                        }\r\n                                        else {\r\n                                            fields[field] = \'\';\r\n                                        }\r\n                                        break;\r\n                                }\r\n\r\n                                arr.push({id: field, value: fields[field]});\r\n                                break;\r\n                            }\r\n                        }\r\n                    });\r\n\r\n                if (arr.length) {\r\n                    data.ticket[\'custom_fields\'] = arr;\r\n                }\r\n            }\r\n            else {\r\n                Zabbix.Log(4, \'[Zendesk Webhook] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'token\', \'type\'].forEach(function (field) {\r\n            if (typeof Zendesk.params !== \'object\' || typeof Zendesk.params[field] === \'undefined\') {\r\n                throw \'Required Zendesk param is not set: \' + field + \'\\n\' + Zendesk.params[field];\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Zendesk.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        if (typeof Zendesk.HTTPProxy === \'string\' && Zendesk.HTTPProxy.trim() !== \'\') {\r\n            request.SetProxy(Zendesk.HTTPProxy);\r\n        }\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(Zendesk.params.token));\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[Zendesk Webhook] Sending request: \' + url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[Zendesk Webhook] Received response with status code \' + request.Status() + \'. \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[Zendesk Webhook] Failed to parse response received from Zendesk.\');\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.error !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n            else if (response !== null && typeof response.description !== \'undefined\'\r\n                && Object.keys(response.description).length > 0) {\r\n                message += \': \' + JSON.stringify(response.description);\r\n            }\r\n            else {\r\n                message += \'. \' + response;\r\n            }\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Zendesk.request(\'get\', \'ticket_fields.json\');\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(data, fields) {\r\n        var result = Zendesk.request(\'post\', \'tickets.json\', Zendesk.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.ticket.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Zendesk issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.ticket.id;\r\n    },\r\n\r\n    updateIssue: function(data, fields) {\r\n        Zendesk.request(\'put\', \'tickets/\' + Zendesk.params.issue_key + \'.json\', Zendesk.addCustomFields(data, fields));\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        zendesk = {},\r\n        update = {},\r\n        data = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'zendesk_\')) {\r\n                zendesk[key.substring(8)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key.substring(12)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter \' + key + \' cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    // Possible values: question, incident, problems, task\r\n    if ([\'question\', \'incident\', \'problem\', \'task\'].indexOf(params.zendesk_type) === -1) {\r\n        throw \'Incorrect "zendesk_type" parameter given: \' + params.zendesk_type +\r\n            \'\\nMust be one of question, incident, problem, task.\';\r\n    }\r\n\r\n    // Possible values: 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    // Zendesk_issue_key must be a positive integer if an update action is being performed.\r\n    if (params.event_source === \'0\' && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n        || (params.event_value === \'0\' && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.zendesk_issue_key)) || parseInt(params.zendesk_issue_key) < 1 )) {\r\n        throw \'Incorrect "zendesk_issue_key" parameter given: \' + params.zendesk_issue_key +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name] || severities[7].name;\r\n\r\n    Zendesk.setParams(zendesk);\r\n    Zendesk.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_value !== \'0\') {\r\n        data = {\r\n            ticket: {\r\n                external_id: params.event_id,\r\n                type: Zendesk.params.type,\r\n                status: \'new\',\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.alert_message,\r\n                    public: \'false\'\r\n                },\r\n                priority: priority,\r\n                tags: params.event_tags\r\n            }\r\n        };\r\n\r\n        Zendesk.createIssue(data, fields);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\') {\r\n        data = {\r\n            ticket: {\r\n                external_id: params.event_id,\r\n                type: Zendesk.params.type,\r\n                status: \'new\',\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' +\r\n                        params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\' + params.alert_message,\r\n                    public: \'false\'\r\n                },\r\n                priority: priority,\r\n                tags: params.event_tags\r\n            }\r\n        };\r\n        var key = Zendesk.createIssue(data, fields);\r\n\r\n        result.tags.__zbx_zdk_issuekey = key;\r\n        result.tags.__zbx_zdk_issuelink = params.zendesk_url +\r\n            (params.zendesk_url.endsWith(\'/\') ? \'\' : \'/\') + \'agent/tickets/\' + key;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        data = {\r\n            ticket: {\r\n                type: Zendesk.params.type,\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.alert_message,\r\n                    public: \'false\'\r\n                }\r\n            }\r\n        };\r\n\r\n        Zendesk.updateIssue(data, fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[Zendesk Webhook] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_zdk_issuelink}','Zendesk: {EVENT.TAGS.__zbx_zdk_issuekey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('18','4','ServiceNow','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var ServiceNow = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        ServiceNow.params = params;\r\n        if (typeof ServiceNow.params.url === \'string\') {\r\n            if (!ServiceNow.params.url.endsWith(\'/\')) {\r\n                ServiceNow.params.url += \'/\';\r\n            }\r\n\r\n            ServiceNow.params.url += \'api/now/table/incident\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        ServiceNow.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    data[field] = (fields[field].match(/^\\d{4}\\.\\d{2}\\.\\d{2}$/) !== null)\r\n                        ? fields[field].replace(/\\./g, \'-\')\r\n                        : fields[field];\r\n                });\r\n        }\r\n    },\r\n\r\n    request: function (method, data) {\r\n        [\'url\', \'user\', \'password\'].forEach(function (field) {\r\n            if (typeof ServiceNow.params !== \'object\' || typeof ServiceNow.params[field] === \'undefined\'\r\n                || ServiceNow.params[field] === \'\' ) {\r\n                throw \'Required ServiceNow param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = ServiceNow.params.url,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(ServiceNow.params.user + \':\' + ServiceNow.params.password));\r\n\r\n        if (typeof ServiceNow.HTTPProxy !== \'undefined\' && ServiceNow.HTTPProxy !== \'\') {\r\n            request.SetProxy(ServiceNow.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ ServiceNow Webhook ] Sending request: \' + url + ((typeof data === \'string\')\r\n            ? (\'\\n\' + data)\r\n            : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ ServiceNow Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ ServiceNow Webhook ] Failed to parse response received from ServiceNow\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.error.message !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error.message);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.result !== \'object\' || typeof response.result.sys_id === \'undefined\') {\r\n            throw \'Cannot create ServiceNow incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return response.result;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        servicenow = {},\r\n        data = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'alert_message\', \'event_source\', \'event_value\',\r\n            \'event_update_status\', \'event_recovery_value\', \'event_nseverity\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        method = \'post\',\r\n        process_tags = true;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'servicenow_\')) {\r\n                servicenow[key.substring(11)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'u_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    data.short_description = params.alert_subject;\r\n    data.description = params.alert_message;\r\n\r\n    if (typeof params[\'urgency_for_\' + severities[params.event_nseverity].name] !== \'undefined\') {\r\n        data.urgency = params[\'urgency_for_\' + severities[params.event_nseverity].name];\r\n    }\r\n\r\n    ServiceNow.setParams(servicenow);\r\n    ServiceNow.setProxy(params.HTTPProxy);\r\n    ServiceNow.setFields(data, fields);\r\n\r\n    if (params.event_source === \'0\' && (params.event_value === \'0\' || params.event_update_status === \'1\')) {\r\n        process_tags = false;\r\n        method = \'put\';\r\n        delete data.description;\r\n        delete data.urgency;\r\n        ServiceNow.params.url += \'/\' + params.servicenow_sys_id;\r\n        data.comments = params.alert_message;\r\n    }\r\n\r\n    var response = ServiceNow.request(method, data);\r\n\r\n    if (process_tags) {\r\n        result.tags.__zbx_servicenow_sys_id = response.sys_id;\r\n        result.tags.__zbx_servicenow_link = params.servicenow_url +\r\n            (params.servicenow_url.endsWith(\'/\') ? \'\' : \'/\') + \'incident.do?sys_id=\' + response.sys_id;\r\n        result.tags.__zbx_servicenow_number = response.number;\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ ServiceNow Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_servicenow_link}','ServiceNow: {EVENT.TAGS.__zbx_servicenow_number}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('19','4','Zammad','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Zammad = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Zammad.params = params;\r\n        if (typeof Zammad.params.url === \'string\') {\r\n            if (!Zammad.params.url.endsWith(\'/\')) {\r\n                Zammad.params.url += \'/\';\r\n            }\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'access_token\'].forEach(function (field) {\r\n            if (typeof Zammad.params !== \'object\' || typeof Zammad.params[field] === \'undefined\'\r\n                || Zammad.params[field] === \'\' ) {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Zammad.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        if (typeof Zammad.HTTPProxy === \'string\' && Zammad.HTTPProxy.trim() !== \'\') {\r\n            request.SetProxy(Zammad.HTTPProxy);\r\n        }\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Token token=\' + Zammad.params.access_token);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Zammad Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Zammad Webhook ] Received response with status code \' + request.Status() + \': \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Zammad Webhook ] Failed to parse response received from Zammad\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    setTicketTags: function(tags, ticket_id) {\r\n        try {\r\n            var tags_json = JSON.parse(tags),\r\n                result;\r\n\r\n            for (var i in tags_json) {\r\n                result = Zammad.request(\'get\',\r\n                    \'/api/v1/tags/add?object=Ticket&o_id=\' + ticket_id +\r\n                    \'&item=\' + tags_json[i].tag);\r\n\r\n                if (typeof result.response !== \'object\'\r\n                    || result.status != 200) {\r\n                    Zabbix.Log(4, \'[ Zammad Webhook ] Cannot add ticket tag:\' + tags_json[i].tag);\r\n                }\r\n            }\r\n        }\r\n        catch (error) {\r\n            Zabbix.Log(4, \'[ Zammad Webhook ] Failed to add ticket tags:\' + error);\r\n        }\r\n\r\n        return;\r\n    },\r\n\r\n    createTicket: function(subject, message, priority) {\r\n        var data = {\r\n                title: subject,\r\n                group: \'Users\',\r\n                article: {\r\n                    subject: subject,\r\n                    body: message,\r\n                    type: \'note\',\r\n                    internal: false\r\n                },\r\n                customer: Zammad.params.customer\r\n            },\r\n            result;\r\n\r\n        if (priority) {\r\n            data.priority_id = priority;\r\n        }\r\n\r\n        result = Zammad.request(\'post\', \'api/v1/tickets\', data);\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Zammad ticket. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateTicket: function(subject, message) {\r\n        var data = {\r\n            ticket_id: Zammad.params.ticket_id,\r\n            subject: subject,\r\n            body: message || \'\',\r\n            type: \'note\',\r\n            internal: false\r\n        };\r\n\r\n        result = Zammad.request(\'post\', \'api/v1/ticket_articles\', data);\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot update Zammad ticket. Check debug log for more information.\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_zammad = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'customer\',\r\n            \'event_source\', \'event_value\',\r\n            \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'zammad_\')) {\r\n                params_zammad[key.substring(7)] = params[key].trim();\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\'\r\n        && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\'\r\n                && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.zammad_ticket_id)) || parseInt(params.zammad_ticket_id) < 1 )) {\r\n        throw \'Incorrect "zammad_ticket_id" parameter given: \' + params.zammad_ticket_id +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    Zammad.setParams(params_zammad);\r\n    Zammad.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create ticket for non trigger-based events.\r\n    if (params.event_source !== \'0\'\r\n        && params.event_value !== \'0\') {\r\n        Zammad.createTicket(params.alert_subject, params.alert_message, priority, params.event_tags);\r\n    }\r\n    // Create ticket for trigger-based events.\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        var ticket_id = Zammad.createTicket(params.alert_subject,\r\n            params.alert_subject + \'\\n\' + params.alert_message + \'\\n\' +\r\n            params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\',\r\n            priority);\r\n\r\n        result.tags.__zbx_zammad_ticket_id = ticket_id;\r\n        result.tags.__zbx_zammad_ticketlink = params.zammad_url +\r\n            (params.zammad_url.endsWith(\'/\') ? \'\' : \'/\') + \'#ticket/zoom/\' + ticket_id;\r\n\r\n        if (Zammad.params.enable_tags.toLowerCase() === \'true\') {\r\n            Zammad.setTicketTags(params.event_tags, ticket_id);\r\n        }\r\n    }\r\n    // Update created ticket for trigger-based event.\r\n    else {\r\n        Zammad.updateTicket(params.alert_subject, params.alert_message);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Zammad Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_zammad_ticketlink}','Zammad: ticket #{EVENT.TAGS.__zbx_zammad_ticket_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('20','4','Jira ServiceDesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Jira = {\r\n    params: {},\r\n    schema: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Jira.params = params;\r\n        if (typeof Jira.params.url === \'string\') {\r\n            if (!Jira.params.url.endsWith(\'/\')) {\r\n                Jira.params.url += \'/\';\r\n            }\r\n\r\n            Jira.params.url += \'rest/servicedeskapi/latest/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Jira.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (!Jira.schema) {\r\n            Zabbix.Log(4, \'[ Jira Service Desk Webhook ] Cannot add labels because failed to retrieve field schema.\');\r\n\r\n            return;\r\n        }\r\n\r\n        var block = Jira.schema.requestTypeFields.filter(function(object) {\r\n            return object.fieldId == \'labels\';\r\n        });\r\n\r\n        if (block[0] && typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n            && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                Jira.labels = [];\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\' ) {\r\n                        label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        if (label.length < 255) {\r\n                            Jira.labels.push(label);\r\n                        }\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                // Code is not missing here.\r\n            }\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            if (Jira.schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        data.requestFieldValues[field] = fields[field];\r\n\r\n                        var block = Jira.schema.requestTypeFields.filter(function(object) {\r\n                            return object.fieldId == field;\r\n                        });\r\n\r\n                        if (typeof block[0] === \'object\' && typeof block[0].jiraSchema === \'object\'\r\n                            && (block[0].jiraSchema.type === \'number\' || block[0].jiraSchema.type === \'datetime\')) {\r\n                            switch (block[0].jiraSchema.type) {\r\n                                case \'number\':\r\n                                    data.requestFieldValues[field] = parseInt(fields[field]);\r\n                                    break;\r\n\r\n                                case \'datetime\':\r\n                                    if (fields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n                                        data.requestFieldValues[field] = fields[field].replace(/\\./g, \'-\');\r\n                                    }\r\n                                    else {\r\n                                        delete data.requestFieldValues[field];\r\n                                    }\r\n                                    break;\r\n                            }\r\n                        }\r\n                    });\r\n            }\r\n            else {\r\n                Zabbix.Log(4, \'[ Jira Service Desk Webhook ] Cannot add custom fields\' +\r\n                    \'because failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'user\', \'password\', \'servicedesk_id\', \'request_type_id\'].forEach(function (field) {\r\n            if (typeof Jira.params !== \'object\' || typeof Jira.params[field] === \'undefined\'\r\n                || Jira.params[field] === \'\' ) {\r\n                throw \'Required Jira param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Jira.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(Jira.params.user + \':\' + Jira.params.password));\r\n        request.AddHeader(\'X-ExperimentalApi: opt-in\');\r\n\r\n        if (typeof Jira.HTTPProxy !== \'undefined\' && Jira.HTTPProxy !== \'\') {\r\n            request.SetProxy(Jira.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Service Desk Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ Jira Service Desk Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ Jira Service Desk Webhook ] Failed to parse response received from Jira\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessage !== \'undefined\'\r\n                && Object.keys(response.errorMessage).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessage);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Jira.request(\'get\', \'servicedesk/\' + Jira.params.servicedesk_id + \'/requesttype/\' +\r\n            Jira.params.request_type_id + \'/field\');\r\n\r\n        if (typeof Jira.schema !== \'object\' && typeof Jira.schema.requestTypeFields !== \'object\') {\r\n            Jira.schema = null;\r\n        }\r\n        else {\r\n            Jira.schema = result.response;\r\n        }\r\n    },\r\n\r\n    createRequest: function(summary, description, fields) {\r\n        var data = {\r\n            serviceDeskId: Jira.params.servicedesk_id,\r\n            requestTypeId: Jira.params.request_type_id,\r\n            requestFieldValues: {\r\n                summary: summary,\r\n                description: description\r\n            }\r\n        };\r\n\r\n        if (Jira.labels && Jira.labels.length > 0) {\r\n            data.requestFieldValues.labels = Jira.labels;\r\n        }\r\n        var result = Jira.request(\'post\', \'request\', Jira.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.issueKey === \'undefined\') {\r\n            throw \'Cannot create Jira request. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.issueKey;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        jira = {},\r\n        comment = {public: true},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'alert_message\', \'event_source\', \'event_value\',\r\n            \'event_update_status\', \'event_recovery_value\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'jira_\')) {\r\n                jira[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Jira.setParams(jira);\r\n    Jira.setProxy(params.HTTPProxy);\r\n    Jira.getSchema();\r\n    Jira.setTags(params.event_tags_json);\r\n\r\n    // Create request for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Jira.createRequest(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create request for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n        && jira.request_key === \'{EVENT.TAGS.__zbx_jira_requestkey}\') {\r\n        var key = Jira.createRequest(params.alert_subject, params.alert_message, fields);\r\n\r\n        result.tags.__zbx_jira_requestkey = key;\r\n        result.tags.__zbx_jira_requestlink = params.jira_url +\r\n            (params.jira_url.endsWith(\'/\') ? \'\' : \'/\') + \'browse/\' + key;\r\n    }\r\n    // Comment created request for trigger-based event.\r\n    else {\r\n        if (jira.request_key === \'{EVENT.TAGS.__zbx_jira_requestkey}\' || jira.request_key.trim() === \'\') {\r\n            throw \'Incorrect Request key given: \' + jira.request_key;\r\n        }\r\n        comment.body = params.alert_message;\r\n        Jira.request(\'post\', \'request/\' + Jira.params.request_key + \'/comment\', comment);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ Jira Service Desk Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_requestlink}','Jira ServiceDesk: {EVENT.TAGS.__zbx_jira_requestkey}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('21','4','OTRS','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var OTRS = {\r\n    params: {},\r\n    entrypoint: \'nph-genericinterface.pl/Webservice/ZabbixTicketConnector/Ticket\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        OTRS.params = params;\r\n        if (typeof OTRS.params.url === \'string\') {\r\n            if (!OTRS.params.url.endsWith(\'/\')) {\r\n                OTRS.params.url += \'/\';\r\n            }\r\n        }\r\n    },\r\n\r\n    addDynamicFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            data.DynamicField = [];\r\n\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (field !== undefined) {\r\n                        if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/)) {\r\n                            fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                        }\r\n\r\n                        data.DynamicField.push({Name: field, Value: fields[field]});\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'auth_user\', \'auth_password\', \'queue\',\r\n            \'customer\', \'ticket_state\', \'default_priority_id\', \'time_unit\'].forEach(function (field) {\r\n            if (typeof OTRS.params !== \'object\' || typeof OTRS.params[field] === \'undefined\'\r\n                || OTRS.params[field] === \'\' ) {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            request = new CurlHttpRequest(),\r\n            url = OTRS.params.url + query +\r\n                \'?UserLogin=\' + encodeURIComponent(OTRS.params.auth_user) +\r\n                \'&Password=\' + encodeURIComponent(OTRS.params.auth_password);\r\n\r\n        if (typeof OTRS.HTTPProxy !== \'undefined\' && OTRS.HTTPProxy.trim() !== \'\') {\r\n            request.SetProxy(OTRS.HTTPProxy);\r\n        }\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ OTRS Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ OTRS Webhook ] Received response with status code \' + request.Status() + \': \' + response);\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            message += \': \' + response;\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ OTRS Webhook ] Failed to parse response received from OTRS\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (typeof response.Error !== \'undefined\'\r\n            && Object.keys(response.Error).length > 0) {\r\n            message = \'Request failed: \' + JSON.stringify(response.Error);\r\n        }\r\n\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createTicket: function(subject, message, priority, fields) {\r\n        var result,\r\n            data = {\r\n                Ticket: {\r\n                    Title: subject,\r\n                    Queue: OTRS.params.queue,\r\n                    State: OTRS.params.ticket_state,\r\n                    PriorityID: priority || OTRS.params.default_priority_id,\r\n                    CustomerUser: OTRS.params.customer\r\n                },\r\n                Article: {\r\n                    Subject: subject,\r\n                    Body: message,\r\n                    TimeUnit: OTRS.params.time_unit,\r\n                    ContentType: \'text/plain; charset=utf8\'\r\n                }\r\n            };\r\n\r\n        result = OTRS.request(\'post\', OTRS.entrypoint, OTRS.addDynamicFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.TicketID === \'undefined\'\r\n            || result.status != 200) {\r\n            throw \'Cannot create OTRS ticket. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.TicketID;\r\n    },\r\n\r\n    updateTicket: function(subject, message) {\r\n        var result,\r\n            data = {\r\n                Article: {\r\n                    Subject: subject,\r\n                    Body: message || \'\',\r\n                    TimeUnit: OTRS.params.time_unit,\r\n                    ContentType: \'text/plain; charset=utf8\'\r\n                }\r\n            };\r\n\r\n        result = OTRS.request(\'put\', OTRS.entrypoint + \'/\' + encodeURIComponent(OTRS.params.ticket_id), data);\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.TicketID === \'undefined\'\r\n            || result.status != 200) {\r\n            throw \'Cannot update OTRS ticket. Check debug log for more information.\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_otrs = {},\r\n        params_fields = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'event_source\',\r\n            \'event_value\',  \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'otrs_\')) {\r\n                params_otrs[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'dynamicfield_\')) {\r\n                params_fields[key.substring(13)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\'\r\n        && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\'\r\n                && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.otrs_ticket_id)) || parseInt(params.otrs_ticket_id) < 1 )) {\r\n        throw \'Incorrect "otrs_ticket_id" parameter given: \' + params.otrs_ticket_id +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    OTRS.setParams(params_otrs);\r\n    OTRS.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create ticket for non trigger-based events.\r\n    if (params.event_source !== \'0\'\r\n        && params.event_value !== \'0\') {\r\n        OTRS.createTicket(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    // Create ticket for trigger-based events.\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        var ticket_id = OTRS.createTicket(params.alert_subject,\r\n            params.alert_subject + \'\\n\' + params.alert_message + \'\\n\' +\r\n            params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\',\r\n            priority,\r\n            params_fields);\r\n\r\n        result.tags.__zbx_otrs_ticket_id = ticket_id;\r\n        result.tags.__zbx_otrs_ticketlink = params.otrs_url +\r\n            (params.otrs_url.endsWith(\'/\') ? \'\' : \'/\') + \'index.pl?Action=AgentTicketZoom;TicketID=\' + ticket_id;\r\n    }\r\n    // Update created ticket for trigger-based event.\r\n    else {\r\n        OTRS.updateTicket(params.alert_subject, params.alert_message);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ OTRS Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_otrs_ticketlink}','OTRS: ticket #{EVENT.TAGS.__zbx_otrs_ticket_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('22','4','iLert','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','try {\r\n    var result = { tags: {} },\r\n        params = JSON.parse(value),\r\n        req = new CurlHttpRequest(),\r\n        resp = \'\';\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.SetProxy(params.HTTPProxy);\r\n    }\r\n    var alertSourceKey = params[\'.ILERT.ALERT.SOURCE.KEY\'];\r\n    if (!alertSourceKey || (typeof alertSourceKey === \'string\' && alertSourceKey.trim() === \'\')) {\r\n        throw \'incorrect value for variable "ILERT.ALERT.SOURCE.KEY". The value must be a non-empty string.\';\r\n    }\r\n    delete params[\'.ILERT.ALERT.SOURCE.KEY\'];\r\n    \r\n    var ilertApiBaseURL = "https://api.ilert.com";\r\n    var reqURL = encodeURI(ilertApiBaseURL + "/api/v1/events/zabbix-mt/" + alertSourceKey)\r\n\r\n    var incidentKey = "zabbix-" + params[\'EVENT.ID\'];\r\n    var incidentViewURL = ilertApiBaseURL + "/api/v1/incidents/resolve-ik/" + alertSourceKey + "/" + incidentKey;\r\n\r\n    req.AddHeader(\'Accept: application/json\');\r\n    req.AddHeader(\'Content-Type: application/json\');\r\n\r\n    Zabbix.Log(4, \'[iLert Webhook] Sending request:\' + JSON.stringify(params));\r\n    resp = req.Post(reqURL, JSON.stringify(params));\r\n    Zabbix.Log(4, \'[iLert Webhook] Receiving response:\' + resp);\r\n\r\n    try {\r\n        resp = JSON.parse(resp);\r\n    }\r\n    catch (error) {\r\n        throw \'incorrect response. iLert returned a non-JSON object.\';\r\n    }\r\n\r\n    if (req.Status() == 200) {\r\n        result.tags.__ilert_incident_url = incidentViewURL;\r\n        return JSON.stringify(result);\r\n    }\r\n\r\n    if (req.Status() == 400 && typeof resp === \'object\' && typeof resp.code === \'string\') {\r\n        if (resp.code === \'NO_OPEN_INCIDENT_WITH_KEY\') {\r\n          return JSON.stringify(result);\r\n        }\r\n        if (resp.code === \'INCIDENT_ALREADY_ACCEPTED\') {\r\n          result.tags.__ilert_incident_url = incidentViewURL;\r\n          return JSON.stringify(result);\r\n        }\r\n    }\r\n\r\n    if (typeof resp === \'object\' && typeof resp.message === \'string\') {\r\n        throw resp.message;\r\n    }\r\n    else {\r\n        throw \'Unknown error.\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[iLert Webhook] Notification failed : \' + error);\r\n    throw \'iLert notification failed : \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__ilert_incident_url}','iLert incident','Please refer to https://docs.ilert.com/integrations/zabbix/native \r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "iLert". You can also rewrite the incident summary via ".ILERT.INCIDENT.SUMMARY" parameter or leave it empty to use the standard pattern.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('23','4','SolarWinds Service Desk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SolarWinds = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        SolarWinds.params = params;\r\n        SolarWinds.params.endpoint = \'https://api.samanage.com/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        SolarWinds.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof data.incident === \'object\' && typeof fields === \'object\' && Object.keys(fields).length) {\r\n            if (typeof fields.sw_fields === \'object\' && Object.keys(fields.sw_fields).length) {\r\n                Object.keys(fields.sw_fields)\r\n                    .forEach(function(field) {\r\n                        try {\r\n                            data.incident[field] = JSON.parse(fields.sw_fields[field]);\r\n                        }\r\n                        catch (error) {\r\n                            data.incident[field] = fields.sw_fields[field];\r\n                        }\r\n                    });\r\n            }\r\n\r\n            if (typeof fields.sw_customfields === \'object\' && Object.keys(fields.sw_customfields).length) {\r\n                data.incident.custom_fields_values = {custom_fields_value: []};\r\n                Object.keys(fields.sw_customfields)\r\n                    .forEach(function(field) {\r\n                        data.incident.custom_fields_values.custom_fields_value.push({\r\n                            name: field,\r\n                            value: fields.sw_customfields[field]\r\n                        });\r\n                    });\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'token\'].forEach(function (field) {\r\n            if (typeof SolarWinds.params !== \'object\' || typeof SolarWinds.params[field] === \'undefined\'\r\n                || SolarWinds.params[field] === \'\' ) {\r\n                throw \'Required SolarWinds param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = SolarWinds.params.endpoint + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'X-Samanage-Authorization: Bearer \' + SolarWinds.params.token);\r\n        request.AddHeader(\'Accept: application/vnd.samanage.v2.1+json\');\r\n\r\n        if (typeof SolarWinds.HTTPProxy !== \'undefined\' && SolarWinds.HTTPProxy !== \'\') {\r\n            request.SetProxy(SolarWinds.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ SolarWinds SD Webhook ] Sending request: \' + url + ((typeof data === \'string\')\r\n            ? (\'\\n\' + data)\r\n            : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ SolarWinds SD Webhook ] Received response with status code \' + request.Status() +\r\n            \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ SolarWinds SD Webhook ] Failed to parse response received from SolarWinds\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.error !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n            else if (response !== null && typeof response === \'object\'\r\n                && Object.keys(response).length > 0) {\r\n                Object.keys(response)\r\n                    .forEach(function(field) {\r\n                        message += \'\\n\' + field + \': \' + response[field][0];\r\n                    });\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createIncident: function(name, description, fields) {\r\n        var data = {\r\n            incident: {\r\n                name: name,\r\n                description: description,\r\n                priority: SolarWinds.params.priority\r\n            }\r\n        };\r\n\r\n        var result = SolarWinds.request(\'post\', \'incidents.json\', SolarWinds.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.id === \'undefined\') {\r\n            throw \'Cannot create SolarWinds incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateIncident: function(name, fields, message) {\r\n        var data = {\r\n            incident: {\r\n                name: name,\r\n                priority: SolarWinds.params.priority\r\n            }\r\n        };\r\n\r\n        SolarWinds.request(\r\n            \'put\',\r\n            \'incidents/\' + SolarWinds.params.incident_id + \'.json\',\r\n            SolarWinds.addCustomFields(data, fields));\r\n\r\n        SolarWinds.commenIncident(message);\r\n    },\r\n\r\n    commenIncident: function(message) {\r\n        var data = {\r\n            comment: {\r\n                body: message\r\n            }\r\n        };\r\n\r\n        SolarWinds.request(\'post\', \'incidents/\' + SolarWinds.params.incident_id + \'/comments.json\', data);\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        samanage = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'event_recovery_value\', \'event_source\', \'event_value\', \'priority_default\'],\r\n        severities = [\r\n            {name: \'not_classified\'},\r\n            {name: \'information\'},\r\n            {name: \'warning\'},\r\n            {name: \'average\'},\r\n            {name: \'high\'},\r\n            {name: \'disaster\'},\r\n            {name: \'resolved\'},\r\n            {name: \'default\'}\r\n        ];\r\n\r\n    fields.sw_fields = {};\r\n    fields.sw_customfields = {};\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'samanage_\')) {\r\n                samanage[key.substring(9)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'sw_field_\')) {\r\n                fields.sw_fields[key.substring(9)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'sw_customfield_\')) {\r\n                fields.sw_customfields[key.substring(15)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    samanage.priority = params[\'priority_\' + severities[params.event_nseverity].name] || params.priority_default;\r\n\r\n    SolarWinds.setParams(samanage);\r\n    SolarWinds.setProxy(params.HTTPProxy);\r\n\r\n    // Create incident for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        SolarWinds.createIncident(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create incident for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n            && samanage.incident_id === \'{EVENT.TAGS.__zbx_solarwinds_inc_id}\') {\r\n        var key = SolarWinds.createIncident(params.alert_subject, params.alert_message, fields);\r\n\r\n\r\n        result.tags.__zbx_solarwinds_inc_id = key;\r\n        result.tags.__zbx_solarwinds_inc_link = params.samanage_url +\r\n            (params.samanage_url.endsWith(\'/\') ? \'\' : \'/\') + \'incidents/\' + key;\r\n    }\r\n    // Update created incident for trigger-based event.\r\n    else {\r\n        if (samanage.incident_id === \'{EVENT.TAGS.__zbx_solarwinds_inc_id}\' || samanage.incident_id === \'\') {\r\n            throw \'Incorrect incident key given: \' + samanage.incident_id;\r\n        }\r\n        if (!params.alert_message) {\r\n            throw \'Parameter "alert_message" can\\\'t be empty.\';\r\n        }\r\n        SolarWinds.updateIncident(params.alert_subject, fields, params.alert_message);\r\n    }\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ SolarWinds SD Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_solarwinds_inc_link}','SolarWinds incident ID: {EVENT.TAGS.__zbx_solarwinds_inc_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('24','4','SysAid','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var SysAid = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        var required = [\'url\', \'auth_user\', \'auth_password\', \'category_level_1\', \'category_level_2\',\r\n            \'category_level_3\', \'incident_id\', \'template_id\', \'urgency_id\', \'incident_state\',\r\n            \'default_priority_id\'\r\n        ];\r\n\r\n        required.forEach(function (field) {\r\n            if (typeof params !== \'object\' || typeof params[field] === \'undefined\' || params[field] === \'\') {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        SysAid.params = params;\r\n        if (typeof SysAid.params.url === \'string\' && !SysAid.params.url.endsWith(\'/\')) {\r\n            SysAid.params.url += \'/\';\r\n        }\r\n    },\r\n\r\n    login: function () {\r\n        var result = SysAid.request(\'post\', \'api/v1/login\', {\r\n            user_name: SysAid.params.auth_user,\r\n            password: SysAid.params.auth_password\r\n        });\r\n\r\n        return result.response.user.id;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        var response,\r\n            request = SysAid.req || (SysAid.req = new CurlHttpRequest()),\r\n            url = SysAid.params.url + query;\r\n\r\n        if (typeof SysAid.HTTPProxy !== \'undefined\' && SysAid.HTTPProxy.trim() !== \'\') {\r\n            request.SetProxy(SysAid.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ SysAid Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ SysAid Webhook ] Received response with status code \' + request.Status() + \': \' + response);\r\n\r\n        if (request.Status() !== 200) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            message += \': \' + response;\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ SysAid Webhook ] Failed to parse response received from SysAid\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (response === null || (typeof response.Error !== \'undefined\' && Object.keys(response.Error).length > 0)) {\r\n            throw \'Request failed: \' + JSON.stringify(response.Error);\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createIncident: function(subject, message, priority) {\r\n        var result = SysAid.request(\'post\', \'api/v1/sr/?template=\' + encodeURIComponent(SysAid.params.template_id), {\r\n            info: [\r\n                {\r\n                    key: \'problem_type\',\r\n                    value: [\r\n                        SysAid.params.category_level_1,\r\n                        SysAid.params.category_level_2,\r\n                        SysAid.params.category_level_3\r\n                    ].join(\'_\')\r\n                },\r\n                {\r\n                    key: \'title\',\r\n                    value: subject\r\n                },\r\n                {\r\n                    key: \'description\',\r\n                    value: message\r\n                },\r\n                {\r\n                    key: \'status\',\r\n                    value: \'1\'\r\n                },\r\n                {\r\n                    key: \'urgency\',\r\n                    value: SysAid.params.urgency_id\r\n                },\r\n                {\r\n                    key: \'priority\',\r\n                    value: priority || SysAid.params.default_priority_id,\r\n                }\r\n            ]\r\n        });\r\n\r\n        if (result.response.id === \'undefined\') {\r\n            throw \'Cannot create SysAid incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateTicket: function(note) {\r\n        var date = new Date().getTime();\r\n\r\n        SysAid.request(\'put\', \'api/v1/sr/\' + encodeURIComponent(SysAid.params.incident_id), {\r\n            id: SysAid.params.incident_id,\r\n            info: [\r\n                {\r\n                    key: \'update_time\',\r\n                    value: date\r\n                },\r\n                {\r\n                    key: \'notes\',\r\n                    value: [\r\n                        {\r\n                            userName: \'Zabbix\',\r\n                            createDate: date,\r\n                            text: note\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        });\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_sysaid = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'event_source\', \'event_value\',  \'event_update_status\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'sysaid_\')) {\r\n                params_sysaid[key.substring(7)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\' && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\' && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n            && (isNaN(parseInt(params.sysaid_incident_id)) || parseInt(params.sysaid_incident_id) < 1 )) {\r\n        throw \'Incorrect "sysaid_incident_id" parameter given: \' + params.sysaid_incident_id + \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    SysAid.setParams(params_sysaid);\r\n    SysAid.HTTPProxy = params.HTTPProxy;\r\n    SysAid.login();\r\n\r\n    if (params.event_source !== \'0\' && params.event_value !== \'0\') {\r\n        // Create ticket for non trigger-based events.\r\n        SysAid.createIncident(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        // Create ticket for trigger-based events.\r\n        var incident_id = SysAid.createIncident(params.alert_subject, params.alert_subject + \'\\n\' + params.alert_message +\r\n                \'\\n\' + params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' +\r\n                params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\', priority\r\n        );\r\n\r\n        result.tags.__zbx_sysaid_incident_id = incident_id;\r\n        result.tags.__zbx_sysaid_incidentlink = params.sysaid_url +\r\n            (params.sysaid_url.endsWith(\'/\') ? \'\' : \'/\') + \'SREdit.jsp?id=\' + incident_id + \'&fromId=IncidentsList\';\r\n    }\r\n    else {\r\n        // Update created ticket for trigger-based event.\r\n        SysAid.updateTicket(params.alert_subject + \'\\n\' + params.alert_message);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ SysAid Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_sysaid_incidentlink}','SysAid: incident #{EVENT.TAGS.__zbx_sysaid_incident_id}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('25','4','TOPdesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Media = {\r\n    params: {},\r\n    name: \'\',\r\n    labels: [],\r\n    HTTPProxy: \'\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Media.params = params;\r\n        Media.params.api += Media.params.api.endsWith(\'/\') ? \'\' : \'/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        if (typeof HTTPProxy !== \'undefined\' && HTTPProxy.trim() !== \'\') {\r\n            Media.HTTPProxy = HTTPProxy;\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'api\', \'token\'].forEach(function (field) {\r\n            if (typeof Media.params !== \'object\' || typeof Media.params[field] === \'undefined\'\r\n                    || Media.params[field] === \'\') {\r\n                throw \'Required \' + Media.name + \' param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Media.params.api + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'Accept: application/json\');\r\n        request.AddHeader(\'Authorization: \' + Media.params.token);\r\n        request.SetProxy(Media.HTTPProxy);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.Put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse response.\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null) {\r\n                if (typeof response.errors === \'object\' && Object.keys(response.errors).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errors);\r\n                }\r\n                else if (typeof response.errorMessages === \'object\' && Object.keys(response.errorMessages).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errorMessages);\r\n                }\r\n                else if (typeof response.message === \'string\') {\r\n                    message += \': \' + response.message;\r\n                }\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    }\r\n};\r\n\r\ntry {\r\n    var result = {tags: {}},\r\n        params = JSON.parse(value),\r\n        media = {},\r\n        fields = {},\r\n        resp = {},\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\',\r\n            \'topdesk_api\',\r\n            \'topdesk_user\',\r\n            \'topdesk_password\'\r\n        ],\r\n        severities = [\r\n            \'not_classified\',\r\n            \'information\',\r\n            \'warning\',\r\n            \'average\',\r\n            \'high\',\r\n            \'disaster\',\r\n            \'resolved\',\r\n            \'default\'\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n            if (key.startsWith(\'topdesk_\')) {\r\n                media[key.substring(8)] = params[key];\r\n            }\r\n        });\r\n\r\n    // Possible values of event_source:\r\n    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check event_value for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_update_status only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_id for a numeric value.\r\n    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {\r\n        throw \'Incorrect "event_id" parameter given: \' + params.event_id + \'\\nMust be a positive number.\';\r\n    }\r\n\r\n    if ((params.event_source === \'1\' || params.event_source === \'2\')  && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for Trigger and Internal actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity]];\r\n    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n    Media.name = \'TOPdesk\';\r\n    Media.setParams(media);\r\n    Media.params.token = \'Basic \' + btoa(Media.params.user + \':\' + Media.params.password);\r\n    Media.setProxy(params.HTTPProxy);\r\n\r\n    // Create an issue.\r\n    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).\r\n    // Numeric value of of the problem update status. Possible values:\r\n    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)\r\n            || (params.event_source == 3 && params.event_value == 1)\r\n            || params.event_source == 1 || params.event_source == 2) {\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Request of the ticket creating.\');\r\n        fields.caller = {dynamicName: \'Zabbix\'};\r\n        fields.briefDescription = params.alert_subject;\r\n        fields.request = params.alert_message.replace(/\\n/g, \'<br>\');\r\n        fields.priority = {name: priority};\r\n        fields.processingStatus = {name: Media.params.status};\r\n        fields.externalNumber = params.event_id;\r\n        fields.request += \'<br>\' + params.zbxurl;\r\n\r\n        if (params.event_source === \'0\') {\r\n            fields.request += \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id;\r\n        }\r\n\r\n        resp = Media.request(\'post\', \'tas/api/incidents\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.id === \'undefined\') {\r\n            throw \'Cannot create \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {\r\n            result.tags.__zbx_tpd_issuekey = resp.response.number;\r\n            result.tags.__zbx_tpd_issuelink = Media.params.api +\r\n                \'tas/secure/incident?action=show&unid=\' + resp.response.id;\r\n        }\r\n    }\r\n    // Update a created issue.\r\n    else {\r\n        if (params.event_source == 3 && params.event_value == 0) {\r\n            throw \'Internal event recovery actions are not supported.\';\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ \' + Media.name + \' Webhook ] Request of the ticket updating.\');\r\n        fields.action = params.alert_message.replace(/\\n/g, \'<br>\');\r\n\r\n        resp = Media.request(\'put\', \'tas/api/incidents/number/\' + Media.params.issue_key, fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.id === \'undefined\'\r\n                || resp.response.number !== Media.params.issue_key) {\r\n            throw \'Cannot update \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ \' + Media.name + \' Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_tpd_issuelink}','TOPdesk: {EVENT.TAGS.__zbx_tpd_issuekey}','Please refer to https://developers.topdesk.com/documentation/index.html and https://www.zabbix.com/documentation/current/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "TOPdesk".\r\nChange the values of the variables topdesk_api (URL), topdesk_password, topdesk_user. The topdesk_status is the default status for creating a new TOPdesk ticket.');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('26','4','iTop','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var Itop = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        if (params.log !== \'private_log\' && params.log !== \'public_log\') {\r\n            throw \'Incorrect "itop_log" parameter given: \' + params.log + \'\\nMust be "private_log" or "public_log".\';\r\n        }\r\n\r\n        Itop.params = params;\r\n        if (typeof Itop.params.url === \'string\') {\r\n            if (!Itop.params.url.endsWith(\'/\')) {\r\n                Itop.params.url += \'/\';\r\n            }\r\n\r\n            Itop.params.url += \'webservices/rest.php?version=\' + encodeURIComponent(Itop.params.api_version);\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Itop.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setCreatePayload: function () {\r\n        json_data.operation = \'core/create\';\r\n        json_data.fields.org_id = Itop.params.organization_id;\r\n        json_data.fields.title = params.alert_subject;\r\n        json_data.fields.description = params.alert_message.replace(\'<\', \'&lt;\')\r\n            .replace(\'>\', \'&gt;\')\r\n            .replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n    },\r\n\r\n    setUpdatePayload: function () {\r\n        json_data.operation = \'core/update\';\r\n        json_data.key = Itop.params.id;\r\n        json_data.fields.title = params.alert_subject;\r\n        json_data.fields[Itop.params.log] = {\r\n            add_item: {\r\n                message: params.alert_subject + \'\\n\' + params.alert_message,\r\n                format: \'text\'\r\n            }\r\n        };\r\n    },\r\n\r\n    request: function (data) {\r\n        [\'url\', \'user\', \'password\', \'organization_id\', \'class\', \'api_version\', \'id\'].forEach(function (field) {\r\n            if (typeof Itop.params !== \'object\' || typeof Itop.params[field] === \'undefined\'\r\n                    || Itop.params[field] === \'\' ) {\r\n                throw \'Required Itop param is not set: "itop_\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Itop.params.url,\r\n            request = new CurlHttpRequest(),\r\n            object;\r\n\r\n        request.AddHeader(\'Content-Type: multipart/form-data\');\r\n        request.AddHeader(\'Authorization: Basic \' + btoa(Itop.params.user + \':\' + Itop.params.password));\r\n\r\n        if (Itop.HTTPProxy) {\r\n            request.SetProxy(Itop.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ iTop Webhook ] Sending request: \' + url + \'&json_data=\' + data);\r\n\r\n        response = request.Post(url + \'&json_data=\' + encodeURIComponent(data));\r\n\r\n        Zabbix.Log(4, \'[ iTop Webhook ] Received response with status code \' + request.Status() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.Log(4, \'[ iTop Webhook ] Failed to parse response received from iTop\');\r\n            throw \'Failed to parse response received from iTop.\\nRequest status code \' +\r\n                    request.Status() + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            throw \'Request failed with status code \' + request.Status() + \'. Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.code !== \'undefined\' && response.code !== 0) {\r\n            throw \'Request failed with iTop code \' + response.code + \': \' +\r\n                    JSON.stringify(response.message) + \'. Check debug log for more information.\';\r\n        }\r\n        else {\r\n            Object.keys(response.objects)\r\n                .forEach(function (key) {\r\n                    object = response.objects[key];\r\n                });\r\n    \r\n            return {\r\n                status: request.Status(),\r\n                response: object.fields\r\n            };\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        json_data = {},\r\n        itop_params = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'summary\', \'event_recovery_value\',\r\n            \'event_source\', \'event_value\', \'action_name\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'itop_\')) {\r\n                itop_params[key.substring(5)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Itop.setParams(itop_params);\r\n    Itop.setProxy(params.HTTPProxy);\r\n\r\n    json_data.operation = \'\';\r\n    json_data.class = Itop.params.class;\r\n    json_data.comment = Itop.params.comment;\r\n    json_data.output_fields = \'id, friendlyname\';\r\n    json_data.fields = {};\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Itop.setCreatePayload();\r\n        Itop.request(json_data);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n            && Itop.params.id === \'{EVENT.TAGS.__zbx_itop_id}\') {\r\n        Itop.setCreatePayload();\r\n\r\n        var response = Itop.request(json_data);\r\n\r\n        result.tags.__zbx_itop_id = response.response.id;\r\n        result.tags.__zbx_itop_key = response.response.friendlyname;\r\n        result.tags.__zbx_itop_link = params.itop_url + (params.itop_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n                \'pages/UI.php?operation=details&class=\' + encodeURIComponent(Itop.params.class) + \'&id=\' +\r\n                encodeURIComponent(response.response.id);\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (Itop.params.id === \'{EVENT.TAGS.__zbx_itop_id}\') {\r\n            throw \'Incorrect iTop ticket ID given: \' + Itop.params.id;\r\n        }\r\n        Itop.setUpdatePayload();\r\n        Itop.request(json_data);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ iTop Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_itop_link}','iTop: {EVENT.TAGS.__zbx_itop_key}','');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`status`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`exec_params`,`maxsessions`,`maxattempts`,`attempt_interval`,`content_type`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`) values ('27','4','Rocket.Chat','','','','','','','','0','25','0','0','0','0','','1','3','10s','1','var RocketChat = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        RocketChat.params = params;\r\n        if (RocketChat.params.url && RocketChat.params.api_url) {\r\n            if (!RocketChat.params.url.endsWith(\'/\')) {\r\n                RocketChat.params.url += \'/\';\r\n            }\r\n            if (!RocketChat.params.api_url.endsWith(\'/\')) {\r\n                RocketChat.params.api_url += \'/\';\r\n            }\r\n            if (RocketChat.params.api_url.startsWith(\'/\')) {\r\n                RocketChat.params.api_url = RocketChat.params.api_url.substring(1);\r\n            }\r\n\r\n            RocketChat.params.url += RocketChat.params.api_url;\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        RocketChat.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addFields: function (fields) {\r\n        var data = [];\r\n\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field] === \'\') {\r\n                        Zabbix.Log(4, \'[ RocketChat Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var parts = field.split(\':\'),\r\n                                prefix = parts[0].split(\'_\');\r\n\r\n                            if (typeof prefix[2] === \'undefined\'\r\n                                    || (prefix[2] === \'p\' && params.event_value === \'1\')\r\n                                    || (prefix[2] === \'r\' && params.event_value === \'0\')) {\r\n                                data.push({\r\n                                    title: field.substring(field.indexOf(\':\') + 1),\r\n                                    value: fields[field],\r\n                                    short: prefix[1] === \'short\'\r\n                                });\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.Log(4, \'[ RocketChat Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'api_url\', \'user_id\', \'user_token\', \'send_to\'].forEach(function (field) {\r\n            if (typeof RocketChat.params !== \'object\' || typeof RocketChat.params[field] === \'undefined\'\r\n                    || RocketChat.params[field] === \'\' ) {\r\n                throw \'Required parameter is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = RocketChat.params.url + query,\r\n            request = new CurlHttpRequest();\r\n\r\n        request.AddHeader(\'Content-Type: application/json\');\r\n        request.AddHeader(\'X-Auth-Token:\' + RocketChat.params.user_token);\r\n        request.AddHeader(\'X-User-Id:\' + RocketChat.params.user_id);\r\n\r\n        if (typeof RocketChat.HTTPProxy !== \'undefined\' && RocketChat.HTTPProxy !== \'\') {\r\n            request.SetProxy(RocketChat.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ RocketChat Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.Get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.Post(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.Log(4, \'[ RocketChat Webhook ] Received response with status code \' +\r\n            request.Status() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.Log(4, \'[ RocketChat Webhook ] Failed to parse response received from RocketChat\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.Status() < 200 || request.Status() >= 300) {\r\n            var message = \'Request failed with status code \' + request.Status();\r\n\r\n            if (response !== null && typeof response.message !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.message);\r\n            }\r\n            else if (response !== null && typeof response.error !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.Status(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    postMessage: function(use_default_message, message, fields) {\r\n        var data = {\r\n            channel: RocketChat.params.send_to,\r\n            attachments: [{\r\n                collapsed: false,\r\n                color: RocketChat.params.color,\r\n                title: params.alert_subject\r\n            }]\r\n        };\r\n\r\n        if (RocketChat.params.title_link) {\r\n            data.attachments[0].title_link = RocketChat.params.title_link;\r\n        }\r\n\r\n        if (use_default_message) {\r\n            data.attachments[0].text = message;\r\n        }\r\n        else {\r\n            data.attachments[0].fields = RocketChat.addFields(fields);\r\n        }\r\n\r\n        var result = RocketChat.request(\'post\', \'chat.postMessage\', data);\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.message._id === \'undefined\') {\r\n            throw \'Cannot send RocketChat message. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            id: result.response.message._id,\r\n            rid: result.response.message.rid,\r\n            channel: result.response.channel\r\n        };\r\n    },\r\n\r\n    sendMessage: function(update, fields) {\r\n\r\n        var data = {\r\n            message: {\r\n                rid: RocketChat.params.room_id,\r\n                tmid: RocketChat.params.msg_id,\r\n                tshow: true\r\n            }\r\n        };\r\n\r\n        if (update.status === \'0\') {\r\n            data.message.attachments = [{\r\n                collapsed: false,\r\n                color: RocketChat.params.color,\r\n                title: params.alert_subject,\r\n                title_link: RocketChat.params.title_link,\r\n                fields: RocketChat.addFields(fields)\r\n            }];\r\n        }\r\n        else {\r\n            data.message.alias = update.user;\r\n            data.message.msg = update.action;\r\n            if (update.message) {\r\n                data.message.attachments = [{\r\n                    color: RocketChat.params.color,\r\n                    text: update.message\r\n                }];\r\n            }\r\n        }\r\n\r\n        RocketChat.request(\'post\', \'chat.sendMessage\', data);\r\n    },\r\n\r\n    getMessageLink: function(rid, id) {\r\n        var room = RocketChat.request(\'get\', \'rooms.info?roomId=\' + encodeURIComponent(rid)),\r\n            link = params.rc_url +\r\n                (params.rc_url.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n        switch (room.response.room.t) {\r\n            case \'c\':\r\n                link += \'channel/\' + room.response.room.name + \'?msg=\' + id;\r\n                break;\r\n\r\n            case \'p\':\r\n                link += \'group/\' + room.response.room.name + \'?msg=\' + id;\r\n                break;\r\n\r\n            case \'d\':\r\n                link += \'direct/\' + rid + \'?msg=\' + id;\r\n                break;\r\n\r\n            default:\r\n                Zabbix.Log(4, \'[ RocketChat Webhook ] Can\\\'t get room type. Link to message will not be added.\');\r\n        }\r\n\r\n        return link;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        response,\r\n        fields = {},\r\n        rc = {},\r\n        update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'alert_message\', \'event_source\', \'event_value\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'rc_\')) {\r\n                rc[key.substring(3)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field_\')) {\r\n                fields[key.substring(6)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Forcing parameters for non trigger-based events.\r\n    if (params.event_source !== \'0\') {\r\n        params.use_default_message = \'true\';\r\n        params.event_nseverity = \'0\';\r\n        params.rc_title_link = false;\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    RocketChat.setParams(rc);\r\n    RocketChat.setProxy(params.HTTPProxy);\r\n    RocketChat.params.color = severities[params.event_nseverity].color;\r\n\r\n    // Send default message if use_default_message === true.\r\n    if (params.use_default_message.toLowerCase() === \'true\') {\r\n        response = RocketChat.postMessage(true, params.alert_message);\r\n        result.tags.__zbx_rc_id = response.id;\r\n        result.tags.__zbx_rc_rid = response.rid;\r\n        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);\r\n    }\r\n    // Send message for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\') {\r\n        response = RocketChat.postMessage(false, params.alert_message, fields);\r\n        result.tags.__zbx_rc_id = response.id;\r\n        result.tags.__zbx_rc_rid = response.rid;\r\n        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);\r\n    }\r\n    // Send thread message for trigger-based event.\r\n    else {\r\n        RocketChat.sendMessage(update, fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.Log(3, \'[ RocketChat Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_rc_msg_url}','Rocket.Chat','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('1','5','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('2','5','bot_token','<YOUR BOT TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('3','5','mattermost_url','<YOUR MATTERMOST URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('4','5','send_mode','alarm');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('5','5','send_to','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('6','5','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('8','5','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('10','5','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('11','5','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('12','5','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('13','5','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('14','5','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('15','5','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('16','5','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('18','5','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('19','5','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('20','5','host_name','{HOST.HOST}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('21','5','host_ip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('22','5','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('23','5','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('24','5','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('25','5','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('37','6','zbxurl','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('39','7','token','<put your key>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('40','7','eventid','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('41','7','eventname','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('42','7','hostname','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('43','7','hostip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('44','7','severity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('45','7','triggerdesc','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('46','7','triggeropdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('47','7','eventtags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('48','7','triggerid','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('49','7','eventdate','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('50','7','eventtime','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('52','7','eventack','{EVENT.ACK.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('53','7','eventupdate','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('54','7','eventvalue','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('55','7','url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('56','8','token','<PUSHOVER TOKEN HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('57','8','user','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('58','8','message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('59','8','title','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('60','8','url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('61','8','url_title','Zabbix');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('63','8','eventid','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('64','8','triggerid','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('65','9','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('66','9','bot_token','<PLACE YOUR KEY HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('67','9','channel','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('68','9','slack_mode','alarm');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('69','9','slack_as_user','true');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('71','9','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('73','9','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('75','9','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('76','9','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('77','9','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('78','9','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('79','9','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('80','9','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('81','9','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('83','9','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('84','9','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('85','9','host_name','{HOST.HOST}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('87','9','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('88','9','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('89','9','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('90','9','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('91','10','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('92','10','discord_endpoint','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('93','10','use_default_message','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('94','10','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('95','10','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('96','10','event_name','{EVENT.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('97','10','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('98','10','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('99','10','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('100','10','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('101','10','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('102','10','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('103','10','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('104','10','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('105','10','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('106','10','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('107','10','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('108','10','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('109','10','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('110','10','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('111','10','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('112','10','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('113','10','host_ip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('114','10','host_name','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('115','10','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('116','10','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('117','8','endpoint','https://api.pushover.net/1/messages.json');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('118','8','retry','60');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('119','8','expire','1200');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('120','11','teamsecret','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('121','11','Subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('122','11','Message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('123','11','Severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('125','11','Hostname','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('127','12','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('128','12','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('129','12','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('130','12','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('131','12','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('132','12','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('133','12','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('134','12','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('135','12','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('136','12','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('137','12','jira_issue_key','{EVENT.TAGS.__zbx_jira_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('138','12','jira_issue_type','<PLACE ISSUETYPE NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('139','12','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('140','12','jira_project_key','<PLACE PROJECT KEY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('141','12','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('142','12','jira_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('143','12','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('144','13','<\'DATETIME\' CUSTOMFIELD FOR EVENT RECOVERY TIME>','{EVENT.RECOVERY.DATE}T{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('145','13','<\'DATETIME\' CUSTOMFIELD FOR EVENT TIME>','{EVENT.DATE}T{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('146','13','<\'NUMBER\' CUSTOMFIELD FOR EVENT.ID>','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('147','13','<\'NUMBER\' CUSTOMFIELD FOR TRIGGER.ID>','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('148','13','<\'STRING\' CUSTOMFIELD FOR HOST\\IP>','{HOST.HOST} [{HOST.IP}]');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('149','13','<\'STRING\' CUSTOMFIELD FOR OPERATIONAL DATA>','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('150','13','<\'STRING\' CUSTOMFIELD FOR SEVERITY>','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('151','13','<\'URL\' CUSTOMFIELD FOR EVENT URL>','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('152','13','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('153','13','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('154','13','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('155','13','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('156','13','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('157','13','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('158','13','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('159','13','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('160','13','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('161','13','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('162','13','jira_issue_key','{EVENT.TAGS.__zbx_jira_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('163','13','jira_issue_type','<PLACE ISSUETYPE NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('164','13','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('165','13','jira_project_key','<PLACE PROJECT KEY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('166','13','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('167','13','jira_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('168','13','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('169','14','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('170','14','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('171','14','event_date','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('172','14','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('173','14','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('174','14','event_opdata','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('175','14','event_recovery_date','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('176','14','event_recovery_time','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('177','14','event_severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('178','14','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('179','14','event_status','{EVENT.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('180','14','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('181','14','event_time','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('182','14','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('183','14','event_update_date','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('184','14','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('185','14','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('186','14','event_update_time','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('187','14','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('188','14','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('189','14','host_ip','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('190','14','host_name','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('191','14','teams_endpoint','<PLACE WEBHOOK URL HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('192','14','trigger_description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('193','14','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('194','14','use_default_message','false');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('195','14','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('196','15','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('197','15','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('198','15','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('199','15','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('200','15','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('201','15','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('202','15','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('203','15','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('204','15','redmine_access_key','<PUT YOUR ACCESS KEY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('205','15','redmine_issue_key','{EVENT.TAGS.__zbx_redmine_issue_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('206','15','redmine_project','<PUT YOUR PROJECT ID OR NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('207','15','redmine_tracker_id','<PUT YOUR TRACKER ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('208','15','redmine_url','<PUT YOUR REDMINE URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('209','15','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('210','15','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('211','16','Message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('212','16','ParseMode','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('213','16','Subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('214','16','To','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('215','16','Token','<PLACE YOUR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('216','17','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('217','17','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('218','17','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('219','17','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('220','17','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('221','17','event_tags','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('222','17','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('223','17','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('224','17','severity_average','normal');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('225','17','severity_default','-');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('226','17','severity_disaster','urgent');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('227','17','severity_high','high');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('228','17','severity_information','low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('229','17','severity_not_classified','low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('230','17','severity_warning','normal');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('231','17','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('232','17','zbxurl','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('233','17','zendesk_issue_key','{EVENT.TAGS.__zbx_zdk_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('234','17','zendesk_token','<put your {enduser_email_address}/token:{api_token}>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('235','17','zendesk_type','incident');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('236','17','zendesk_url','<put your Zendesk URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('237','18','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('238','18','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('239','18','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('240','18','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('241','18','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('242','18','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('243','18','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('244','18','servicenow_password','<PLACE PASSWORD HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('245','18','servicenow_sys_id','{EVENT.TAGS.__zbx_servicenow_sys_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('246','18','servicenow_url','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('247','18','servicenow_user','<PLACE USERNAME HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('248','18','urgency_for_average','2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('249','18','urgency_for_disaster','1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('250','18','urgency_for_high','2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('251','18','urgency_for_information','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('252','18','urgency_for_not_classified','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('253','18','urgency_for_warning','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('254','19','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('255','19','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('256','19','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('257','19','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('258','19','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('259','19','event_tags','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('260','19','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('261','19','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('262','19','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('263','19','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('264','19','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('265','19','zammad_access_token','<PUT YOUR ACCESS TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('266','19','zammad_customer','<PUT YOUR CUSTOMER EMAIL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('267','19','zammad_enable_tags','true');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('268','19','zammad_ticket_id','{EVENT.TAGS.__zbx_zammad_ticket_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('269','19','zammad_url','<PUT YOUR ZAMMAD URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('270','20','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('271','20','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('272','20','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('273','20','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('274','20','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('275','20','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('276','20','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('277','20','jira_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('278','20','jira_request_key','{EVENT.TAGS.__zbx_jira_requestkey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('279','20','jira_request_type_id','<PLACE REQUEST TYPE ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('280','20','jira_servicedesk_id','<PLACE SERVICEDESK ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('281','20','jira_url','<PLACE YOUR JIRA URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('282','20','jira_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('283','21','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('284','21','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('285','21','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('286','21','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('287','21','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('288','21','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('289','21','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('290','21','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('291','21','otrs_auth_password','<PUT YOUR USER PASSWORD>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('292','21','otrs_auth_user','<PUT YOUR USER NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('293','21','otrs_customer','<PUT YOUR CUSTOMER EMAIL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('294','21','otrs_default_priority_id','3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('295','21','otrs_queue','<PUT YOUR QUEUE NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('296','21','otrs_ticket_id','{EVENT.TAGS.__zbx_otrs_ticket_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('297','21','otrs_ticket_state','new');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('298','21','otrs_time_unit','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('299','21','otrs_url','<PUT YOUR OTRS URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('300','21','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('301','21','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('302','11','Event_Ack_Status','{EVENT.ACK.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('303','11','Event_Date_Time','{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('304','11','Event_ID','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('305','11','Event_Update_Action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('306','11','Event_Update_Status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('307','11','Host_IP','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('308','11','Trigger_ID','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('309','11','Trigger_Status','{TRIGGER.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('310','11','User','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('311','11','Zabbix_URL','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('312','10','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('313','22','.ILERT.ALERT.SOURCE.KEY','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('314','22','.ILERT.INCIDENT.SUMMARY','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('315','22','ALERT.MESSAGE','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('316','22','ALERT.SUBJECT','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('317','22','EVENT.ACK.STATUS','{EVENT.ACK.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('318','22','EVENT.DATE','{EVENT.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('319','22','EVENT.ID','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('320','22','EVENT.NAME','{EVENT.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('321','22','EVENT.NSEVERITY','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('322','22','EVENT.OPDATA','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('323','22','EVENT.RECOVERY.DATE','{EVENT.RECOVERY.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('324','22','EVENT.RECOVERY.TIME','{EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('325','22','EVENT.RECOVERY.VALUE','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('326','22','EVENT.SEVERITY','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('327','22','EVENT.TAGS','{EVENT.TAGS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('328','22','EVENT.TIME','{EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('329','22','EVENT.UPDATE.ACTION','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('330','22','EVENT.UPDATE.DATE','{EVENT.UPDATE.DATE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('331','22','EVENT.UPDATE.MESSAGE','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('332','22','EVENT.UPDATE.STATUS','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('333','22','EVENT.UPDATE.TIME','{EVENT.UPDATE.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('334','22','EVENT.VALUE','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('335','22','HOST.HOST','{HOST.HOST}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('336','22','HOST.IP','{HOST.IP}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('337','22','HOST.NAME','{HOST.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('338','22','ITEM.ID1','{ITEM.ID1}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('339','22','ITEM.ID2','{ITEM.ID2}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('340','22','ITEM.ID3','{ITEM.ID3}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('341','22','ITEM.ID4','{ITEM.ID4}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('342','22','ITEM.ID5','{ITEM.ID5}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('343','22','ITEM.NAME1','{ITEM.NAME1}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('344','22','ITEM.NAME2','{ITEM.NAME2}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('345','22','ITEM.NAME3','{ITEM.NAME3}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('346','22','ITEM.NAME4','{ITEM.NAME4}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('347','22','ITEM.NAME5','{ITEM.NAME5}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('348','22','TRIGGER.DESCRIPTION','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('349','22','TRIGGER.ID','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('350','22','TRIGGER.NAME','{TRIGGER.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('351','22','TRIGGER.SEVERITY','{TRIGGER.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('352','22','TRIGGER.STATUS','{TRIGGER.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('353','22','TRIGGER.URL','{TRIGGER.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('354','22','TRIGGER.VALUE','{TRIGGER.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('355','22','USER.FULLNAME','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('356','22','ZABBIX.URL','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('357','5','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('358','5','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('359','5','discovery_host_dns','{DISCOVERY.DEVICE.DNS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('360','5','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('361','5','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('362','6','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('363','6','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('364','6','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('365','6','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('366','6','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('367','6','event_tags_json','{EVENT.TAGSJSON}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('368','6','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('369','6','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('370','6','opsgenie_api','<put your opsgenie api>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('371','6','opsgenie_tags','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('372','6','opsgenie_teams','');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('373','6','opsgenie_token','<put your token>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('374','6','opsgenie_web','<put your opsgenie web>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('375','6','severity_average','P3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('376','6','severity_default','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('377','6','severity_disaster','P1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('378','6','severity_high','P2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('379','6','severity_information','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('380','6','severity_not_classified','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('381','6','severity_warning','P4');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('382','6','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('383','6','zbxuser','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('384','7','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('385','7','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('386','8','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('387','8','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('388','8','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('389','8','priority_average','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('390','8','priority_default','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('391','8','priority_disaster','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('392','8','priority_high','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('393','8','priority_information','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('394','8','priority_not_classified','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('395','8','priority_warning','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('396','9','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('397','9','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('398','9','discovery_host_dns','{DISCOVERY.DEVICE.DNS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('399','9','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('400','9','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('401','9','host_conn','{HOST.CONN}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('402','23','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('403','23','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('404','23','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('405','23','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('406','23','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('407','23','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('408','23','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('409','23','priority_average','Medium');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('410','23','priority_default','Low');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('411','23','priority_disaster','Critical');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('412','23','priority_high','High');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('413','23','samanage_incident_id','{EVENT.TAGS.__zbx_solarwinds_inc_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('414','23','samanage_token','<PUT YOUR TOKEN HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('415','23','samanage_url','<PUT YOUR INSTANCE URL HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('416','24','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('417','24','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('418','24','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('419','24','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('420','24','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('421','24','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('422','24','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('423','24','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('424','24','sysaid_auth_password','<PUT YOUR USER PASSWORD>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('425','24','sysaid_auth_user','<PUT YOUR USER NAME>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('426','24','sysaid_category_level_1','<PUT YOUR CATEGORY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('427','24','sysaid_category_level_2','<PUT YOUR SUB-CATEGORY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('428','24','sysaid_category_level_3','<PUT YOUR THIRD LEVEL CATEGORY>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('429','24','sysaid_default_priority_id','1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('430','24','sysaid_incident_id','{EVENT.TAGS.__zbx_sysaid_incident_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('431','24','sysaid_incident_state','1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('432','24','sysaid_template_id','<PUT YOUR TEMPLATE ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('433','24','sysaid_urgency_id','<PUT YOUR URGENCY ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('434','24','sysaid_url','<PUT YOUR SYSAID URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('435','24','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('436','24','zabbix_url','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('437','25','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('438','25','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('439','25','event_id','{EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('440','25','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('441','25','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('442','25','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('443','25','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('444','25','severity_average','P3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('445','25','severity_default','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('446','25','severity_disaster','P1');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('447','25','severity_high','P2');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('448','25','severity_information','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('449','25','severity_not_classified','P5');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('450','25','severity_warning','P4');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('451','25','topdesk_api','<put your TOPdesk API URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('452','25','topdesk_issue_key','{EVENT.TAGS.__zbx_tpd_issuekey}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('453','25','topdesk_password','<put your TOPdesk application password>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('454','25','topdesk_status','<put default status for new tickets>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('455','25','topdesk_user','<put your TOPdesk username>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('456','25','trigger_id','{TRIGGER.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('457','25','zbxurl','{$ZABBIX.URL}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('458','26','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('459','26','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('460','26','event_recovery_value','{EVENT.RECOVERY.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('461','26','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('462','26','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('463','26','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('464','26','itop_api_version','1.3');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('465','26','itop_class','UserRequest');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('466','26','itop_comment','Created by Zabbix action {ACTION.NAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('467','26','itop_id','{EVENT.TAGS.__zbx_itop_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('468','26','itop_log','private_log');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('469','26','itop_organization_id','<PLACE ORGANIZATION ID>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('470','26','itop_password','<PLACE PASSWORD OR TOKEN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('471','26','itop_url','<PLACE YOUR ITOP URL>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('472','26','itop_user','<PLACE LOGIN>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('473','27','alert_message','{ALERT.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('474','27','alert_subject','{ALERT.SUBJECT}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('475','27','event_nseverity','{EVENT.NSEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('476','27','event_source','{EVENT.SOURCE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('477','27','event_update_action','{EVENT.UPDATE.ACTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('478','27','event_update_message','{EVENT.UPDATE.MESSAGE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('479','27','event_update_status','{EVENT.UPDATE.STATUS}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('480','27','event_update_user','{USER.FULLNAME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('481','27','event_value','{EVENT.VALUE}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('482','27','field_1_full:Host','{HOST.NAME} [{HOST.IP}]');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('483','27','field_2_short:Severity','{EVENT.SEVERITY}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('484','27','field_3_short:Event time','{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('485','27','field_3_short_r:Recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('486','27','field_4_short_r:Event duration','{EVENT.DURATION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('487','27','field_5_short:Operational data','{EVENT.OPDATA}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('488','27','field_999_full_p:Trigger description','{TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('489','27','rc_api_url','api/v1/');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('490','27','rc_msg_id','{EVENT.TAGS.__zbx_rc_id}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('491','27','rc_room_id','{EVENT.TAGS.__zbx_rc_rid}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('492','27','rc_send_to','{ALERT.SENDTO}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('493','27','rc_title_link','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('494','27','rc_url','<PLACE YOUR INSTANCE URL HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('495','27','rc_user_id','<PLACE USER ID HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('496','27','rc_user_token','<PLACE TOKEN HERE>');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`) values ('497','27','use_default_message','false');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('1','1','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('2','1','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('3','1','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('4','1','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('5','1','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('6','3','0','0','','{EVENT.SEVERITY}: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\n{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('7','3','0','1','','Resolved in {EVENT.DURATION}: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\n{EVENT.DATE} {EVENT.TIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('8','3','0','2','','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem in {EVENT.AGE} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('9','3','1','0','','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('10','3','2','0','','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('11','4','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {EVENT.TIME} on {EVENT.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Operational data:</b> {EVENT.OPDATA}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('12','4','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Problem duration:</b> {EVENT.DURATION}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('13','4','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem</b> at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.<br>{EVENT.UPDATE.MESSAGE}<br><br><b>Current problem status:</b> {EVENT.STATUS}<br><b>Age:</b> {EVENT.AGE}<br><b>Acknowledged:</b> {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('14','4','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {DISCOVERY.RULE.NAME}<br><br><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}<br><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}<br><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}<br><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}<br><br><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}<br><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}<br><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}<br><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('15','4','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {HOST.HOST}<br><b>Host IP:</b> {HOST.IP}<br><b>Agent port:</b> {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('16','11','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('17','11','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('18','11','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('19','11','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('20','11','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('21','12','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('22','12','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('23','12','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('24','12','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('25','12','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('26','13','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('27','13','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('28','13','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('29','13','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('30','13','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('31','14','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('32','14','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('33','14','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('34','14','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('35','14','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('36','15','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('37','15','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('38','15','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('39','15','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('40','15','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('41','16','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('42','16','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('43','16','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('44','16','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('45','16','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('46','17','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('47','17','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('48','17','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('49','17','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('50','17','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('51','17','3','0','Internal problem: {EVENT.NAME}','Internal problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('52','18','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('53','18','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('54','18','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('55','18','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('56','18','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('57','19','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('58','19','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('59','19','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('60','19','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('61','19','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('62','20','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('63','20','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('64','20','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('65','20','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('66','20','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('67','21','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('68','21','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('69','21','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('70','21','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('71','21','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('72','10','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('73','10','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('74','10','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('75','10','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('76','10','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('77','22','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('78','22','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('79','22','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('80','5','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('81','5','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('82','5','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('83','5','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('84','5','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('85','6','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('86','6','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('87','6','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('88','6','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('89','6','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('90','7','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('91','7','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('92','7','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('93','7','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('94','7','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('95','8','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('96','8','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('97','8','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('98','8','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('99','8','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('100','9','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('101','9','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('102','9','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('103','9','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('104','9','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('105','23','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n\r\nTrigger description: {TRIGGER.DESCRIPTION}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('106','23','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('107','23','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('108','23','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('109','23','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('110','24','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('111','24','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('112','24','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('113','24','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('114','24','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('115','25','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('116','25','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('117','25','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('118','25','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('119','25','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('120','26','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('121','26','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('122','26','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('123','26','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('124','26','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('125','27','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('126','27','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('127','27','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('128','27','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) values ('129','27','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('7','Zabbix administrators','0','0','0');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('8','Guests','1','0','0');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('9','Disabled','0','1','0');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('11','Enabled debug mode','0','0','1');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`) values ('12','No access to the frontend','3','0','0');
INSERT INTO `users_groups` (`id`,`usrgrpid`,`userid`) values ('2','8','2');
INSERT INTO `users_groups` (`id`,`usrgrpid`,`userid`) values ('3','9','2');
INSERT INTO `users_groups` (`id`,`usrgrpid`,`userid`) values ('4','7','1');
INSERT INTO `scripts` (`scriptid`,`name`,`command`,`host_access`,`usrgrpid`,`groupid`,`description`,`confirmation`,`type`,`execute_on`) values ('1','Ping','ping -c 3 {HOST.CONN}; case $? in [01]) true;; *) false;; esac','2',NULL,NULL,'','','0','2');
INSERT INTO `scripts` (`scriptid`,`name`,`command`,`host_access`,`usrgrpid`,`groupid`,`description`,`confirmation`,`type`,`execute_on`) values ('2','Traceroute','/usr/bin/traceroute {HOST.CONN}','2',NULL,NULL,'','','0','2');
INSERT INTO `scripts` (`scriptid`,`name`,`command`,`host_access`,`usrgrpid`,`groupid`,`description`,`confirmation`,`type`,`execute_on`) values ('3','Detect operating system','sudo /usr/bin/nmap -O {HOST.CONN}','2','7',NULL,'','','0','2');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('2','Auto discovery. Linux servers.','1','0','1','0','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('3','Report problems to Zabbix administrators','0','0','1','1h','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('4','Report not supported items','3','0','1','1h','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('5','Report not supported low level discovery rules','3','0','1','1h','','1');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`) values ('6','Report unknown triggers','3','0','1','1h','','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('1','2','6','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('2','2','4','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('3','3','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('4','4','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('5','5','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('6','6','0','0','1','1','0','0');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('7','3','11','0','1','1','0','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('8','4','11','0','1','1','0','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('9','5','11','0','1','1','0','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) values ('10','6','11','0','1','1','0','1');
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('3','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('4','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('5','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('6','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('7','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('8','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('9','1','','',NULL);
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) values ('10','1','','',NULL);
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('1','3','7');
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('2','4','7');
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('3','5','7');
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) values ('4','6','7');
INSERT INTO `opgroup` (`opgroupid`,`operationid`,`groupid`) values ('1','2','2');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('2','2','10','0','0','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('3','2','8','0','9','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('4','2','12','2','Linux','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('6','4','23','0','0','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('7','5','23','0','2','');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) values ('8','6','23','0','4','');
INSERT INTO `config` (`configid`,`work_period`,`alert_usrgrpid`,`discovery_groupid`) values ('1','1-5,09:00-18:00','7','5');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('1','blue-theme','FFFFFF','FFFFFF','CCD5D9','ACBBC2','ACBBC2','1F2C33','E33734','429E47','E33734','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('2','dark-theme','2B2B2B','2B2B2B','454545','4F4F4F','4F4F4F','F2F2F2','E45959','59DB8F','E45959','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('3','hc-light','FFFFFF','FFFFFF','555555','000000','333333','000000','333333','000000','000000','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) values ('4','hc-dark','000000','000000','666666','888888','4F4F4F','FFFFFF','FFFFFF','FFFFFF','FFFFFF','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4');
INSERT INTO `globalmacro` (`globalmacroid`,`macro`,`value`,`description`,`type`) values ('2','{$SNMP_COMMUNITY}','public','','0');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('1','File systems for discovery','ext3');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('2','Network interfaces for discovery','eth0');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('3','Storage devices for SNMP discovery','/boot');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('4','Windows service names for discovery','SysmonLog');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) values ('5','Windows service startup states for discovery','automatic');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('1','1','^(btrfs|ext2|ext3|ext4|reiser|xfs|ffs|ufs|jfs|jfs2|vxfs|hfs|apfs|refs|ntfs|fat32|zfs)$','3',',','0');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('3','3','^(Physical memory|Virtual memory|Memory buffers|Cached memory|Swap space)$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('5','4','^(MMCSS|gupdate|SysmonLog|clr_optimization_v2.0.50727_32|clr_optimization_v4.0.30319_32)$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('6','5','^(automatic|automatic delayed)$','3',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('7','2','^Software Loopback Interface','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('8','2','^(In)?[Ll]oop[Bb]ack[0-9._]*$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('9','2','^NULL[0-9.]*$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('10','2','^[Ll]o[0-9.]*$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('11','2','^[Ss]ystem$','4',',','1');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) values ('12','2','^Nu[0-9.]*$','4',',','1');
INSERT INTO `config_autoreg_tls` (`autoreg_tlsid`,`tls_psk_identity`,`tls_psk`) values ('1','','');
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('1','1','0','ui.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('2','1','0','modules.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('3','1','0','api.access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('4','1','0','actions.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('5','2','0','ui.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('6','2','0','modules.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('7','2','0','api.access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('8','2','0','actions.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('9','3','0','ui.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('10','3','0','modules.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('11','3','0','api.access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('12','3','0','actions.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('13','4','0','ui.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('14','4','0','modules.default_access','1','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('15','4','0','api.access','0','',NULL);
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`) values ('16','4','0','actions.default_access','0','',NULL);
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10001',NULL,'Linux by Zabbix agent','3','-1','2','','','Linux by Zabbix agent','0',NULL,'Official Linux template. Requires agent of Zabbix 3.0.14, 3.4.5 and 4.0.0 or newer.\r\n\r\nKnown Issues:\r\n\r\n  Description: Network discovery. Zabbix agent as of 4.2 doesn\'t support items such as net.if.status, net.if.speed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10047',NULL,'Zabbix Server','3','-1','2','','','Zabbix Server','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10048',NULL,'Zabbix Proxy','3','-1','2','','','Zabbix Proxy','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10050',NULL,'Zabbix agent','3','-1','2','','','Zabbix agent','0',NULL,'Use this template for agents reachable from Zabbix server/proxy (passive mode).\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10074',NULL,'OpenBSD','3','-1','2','','','OpenBSD','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10075',NULL,'FreeBSD','3','-1','2','','','FreeBSD','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10076',NULL,'AIX','3','-1','2','','','AIX','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10077',NULL,'HP-UX','3','-1','2','','','HP-UX','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10078',NULL,'Solaris','3','-1','2','','','Solaris','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10079',NULL,'Mac OS X','3','-1','2','','','Mac OS X','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10081',NULL,'Windows by Zabbix agent','3','-1','2','','','Windows by Zabbix agent','0',NULL,'Official Windows template. Requires agent of Zabbix 4.4 and newer.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10084',NULL,'Zabbix server','0','-1','2','','','Zabbix server','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10093',NULL,'FTP Service','3','-1','2','','','FTP Service','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10094',NULL,'HTTP Service','3','-1','2','','','HTTP Service','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10095',NULL,'HTTPS Service','3','-1','2','','','HTTPS Service','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10096',NULL,'IMAP Service','3','-1','2','','','IMAP Service','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10097',NULL,'LDAP Service','3','-1','2','','','LDAP Service','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10098',NULL,'NNTP Service','3','-1','2','','','NNTP Service','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10099',NULL,'NTP Service','3','-1','2','','','NTP Service','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10100',NULL,'POP Service','3','-1','2','','','POP Service','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10101',NULL,'SMTP Service','3','-1','2','','','SMTP Service','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10102',NULL,'SSH Service','3','-1','2','','','SSH Service','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10103',NULL,'Telnet Service','3','-1','2','','','Telnet Service','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10169',NULL,'Generic Java JMX','3','-1','2','','','Generic Java JMX','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10171',NULL,'Intel SR1530 IPMI','3','-1','2','','','Intel SR1530 IPMI','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10172',NULL,'Intel SR1630 IPMI','3','-1','2','','','Intel SR1630 IPMI','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10173',NULL,'VMware','3','-1','2','','','VMware','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10174',NULL,'VMware Guest','3','-1','2','','','VMware Guest','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10175',NULL,'VMware Hypervisor','3','-1','2','','','VMware Hypervisor','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10183',NULL,'EtherLike-MIB SNMP','3','-1','2','','','EtherLike-MIB SNMP','0',NULL,'Template EtherLike-MIB (duplex control only)\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10185',NULL,'HOST-RESOURCES-MIB SNMP','3','-1','2','','','HOST-RESOURCES-MIB SNMP','0',NULL,'HOST-RESOURCES-MIB: CPU, memory and storage(vfs.fs.file) linked together.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10186',NULL,'ICMP Ping','3','-1','2','','','ICMP Ping','0',NULL,'Template Module ICMP Ping\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10188',NULL,'Interfaces Simple SNMP','3','-1','2','','','Interfaces Simple SNMP','0',NULL,'Template Module Interfaces Simple (no ifXTable). This is the exact copy of Template Module Interfaces template with the exception that metrics from ifXTable are replaced with ifTable counters where possible. Use this template with devices where IF-MIB::ifXtable is not available. If supported by the host - use Template Module Interfaces template instead.\r\n\r\nMIBs used:\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: 32bit counters are used in this template (since there is no ifXtable available). If busy interfaces return incorrect bits sent/received - set update interval to 1m or less.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10190',NULL,'Interfaces SNMP','3','-1','2','','','Interfaces SNMP','0',NULL,'Template Module Interfaces\r\n\r\nMIBs used:\r\nIF-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10192',NULL,'Interfaces Windows SNMP','3','-1','2','','','Interfaces Windows SNMP','0',NULL,'Template Interfaces Windows\r\n\r\nMIBs used:\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: 32bit counters are used in this template (since 64bit are not supported by Windows OS). If busy interfaces return incorrect bits sent/received - set update interval to 1m or less.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10204',NULL,'Generic SNMP','3','-1','2','','','Generic SNMP','0',NULL,'Template Module Generic\r\n\r\nMIBs used:\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10207',NULL,'Alcatel Timetra TiMOS SNMP','3','-1','2','','','Alcatel Timetra TiMOS SNMP','0',NULL,'Template Net Alcatel Timetra TiMOS\r\n\r\nMIBs used:\r\nTIMETRA-CHASSIS-MIB\r\nTIMETRA-SYSTEM-MIB\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10208',NULL,'Brocade FC SNMP','3','-1','2','','','Brocade FC SNMP','0',NULL,'Template Net Brocade FC\r\n\r\nMIBs used:\r\nSW-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: no IF-MIB::ifAlias is available\r\n  Version: v6.3.1c, v7.0.0c,  v7.4.1c\r\n  Device: all\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10209',NULL,'Brocade_Foundry Performance SNMP','3','-1','2','','','Brocade_Foundry Performance SNMP','0',NULL,'Template Module Brocade_Foundry Performance\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10210',NULL,'Brocade_Foundry Nonstackable SNMP','3','-1','2','','','Brocade_Foundry Nonstackable SNMP','0',NULL,'Template Net Brocade_Foundry Nonstackable\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10211',NULL,'Brocade_Foundry Stackable SNMP','3','-1','2','','','Brocade_Foundry Stackable SNMP','0',NULL,'Template Brocade_Foundry Stackable\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\nFOUNDRY-SN-STACKING-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Correct fan(returns fan status as \'other(1)\' and temperature (returns 0) for the non-master Switches are not available in SNMP\r\n  Version: Version 08.0.40b and above\r\n  Device: ICX 7750 in stack\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10212',NULL,'Cisco CISCO-MEMORY-POOL-MIB SNMP','3','-1','2','','','Cisco CISCO-MEMORY-POOL-MIB SNMP','0',NULL,'Template Cisco CISCO-MEMORY-POOL-MIB\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10213',NULL,'Cisco CISCO-PROCESS-MIB SNMP','3','-1','2','','','Cisco CISCO-PROCESS-MIB SNMP','0',NULL,'Template Cisco CISCO-PROCESS-MIB\r\n\r\nMIBs used:\r\nCISCO-PROCESS-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10215',NULL,'Cisco OLD-CISCO-CPU-MIB SNMP','3','-1','2','','','Cisco OLD-CISCO-CPU-MIB SNMP','0',NULL,'Template Cisco OLD-CISCO-CPU-MIB\r\n\r\nMIBs used:\r\nOLD-CISCO-CPU-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10216',NULL,'Cisco Inventory SNMP','3','-1','2','','','Cisco Inventory SNMP','0',NULL,'Template Cisco Inventory\r\n\r\nMIBs used:\r\nENTITY-MIB\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10217',NULL,'Cisco CISCO-ENVMON-MIB SNMP','3','-1','2','','','Cisco CISCO-ENVMON-MIB SNMP','0',NULL,'Template Cisco CISCO-ENVMON-MIB\r\n\r\nMIBs used:\r\nCISCO-ENVMON-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10218',NULL,'Cisco IOS SNMP','3','-1','2','','','Cisco IOS SNMP','0',NULL,'Template Cisco IOS Software releases 12.2(3.5) or later\r\n\r\nKnown Issues:\r\n\r\n  Description: no if(in|out)(Errors|Discards) are available for vlan ifType\r\n  Version: IOS for example: 12.1(22)EA11, 15.4(3)M2\r\n  Device: C2911, C7600\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10220',NULL,'Cisco IOS prior to 12.0_3_T SNMP','3','-1','2','','','Cisco IOS prior to 12.0_3_T SNMP','0',NULL,'Cisco IOS Software releases prior to 12.0(3)T\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10221',NULL,'Dell Force S-Series SNMP','3','-1','2','','','Dell Force S-Series SNMP','0',NULL,'Template Dell Force S-Series\r\n\r\nMIBs used:\r\nF10-S-SERIES-CHASSIS-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10222',NULL,'D-Link DES 7200 SNMP','3','-1','2','','','D-Link DES 7200 SNMP','0',NULL,'Template D-Link DES 7200\r\n\r\nMIBs used:\r\nMY-PROCESS-MIB\r\nSNMPv2-MIB\r\nMY-MEMORY-MIB\r\nENTITY-MIB\r\nMY-SYSTEM-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10223',NULL,'D-Link DES_DGS Switch SNMP','3','-1','2','','','D-Link DES_DGS Switch SNMP','0',NULL,'Template D-Link DES_DGS Switch\r\n\r\nMIBs used:\r\nDLINK-AGENT-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\nEQUIPMENT-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: D-Link reports missing PSU as fail(4)\r\n  Version: Firmware: 1.73R008,hardware revision: B1\r\n  Device: DGS-3420-26SC Gigabit Ethernet Switch\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10224',NULL,'Extreme EXOS SNMP','3','-1','2','','','Extreme EXOS SNMP','0',NULL,'Template Extreme EXOS\r\n\r\nMIBs used:\r\nEXTREME-SOFTWARE-MONITOR-MIB\r\nEXTREME-SYSTEM-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10226',NULL,'Network Generic Device SNMP','3','-1','2','','','Network Generic Device SNMP','0',NULL,'Template Net Network Generic Device\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10227',NULL,'HP Comware HH3C SNMP','3','-1','2','','','HP Comware HH3C SNMP','0',NULL,'Template Net HP Comware (HH3C)\r\n\r\nMIBs used:\r\nENTITY-MIB\r\nHH3C-ENTITY-EXT-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: No temperature sensors. All entities of them return 0 for HH3C-ENTITY-EXT-MIB::hh3cEntityExtTemperature\r\n  Version: 1910-48 Switch Software Version 5.20.99, Release 1116 Copyright(c)2010-2016 Hewlett Packard Enterprise Development LP\r\n  Device: HP 1910-48\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10229',NULL,'Huawei VRP SNMP','3','-1','2','','','Huawei VRP SNMP','0',NULL,'Template Net Huawei VRP\r\n\r\nMIBs used:\r\nHUAWEI-ENTITY-EXTENT-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10230',NULL,'Intel_Qlogic Infiniband SNMP','3','-1','2','','','Intel_Qlogic Infiniband SNMP','0',NULL,'Template Net Intel_Qlogic Infiniband\r\n\r\nMIBs used:\r\nICS-CHASSIS-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10231',NULL,'Juniper SNMP','3','-1','2','','','Juniper SNMP','0',NULL,'Template Net Juniper\r\n\r\nMIBs used:\r\nJUNIPER-ALARM-MIB\r\nJUNIPER-MIB\r\nSNMPv2-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10233',NULL,'Mikrotik SNMP','3','-1','2','','','Mikrotik SNMP','0',NULL,'Template Net Mikrotik\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nMIKROTIK-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Doesn\'t have ifHighSpeed filled. fixed in more recent versions\r\n  Version: RouterOS 6.28 or lower\r\n\r\n  Description: Doesn\'t have any temperature sensors\r\n  Version: RouterOS 6.38.5\r\n  Device: Mikrotik 941-2nD, Mikrotik 951G-2HnD\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10234',NULL,'Netgear Fastpath SNMP','3','-1','2','','','Netgear Fastpath SNMP','0',NULL,'Template Net Netgear Fastpath\r\n\r\nMIBs used:\r\nFASTPATH-SWITCHING-MIB\r\nFASTPATH-BOXSERVICES-PRIVATE-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10235',NULL,'QTech QSW SNMP','3','-1','2','','','QTech QSW SNMP','0',NULL,'Template Net QTech QSW\r\n\r\nMIBs used:\r\nQTECH-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10236',NULL,'TP-LINK SNMP','3','-1','2','','','TP-LINK SNMP','0',NULL,'Template Net TP-LINK\r\n\r\nMIBs used:\r\nTPLINK-SYSINFO-MIB\r\nTPLINK-SYSMONITOR-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Default sysLocation, sysName and sysContact is not filled with proper data. Real hostname and location can be found only in private branch (TPLINK-SYSINFO-MIB). Please check whether this problem exists in the latest firmware: https://www.tp-link.com/en/support/download/t2600g-28ts/#Firmware\r\n  Version: 2.0.0 Build 20170628 Rel.55184 (Beta)\r\n  Device: T2600G-28TS 2.0\r\n\r\n  Description: The Serial number of the product (tpSysInfoSerialNum) is missing in HW versions prior to V2_170323\r\n  Version: Prior to version V2_170323\r\n  Device: T2600G-28TS 2.0\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10237',NULL,'Ubiquiti AirOS SNMP','3','-1','2','','','Ubiquiti AirOS SNMP','0',NULL,'Template Net Ubiquiti AirOS\r\n\r\nMIBs used:\r\nIEEE802dot11-MIB\r\nFROGFOOT-RESOURCES-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: UBNT unifi reports speed: like IF-MIB::ifSpeed.1 = Gauge32: 4294967295 for all interfaces\r\n  Version: Firmware: BZ.ar7240.v3.7.51.6230.170322.1513\r\n  Device: UBNT UAP-LR\r\n\r\n  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports ifSpeed: as 0 for VLAN and wireless(ath0) interfaces\r\n  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836\r\n  Device: NanoStation M5\r\n\r\n  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports always return ifType: as ethernet(6) even for wifi,vlans and other types\r\n  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836\r\n  Device: NanoStation M5\r\n\r\n  Description: ifXTable is not provided in IF-MIB. So Interfaces Simple Template is used instead\r\n  Version: all above\r\n  Device: NanoStation, UAP-LR\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10248',NULL,'Linux SNMP','3','-1','2','','','Linux SNMP','0',NULL,'Template OS Linux\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10249',NULL,'Windows SNMP','3','-1','2','','','Windows SNMP','0',NULL,'Official Windows SNMP template. Requires Zabbix server 4.0.14, 4.2.8, 4.4.0 or newer (JSONPath function avg() used with types autoconversion).\r\n\r\n\r\nKnown Issues:\r\n\r\n  Description: Doesn\'t support In/Out 64 bit counters even though IfxTable is present:\r\nCurrently, Windows gets it’s interface status from MIB-2. Since these 64bit SNMP counters (ifHCInOctets, ifHCOutOctets, etc.) are defined as an extension to IF-MIB, Microsoft has not implemented it.\r\nhttps://social.technet.microsoft.com/Forums/windowsserver/en-US/07b62ff0-94f6-40ca-a99d-d129c1b33d70/windows-2008-r2-snmp-64bit-counters-support?forum=winservergen\r\n\r\n  Version: Win2008, Win2012R2.\r\n\r\n  Description: Doesn\'t support ifXTable at all\r\n  Version: WindowsXP\r\n\r\n  Description: EtherLike MIB is not supported\r\n  Version: *\r\n  Device: *\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10250',NULL,'HP Enterprise Switch SNMP','3','-1','2','','','HP Enterprise Switch SNMP','0',NULL,'Template Net HP Enterprise Switch\r\n\r\nMIBs used:\r\nSEMI-MIB\r\nNETSWITCH-MIB\r\nHP-ICF-CHASSIS\r\nENTITY-SENSORS-MIB\r\nENTITY-MIB\r\nSTATISTICS-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10251',NULL,'Mellanox SNMP','3','-1','2','','','Mellanox SNMP','0',NULL,'Template Net Mellanox\r\n\r\nMIBs used:\r\nENTITY-SENSORS-MIB\r\nENTITY-STATE-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10252',NULL,'Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5 SNMP','3','-1','2','','','Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5 SNMP','0',NULL,'Template Module Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5\r\n\r\nMIBs used:\r\nCISCO-PROCESS-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10253',NULL,'Cisco IOS versions 12.0_3_T-12.2_3.5 SNMP','3','-1','2','','','Cisco IOS versions 12.0_3_T-12.2_3.5 SNMP','0',NULL,'Cisco IOS Software releases later to 12.0(3)T and prior to 12.2(3.5)\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10254',NULL,'Arista SNMP','3','-1','2','','','Arista SNMP','0',NULL,'Template Net Arista\r\n\r\nMIBs used:\r\nENTITY-SENSORS-MIB\r\nENTITY-STATE-MIB\r\nENTITY-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10255',NULL,'Dell iDRAC SNMP','3','-1','2','','','Dell iDRAC SNMP','0',NULL,'Template Server iDRAC\r\n\r\nMIBs used:\r\nIDRAC-MIB-SMIv2\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10256',NULL,'HP iLO SNMP','3','-1','2','','','HP iLO SNMP','0',NULL,'Template Server HP iLO\r\n\r\nMIBs used:\r\nCPQSINFO-MIB\r\nCPQHLTH-MIB\r\nCPQIDA-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10258',NULL,'IBM IMM SNMP','3','-1','2','','','IBM IMM SNMP','0',NULL,'Template Server IBM IMM\r\n\r\nMIBs used:\r\nIMM-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Some IMMs (IMM1) do not return disks\r\n  Version: IMM1\r\n  Device: IBM x3250M3\r\n\r\n  Description: Some IMMs (IMM1) do not return fan status: fanHealthStatus\r\n  Version: IMM1\r\n  Device: IBM x3250M3\r\n\r\n  Description: IMM1 servers (M2, M3 generations) sysObjectID is NET-SNMP-MIB::netSnmpAgentOIDs.10\r\n  Version: IMM1\r\n  Device: IMM1 servers (M2,M3 generations)\r\n\r\n  Description: IMM1 servers (M2, M3 generations) only Ambient temperature sensor available\r\n  Version: IMM1\r\n  Device: IMM1 servers (M2,M3 generations)\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10259',NULL,'Supermicro Aten SNMP','3','-1','2','','','Supermicro Aten SNMP','0',NULL,'Template Server Supermicro Aten\r\n\r\nMIBs used:\r\nATEN-IPMI-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10260',NULL,'Apache Tomcat JMX','3','-1','2','','','Apache Tomcat JMX','0',NULL,'The template to monitor Apache Tomcat by Zabbix that work without any external scripts.\r\nThe metrics are collected by JMX.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411862-discussion-thread-for-official-zabbix-template-tomcat\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10261',NULL,'Remote Zabbix server','3','-1','2','','','Remote Zabbix server','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10262',NULL,'Remote Zabbix proxy','3','-1','2','','','Remote Zabbix proxy','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10264',NULL,'Apache by Zabbix agent','3','-1','2','','','Apache by Zabbix agent','0',NULL,'Get metrics from mod_status module using HTTP agent.\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10265',NULL,'Apache by HTTP','3','-1','2','','','Apache by HTTP','0',NULL,'Get metrics from mod_status module using HTTP agent.\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10266',NULL,'Nginx by Zabbix agent','3','-1','2','','','Nginx by Zabbix agent','0',NULL,'Get metrics from stub status module using Zabbix agent running on Linux\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10267',NULL,'Nginx by HTTP','3','-1','2','','','Nginx by HTTP','0',NULL,'Get metrics from stub status module using HTTP agent\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10268',NULL,'Linux memory SNMP','3','-1','2','','','Linux memory SNMP','0',NULL,'MIBs used:\r\nUCD-SNMP-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Please note that memory utilization is a rough estimate, since memory available is calculated as free+buffers+cached, which is not 100% accurate, but the best we can get using SNMP.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10269',NULL,'Linux block devices SNMP','3','-1','2','','','Linux block devices SNMP','0',NULL,'MIBs used:\r\nUCD-DISKIO-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10270',NULL,'Linux CPU SNMP','3','-1','2','','','Linux CPU SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\nUCD-SNMP-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10271',NULL,'Linux filesystems SNMP','3','-1','2','','','Linux filesystems SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\nUCD-SNMP-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10272',NULL,'Linux CPU by Zabbix agent','3','-1','2','','','Linux CPU by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10273',NULL,'Linux filesystems by Zabbix agent','3','-1','2','','','Linux filesystems by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10274',NULL,'Linux memory by Zabbix agent','3','-1','2','','','Linux memory by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10275',NULL,'Linux block devices by Zabbix agent','3','-1','2','','','Linux block devices by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10276',NULL,'Linux network interfaces by Zabbix agent','3','-1','2','','','Linux network interfaces by Zabbix agent','0',NULL,'Known Issues:\r\n\r\n  Description: High interface utilization trigger is removed since currently it is not possible to retrieve interface speed to determine the max bandwidth.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10277',NULL,'Linux generic by Zabbix agent','3','-1','2','','','Linux generic by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10285',NULL,'Linux by Prom','3','-1','2','','','Linux by Prom','0',NULL,'Official Linux template using node exporter.\r\n\r\nKnown Issues:\r\n\r\n  Description: node_exporter v0.16.0 renamed many metrics. CPU utilization for \'guest\' and \'guest_nice\' metrics are not supported in this template with node_exporter < 0.16. Disk IO metrics are not supported. Other metrics provided as \'best effort\'.  \r\n See https://github.com/prometheus/node_exporter/releases/tag/v0.16.0 for details.\r\n  Version: below 0.16.0\r\n\r\n  Description: metric node_network_info with label \'device\' cannot be found, so network discovery is not possible.\r\n  Version: below 0.18\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10286',NULL,'Windows CPU by Zabbix agent','3','-1','2','','','Windows CPU by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10287',NULL,'Windows memory by Zabbix agent','3','-1','2','','','Windows memory by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10288',NULL,'Windows filesystems by Zabbix agent','3','-1','2','','','Windows filesystems by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10289',NULL,'Windows physical disks by Zabbix agent','3','-1','2','','','Windows physical disks by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10290',NULL,'Windows generic by Zabbix agent','3','-1','2','','','Windows generic by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10291',NULL,'Windows network by Zabbix agent','3','-1','2','','','Windows network by Zabbix agent','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10292',NULL,'Zabbix agent active','3','-1','2','','','Zabbix agent active','0',NULL,'Use this template instead of \'Template Module Zabbix agent\' for agents running in active mode only.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10300',NULL,'RabbitMQ cluster by Zabbix agent','3','-1','2','','','RabbitMQ cluster by Zabbix agent','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10301',NULL,'RabbitMQ node by Zabbix agent','3','-1','2','','','RabbitMQ node by Zabbix agent','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10302',NULL,'RabbitMQ cluster by HTTP','3','-1','2','','','RabbitMQ cluster by HTTP','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10303',NULL,'RabbitMQ node by HTTP','3','-1','2','','','RabbitMQ node by HTTP','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10304',NULL,'Cisco UCS SNMP','3','-1','2','','','Cisco UCS SNMP','0',NULL,'Template Server Cisco UCS\r\n\r\nMIBs used:\r\nCISCO-UNIFIED-COMPUTING-COMPUTE-MIB\r\nCISCO-UNIFIED-COMPUTING-PROCESSOR-MIB\r\nCISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB\r\nCISCO-UNIFIED-COMPUTING-STORAGE-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10305',NULL,'HOST-RESOURCES-MIB CPU SNMP','3','-1','2','','','HOST-RESOURCES-MIB CPU SNMP','0',NULL,'Requires Zabbix server 4.0.14, 4.2.8, 4.4.0 or newer (JSONPath function avg() used with types autoconversion).\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10306',NULL,'HOST-RESOURCES-MIB memory SNMP','3','-1','2','','','HOST-RESOURCES-MIB memory SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10307',NULL,'HOST-RESOURCES-MIB storage SNMP','3','-1','2','','','HOST-RESOURCES-MIB storage SNMP','0',NULL,'MIBs used:\r\nHOST-RESOURCES-MIB\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10308',NULL,'HAProxy by Zabbix agent','3','-1','2','','','HAProxy by Zabbix agent','0',NULL,'Get metrics from status page using Zabbix agent\r\nhttps://www.haproxy.com/blog/exploring-the-haproxy-stats-page/.\r\nExample configuration of HAProxy:        \r\n  frontend stats\r\n      bind *:8404\r\n      stats enable\r\n      stats uri /stats\r\n      stats refresh 10s\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10309',NULL,'HAProxy by HTTP','3','-1','2','','','HAProxy by HTTP','0',NULL,'Get metrics from status page using HTTP agent\r\nhttps://www.haproxy.com/blog/exploring-the-haproxy-stats-page/.\r\nExample configuration of HAProxy:        \r\n  frontend stats\r\n      bind *:8404\r\n      stats enable\r\n      stats uri /stats\r\n      stats refresh 10s\r\n      #stats auth Username:Password  # Authentication credentials\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10310',NULL,'Redis','3','-1','2','','','Redis','0',NULL,'Get Redis metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/389050-discussion-thread-for-official-zabbix-template-redis\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10314',NULL,'Windows services by Zabbix agent','3','-1','2','','','Windows services by Zabbix agent','0',NULL,'Template Services OS Windows\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10316',NULL,'MySQL by Zabbix agent','3','-1','2','','','MySQL by Zabbix agent','0',NULL,'Requirements for template operation:\r\n1.Install Zabbix agent and MySQL client.\r\n2.Copy template_db_mysql.conf into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don\'t forget restart zabbix-agent. \r\n3.Create MySQL user for monitoring. For example:\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\nFor more information read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please. \r\n4.Create .my.cnf in home directory of Zabbix agent for Linux (/var/lib/zabbix by default ) or my.cnf in c:\\ for Windows. For example:\r\n[client]\r\nuser=\'zbx_monitor\'\r\npassword=\'<password>\'\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10317',NULL,'MySQL by ODBC','3','-1','2','','','MySQL by ODBC','0',NULL,'Requirements for template operation:\r\n1. Create MySQL user for monitoring. For example:\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\nFor more information read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please. \r\n2. Set the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10318',NULL,'Docker','3','-1','2','','','Docker','0',NULL,'Get Docker engine metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum \r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10319',NULL,'Memcached','3','-1','2','','','Memcached','0',NULL,'Get Memcached metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398623-discussion-thread-for-official-zabbix-template-memcached\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10320',NULL,'MySQL by Zabbix agent 2','3','-1','2','','','MySQL by Zabbix agent 2','0',NULL,'Requirements for template operation:\r\n1. Create MySQL user for monitoring. For example:\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\nFor more information please read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.\r\n2. Set in the {$MYSQL.DSN} macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.\r\nExamples: MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock\r\nFor more information about MySQL Unix socket file please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.\r\n3. If you had set URI in the {$MYSQL.DSN}, please define the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\nLeave macros {$MYSQL.USER} and {$MYSQL.PASSWORD} empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.\r\nFor more information about configuring the Zabbix MySQL plugin please read the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10321',NULL,'Chassis by IPMI','3','-1','2','','','Chassis by IPMI','0',NULL,'Template for monitoring servers with BMC over IPMI that work without any external scripts. \r\nAll metrics are collected at once, thanks to Zabbix\'s bulk data collection. The template is available starting from Zabbix version 5.0. \r\nIt collects metrics by polling BMC remotely using an IPMI agent.\r\n\r\n\r\nKnown Issues:\r\n\r\n  Description: If the BMC has a sensor with an empty threshold value, we get the LLD error "Cannot create trigger...".\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398023-discussion-thread-for-official-zabbix-template-ipmi\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10322',NULL,'Elasticsearch Cluster by HTTP','3','-1','2','','','Elasticsearch Cluster by HTTP','0',NULL,'The template to monitor Elasticsearch by Zabbix that work without any external scripts.\r\nIt works with both standalone and cluster instances.\r\nThe metrics are collected in one pass remotely using an HTTP agent. \r\nThey are getting values from REST API _cluster/health, _cluster/stats, _nodes/stats requests.\r\nYou can set {$ELASTICSEARCH.USERNAME} and {$ELASTICSEARCH.PASSWORD} macros in the template for using on the host level.\r\nIf you use an atypical location ES API, don\'t forget to change the macros {$ELASTICSEARCH.SCHEME},{$ELASTICSEARCH.PORT}.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/399473-discussion-thread-for-official-zabbix-template-for-elasticsearch\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10323',NULL,'ClickHouse by HTTP','3','-1','2','','','ClickHouse by HTTP','0',NULL,'Get node metrics from ClickHouse HTTP interface using HTTP agent.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10324',NULL,'Etcd by HTTP','3','-1','2','','','Etcd by HTTP','0',NULL,'Get Etcd metrics by HTTP agent.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10325',NULL,'IIS by Zabbix agent','3','-1','2','','','IIS by Zabbix agent','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10326',NULL,'IIS by Zabbix agent active','3','-1','2','','','IIS by Zabbix agent active','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10327',NULL,'MSSQL by ODBC','3','-1','2','','','MSSQL by ODBC','0',NULL,'1. Create an MSSQL user for monitoring.\r\n  View Server State and View Any Definition permissions should be granted to the user.\r\n  For more information please see the MSSQL documentation.\r\n2. Set the user name and password in host macros ({$MSSQL.USER} and {$MSSQL.PASSWORD}).\r\n  Do not forget to install the Microsoft ODBC driver on the Zabbix server or the Zabbix proxy.\r\n  See Microsoft documentation for instructions: https://docs.microsoft.com/en-us/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server?view=sql-server-ver15.\r\n  Note! Credentials in the odbc.ini do not work for MSSQL.\r\n3. For named instance set the value of {$MSSQL.INSTANCE} macro as MSSQL$instance name, please.\r\nThe "Service\'s TCP port state" item uses {HOST.CONN} and {$MSSQL.PORT} macros to check the availability of the MSSQL instance.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10328',NULL,'Oracle by ODBC','3','-1','2','','','Oracle by ODBC','0',NULL,'1. Create an Oracle user for monitoring.\r\n\r\n2. Set the user name and password in host macros ({$ORACLE.USER} and {$ORACLE.PASSWORD}).\r\n  Do not forget to install the Microsoft ODBC driver on the Zabbix server or the Zabbix proxy.\r\n  See Oracle documentation for instructions: https://www.oracle.com/database/technologies/releasenote-odbc-ic.html.\r\n\r\n  Note! Credentials in the odbc.ini do not work for Oracle.\r\n  Note! Be sure that ODBC connects to Oracle with session parameter NLS_NUMERIC_CHARACTERS= \'.,\' It is important for correct display float numbers in Zabbix.\r\nThe "Service\'s TCP port state" item uses {HOST.CONN} and {$ORACLE.PORT} macros to check the availability of the listener.\r\n\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10329',NULL,'PostgreSQL Agent 2','3','-1','2','','','PostgreSQL Agent 2','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10330',NULL,'PHP-FPM by Zabbix agent','3','-1','2','','','PHP-FPM by Zabbix agent','0',NULL,'Get PHP-FPM metrics using Zabbix agent running on Linux.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10331',NULL,'PHP-FPM by HTTP','3','-1','2','','','PHP-FPM by HTTP','0',NULL,'Get PHP-FPM metrics using the Zabbix HTTP agent.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10332',NULL,'VMware macros','3','-1','2','','','VMware macros','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10333',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','','1','0','1');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10334',NULL,'{#VM.UUID}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','','1','0','1');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10335',NULL,'Oracle by Zabbix Agent 2','3','-1','2','','','Oracle by Zabbix Agent 2','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10336',NULL,'Asterisk by HTTP','3','-1','2','','','Asterisk by HTTP','0',NULL,'The template gets Asterisk metrics from AMI by HTTP agent. You should enable the mini-HTTP Server, add the option webenabled=yes in the general section of the manager.conf file and create Asterisk Manager user with system and command write permissions within your Asterisk instance. Please, define AMI address in the {$AMI.URL} macro. Also, the Zabbix host should have an Agent interface with the AMI address to check Asterisk service status. Then you can define {$AMI.USERNAME} and {$AMI.SECRET} macros in the template for using on the host level. If there are errors, increase the logging to debug level and see the Zabbix server log.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410060-discussion-thread-for-official-zabbix-template-asterisk\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10337',NULL,'Linux block devices by Zabbix agent active','3','-1','2','','','Linux block devices by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10338',NULL,'Linux CPU by Zabbix agent active','3','-1','2','','','Linux CPU by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10339',NULL,'Linux filesystems by Zabbix agent active','3','-1','2','','','Linux filesystems by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10340',NULL,'Linux generic by Zabbix agent active','3','-1','2','','','Linux generic by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10341',NULL,'Linux memory by Zabbix agent active','3','-1','2','','','Linux memory by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10342',NULL,'Linux network interfaces by Zabbix agent active','3','-1','2','','','Linux network interfaces by Zabbix agent active','0',NULL,'Known Issues:\r\n\r\n  Description: High interface utilization trigger is removed since currently it is not possible to retrieve interface speed to determine the max bandwidth.\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10343',NULL,'Linux by Zabbix agent active','3','-1','2','','','Linux by Zabbix agent active','0',NULL,'Official Linux template. Requires agent of Zabbix 3.0.14, 3.4.5 and 4.0.0 or newer.\r\n\r\nKnown Issues:\r\n\r\n  Description: Network discovery. Zabbix agent as of 4.2 doesn\'t support items such as net.if.status, net.if.speed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10344',NULL,'Windows CPU by Zabbix agent active','3','-1','2','','','Windows CPU by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10345',NULL,'Windows filesystems by Zabbix agent active','3','-1','2','','','Windows filesystems by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10346',NULL,'Windows generic by Zabbix agent active','3','-1','2','','','Windows generic by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10347',NULL,'Windows memory by Zabbix agent active','3','-1','2','','','Windows memory by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10348',NULL,'Windows network by Zabbix agent active','3','-1','2','','','Windows network by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10349',NULL,'Windows physical disks by Zabbix agent active','3','-1','2','','','Windows physical disks by Zabbix agent active','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10350',NULL,'Windows services by Zabbix agent active','3','-1','2','','','Windows services by Zabbix agent active','0',NULL,'Template Services OS Windows\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10351',NULL,'Windows by Zabbix agent active','3','-1','2','','','Windows by Zabbix agent active','0',NULL,'Official Windows template. Requires agent of Zabbix 4.4 and newer.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10353',NULL,'Ceph by Zabbix Agent2','3','-1','2','','','Ceph by Zabbix Agent2','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410059-discussion-thread-for-official-zabbix-template-ceph\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10355',NULL,'Squid SNMP','3','-1','2','','','Squid SNMP','0',NULL,'Template for monitoring Squid caching proxy via SNMP\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/409339-discussion-thread-for-official-zabbix-template-squid\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10357',NULL,'PostgreSQL','3','-1','2','','','PostgreSQL','0',NULL,'','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10358',NULL,'Apache Kafka by JMX','3','-1','2','','','Apache Kafka by JMX','0',NULL,'Official JMX Template for Apache Kafka.\r\n  The metrics are collected by JMX.\r\n  You can set {$KAFKA.USER} and {$KAFKA.PASSWORD} macros in the template for using on the host level.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10359',NULL,'Apache Cassandra by JMX','3','-1','2','','','Apache Cassandra by JMX','0',NULL,'The template to monitor Apache Cassandra by Zabbix that work without any external scripts.\r\nIt works with both standalone and cluster instances.\r\nThe metrics are collected by JMX.\r\nYou can set {$CASSANDRA.USER} and {$CASSANDRA.PASSWORD} macros in the template for using on the host level.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410057-discussion-thread-for-official-zabbix-template-apache-cassandra\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10360',NULL,'Aranet Cloud','3','-1','2','','','Aranet Cloud','0',NULL,'Template tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10361',NULL,'Hadoop by HTTP','3','-1','2','','','Hadoop by HTTP','0',NULL,'The template gets the Hadoop metrics from cluster\'s hosts (ResourceManager, NodeManagers, NameNode, DataNodes) by HTTP agent. You should define the IP address (or FQDN) and Web-UI port for the ResourceManager in {$HADOOP.RESOURCEMANAGER.HOST} and {$HADOOP.RESOURCEMANAGER.PORT} macros and for the NameNode in {$HADOOP.NAMENODE.HOST} and {$HADOOP.NAMENODE.PORT} macros respectively. Macros can be set in the template or overridden at the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/413459-discussion-thread-for-official-zabbix-template-hadoop\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10362',NULL,'VMware FQDN','3','-1','2','','','VMware FQDN','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10363',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','','1','0','1');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10364',NULL,'{#VM.DNS}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','','1','0','1');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10365',NULL,'Zookeeper by HTTP','3','-1','2','','','Zookeeper by HTTP','0',NULL,'Get Apache Zookeeper metrics by HTTP agent.\r\n  This template works with standalone and cluster instances. Metrics are collected from each Zookeper node by requests to AdminServer.  \r\n  Don\'t forget to change macros {$ZOOKEEPER.COMMAND_URL}, {$ZOOKEEPER.PORT}, {$ZOOKEEPER.SCHEME}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10366',NULL,'Morningstar ProStar MPPT SNMP','3','-1','2','','','Morningstar ProStar MPPT SNMP','0',NULL,'MIBs used:\r\nPROSTAR-MPPT\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10367',NULL,'Morningstar ProStar PWM SNMP','3','-1','2','','','Morningstar ProStar PWM SNMP','0',NULL,'MIBs used:\r\nPROSTAR-PWM\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10368',NULL,'Morningstar SunSaver MPPT SNMP','3','-1','2','','','Morningstar SunSaver MPPT SNMP','0',NULL,'MIBs used:\r\nSUNSAVER-MPPT\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10369',NULL,'Morningstar SureSine SNMP','3','-1','2','','','Morningstar SureSine SNMP','0',NULL,'MIBs used:\r\nSURESINE\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10370',NULL,'Morningstar TriStar MPPT 600V SNMP','3','-1','2','','','Morningstar TriStar MPPT 600V SNMP','0',NULL,'MIBs used:\r\nTRISTAR-MPPT\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10371',NULL,'Morningstar TriStar MPPT SNMP','3','-1','2','','','Morningstar TriStar MPPT SNMP','0',NULL,'MIBs used:\r\nTRISTAR-MPPT\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10372',NULL,'Morningstar TriStar PWM SNMP','3','-1','2','','','Morningstar TriStar PWM SNMP','0',NULL,'MIBs used:\r\nTRISTAR\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10373',NULL,'GitLab by HTTP','3','-1','2','','','GitLab by HTTP','0',NULL,'Get GitLab metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nTo access the metrics, the client IP address must be explicitly allowed. See https://docs.gitlab.com/ee/administration/monitoring/ip_whitelist.html.\r\n\r\nDon\'t forget change macros {$GITLAB.URL}, {$GITLAB.PORT}. \r\nSome metrics may not be collected depending on your Gitlab instance version and configuration. See (Gitlab’s documentation[)https://docs.gitlab.com/ee/administration/monitoring/prometheus/gitlab_metrics.html] for further information about its metric collection.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10374',NULL,'Apache ActiveMQ by JMX','3','-1','2','','','Apache ActiveMQ by JMX','0',NULL,'The template to monitor Apache ActiveMQ by Zabbix that work without any external scripts.\r\nThe metrics are collected by JMX.\r\nYou can set macro values and add macros with context for specific brokers or destinations following macro description.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411049-discussion-thread-for-official-zabbix-template-amq\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10375',NULL,'Microsoft Exchange Server 2016 by Zabbix agent','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.\r\nThe metrics are collected by Zabbix agent.\r\nRecommended to use it with "OS Windows by Zabbix agent" template.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10376',NULL,'Microsoft Exchange Server 2016 by Zabbix agent active','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent active','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.\r\nThe metrics are collected by Zabbix agent active.\r\nRecommended to use it with "OS Windows by Zabbix agent active" template.\r\n\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10377',NULL,'HashiCorp Vault by HTTP','3','-1','2','','','HashiCorp Vault by HTTP','0',NULL,'Get HashiCorp Vault metrics from Vault API HTTP Prometheus metrics endpoint.\r\n\r\nSome metrics may not be collected depending on your Vault instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `hosts` (`hostid`,`proxy_hostid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`proxy_address`,`auto_compress`,`discover`,`custom_interfaces`) values ('10378',NULL,'NetApp FAS3220 SNMP','3','-1','2','','','NetApp FAS3220 SNMP','0',NULL,'The template to monitor SAN NetApp FAS3220 cluster by Zabbix SNMP agent.\r\n\r\nMIBs used:\r\nNETAPP-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/416694-discussion-thread-for-official-zabbix-template-netapp-fas3220\r\n\r\nTemplate tooling version used: 0.38','1','1','','','','','','1','0','0');
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('1','10333','{#CLUSTER.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('2','10333','{#DATACENTER.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('4','10334','{#CLUSTER.NAME} (vm)',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('5','10334','{#DATACENTER.NAME} (vm)',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('6','10334','{#HV.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('20','10363','{#CLUSTER.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('21','10363','{#DATACENTER.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('23','10364','{#CLUSTER.NAME} (vm)',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('24','10364','{#DATACENTER.NAME} (vm)',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('25','10364','{#HV.NAME}',NULL,NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('31','10333','','12',NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('32','10334','','12',NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('33','10363','','12',NULL);
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) values ('34','10364','','12',NULL);
INSERT INTO `screens` (`screenid`,`name`,`hsize`,`vsize`,`userid`,`private`) values ('1','Zabbix server','2','2','1','1');
INSERT INTO `screens_items` (`screenitemid`,`screenid`,`resourcetype`,`resourceid`,`width`,`height`,`x`,`y`,`colspan`,`rowspan`,`elements`,`valign`,`halign`,`style`,`url`,`dynamic`,`sort_triggers`,`application`,`max_columns`) values ('1','1','2','1','500','100','0','0','2','1','0','0','0','0','','0','0','','3');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('179','10047','Zabbix server','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('253','10074','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('254','10074','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('255','10074','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('256','10074','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('257','10074','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('258','10074','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('259','10074','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('260','10074','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('261','10074','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('263','10075','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('264','10075','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('265','10075','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('266','10075','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('267','10075','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('268','10075','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('269','10075','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('270','10075','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('271','10075','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('273','10076','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('274','10076','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('275','10076','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('276','10076','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('277','10076','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('278','10076','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('279','10076','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('280','10076','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('281','10076','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('283','10077','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('284','10077','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('285','10077','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('286','10077','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('287','10077','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('288','10077','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('289','10077','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('290','10077','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('291','10077','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('293','10078','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('294','10078','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('295','10078','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('296','10078','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('297','10078','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('298','10078','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('299','10078','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('300','10078','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('301','10078','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('303','10079','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('304','10079','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('305','10079','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('306','10079','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('307','10079','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('308','10079','OS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('309','10079','Performance','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('310','10079','Processes','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('311','10079','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('331','10076','Logical partitions','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('345','10084','Zabbix server','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('356','10048','Zabbix proxy','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('446','10093','FTP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('447','10094','HTTP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('448','10095','HTTPS service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('449','10096','IMAP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('450','10097','LDAP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('451','10098','NNTP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('452','10099','NTP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('453','10100','POP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('454','10101','SMTP service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('455','10102','SSH service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('456','10103','Telnet service','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('741','10171','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('742','10171','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('743','10171','Voltage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('744','10172','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('745','10172','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('746','10172','Voltage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('771','10183','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('780','10186','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('782','10188','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('784','10190','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('786','10192','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('799','10204','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('800','10204','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('803','10207','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('804','10207','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('805','10207','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('806','10207','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('807','10207','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('808','10207','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('809','10207','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('810','10207','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('811','10208','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('812','10208','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('813','10208','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('814','10208','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('815','10208','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('816','10208','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('817','10208','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('818','10208','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('819','10208','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('820','10210','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('821','10210','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('822','10210','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('823','10211','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('824','10211','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('825','10211','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('826','10209','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('827','10209','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('828','10210','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('829','10210','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('830','10210','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('831','10210','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('832','10211','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('833','10211','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('834','10211','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('835','10211','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('836','10210','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('837','10210','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('838','10211','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('839','10211','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('840','10218','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('841','10218','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('842','10218','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('846','10220','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('847','10220','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('848','10212','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('849','10213','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('851','10215','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('852','10216','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('853','10217','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('854','10217','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('855','10217','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('856','10218','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('857','10218','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('858','10218','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('859','10218','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('860','10218','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('861','10218','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('868','10220','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('869','10220','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('870','10220','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('871','10220','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('872','10220','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('873','10220','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('874','10221','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('875','10221','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('876','10221','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('877','10221','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('878','10221','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('879','10221','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('880','10221','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('881','10221','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('882','10221','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('883','10222','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('884','10222','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('885','10222','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('886','10222','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('887','10222','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('888','10222','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('889','10222','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('890','10222','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('891','10222','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('892','10223','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('893','10223','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('894','10223','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('895','10223','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('896','10223','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('897','10223','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('898','10223','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('899','10223','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('900','10223','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('901','10224','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('902','10224','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('903','10224','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('904','10224','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('905','10224','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('906','10224','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('907','10224','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('908','10224','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('909','10224','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('913','10226','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('914','10226','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('915','10226','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('916','10227','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('917','10227','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('918','10227','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('919','10227','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('920','10227','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('921','10227','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('922','10227','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('923','10227','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('924','10227','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('934','10229','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('935','10229','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('936','10229','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('937','10229','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('938','10229','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('939','10229','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('940','10229','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('941','10229','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('942','10230','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('943','10230','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('944','10230','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('945','10230','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('946','10230','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('947','10230','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('948','10230','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('949','10231','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('950','10231','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('951','10231','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('952','10231','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('953','10231','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('954','10231','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('955','10231','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('956','10231','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('957','10231','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('969','10233','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('970','10233','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('971','10233','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('972','10233','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('973','10233','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('974','10233','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('975','10233','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('976','10233','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('977','10234','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('978','10234','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('979','10234','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('980','10234','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('981','10234','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('982','10234','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('983','10234','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('984','10234','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('985','10234','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('986','10235','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('987','10235','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('988','10235','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('989','10235','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('990','10235','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('991','10235','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('992','10236','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('993','10236','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('994','10236','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('995','10236','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('996','10236','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('997','10236','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('998','10237','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('999','10237','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1000','10237','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1001','10237','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1002','10237','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1003','10237','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1028','10250','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1029','10250','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1030','10250','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1031','10250','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1032','10250','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1033','10250','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1034','10250','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1035','10250','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1036','10250','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1041','10251','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1042','10251','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1043','10251','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1044','10251','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1045','10251','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1046','10251','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1047','10251','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1048','10253','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1049','10253','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1050','10253','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1051','10253','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1052','10253','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1053','10253','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1054','10253','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1055','10253','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1056','10252','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1057','10253','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1058','10254','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1059','10254','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1060','10254','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1062','10254','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1064','10254','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1066','10254','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1068','10254','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1069','10255','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1070','10255','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1071','10255','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1072','10255','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1073','10255','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1074','10255','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1075','10255','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1076','10255','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1077','10255','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1078','10256','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1079','10256','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1080','10256','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1081','10256','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1082','10256','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1083','10256','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1084','10256','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1085','10256','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1086','10256','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1094','10258','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1095','10258','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1096','10258','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1097','10258','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1098','10258','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1099','10258','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1100','10258','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1101','10259','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1102','10259','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1103','10259','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1104','10259','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1109','10260','Tomcat','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1110','10261','Zabbix server','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1111','10262','Zabbix proxy','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1116','10264','Apache','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1117','10264','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1118','10265','Apache','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1119','10265','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1120','10266','Nginx','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1121','10266','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1122','10267','Nginx','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1123','10267','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1125','10248','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1126','10248','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1127','10248','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1128','10268','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1129','10269','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1130','10270','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1131','10271','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1132','10248','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1133','10248','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1134','10248','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1135','10249','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1136','10249','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1141','10249','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1142','10272','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1143','10273','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1144','10274','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1145','10275','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1146','10275','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1147','10276','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1148','10277','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1149','10277','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1150','10277','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1151','10277','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1152','10001','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1153','10001','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1154','10001','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1155','10001','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1156','10001','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1157','10001','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1158','10001','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1159','10001','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1160','10001','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1161','10001','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1162','10084','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1163','10084','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1164','10084','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1165','10084','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1166','10084','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1167','10084','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1168','10084','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1169','10084','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1170','10084','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1171','10084','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1193','10285','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1194','10285','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1195','10285','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1196','10285','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1197','10285','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1198','10285','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1199','10285','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1200','10285','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1201','10285','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1202','10286','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1203','10287','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1204','10288','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1205','10289','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1207','10290','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1208','10290','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1209','10290','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1210','10291','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1211','10291','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1212','10081','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1213','10081','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1214','10081','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1215','10081','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1216','10081','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1217','10081','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1218','10081','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1219','10081','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1220','10081','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1221','10050','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1222','10050','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1223','10292','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1224','10292','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1225','10001','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1226','10074','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1227','10074','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1228','10075','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1229','10075','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1230','10076','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1231','10076','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1232','10077','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1233','10077','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1234','10078','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1235','10078','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1236','10079','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1237','10079','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1238','10081','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1240','10084','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1261','10300','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1262','10300','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1263','10301','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1264','10301','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1265','10302','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1266','10302','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1267','10303','RabbitMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1268','10303','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1270','10304','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1271','10304','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1272','10304','Disk arrays','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1273','10304','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1274','10304','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1275','10304','Physical disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1276','10304','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1277','10304','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1278','10304','Virtual disks','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1279','10207','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1280','10235','Fans','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1281','10235','Power supply','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1282','10235','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1283','10305','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1284','10306','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1285','10307','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1286','10185','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1287','10185','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1288','10185','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1289','10251','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1290','10251','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1291','10251','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1292','10249','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1293','10249','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1294','10249','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1295','10254','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1296','10254','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1297','10254','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1298','10308','HAProxy','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1299','10308','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1300','10309','HAProxy','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1301','10309','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1302','10310','Redis','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1303','10310','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1310','10314','Services','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1311','10081','Services','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1314','10316','MySQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1315','10316','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1316','10317','MySQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1317','10317','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1318','10318','Docker','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1319','10318','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1320','10319','Memcached','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1321','10319','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1322','10320','MySQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1323','10320','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1324','10321','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1325','10321','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1326','10322','ES cluster','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1327','10322','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1328','10323','ClickHouse','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1329','10323','ClickHouse ZooKeeper','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1330','10323','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1331','10324','Etcd','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1332','10324','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1333','10325','IIS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1334','10326','IIS','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1335','10327','MSSQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1336','10327','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1337','10328','Oracle','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1338','10328','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1339','10329','PostgreSQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1340','10329','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1341','10169','JMX','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1342','10233','Wireless','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1343','10330','PHP-FPM','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1344','10330','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1345','10331','PHP-FPM','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1346','10331','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1347','10173','VMware','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1348','10174','VMware','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1349','10175','VMware','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1350','10335','Oracle','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1351','10335','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1352','10336','Asterisk','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1353','10336','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1354','10343','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1355','10343','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1356','10337','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1357','10337','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1358','10338','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1359','10339','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1360','10340','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1361','10340','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1362','10340','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1363','10340','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1364','10341','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1365','10342','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1366','10343','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1367','10343','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1368','10343','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1369','10343','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1370','10343','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1371','10343','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1372','10343','Security','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1373','10343','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1374','10343','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1375','10351','Monitoring agent','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1376','10351','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1377','10344','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1378','10345','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1379','10346','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1380','10346','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1381','10346','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1382','10347','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1383','10348','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1384','10348','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1385','10349','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1386','10350','Services','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1387','10351','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1388','10351','Filesystems','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1389','10351','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1390','10351','Inventory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1391','10351','Memory','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1392','10351','Network interfaces','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1393','10351','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1394','10351','Storage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1395','10351','Services','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1398','10353','Ceph','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1399','10353','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1401','10355','Squid','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1404','10357','PostgreSQL','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1405','10357','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1406','10358','Kafka','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1407','10359','Cassandra','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1408','10254','Voltage','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1409','10254','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1410','10360','Aranet','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1411','10360','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1412','10361','Hadoop','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1413','10361','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1414','10362','VMware','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1415','10365','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1416','10365','Zookeeper','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1417','10366','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1418','10366','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1419','10366','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1420','10366','Load','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1421','10366','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1422','10366','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1423','10366','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1424','10367','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1425','10367','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1426','10367','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1427','10367','Load','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1428','10367','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1429','10367','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1430','10367','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1431','10368','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1432','10368','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1433','10368','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1434','10368','Load','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1435','10368','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1436','10368','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1437','10368','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1438','10369','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1439','10369','Load','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1440','10369','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1441','10369','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1442','10369','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1443','10370','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1444','10370','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1445','10370','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1446','10370','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1447','10370','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1448','10370','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1449','10371','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1450','10371','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1451','10371','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1452','10371','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1453','10371','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1454','10371','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1455','10372','Array','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1456','10372','Battery','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1457','10372','Counter','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1458','10372','Load','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1459','10372','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1460','10372','Temperature','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1461','10372','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1462','10373','GitLab','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1463','10373','GitLab: Puma stats','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1464','10373','GitLab: Unicorn stats','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1465','10373','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1466','10374','ActiveMQ','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1467','10375','MS Exchange','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1468','10376','MS Exchange','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1469','10377','Vault','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1470','10377','Zabbix raw items','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1471','10378','General','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1472','10378','Status','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1473','10378','CPU','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1474','10378','NetApp FAS3220','0');
INSERT INTO `applications` (`applicationid`,`hostid`,`name`,`flags`) values ('1475','10378','Network interfaces','0');
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) values ('1','10084','1','1','1','127.0.0.1','','10050');
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) values ('2','10333','1','1','1','{#HV.IP}','','10050');
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) values ('3','10334','1','1','1','{#VM.IP}','','10050');
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) values ('4','10363','1','1','1','{#HV.IP}','','10050');
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) values ('5','10364','1','1','1','{#VM.IP}','','10050');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('1','Service state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('2','Host availability');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('3','Windows service state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('4','APC Battery Replacement Status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('5','APC Battery Status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('6','HP Insight System Status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('7','Dell Open Manage System Status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('8','SNMP interface status (ifOperStatus)');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('9','SNMP device status (hrDeviceStatus)');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('10','Zabbix agent ping status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('11','SNMP interface status (ifAdminStatus)');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('12','VMware VirtualMachinePowerState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('13','VMware status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('14','Maintenance status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('15','Value cache operating mode');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('16','Windows service startup type');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('17','HTTP response status code');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('18','ENTITY-SENSORS-MIB::EntitySensorStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('19','EtherLike-MIB::dot3StatsDuplexStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('20','IF-MIB::ifOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('21','IF-MIB::ifType');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('22','zabbix.host.available');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('23','TIMETRA-CHASSIS-MIB::TmnxDeviceState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('24','SW-MIB::swSensorStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('25','SW-MIB::swOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('26','FOUNDRY-SN-AGENT-MIB::snChasPwrSupplyOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('27','FOUNDRY-SN-AGENT-MIB::snChasFanOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('28','CISCO-ENVMON-MIB::CiscoEnvMonState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('29','F10-S-SERIES-CHASSIS-MIB::extremeFanOperational');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('30','F10-S-SERIES-CHASSIS-MIB::chSysFanTrayOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('31','F10-S-SERIES-CHASSIS-MIB::chSysPowerSupplyOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('32','MY-SYSTEM-MIB::mySystemFanIsNormal');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('33','EQUIPMENT-MIB::swFanStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('34','EQUIPMENT-MIB::swPowerStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('35','TruthValue');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('36','EXTREME-SYSTEM-MIB::extremeFanOperational');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('37','EXTREME-SYSTEM-MIB::extremeOverTemperatureAlarm');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('38','EXTREME-SYSTEM-MIB::extremePowerSupplyStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('39','HH3C-ENTITY-EXT-MIB::hh3cEntityExtErrorStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('40','HP-ICF-CHASSIS::hpicfSensorStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('41','HUAWEI-ENTITY-EXTENT-MIB::hwEntityFanState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('42','ICS-CHASSIS-MIB::icsChassisFanOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('43','ICS-CHASSIS-MIB::icsChassisSensorSlotOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('44','ICS-CHASSIS-MIB::icsChassisPowerSupplyOperStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('45','ICS-CHASSIS-MIB::icsChassisTemperatureStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('46','JUNIPER-ALARM-MIB::jnxRedAlarmState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('47','JUNIPER-ALARM-MIB::jnxOperatingState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('48','ENTITY-STATE-MIB::EntityOperState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('49','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesPowSupplyItemState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('50','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesFanItemState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('51','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesTempSensorState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('52','QTECH-MIB::sysFanStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('53','QTECH-MIB::sysPowerStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('54','CPQSINFO-MIB::status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('55','CPQHLTH-MIB::cpqHeTemperatureLocale');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('56','CPQIDA-MIB::cpqDaCntlrModel');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('57','CPQIDA-MIB::cpqDaPhyDrvStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('58','IMM-MIB::systemHealthStat');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('59','IDRAC-MIB-SMIv2::ObjectStatusEnum');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('60','IDRAC-MIB-SMIv2::StatusProbeEnum');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('61','IDRAC-MIB-SMIv2::physicalDiskComponentStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('62','IDRAC-MIB-SMIv2::BooleanType');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('63','IDRAC-MIB-SMIv2::physicalDiskMediaType');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('64','IDRAC-MIB-SMIv2::batteryState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('65','IDRAC-MIB-SMIv2::virtualDiskLayout');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('66','IDRAC-MIB-SMIv2::virtualDiskOperationalState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('67','IDRAC-MIB-SMIv2::virtualDiskWritePolicy');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('68','IDRAC-MIB-SMIv2::virtualDiskReadPolicy');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('69','IDRAC-MIB-SMIv2::virtualDiskState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('70','CPQIDA-MIB::cpqDaPhyDrvSmartStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('71','CPQIDA-MIB::cpqDaAccelStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('72','CPQIDA-MIB::cpqDaAccelBattery');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('73','CPQIDA-MIB::cpqDaPhyDrvMediaType');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('74','CPQIDA-MIB::cpqDaLogDrvFaultTol');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('75','CPQIDA-MIB::cpqDaLogDrvStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('76','PostgreSQL recovery role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('77','PostgreSQL replication status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('78','Linux::Interface protocol types');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('79','Win32_NetworkAdapter::AdapterTypeId');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('80','CIM_LogicalDevice::Availability');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('81','Win32_NetworkAdapter::NetConnectionStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('82','RabbitMQ healthcheck');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('83','Alarm state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('84','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentOperability');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('85','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsLsOperState');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('86','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStoragePDriveStatus');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('87','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStorageLunType');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('88','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentPresence');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('89','Redis bgwrite status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('90','Redis flag');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('91','Redis repl offset');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('92','Redis bgsave time');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('93','Docker flag');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('94','ES cluster state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('95','Replicas state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('96','Etcd healthcheck');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('97','Etcd leader');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('98','Application pool state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('99','MSSQL DB state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('100','MSSQL AG Connected state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('101','MSSQL AG Join state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('102','MSSQL AG Operational state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('103','MSSQL AG Recovery health');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('104','MSSQL AG Role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('105','MSSQL AG Suspend state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('106','MSSQL AG Synchronization health');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('107','MSSQL - Yes / No');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('108','MSSQL Mirroring State');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('109','MSSQL Mirroring Role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('110','MSSQL Safety level');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('111','MSSQL Witness state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('112','Oracle DB open status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('113','Oracle DB role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('114','Oracle instance status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('115','Oracle instance role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('116','Oracle archiver state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('117','Oracle tablespace status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('118','Oracle Archivelog status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('119','Oracle force log status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('120','Oracle log mode');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('121','Ceph cluster status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('122','Kafka controller state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('123','ProStar MPPT charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('124','ProStar MPPT load state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('125','ProStar PWM charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('126','ProStar PWM load state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('127','SunSaver MPPT charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('128','SunSaver MPPT load state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('129','SureSine load state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('130','TriStar MPPT 600V charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('131','TriStar MPPT charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('132','TriStar PWM charge state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('133','TriStar PWM control mode');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('134','TriStar PWM load state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('135','GitLab healthcheck');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('136','Exchange database copy role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('137','Exchange database state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('138','Vault flag');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('139','FAS3220 HA cannot takeover cause');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('140','FAS3220 HA settings');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('141','FAS3220 NVRAM battery status');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('142','FAS3220 Port health');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('143','FAS3220 Port link state');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('144','FAS3220 Port role');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('145','FAS3220 Port speed');
INSERT INTO `valuemaps` (`valuemapid`,`name`) values ('146','FAS3220 Port UP by administrator');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10061','5','','10047','Number of processed numeric (float) values per second','zabbix[wcache,values,float]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10062','5','','10047','Number of processed character values per second','zabbix[wcache,values,str]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10063','5','','10047','Number of processed log values per second','zabbix[wcache,values,log]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10064','5','','10047','Number of processed numeric (unsigned) values per second','zabbix[wcache,values,uint]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10065','5','','10047','Number of processed text values per second','zabbix[wcache,values,text]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10066','5','','10047','Number of processed not supported values per second','zabbix[wcache,values,not supported]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10067','5','','10048','Number of processed numeric (float) values per second','zabbix[wcache,values,float]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10068','5','','10048','Number of processed character values per second','zabbix[wcache,values,str]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10069','5','','10048','Number of processed log values per second','zabbix[wcache,values,log]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10070','5','','10048','Number of processed numeric (unsigned) values per second','zabbix[wcache,values,uint]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10071','5','','10048','Number of processed text values per second','zabbix[wcache,values,text]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('10072','5','','10048','Number of processed not supported values per second','zabbix[wcache,values,not supported]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22183','5','','10047','Zabbix history write cache, % used','zabbix[wcache,history,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22185','5','','10047','Zabbix trend write cache, % used','zabbix[wcache,trend,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22187','5','','10047','Number of processed values per second','zabbix[wcache,values]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22189','5','','10047','Zabbix configuration cache, % used','zabbix[rcache,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22191','5','','10047','Zabbix value cache, % used','zabbix[vcache,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22196','5','','10047','Zabbix value cache hits','zabbix[vcache,cache,hits]','1m','1w','365d','0','0','','vps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22199','5','','10047','Zabbix value cache misses','zabbix[vcache,cache,misses]','1m','1w','365d','0','0','','vps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22219','5','','10047','Zabbix queue over 10 minutes','zabbix[queue,10m]','10m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22231','0','','10050','Version of Zabbix agent running','agent.version','1h','7d','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22232','0','','10050','Zabbix agent ping','agent.ping','1m','7d','365d','0','3','','','','',NULL,'10','','','0','','','','','0',NULL,'The agent always returns 1 for this item. It could be used in combination with nodata() for availability check.','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22396','5','','10047','Zabbix history index cache, % used','zabbix[wcache,index,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22399','5','','10047','Utilization of poller data collector processes, in %','zabbix[process,poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22400','5','','10047','Utilization of unreachable poller data collector processes, in %','zabbix[process,unreachable poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22401','5','','10047','Utilization of vmware data collector processes, in %','zabbix[process,vmware collector,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22402','5','','10047','Utilization of http poller data collector processes, in %','zabbix[process,http poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22404','5','','10047','Utilization of trapper data collector processes, in %','zabbix[process,trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22406','5','','10047','Utilization of history syncer internal processes, in %','zabbix[process,history syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22408','5','','10047','Utilization of housekeeper internal processes, in %','zabbix[process,housekeeper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22412','5','','10047','Utilization of configuration syncer internal processes, in %','zabbix[process,configuration syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22414','5','','10047','Utilization of self-monitoring internal processes, in %','zabbix[process,self-monitoring,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22416','5','','10047','Utilization of ipmi poller data collector processes, in %','zabbix[process,ipmi poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22418','5','','10047','Utilization of icmp pinger data collector processes, in %','zabbix[process,icmp pinger,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22420','5','','10047','Utilization of proxy poller data collector processes, in %','zabbix[process,proxy poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22422','5','','10047','Utilization of escalator internal processes, in %','zabbix[process,escalator,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22424','5','','10047','Utilization of alerter internal processes, in %','zabbix[process,alerter,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22426','5','','10047','Utilization of timer internal processes, in %','zabbix[process,timer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22430','5','','10047','Utilization of discoverer data collector processes, in %','zabbix[process,discoverer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22689','5','','10047','Utilization of java poller data collector processes, in %','zabbix[process,java poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22835','0','','10074','Maximum number of opened files','kernel.maxfiles','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22836','0','','10074','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22837','0','','10074','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22838','0','','10074','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22839','0','','10074','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22840','0','','10074','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22841','0','','10074','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22842','0','','10074','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22843','0','','10074','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22844','0','','10074','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22845','0','','10074','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22846','0','','10074','CPU interrupt time','system.cpu.util[,interrupt]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The amount of time the CPU has been servicing hardware interrupts.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22848','0','','10074','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22851','0','','10074','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22852','0','','10074','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22853','0','','10074','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22854','0','','10074','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22855','0','','10074','Free swap space','system.swap.size[,free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22856','0','','10074','Free swap space in %','system.swap.size[,pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22857','0','','10074','Total swap space','system.swap.size[,total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22858','0','','10074','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22859','0','','10074','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22860','0','','10074','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22861','0','','10074','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22862','0','','10074','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22863','0','','10074','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22867','0','','10074','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22868','0','','10074','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22869','0','','10074','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22870','0','','10074','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22871','0','','10074','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22872','0','','10074','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22875','0','','10075','Maximum number of opened files','kernel.maxfiles','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22876','0','','10075','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22877','0','','10075','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22878','0','','10075','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22879','0','','10075','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22880','0','','10075','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22881','0','','10075','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22882','0','','10075','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22883','0','','10075','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22884','0','','10075','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22885','0','','10075','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22886','0','','10075','CPU interrupt time','system.cpu.util[,interrupt]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The amount of time the CPU has been servicing hardware interrupts.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22888','0','','10075','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22891','0','','10075','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22892','0','','10075','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22893','0','','10075','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22894','0','','10075','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22895','0','','10075','Free swap space','system.swap.size[,free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22896','0','','10075','Free swap space in %','system.swap.size[,pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22897','0','','10075','Total swap space','system.swap.size[,total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22898','0','','10075','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22899','0','','10075','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22900','0','','10075','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22901','0','','10075','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22902','0','','10075','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22903','0','','10075','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22907','0','','10075','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22908','0','','10075','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22909','0','','10075','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22910','0','','10075','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22911','0','','10075','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22912','0','','10075','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22917','0','','10076','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22918','0','','10076','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22920','0','','10076','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22921','0','','10076','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22922','0','','10076','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22923','0','','10076','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22924','0','','10076','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22933','0','','10076','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22934','0','','10076','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22938','0','','10076','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22939','0','','10076','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22940','0','','10076','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22941','0','','10076','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22942','0','','10076','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22943','0','','10076','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22944','0','','10076','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22945','0','','10076','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22946','0','','10076','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22947','0','','10076','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22948','0','','10076','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22949','0','','10076','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22950','0','','10076','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22951','0','','10076','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22952','0','','10076','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22961','0','','10077','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22962','0','','10077','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22963','0','','10077','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22965','0','','10077','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22968','0','','10077','CPU nice time','system.cpu.util[,nice]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that have been niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22971','0','','10077','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22972','0','','10077','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22973','0','','10077','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22974','0','','10077','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22978','0','','10077','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22980','0','','10077','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22981','0','','10077','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22982','0','','10077','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22983','0','','10077','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22984','0','','10077','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22985','0','','10077','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22986','0','','10077','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22987','0','','10077','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22988','0','','10077','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22989','0','','10077','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22990','0','','10077','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22991','0','','10077','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22992','0','','10077','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22996','0','','10078','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22997','0','','10078','Number of running processes','proc.num[,,run]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of processes in running state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22998','0','','10078','Number of processes','proc.num[]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Total number of processes in any state.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('22999','0','','10078','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23000','0','','10078','Interrupts per second','system.cpu.intr','1m','1w','365d','0','3','','ips','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23001','0','','10078','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23002','0','','10078','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23003','0','','10078','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23004','0','','10078','Context switches per second','system.cpu.switches','1m','1w','365d','0','3','','sps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23005','0','','10078','CPU idle time','system.cpu.util[,idle]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent doing nothing.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23007','0','','10078','CPU iowait time','system.cpu.util[,iowait]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'Amount of time the CPU has been waiting for I/O to complete.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23011','0','','10078','CPU system time','system.cpu.util[,system]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running the kernel and its processes.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23012','0','','10078','CPU user time','system.cpu.util[,user]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The time the CPU has spent running users\' processes that are not niced.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23013','0','','10078','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23014','0','','10078','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23015','0','','10078','Free swap space','system.swap.size[,free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23016','0','','10078','Free swap space in %','system.swap.size[,pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23017','0','','10078','Total swap space','system.swap.size[,total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23018','0','','10078','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23019','0','','10078','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23020','0','','10078','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23021','0','','10078','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23022','0','','10078','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23023','0','','10078','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23024','0','','10078','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23025','0','','10078','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23026','0','','10078','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23027','0','','10078','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23028','0','','10078','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23029','0','','10078','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23030','0','','10078','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23031','0','','10078','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23032','0','','10078','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23035','0','','10079','Maximum number of opened files','kernel.maxfiles','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23036','0','','10079','Maximum number of processes','kernel.maxproc','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'It could be increased by using sysctrl utility or modifying file /etc/sysctl.conf.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23039','0','','10079','Host boot time','system.boottime','10m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23041','0','','10079','Processor load (15 min average per core)','system.cpu.load[percpu,avg15]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23042','0','','10079','Processor load (1 min average per core)','system.cpu.load[percpu,avg1]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23043','0','','10079','Processor load (5 min average per core)','system.cpu.load[percpu,avg5]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The processor load is calculated as system CPU load divided by number of CPU cores.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23053','0','','10079','Host name','system.hostname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'System host name.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23054','0','','10079','Host local time','system.localtime','1m','1w','365d','0','3','','unixtime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23058','0','','10079','System information','system.uname','1h','1w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The information as normally returned by \'uname -a\'.','5','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23059','0','','10079','System uptime','system.uptime','10m','1w','365d','0','3','','uptime','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23060','0','','10079','Number of logged in users','system.users.num','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'Number of users who are currently logged in.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23061','0','','10079','Checksum of /etc/passwd','vfs.file.cksum[/etc/passwd]','1h','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23062','0','','10079','Available memory','vm.memory.size[available]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'Available memory is defined as free+cached+buffers memory.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23063','0','','10079','Total memory','vm.memory.size[total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23067','0','','10079','Mounted filesystem discovery','vfs.fs.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of file systems of different types as defined in global regular expression "File systems for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23068','0','','10079','Free disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},free]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23069','0','','10079','Free inodes on {#FSNAME} (percentage)','vfs.fs.inode[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23070','0','','10079','Total disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},total]','1h','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23071','0','','10079','Used disk space on {#FSNAME}','vfs.fs.size[{#FSNAME},used]','1m','1w','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23072','0','','10079','Free disk space on {#FSNAME} (percentage)','vfs.fs.size[{#FSNAME},pfree]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23073','0','','10075','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23074','0','','10075','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23075','0','','10074','Incoming network traffic on {#IFNAME}','net.if.in[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23076','0','','10074','Outgoing network traffic on {#IFNAME}','net.if.out[{#IFNAME}]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23077','0','','10079','Incoming network traffic on en0','net.if.in[en0]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23078','0','','10079','Outgoing network traffic on en0','net.if.out[en0]','1m','1w','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23108','0','','10076','CPU available physical processors in the shared pool','system.stat[cpu,app]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23109','0','','10076','CPU entitled capacity consumed','system.stat[cpu,ec]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23110','0','','10076','CPU idle time','system.stat[cpu,id]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23111','0','','10076','CPU logical processor utilization','system.stat[cpu,lbusy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23112','0','','10076','CPU number of physical processors consumed','system.stat[cpu,pc]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23113','0','','10076','CPU system time','system.stat[cpu,sy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23114','0','','10076','CPU user time','system.stat[cpu,us]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23115','0','','10076','CPU iowait time','system.stat[cpu,wa]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23116','0','','10076','Amount of data transferred','system.stat[disk,bps]','1m','1w','365d','0','0','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23117','0','','10076','Number of transfers','system.stat[disk,tps]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23118','0','','10076','Processor units is entitled to receive','system.stat[ent]','1h','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23119','0','','10076','Kernel thread context switches','system.stat[faults,cs]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23120','0','','10076','Device interrupts','system.stat[faults,in]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23121','0','','10076','System calls','system.stat[faults,sy]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23122','0','','10076','Length of the swap queue','system.stat[kthr,b]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23123','0','','10076','Length of the run queue','system.stat[kthr,r]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23124','0','','10076','Active virtual pages','system.stat[memory,avm]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23125','0','','10076','Free real memory','system.stat[memory,fre]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23126','0','','10076','File page-ins per second','system.stat[page,fi]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23127','0','','10076','File page-outs per second','system.stat[page,fo]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23128','0','','10076','Pages freed (page replacement)','system.stat[page,fr]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23129','0','','10076','Pages paged in from paging space','system.stat[page,pi]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23130','0','','10076','Pages paged out to paging space','system.stat[page,po]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23131','0','','10076','Pages scanned by page-replacement algorithm','system.stat[page,sr]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23171','5','','10047','Utilization of snmp trapper data collector processes, in %','zabbix[process,snmp trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23251','5','','10047','Zabbix queue','zabbix[queue]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23318','0','','10050','Host name of Zabbix agent running','agent.hostname','1h','7d','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23329','0','','10074','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23340','5','','10048','Number of processed values per second','zabbix[wcache,values]','1m','1w','365d','0','0','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23341','5','','10048','Zabbix history index cache, % used','zabbix[wcache,index,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23342','5','','10048','Zabbix history write cache, % used','zabbix[wcache,history,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23343','5','','10048','Utilization of self-monitoring internal processes, in %','zabbix[process,self-monitoring,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23344','5','','10048','Utilization of snmp trapper data collector processes, in %','zabbix[process,snmp trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23345','5','','10048','Utilization of trapper data collector processes, in %','zabbix[process,trapper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23346','5','','10048','Utilization of unreachable poller data collector processes, in %','zabbix[process,unreachable poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23347','5','','10048','Utilization of configuration syncer internal processes, in %','zabbix[process,configuration syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23348','5','','10048','Utilization of poller data collector processes, in %','zabbix[process,poller,avg,busy]','1m','1w','365d','0','0','localhost','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23349','5','','10048','Utilization of java poller data collector processes, in %','zabbix[process,java poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23350','5','','10048','Utilization of history syncer internal processes, in %','zabbix[process,history syncer,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23351','5','','10048','Utilization of heartbeat sender internal processes, in %','zabbix[process,heartbeat sender,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23352','5','','10048','Utilization of discoverer data collector processes, in %','zabbix[process,discoverer,avg,busy]','1m','1w','365d','0','0','localhost','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23353','5','','10048','Utilization of housekeeper internal processes, in %','zabbix[process,housekeeper,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23354','5','','10048','Utilization of http poller data collector processes, in %','zabbix[process,http poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23355','5','','10048','Utilization of ipmi poller data collector processes, in %','zabbix[process,ipmi poller,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23356','5','','10048','Utilization of icmp pinger data collector processes, in %','zabbix[process,icmp pinger,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23357','5','','10048','Zabbix configuration cache, % used','zabbix[rcache,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23358','5','','10048','Zabbix queue','zabbix[queue]','1m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23359','5','','10048','Zabbix queue over 10 minutes','zabbix[queue,10m]','10m','1w','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23360','5','','10048','Utilization of data sender internal processes, in %','zabbix[process,data sender,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23540','0','','10075','Network interface discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of network interfaces as defined in global regular expression "Network interfaces for discovery".','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23634','5','','10047','Zabbix vmware cache, % used','zabbix[vmware,buffer,pused]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23644','3','','10093','FTP service is running','net.tcp.service[ftp]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23645','3','','10094','HTTP service is running','net.tcp.service[http]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23646','3','','10095','HTTPS service is running','net.tcp.service[https]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23647','3','','10096','IMAP service is running','net.tcp.service[imap]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23648','3','','10097','LDAP service is running','net.tcp.service[ldap]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23649','3','','10098','NNTP service is running','net.tcp.service[nntp]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23650','3','','10099','NTP service is running','net.udp.service[ntp]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23651','3','','10100','POP service is running','net.tcp.service[pop]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23652','3','','10101','SMTP service is running','net.tcp.service[smtp]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23653','3','','10102','SSH service is running','net.tcp.service[ssh]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23654','3','','10103','Telnet service is running','net.tcp.service[telnet]','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23661','5','','10047','Zabbix value cache operating mode','zabbix[vcache,cache,mode]','1m','1w','365d','0','3','','','','',NULL,'15','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('23663','5','','10047','Utilization of task manager internal processes, in %','zabbix[process,task manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('25366','5','','10047','Utilization of ipmi manager internal processes, in %','zabbix[process,ipmi manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('25368','5','','10048','Utilization of ipmi manager internal processes, in %','zabbix[process,ipmi manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('25369','5','','10048','Utilization of task manager internal processes, in %','zabbix[process,task manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','1','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('25370','5','','10047','Utilization of alert manager internal processes, in %','zabbix[process,alert manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('25665','5','','10047','Utilization of preprocessing manager internal processes, in %','zabbix[process,preprocessing manager,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('25666','5','','10047','Utilization of preprocessing worker internal processes, in %','zabbix[process,preprocessing worker,avg,busy]','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','0','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26925','12','','10171','Power','power','1m','1w','365d','0','3','','','','',NULL,NULL,'','power','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26926','12','','10171','Processor Vcc','processor_vcc','1m','1w','365d','0','0','','V','','',NULL,NULL,'','Processor Vcc','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26927','12','','10171','System Fan 3','system_fan_3','1m','1w','365d','0','0','','RPM','','',NULL,NULL,'','System Fan 3','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26928','12','','10171','BB Ambient Temp','bb_ambient_temp','1m','1w','365d','0','0','','C','','',NULL,NULL,'','BB Ambient Temp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26929','12','','10171','BB +5.0V','bb_5.0v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +5.0V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26930','12','','10171','BB +3.3V','bb_3.3v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26931','12','','10171','BB +3.3V STBY','bb_3.3v_stby','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V STBY','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26932','12','','10171','BB +1.8V SM','bb_1.8v_sm','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.8V SM','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26933','12','','10172','Front Panel Temp','front_panel_temp','1m','1w','365d','0','0','','C','','',NULL,NULL,'','Front Panel Temp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26934','12','','10172','Power','power','1m','1w','365d','0','3','','','','',NULL,NULL,'','power','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26935','12','','10172','System Fan 2','system_fan_2','1m','1w','365d','0','0','','RPM','','',NULL,NULL,'','System Fan 2','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26936','12','','10172','System Fan 3','system_fan_3','1m','1w','365d','0','0','','RPM','','',NULL,NULL,'','System Fan 3','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26937','12','','10172','BB +5.0V','bb_5.0v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +5.0V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26938','12','','10172','BB +3.3V STBY','bb_3.3v_stby','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V STBY','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26939','12','','10172','BB +1.05V PCH','bb_1.05v_pch','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.05V PCH','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26940','12','','10172','BB +1.1V P1 Vccp','bb_1.1v_p1_vccp','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.1V P1 Vccp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26941','12','','10172','BB +1.5V P1 DDR3','bb_1.5v_p1_ddr3','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +1.5V P1 DDR3','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26942','12','','10172','BB +3.3V','bb_3.3v','1m','1w','365d','0','0','','V','','',NULL,NULL,'','BB +3.3V','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('26943','12','','10172','Baseboard Temp','baseboard_temp','1m','1w','365d','0','0','','C','','',NULL,NULL,'','Baseboard Temp','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27031','20','discovery[{#SNMPVALUE},1.3.6.1.2.1.10.7.2.1.19,{#IFOPERSTATUS},1.3.6.1.2.1.2.2.1.8,{#IFALIAS},1.3.6.1.2.1.31.1.1.1.18,{#IFNAME},1.3.6.1.2.1.31.1.1.1.1,{#IFDESCR},1.3.6.1.2.1.2.2.1.2]','10183','EtherLike-MIB Discovery','net.if.duplex.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering interfaces from IF-MIB and EtherLike-MIB. Interfaces with up(1) Operational Status are discovered.','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27032','20','1.3.6.1.2.1.10.7.2.1.19.{#SNMPINDEX}','10183','Interface {#IFNAME}({#IFALIAS}): Duplex status','net.if.duplex[dot3StatsDuplexStatus.{#SNMPINDEX}]','1m','7d','365d','0','3','','','','',NULL,'19','','','0','','','','','2',NULL,'MIB: EtherLike-MIB\r\nThe current mode of operation of the MAC\r\nentity.  \'unknown\' indicates that the current\r\nduplex mode could not be determined.\r\n\r\nManagement control of the duplex mode is\r\naccomplished through the MAU MIB.  When\r\nan interface does not support autonegotiation,\r\nor when autonegotiation is not enabled, the\r\nduplex mode is controlled using\r\nifMauDefaultType.  When autonegotiation is\r\nsupported and enabled, duplex mode is controlled\r\nusing ifMauAutoNegAdvertisedBits.  In either\r\ncase, the currently operating duplex mode is\r\nreflected both in this object and in ifMauType.\r\n\r\nNote that this object provides redundant\r\ninformation with ifMauType.  Normally, redundant\r\nobjects are discouraged.  However, in this\r\ninstance, it allows a management application to\r\ndetermine the duplex status of an interface\r\nwithout having to know every possible value of\r\nifMauType.  This was felt to be sufficiently\r\nvaluable to justify the redundancy.\r\nReference: [IEEE 802.3 Std.], 30.3.1.1.32,aDuplexStatus.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27065','3','','10186','ICMP response time','icmppingsec','1m','1w','365d','0','0','','s','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27066','3','','10186','ICMP loss','icmppingloss','1m','1w','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27067','3','','10186','ICMP ping','icmpping','1m','1w','365d','0','3','','','','',NULL,'1','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27078','20','discovery[{#IFOPERSTATUS},1.3.6.1.2.1.2.2.1.8,{#IFADMINSTATUS},1.3.6.1.2.1.2.2.1.7,{#IFNAME},1.3.6.1.2.1.2.2.1.2,{#IFDESCR},1.3.6.1.2.1.2.2.1.2,{#IFTYPE},1.3.6.1.2.1.2.2.1.3]','10188','Network interfaces discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering interfaces from IF-MIB.','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27079','20','1.3.6.1.2.1.2.2.1.13.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Inbound packets discarded','net.if.in.discards[ifInDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe number of inbound packets which were chosen to be discarded\r\neven though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\r\nOne possible reason for discarding such a packet could be to free up buffer space.\r\nDiscontinuities in the value of this counter can occur at re-initialization of the management system,\r\nand at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27080','20','1.3.6.1.2.1.2.2.1.3.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Interface type','net.if.type[ifType.{#SNMPINDEX}]','1h','7d','0d','0','3','','','','',NULL,'21','','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe type of interface.\r\nAdditional values for ifType are assigned by the Internet Assigned NumbersAuthority (IANA),\r\nthrough updating the syntax of the IANAifType textual convention.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27081','20','1.3.6.1.2.1.2.2.1.5.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Speed','net.if.speed[ifSpeed.{#SNMPINDEX}]','5m','7d','0d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nAn estimate of the interface\'s current bandwidth in bits per second.\r\nFor interfaces which do not vary in bandwidth or for those where no accurate estimation can be made,\r\nthis object should contain the nominal bandwidth.\r\nIf the bandwidth of the interface is greater than the maximum value reportable by this object then\r\nthis object should report its maximum value (4,294,967,295) and ifHighSpeed must be used to report the interace\'s speed.\r\nFor a sub-layer which has no concept of bandwidth, this object should be zero.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27082','20','1.3.6.1.2.1.2.2.1.19.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Outbound packets discarded','net.if.out.discards[ifOutDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe number of outbound packets which were chosen to be discarded\r\neven though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\r\nOne possible reason for discarding such a packet could be to free up buffer space.\r\nDiscontinuities in the value of this counter can occur at re-initialization of the management system,\r\nand at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27083','20','1.3.6.1.2.1.2.2.1.20.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Outbound packets with errors','net.if.out.errors[ifOutErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nFor packet-oriented interfaces, the number of outbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of outbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27084','20','1.3.6.1.2.1.2.2.1.10.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Bits received','net.if.in[ifInOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe total number of octets received on the interface,including framing characters. Discontinuities in the value of this counter can occurat re-initialization of the management system, and atother times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27085','20','1.3.6.1.2.1.2.2.1.16.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Bits sent','net.if.out[ifOutOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe total number of octets transmitted out of the interface, including framing characters. Discontinuities in the value of this counter can occurat re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27086','20','1.3.6.1.2.1.2.2.1.14.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Inbound packets with errors','net.if.in.errors[ifInErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nFor packet-oriented interfaces, the number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of inbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27087','20','1.3.6.1.2.1.2.2.1.8.{#SNMPINDEX}','10188','Interface {#IFDESCR}: Operational status','net.if.status[ifOperStatus.{#SNMPINDEX}]','1m','7d','0','0','3','','','','',NULL,'20','','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe current operational state of the interface.\r\n- The testing(3) state indicates that no operational packet scan be passed\r\n- If ifAdminStatus is down(2) then ifOperStatus should be down(2)\r\n- If ifAdminStatus is changed to up(1) then ifOperStatus should change to up(1) if the interface is ready to transmit and receive network traffic\r\n- It should change todormant(5) if the interface is waiting for external actions (such as a serial line waiting for an incoming connection)\r\n- It should remain in the down(2) state if and only if there is a fault that prevents it from going to the up(1) state\r\n- It should remain in the notPresent(6) state if the interface has missing(typically, hardware) components.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27098','20','discovery[{#IFOPERSTATUS},1.3.6.1.2.1.2.2.1.8,{#IFADMINSTATUS},1.3.6.1.2.1.2.2.1.7,{#IFALIAS},1.3.6.1.2.1.31.1.1.1.18,{#IFNAME},1.3.6.1.2.1.31.1.1.1.1,{#IFDESCR},1.3.6.1.2.1.2.2.1.2,{#IFTYPE},1.3.6.1.2.1.2.2.1.3]','10190','Network interfaces discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering interfaces from IF-MIB.','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27099','20','1.3.6.1.2.1.2.2.1.13.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Inbound packets discarded','net.if.in.discards[ifInDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe number of inbound packets which were chosen to be discarded\r\neven though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\r\nOne possible reason for discarding such a packet could be to free up buffer space.\r\nDiscontinuities in the value of this counter can occur at re-initialization of the management system,\r\nand at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27100','20','1.3.6.1.2.1.2.2.1.3.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Interface type','net.if.type[ifType.{#SNMPINDEX}]','1h','7d','0d','0','3','','','','',NULL,'21','','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe type of interface.\r\nAdditional values for ifType are assigned by the Internet Assigned NumbersAuthority (IANA),\r\nthrough updating the syntax of the IANAifType textual convention.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27101','20','1.3.6.1.2.1.31.1.1.1.15.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Speed','net.if.speed[ifHighSpeed.{#SNMPINDEX}]','5m','7d','0d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nAn estimate of the interface\'s current bandwidth in units of 1,000,000 bits per second. If this object reports a value of `n\' then the speed of the interface is somewhere in the range of `n-500,000\' to`n+499,999\'.  For interfaces which do not vary in bandwidth or for those where no accurate estimation can be made, this object should contain the nominal bandwidth. For a sub-layer which has no concept of bandwidth, this object should be zero.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27102','20','1.3.6.1.2.1.2.2.1.19.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Outbound packets discarded','net.if.out.discards[ifOutDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe number of outbound packets which were chosen to be discarded\r\neven though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\r\nOne possible reason for discarding such a packet could be to free up buffer space.\r\nDiscontinuities in the value of this counter can occur at re-initialization of the management system,\r\nand at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27103','20','1.3.6.1.2.1.2.2.1.20.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Outbound packets with errors','net.if.out.errors[ifOutErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nFor packet-oriented interfaces, the number of outbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of outbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27104','20','1.3.6.1.2.1.31.1.1.1.6.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Bits received','net.if.in[ifHCInOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe total number of octets received on the interface, including framing characters. This object is a 64-bit version of ifInOctets. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27105','20','1.3.6.1.2.1.31.1.1.1.10.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Bits sent','net.if.out[ifHCOutOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe total number of octets transmitted out of the interface, including framing characters. This object is a 64-bit version of ifOutOctets.Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27106','20','1.3.6.1.2.1.2.2.1.14.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Inbound packets with errors','net.if.in.errors[ifInErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nFor packet-oriented interfaces, the number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of inbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27107','20','1.3.6.1.2.1.2.2.1.8.{#SNMPINDEX}','10190','Interface {#IFNAME}({#IFALIAS}): Operational status','net.if.status[ifOperStatus.{#SNMPINDEX}]','1m','7d','0','0','3','','','','',NULL,'20','','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe current operational state of the interface.\r\n- The testing(3) state indicates that no operational packet scan be passed\r\n- If ifAdminStatus is down(2) then ifOperStatus should be down(2)\r\n- If ifAdminStatus is changed to up(1) then ifOperStatus should change to up(1) if the interface is ready to transmit and receive network traffic\r\n- It should change todormant(5) if the interface is waiting for external actions (such as a serial line waiting for an incoming connection)\r\n- It should remain in the down(2) state if and only if there is a fault that prevents it from going to the up(1) state\r\n- It should remain in the notPresent(6) state if the interface has missing(typically, hardware) components.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27118','20','discovery[{#IFOPERSTATUS},1.3.6.1.2.1.2.2.1.8,{#IFADMINSTATUS},1.3.6.1.2.1.2.2.1.7,{#IFALIAS},1.3.6.1.2.1.31.1.1.1.18,{#IFNAME},1.3.6.1.2.1.31.1.1.1.1,{#IFDESCR},1.3.6.1.2.1.2.2.1.2,{#IFTYPE},1.3.6.1.2.1.2.2.1.3]','10192','Network interfaces discovery','net.if.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering interfaces from IF-MIB.','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27119','20','1.3.6.1.2.1.2.2.1.13.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Inbound packets discarded','net.if.in.discards[ifInDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe number of inbound packets which were chosen to be discarded\r\neven though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\r\nOne possible reason for discarding such a packet could be to free up buffer space.\r\nDiscontinuities in the value of this counter can occur at re-initialization of the management system,\r\nand at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27120','20','1.3.6.1.2.1.2.2.1.3.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Interface type','net.if.type[ifType.{#SNMPINDEX}]','1h','7d','0d','0','3','','','','',NULL,'21','','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe type of interface.\r\nAdditional values for ifType are assigned by the Internet Assigned NumbersAuthority (IANA),\r\nthrough updating the syntax of the IANAifType textual convention.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27121','20','1.3.6.1.2.1.31.1.1.1.15.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Speed','net.if.speed[ifHighSpeed.{#SNMPINDEX}]','5m','7d','0d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nAn estimate of the interface\'s current bandwidth in units of 1,000,000 bits per second. If this object reports a value of `n\' then the speed of the interface is somewhere in the range of `n-500,000\' to`n+499,999\'.  For interfaces which do not vary in bandwidth or for those where no accurate estimation can be made, this object should contain the nominal bandwidth. For a sub-layer which has no concept of bandwidth, this object should be zero.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27122','20','1.3.6.1.2.1.2.2.1.19.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Outbound packets discarded','net.if.out.discards[ifOutDiscards.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe number of outbound packets which were chosen to be discarded\r\neven though no errors had been detected to prevent their being deliverable to a higher-layer protocol.\r\nOne possible reason for discarding such a packet could be to free up buffer space.\r\nDiscontinuities in the value of this counter can occur at re-initialization of the management system,\r\nand at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27123','20','1.3.6.1.2.1.2.2.1.20.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Outbound packets with errors','net.if.out.errors[ifOutErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nFor packet-oriented interfaces, the number of outbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of outbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27124','20','1.3.6.1.2.1.2.2.1.10.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Bits received','net.if.in[ifInOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe total number of octets received on the interface,including framing characters. Discontinuities in the value of this counter can occur at re-initialization of the management system, and atother times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27125','20','1.3.6.1.2.1.2.2.1.16.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Bits sent','net.if.out[ifOutOctets.{#SNMPINDEX}]','3m','7d','365d','0','3','','bps','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe total number of octets transmitted out of the interface, including framing characters. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27126','20','1.3.6.1.2.1.2.2.1.14.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Inbound packets with errors','net.if.in.errors[ifInErrors.{#SNMPINDEX}]','3m','7d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: IF-MIB\r\nFor packet-oriented interfaces, the number of inbound packets that contained errors preventing them from being deliverable to a higher-layer protocol.  For character-oriented or fixed-length interfaces, the number of inbound transmission units that contained errors preventing them from being deliverable to a higher-layer protocol. Discontinuities in the value of this counter can occur at re-initialization of the management system, and at other times as indicated by the value of ifCounterDiscontinuityTime.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27127','20','1.3.6.1.2.1.2.2.1.8.{#SNMPINDEX}','10192','Interface {#IFNAME}({#IFALIAS}): Operational status','net.if.status[ifOperStatus.{#SNMPINDEX}]','1m','7d','0','0','3','','','','',NULL,'20','','','0','','','','','2',NULL,'MIB: IF-MIB\r\nThe current operational state of the interface.\r\n- The testing(3) state indicates that no operational packet scan be passed\r\n- If ifAdminStatus is down(2) then ifOperStatus should be down(2)\r\n- If ifAdminStatus is changed to up(1) then ifOperStatus should change to up(1) if the interface is ready to transmit and receive network traffic\r\n- It should change todormant(5) if the interface is waiting for external actions (such as a serial line waiting for an incoming connection)\r\n- It should remain in the down(2) state if and only if there is a fault that prevents it from going to the up(1) state\r\n- It should remain in the notPresent(6) state if the interface has missing(typically, hardware) components.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27152','20','1.3.6.1.2.1.1.5.0','10204','System name','system.name','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SNMPv2-MIB\r\nAn administratively-assigned name for this managed node.By convention, this is the node\'s fully-qualified domain name.  If the name is unknown, the value is the zero-length string.','3','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27154','5','','10204','SNMP agent availability','zabbix[host,snmp,available]','1m','7d','365d','0','3','','','','',NULL,'22','','','0','','','','','0',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27157','17','','10204','SNMP traps (fallback)','snmptrap.fallback','1m','2w','0','0','2','','','','hh:mm:sszyyyy/MM/dd',NULL,NULL,'','','0','','','','','0',NULL,'Item is used to collect all SNMP traps unmatched by other snmptrap items','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27203','20','1.3.6.1.2.1.1.1.0','10207','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SNMPv2-MIB','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27207','20','1.3.6.1.4.1.6527.3.1.2.1.1.9.0','10207','Used memory','vm.memory.used[sgiKbMemoryUsed.0]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: TIMETRA-SYSTEM-MIB\r\nThe value of sgiKbMemoryUsed indicates the total pre-allocated pool memory, in kilobytes, currently in use on the system.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27208','20','1.3.6.1.4.1.6527.3.1.2.1.1.1.0','10207','CPU utilization','system.cpu.util[sgiCpuUsage.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: TIMETRA-SYSTEM-MIB\r\nThe value of sgiCpuUsage indicates the current CPU utilization for the system.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27209','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6527.3.1.2.2.1.8.1.8,{#TEMP_SENSOR},1.3.6.1.4.1.6527.3.1.2.2.1.8.1.17]','10207','Temperature Discovery','temperature.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27210','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6527.3.1.2.2.1.4.1.2]','10207','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27211','20','discovery[{#ENT_NAME},1.3.6.1.4.1.6527.3.1.2.2.1.8.1.8,{#ENT_CLASS},1.3.6.1.4.1.6527.3.1.2.2.1.8.1.7,{#ENT_SN},1.3.6.1.4.1.6527.3.1.2.2.1.8.1.5]','10207','Entity Serial Numbers Discovery','entity_sn.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27212','20','1.3.6.1.4.1.6527.3.1.2.2.1.8.1.18.{#SNMPINDEX}','10207','{#SNMPVALUE}: Temperature','sensor.temp.value[tmnxHwTemperature.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: TIMETRA-SYSTEM-MIB\r\nThe current temperature reading in degrees celsius from this hardware component\'s temperature sensor.  If this component does not contain a temperature sensor, then the value -1 is returned.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27213','20','1.3.6.1.4.1.6527.3.1.2.2.1.4.1.2.{#SNMPINDEX}','10207','#{#SNMPINDEX}: Fan status','sensor.fan.status[tmnxChassisFanOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'23','','','0','','','','','2',NULL,'MIB: TIMETRA-SYSTEM-MIB\r\nCurrent status of the Fan tray.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27214','20','1.3.6.1.4.1.6527.3.1.2.2.1.8.1.5.{#SNMPINDEX}','10207','{#ENT_NAME}: Hardware serial number','system.hw.serialnumber[tmnxHwSerialNumber.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: TIMETRA-CHASSIS-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27236','20','1.3.6.1.4.1.1588.2.1.1.1.1.6.0','10208','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SW-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27237','20','1.3.6.1.4.1.1588.2.1.1.1.1.10.0','10208','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SW-MIB','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27238','20','1.3.6.1.4.1.1588.2.1.1.1.1.7.0','10208','Overall system health status','system.status[swOperStatus.0]','30s','2w','0d','0','3','','','','',NULL,'25','','','0','','','','','0',NULL,'MIB: SW-MIB\r\nThe current operational status of the switch.The states are as follow:\r\nonline(1) means the switch is accessible by an external Fibre Channel port\r\noffline(2) means the switch is not accessible\r\ntesting(3) means the switch is in a built-in test mode and is not accessible by an external Fibre Channel port\r\nfaulty(4) means the switch is not operational.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27240','20','1.3.6.1.4.1.1588.2.1.1.1.26.1.0','10208','CPU utilization','system.cpu.util[swCpuUsage.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SW-MIB\r\nSystem\'s CPU usage.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27242','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.1,{#SENSOR_TYPE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.2,{#SENSOR_INFO},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.5]','10208','Temperature Discovery','temperature.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27243','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.1,{#SENSOR_TYPE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.2,{#SENSOR_INFO},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.5]','10208','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27244','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.1,{#SENSOR_TYPE},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.2,{#SENSOR_INFO},1.3.6.1.4.1.1588.2.1.1.1.1.22.1.5]','10208','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27246','20','1.3.6.1.4.1.1588.2.1.1.1.1.22.1.3.{#SNMPINDEX}','10208','{#SENSOR_INFO}: Temperature status','sensor.temp.status[swSensorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'24','','','0','','','','','2',NULL,'MIB: SW-MIB\r\nTemperature status of testpoint: {#SENSOR_INFO}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27247','20','1.3.6.1.4.1.1588.2.1.1.1.1.22.1.4.{#SNMPINDEX}','10208','{#SENSOR_INFO}: Temperature','sensor.temp.value[swSensorValue.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: SW-MIB\r\nTemperature readings of testpoint: {#SENSOR_INFO}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27248','20','1.3.6.1.4.1.1588.2.1.1.1.1.22.1.3.{#SNMPINDEX}','10208','{#SENSOR_INFO}: Power supply status','sensor.psu.status[swSensorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'24','','','0','','','','','2',NULL,'MIB: SW-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27249','20','1.3.6.1.4.1.1588.2.1.1.1.1.22.1.4.{#SNMPINDEX}','10208','{#SENSOR_INFO}: Fan speed','sensor.fan.speed[swSensorValue.{#SNMPINDEX}]','1m','90d','365d','0','3','','rpm','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: SW-MIB\r\nThe current value (reading) of the sensor.\r\nThe value, -2147483648, represents an unknown quantity.\r\nThe fan value will be in RPM(revolution per minute)','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27250','20','1.3.6.1.4.1.1588.2.1.1.1.1.22.1.3.{#SNMPINDEX}','10208','{#SENSOR_INFO}: Fan status','sensor.fan.status[swSensorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'24','','','0','','','','','2',NULL,'MIB: SW-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27294','20','1.3.6.1.4.1.1991.1.1.2.1.52.0','10209','CPU utilization','system.cpu.util[snAgGblCpuUtil1MinAvg.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FOUNDRY-SN-AGENT-MIB\r\nThe statistics collection of 1 minute CPU utilization.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27295','20','1.3.6.1.4.1.1991.1.1.2.1.11.0','10210','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FOUNDRY-SN-AGENT-MIB\r\nThe version of the running software in the form\'major.minor.maintenance[letters]\'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27296','20','1.3.6.1.4.1.1991.1.1.1.1.2.0','10210','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FOUNDRY-SN-AGENT-MIB','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27297','20','1.3.6.1.4.1.1991.1.1.2.1.11.0','10211','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: FOUNDRY-SN-AGENT-MIB\r\nThe version of the running software in the form \'major.minor.maintenance[letters]\'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27302','20','discovery[{#PSU_INDEX},1.3.6.1.4.1.1991.1.1.1.2.1.1.1]','10210','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snChasPwrSupplyTable: A table of each power supply information. Only installed power supply appears in a table row.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27303','20','discovery[{#FAN_INDEX},1.3.6.1.4.1.1991.1.1.1.3.1.1.1]','10210','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snChasFanTable: A table of each fan information. Only installed fan appears in a table row.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27304','20','discovery[{#SENSOR_DESCR},1.3.6.1.4.1.1991.1.1.2.13.1.1.3]','10210','Temperature Discovery','temp.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snAgentTempTable:Table to list temperatures of the modules in the device. This table is applicable to only those modules with temperature sensors.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27306','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1991.1.1.1.1.18]','10210','Temperature Discovery Chassis','temp.chassis.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Since temperature of the chassis is not available on all Brocade/Foundry hardware, this LLD is here to avoid unsupported items.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27307','20','discovery[{#PSU_UNIT},1.3.6.1.4.1.1991.1.1.1.2.2.1.1,{#PSU_INDEX},1.3.6.1.4.1.1991.1.1.1.2.2.1.2]','10211','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snChasPwrSupply2Table: A table of each power supply information for each unit. Only installed power supply appears in a table row.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27308','20','discovery[{#FAN_UNIT},1.3.6.1.4.1.1991.1.1.1.3.2.1.1,{#FAN_INDEX},1.3.6.1.4.1.1991.1.1.1.3.2.1.2]','10211','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snChasFan2Table: A table of each fan information for each unit. Only installed fan appears in a table row.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27309','20','discovery[{#SENSOR_DESCR},1.3.6.1.4.1.1991.1.1.2.13.3.1.4]','10211','Temperature Discovery','temp.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snAgentTemp2Table:Table to list temperatures of the modules in the device for each unit. This table is applicable to only those modules with temperature sensors.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27310','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1991.1.1.3.31.2.1.1.5]','10211','Stack Discovery','stack.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering snStackingConfigUnitTable for Model names','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27311','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1991.1.1.1.4.1.1.1]','10211','Chassis Discovery','chassis.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'snChasUnitIndex: The index to chassis table.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27312','20','1.3.6.1.4.1.1991.1.1.1.2.1.1.3.{#SNMPINDEX}','10210','PSU {#PSU_INDEX}: Power supply status','sensor.psu.status[snChasPwrSupplyOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'26','','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27313','20','1.3.6.1.4.1.1991.1.1.1.3.1.1.3.{#SNMPINDEX}','10210','Fan {#FAN_INDEX}: Fan status','sensor.fan.status[snChasFanOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'27','','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27314','20','1.3.6.1.4.1.1991.1.1.2.13.1.1.4.{#SNMPINDEX}','10210','{#SENSOR_DESCR}: Temperature','sensor.temp.value[snAgentTempValue.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB\r\nTemperature of the sensor represented by this row. Each unit is 0.5 degrees Celsius.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27315','20','1.3.6.1.4.1.1991.1.1.1.1.18.{#SNMPINDEX}','10210','Chassis #{#SNMPINDEX}: Temperature','sensor.temp.value[snChasActualTemperature.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB\r\nTemperature of the chassis. Each unit is 0.5 degrees Celcius.\r\nOnly management module built with temperature sensor hardware is applicable.\r\nFor those non-applicable management module, it returns no-such-name.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27316','20','1.3.6.1.4.1.1991.1.1.1.2.2.1.4.{#SNMPINDEX}','10211','Unit {#PSU_UNIT} PSU {#PSU_INDEX}: Power supply status','sensor.psu.status[snChasPwrSupply2OperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'26','','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27317','20','1.3.6.1.4.1.1991.1.1.1.3.2.1.4.{#SNMPINDEX}','10211','Unit {#FAN_UNIT} Fan {#FAN_INDEX}: Fan status','sensor.fan.status[snChasFan2OperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'27','','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27318','20','1.3.6.1.4.1.1991.1.1.2.13.3.1.5.{#SNMPINDEX}','10211','{#SENSOR_DESCR}: Temperature','sensor.temp.value[snAgentTemp2Value.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB\r\nTemperature of the sensor represented by this row. Each unit is 0.5 degrees Celsius.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27319','20','1.3.6.1.4.1.1991.1.1.3.31.2.1.1.5.{#SNMPINDEX}','10211','Unit {#SNMPINDEX}: Hardware model name','system.hw.model[snStackingConfigUnitType.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-STACKING-MIB\r\nA description of the configured/active system type for each unit.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27320','20','1.3.6.1.4.1.1991.1.1.1.4.1.1.2.{#SNMPINDEX}','10211','Unit {#SNMPVALUE}: Hardware serial number','system.hw.serialnumber[snChasUnitSerNum.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: FOUNDRY-SN-AGENT-MIB\r\nThe serial number of the chassis for each unit. If the serial number is unknown or unavailable then the value should be a zero length string.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27376','20','1.3.6.1.4.1.9.2.1.58','10215','CPU utilization','system.cpu.util[avgBusy5]','5m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: OLD-CISCO-CPU-MIB\r\n5 minute exponentially-decayed moving average of the CPU busy percentage.\r\nReference: http://www.cisco.com/c/en/us/support/docs/ip/simple-network-management-protocol-snmp/15215-collect-cpu-util-snmp.html','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27378','20','1.3.6.1.2.1.47.1.1.1.1.11.1','10216','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27379','20','1.3.6.1.2.1.47.1.1.1.1.13.1','10216','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27390','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.9.9.48.1.1.1.2]','10212','Memory Discovery','memory.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of ciscoMemoryPoolTable, a table of memory pool monitoring entries.\r\nhttp://www.cisco.com/c/en/us/support/docs/ip/simple-network-management-protocol-snmp/15216-contiguous-memory.html','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27391','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.9.9.109.1.1.1.1.5]','10213','CPU Discovery','cpu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'If your IOS device has several CPUs, you must use CISCO-PROCESS-MIB and its object cpmCPUTotal5minRev from the table called cpmCPUTotalTable ,\r\nindexed with cpmCPUTotalIndex .\r\nThis table allows CISCO-PROCESS-MIB to keep CPU statistics for different physical entities in the router,\r\nlike different CPU chips, group of CPUs, or CPUs in different modules/cards.\r\nIn case of a single CPU, cpmCPUTotalTable has only one entry.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27393','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7,{#ENT_SN},1.3.6.1.2.1.47.1.1.1.1.11]','10216','Entity Serial Numbers Discovery','entity_sn.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','1','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27394','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.9.9.13.1.3.1.2]','10217','Temperature Discovery','temperature.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovery of ciscoEnvMonTemperatureTable (ciscoEnvMonTemperatureDescr), a table of ambient temperature status\r\nmaintained by the environmental monitor.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27395','20','discovery[{#SENSOR_INFO},1.3.6.1.4.1.9.9.13.1.5.1.2]','10217','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'The table of power supply status maintained by the environmental monitor card.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27396','20','discovery[{#SENSOR_INFO},1.3.6.1.4.1.9.9.13.1.4.1.2]','10217','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'The table of fan status maintained by the environmental monitor.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27415','20','1.3.6.1.4.1.9.9.48.1.1.1.6.{#SNMPINDEX}','10212','{#SNMPVALUE}: Free memory','vm.memory.free[ciscoMemoryPoolFree.{#SNMPINDEX}]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: CISCO-MEMORY-POOL-MIB\r\nIndicates the number of bytes from the memory pool that are currently unused on the managed device. Note that the sum of ciscoMemoryPoolUsed and ciscoMemoryPoolFree is the total amount of memory in the pool\r\nReference: http://www.cisco.com/c/en/us/support/docs/ip/simple-network-management-protocol-snmp/15216-contiguous-memory.html','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27416','20','1.3.6.1.4.1.9.9.48.1.1.1.5.{#SNMPINDEX}','10212','{#SNMPVALUE}: Used memory','vm.memory.used[ciscoMemoryPoolUsed.{#SNMPINDEX}]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: CISCO-MEMORY-POOL-MIB\r\nIndicates the number of bytes from the memory pool that are currently in use by applications on the managed device.\r\nReference: http://www.cisco.com/c/en/us/support/docs/ip/simple-network-management-protocol-snmp/15216-contiguous-memory.html','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27417','20','1.3.6.1.4.1.9.9.109.1.1.1.1.8.{#SNMPINDEX}','10213','#{#SNMPINDEX}: CPU utilization','system.cpu.util[cpmCPUTotal5minRev.{#SNMPINDEX}]','5m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: CISCO-PROCESS-MIB\r\nThe cpmCPUTotal5minRev MIB object provides a more accurate view of the performance of the router over time than the MIB objects cpmCPUTotal1minRev and cpmCPUTotal5secRev . These MIB objects are not accurate because they look at CPU at one minute and five second intervals, respectively. These MIBs enable you to monitor the trends and plan the capacity of your network. The recommended baseline rising threshold for cpmCPUTotal5minRev is 90 percent. Depending on the platform, some routers that run at 90 percent, for example, 2500s, can exhibit performance degradation versus a high-end router, for example, the 7500 series, which can operate fine.\r\nReference: http://www.cisco.com/c/en/us/support/docs/ip/simple-network-management-protocol-snmp/15215-collect-cpu-util-snmp.html','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27419','20','1.3.6.1.2.1.47.1.1.1.1.11.{#SNMPINDEX}','10216','{#ENT_NAME}: Hardware serial number','system.hw.serialnumber[entPhysicalSerialNum.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27420','20','1.3.6.1.4.1.9.9.13.1.3.1.6.{#SNMPINDEX}','10217','{#SNMPVALUE}: Temperature status','sensor.temp.status[ciscoEnvMonTemperatureState.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'28','','','0','','','','','2',NULL,'MIB: CISCO-ENVMON-MIB\r\nThe current state of the test point being instrumented.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27421','20','1.3.6.1.4.1.9.9.13.1.3.1.3.{#SNMPINDEX}','10217','{#SNMPVALUE}: Temperature','sensor.temp.value[ciscoEnvMonTemperatureValue.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: CISCO-ENVMON-MIB\r\nThe current measurement of the test point being instrumented.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27422','20','1.3.6.1.4.1.9.9.13.1.5.1.3.{#SNMPINDEX}','10217','{#SENSOR_INFO}: Power supply status','sensor.psu.status[ciscoEnvMonSupplyState.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'28','','','0','','','','','2',NULL,'MIB: CISCO-ENVMON-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27423','20','1.3.6.1.4.1.9.9.13.1.4.1.3.{#SNMPINDEX}','10217','{#SENSOR_INFO}: Fan status','sensor.fan.status[ciscoEnvMonFanState.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'28','','','0','','','','','2',NULL,'MIB: CISCO-ENVMON-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27473','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6027.3.10.1.2.9.1.1]','10221','CPU and Memory and Flash Discovery','module.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27474','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6027.3.10.1.2.3.1.1]','10221','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'A list of power supply residents in the S-series chassis.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27475','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6027.3.10.1.2.4.1.1]','10221','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27476','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.6027.3.10.1.2.2.1.2]','10221','Stack Unit Discovery','stack.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27478','20','1.3.6.1.4.1.6027.3.10.1.2.9.1.3.{#SNMPINDEX}','10221','#{#SNMPINDEX}: CPU utilization','system.cpu.util[chStackUnitCpuUtil1Min.{#SNMPINDEX}]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB\r\nCPU utilization in percentage for last 1 minute.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27479','20','1.3.6.1.4.1.6027.3.10.1.2.3.1.2.{#SNMPINDEX}','10221','PSU {#SNMPVALUE}: Power supply status','sensor.psu.status[chSysPowerSupplyOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'31','','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB\r\nThe status of the power supply {#SNMPVALUE}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27480','20','1.3.6.1.4.1.6027.3.10.1.2.4.1.2.{#SNMPINDEX}','10221','Fan {#SNMPVALUE}: Fan status','sensor.fan.status[chSysFanTrayOperStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'30','','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB\r\nThe status of the fan tray {#SNMPVALUE}.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27481','20','1.3.6.1.4.1.6027.3.10.1.2.2.1.10.{#SNMPINDEX}','10221','#{#SNMPVALUE}: Operating system','system.sw.os[chStackUnitCodeVersion.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB\r\nCurrent code version of this unit.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27482','20','1.3.6.1.4.1.6027.3.10.1.2.2.1.21.{#SNMPINDEX}','10221','#{#SNMPVALUE}: Hardware version(revision)','system.hw.version[chStackUnitProductRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB\r\nThe unit manufacturer\'s product revision','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27483','20','1.3.6.1.4.1.6027.3.10.1.2.2.1.12.{#SNMPINDEX}','10221','#{#SNMPVALUE}: Hardware serial number','system.hw.serialnumber[chStackUnitSerialNumber.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB\r\nThe unit\'s serial number.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27484','20','1.3.6.1.4.1.6027.3.10.1.2.2.1.7.{#SNMPINDEX}','10221','#{#SNMPVALUE}: Hardware model name','system.hw.model[chStackUnitModelID.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB\r\nThe plugged-in model ID for this unit.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27485','20','1.3.6.1.4.1.6027.3.10.1.2.2.1.14.{#SNMPINDEX}','10221','Device {#SNMPVALUE}: Temperature','sensor.temp.value[chStackUnitTemp.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: F10-S-SERIES-CHASSIS-MIB\r\nThe temperature of the unit.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27508','20','1.3.6.1.2.1.47.1.1.1.1.8.1','10222','Hardware version(revision)','system.hw.version','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27509','20','1.3.6.1.2.1.47.1.1.1.1.9.1','10222','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27510','20','1.3.6.1.2.1.1.1.0','10222','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SNMPv2-MIB\r\nA textual description of the entity. This value should\r\ninclude the full name and version identification of the system\'s hardware type, software operating-system, and\r\nnetworking software.','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27511','20','1.3.6.1.4.1.171.10.97.2.36.1.1.3.0','10222','CPU utilization','system.cpu.util[myCPUUtilization5Min.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: MY-PROCESS-MIB\r\nCPU utilization in %','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27512','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.10.97.2.35.1.1.1.2]','10222','Memory Discovery','memory.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27513','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.10.97.2.1.1.23.1.2]','10222','Temperature Discovery','temperature.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27514','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.10.97.2.1.1.18.1.3]','10222','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27515','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.10.97.2.1.1.21.1.3]','10222','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27517','20','1.3.6.1.4.1.171.10.97.2.1.1.23.1.3.{#SNMPINDEX}','10222','{#SNMPVALUE}: Temperature','sensor.temp.value[mySystemTemperatureCurrent.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: MY-SYSTEM-MIB\r\nReturn the current temperature of the FastSwitch.The temperature display is not supported for the current temperature returns to 0.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27518','20','1.3.6.1.4.1.171.10.97.2.1.1.18.1.2.{#SNMPINDEX}','10222','{#SNMPVALUE}: Power supply status','sensor.psu.status[mySystemElectricalSourceIsNormal.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'32','','','0','','','','','2',NULL,'MIB: MY-SYSTEM-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27519','20','1.3.6.1.4.1.171.10.97.2.1.1.21.1.2.{#SNMPINDEX}','10222','{#SNMPVALUE}: Fan status','sensor.fan.status[mySystemFanIsNormal.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'32','','','0','','','','','2',NULL,'MIB: MY-SYSTEM-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27543','20','1.3.6.1.2.1.47.1.1.1.1.8.1','10223','Hardware version(revision)','system.hw.version','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27544','20','1.3.6.1.2.1.47.1.1.1.1.9.1','10223','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27545','20','1.3.6.1.4.1.171.12.1.1.12.0','10223','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: DLINK-AGENT-MIB\r\nA text string containing the serial number of this device.','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27546','20','1.3.6.1.2.1.1.1.0','10223','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: SNMPv2-MIB\r\nA textual description of the entity.  This value should\r\ninclude the full name and version identification of the system\'s hardware type, software operating-system, and\r\nnetworking software.','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27547','20','1.3.6.1.4.1.171.12.1.1.6.2.0','10223','CPU utilization','system.cpu.util[agentCPUutilizationIn1min.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: DLINK-AGENT-MIB\r\nThe unit of time is 1 minute. The value will be between 0% (idle) and 100%(very busy).','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27548','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.12.1.1.9.1.1]','10223','Memory Discovery','memory.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27549','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.12.11.1.8.1.1]','10223','Temperature Discovery','temperature.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27550','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.12.11.1.6.1.2,{#STATUS},1.3.6.1.4.1.171.12.11.1.6.1.3]','10223','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'swPowerID of EQUIPMENT-MIB::swPowerTable','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27551','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.171.12.11.1.7.1.2,{#STATUS},1.3.6.1.4.1.171.12.11.1.7.1.3]','10223','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'swFanID of EQUIPMENT-MIB::swFanTable','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27553','20','1.3.6.1.4.1.171.12.11.1.8.1.2.{#SNMPINDEX}','10223','#{#SNMPVALUE}: Temperature','sensor.temp.value[swTemperatureCurrent.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: EQUIPMENT-MIB\r\nThe shelf current temperature.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27554','20','1.3.6.1.4.1.171.12.11.1.6.1.3.{#SNMPINDEX}','10223','#{#SNMPVALUE}: Power supply status','sensor.psu.status[swPowerStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'34','','','0','','','','','2',NULL,'MIB: EQUIPMENT-MIB\r\nIndicates the current power status.\r\nlowVoltage : The voltage of the power unit is too low.\r\noverCurrent: The current of the power unit is too high.\r\nworking    : The power unit is working normally.\r\nfail       : The power unit has failed.\r\nconnect    : The power unit is connected but not powered on.\r\ndisconnect : The power unit is not connected.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27555','20','1.3.6.1.4.1.171.12.11.1.7.1.3.{#SNMPINDEX}','10223','#{#SNMPVALUE}: Fan status','sensor.fan.status[swFanStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'33','','','0','','','','','2',NULL,'MIB: EQUIPMENT-MIB\r\nIndicates the current fan status.\r\nspeed-0     : If the fan function is normal and the fan does not spin            due to the temperature not  reaching the threshold, the status of the fan is speed 0.\r\nspeed-low   : Fan spin using the lowest speed.\r\nspeed-middle: Fan spin using the middle speed.\r\nspeed-high  : Fan spin using the highest speed.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27579','20','1.3.6.1.2.1.47.1.1.1.1.9.1','10224','Firmware version','system.hw.firmware','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27580','20','1.3.6.1.2.1.47.1.1.1.1.9.1','10224','Hardware version(revision)','system.hw.version','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27582','20','1.3.6.1.2.1.47.1.1.1.1.11.1','10224','Hardware serial number','system.hw.serialnumber','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','8','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27583','20','1.3.6.1.2.1.47.1.1.1.1.2.1','10224','Hardware model name','system.hw.model','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: ENTITY-MIB','29','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27584','20','1.3.6.1.4.1.1916.1.1.1.8.0','10224','Device: Temperature','sensor.temp.value[extremeCurrentTemperature.0]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: EXTREME-SYSTEM-MIB\r\nTemperature readings of testpoint: Device\r\nReference: https://gtacknowledge.extremenetworks.com/articles/Q_A/Does-EXOS-support-temperature-polling-via-SNMP-on-all-nodes-in-a-stack','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27585','20','1.3.6.1.4.1.1916.1.1.1.7.0','10224','Device: Temperature status','sensor.temp.status[extremeOverTemperatureAlarm.0]','3m','2w','0d','0','3','','','','',NULL,'37','','','0','','','','','0',NULL,'MIB: EXTREME-SYSTEM-MIB\r\nTemperature status of testpoint: Device','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27586','20','1.3.6.1.4.1.1916.1.32.1.2.0','10224','CPU utilization','system.cpu.util[extremeCpuMonitorTotalUtilization.0]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'MIB: EXTREME-SOFTWARE-MONITOR-MIB\r\nTotal CPU utlization (percentage) as of last sampling.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27587','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1916.1.32.2.2.1.1]','10224','Memory Discovery','memory.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27588','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1916.1.1.1.27.1.1]','10224','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Table of status of all power supplies in the system.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27589','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.1916.1.1.1.9.1.1]','10224','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27591','20','1.3.6.1.4.1.1916.1.32.2.2.1.2.{#SNMPINDEX}','10224','#{#SNMPVALUE}: Total memory','vm.memory.total[extremeMemoryMonitorSystemTotal.{#SNMPINDEX}]','1m','7d','365d','0','3','','B','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: EXTREME-SOFTWARE-MONITOR-MIB\r\nTotal amount of DRAM in Kbytes in the system.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27593','20','1.3.6.1.4.1.1916.1.1.1.27.1.2.{#SNMPINDEX}','10224','PSU {#SNMPVALUE}: Power supply status','sensor.psu.status[extremePowerSupplyStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'38','','','0','','','','','2',NULL,'MIB: EXTREME-SYSTEM-MIB\r\nStatus of the power supply {#SNMPVALUE}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27594','20','1.3.6.1.4.1.1916.1.1.1.9.1.4.{#SNMPINDEX}','10224','Fan {#SNMPVALUE}: Fan speed','sensor.fan.speed[extremeFanSpeed.{#SNMPINDEX}]','1m','90d','365d','0','3','','rpm','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: EXTREME-SYSTEM-MIB\r\nThe speed (RPM) of a cooling fan in the fantray {#SNMPVALUE}','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27595','20','1.3.6.1.4.1.1916.1.1.1.9.1.2.{#SNMPINDEX}','10224','Fan {#SNMPVALUE}: Fan status','sensor.fan.status[extremeFanOperational.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'36','','','0','','','','','2',NULL,'MIB: EXTREME-SYSTEM-MIB\r\nOperational status of a cooling fan.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27665','20','discovery[{#SNMPVALUE},1.3.6.1.2.1.47.1.1.1.1.2,{#MODULE_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10227','Module Discovery','module.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Filter limits results to \'Module level1\' or Fabric Modules','0','30d','2','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27666','20','discovery[{#SNMPVALUE},1.3.6.1.2.1.47.1.1.1.1.2,{#MODULE_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10227','Temperature Discovery','temp.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering modules temperature (same filter as in Module Discovery) plus and temperature sensors','0','30d','2','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27667','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7,{#ENT_DESCR},1.3.6.1.2.1.47.1.1.1.1.2]','10227','FAN Discovery','fan.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering all entities of PhysicalClass - 7: fan(7)','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27668','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7,{#ENT_DESCR},1.3.6.1.2.1.47.1.1.1.1.2]','10227','PSU Discovery','psu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'Discovering all entities of PhysicalClass - 6: powerSupply(6)','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27669','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10227','Entity Discovery','entity.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27671','20','1.3.6.1.4.1.25506.2.6.1.1.1.1.6.{#SNMPINDEX}','10227','{#MODULE_NAME}: CPU utilization','system.cpu.util[hh3cEntityExtCpuUsage.{#SNMPINDEX}]','1m','7d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: HH3C-ENTITY-EXT-MIB\r\nThe CPU usage for this entity. Generally, the CPU usage\r\nwill calculate the overall CPU usage on the entity, and it\r\nis not sensible with the number of CPU on the entity','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27672','20','1.3.6.1.4.1.25506.2.6.1.1.1.1.12.{#SNMPINDEX}','10227','{#SNMPVALUE}: Temperature','sensor.temp.value[hh3cEntityExtTemperature.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: HH3C-ENTITY-EXT-MIB\r\nThe temperature for the {#SNMPVALUE}.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27673','20','1.3.6.1.4.1.25506.2.6.1.1.1.1.19.{#SNMPINDEX}','10227','{#ENT_NAME}: Fan status','sensor.fan.status[hh3cEntityExtErrorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'39','','','0','','','','','2',NULL,'MIB: HH3C-ENTITY-EXT-MIB\r\nIndicate the error state of this entity object.\r\nfanError(41) means that the fan stops working.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27674','20','1.3.6.1.4.1.25506.2.6.1.1.1.1.19.{#SNMPINDEX}','10227','{#ENT_NAME}: Power supply status','sensor.psu.status[hh3cEntityExtErrorStatus.{#SNMPINDEX}]','3m','2w','0d','0','3','','','','',NULL,'39','','','0','','','','','2',NULL,'MIB: HH3C-ENTITY-EXT-MIB\r\nIndicate the error state of this entity object.\r\npsuError(51) means that the Power Supply Unit is in the state of fault.\r\nrpsError(61) means the Redundant Power Supply is in the state of fault.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27675','20','1.3.6.1.2.1.47.1.1.1.1.10.{#SNMPINDEX}','10227','{#ENT_NAME}: Operating system','system.sw.os[entPhysicalSoftwareRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27676','20','1.3.6.1.2.1.47.1.1.1.1.8.{#SNMPINDEX}','10227','{#ENT_NAME}: Hardware version(revision)','system.hw.version[entPhysicalHardwareRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27677','20','1.3.6.1.2.1.47.1.1.1.1.9.{#SNMPINDEX}','10227','{#ENT_NAME}: Firmware version','system.hw.firmware[entPhysicalFirmwareRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27678','20','1.3.6.1.2.1.47.1.1.1.1.11.{#SNMPINDEX}','10227','{#ENT_NAME}: Hardware serial number','system.hw.serialnumber[entPhysicalSerialNum.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27679','20','1.3.6.1.2.1.47.1.1.1.1.2.{#SNMPINDEX}','10227','{#ENT_NAME}: Hardware model name','system.hw.model[entPhysicalDescr.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27745','20','discovery[{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10229','MPU Discovery','mpu.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'http://support.huawei.com/enterprise/KnowledgebaseReadAction.action?contentId=KB1000090234. Filter limits results to Main Processing Units','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27746','20','discovery[{#ENT_CLASS},1.3.6.1.2.1.47.1.1.1.1.5,{#ENT_NAME},1.3.6.1.2.1.47.1.1.1.1.7]','10229','Entity Discovery','entity.discovery','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27747','20','discovery[{#SNMPVALUE},1.3.6.1.4.1.2011.5.25.31.1.1.10.1.1]','10229','FAN Discovery','discovery.fans','1h','90d','0','0','4','','','','',NULL,NULL,'','','0','','','','','1',NULL,'','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27748','20','1.3.6.1.2.1.47.1.1.1.1.8.{#SNMPINDEX}','10229','{#ENT_NAME}: Hardware version(revision)','system.hw.version[entPhysicalHardwareRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27749','20','1.3.6.1.2.1.47.1.1.1.1.10.{#SNMPINDEX}','10229','{#ENT_NAME}: Operating system','system.sw.os[entPhysicalSoftwareRev.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27750','20','1.3.6.1.2.1.47.1.1.1.1.11.{#SNMPINDEX}','10229','{#ENT_NAME}: Hardware serial number','system.hw.serialnumber[entPhysicalSerialNum.{#SNMPINDEX}]','1h','2w','0','0','1','','','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: ENTITY-MIB','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27751','20','1.3.6.1.4.1.2011.5.25.31.1.1.1.1.11.{#SNMPINDEX}','10229','{#ENT_NAME}: Temperature','sensor.temp.value[hwEntityTemperature.{#SNMPINDEX}]','3m','90d','365d','0','0','','°C','','',NULL,NULL,'','','0','','','','','2',NULL,'MIB: HUAWEI-ENTITY-EXTENT-MIB\r\nThe temperature for the {#SNMPVALUE}.','0','30d','0','',NULL,'3s','','','','200','1','0','','0','0','0','0','0','0','0');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`) values ('27753','20','1.3.6.1.4.1.2011.5.25.31.1.1.1.1.5.{#SNMPINDEX}','10229','{#ENT_NAME}: CPU utilization','system.cpu.util[hwEntityCpuUsage.{#SNMPINDEX}]','1m','7d','365d'