/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.Collection;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.gui.MutableListModel;

public class KillRing
implements MutableListModel<String> {
    private String[] ring;
    private int count;
    private boolean wrap;
    private static KillRing killRing = new KillRing();

    public static KillRing getInstance() {
        return killRing;
    }

    public static void setInstance(KillRing killRing) {
        KillRing.killRing = killRing;
    }

    public void propertiesChanged(int n) {
        int n2 = Math.max(1, n);
        if (this.ring == null) {
            this.ring = new String[n2];
        } else if (n2 != this.ring.length) {
            String[] stringArray = new String[n2];
            int n3 = Math.min(this.getSize(), n2);
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = this.getElementAt(i);
            }
            this.ring = stringArray;
            this.count = n3;
            this.wrap = false;
        }
        if (this.count == this.ring.length) {
            this.count = 0;
            this.wrap = true;
        }
    }

    public void load() {
    }

    public void save() {
    }

    protected void reset(Collection<String> collection) {
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (String string : collection) {
            stringArray[n++] = string;
        }
        this.ring = stringArray;
        this.count = 0;
        this.wrap = true;
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
    }

    @Override
    public String getElementAt(int n) {
        return this.ring[this.virtualToPhysicalIndex(n)];
    }

    @Override
    public int getSize() {
        if (this.wrap) {
            return this.ring.length;
        }
        return this.count;
    }

    @Override
    public boolean removeElement(Object object) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.ring[i].equals(object)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public void insertElementAt(String string, int n) {
        this.remove(n);
        this.add(string);
    }

    void changed(String string, String string2) {
        int n = this.indexOf(string);
        if (n != -1) {
            this.ring[n] = string2;
        } else {
            this.add(string2);
        }
    }

    void add(String string) {
        if (this.indexOf(string) != -1) {
            return;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        this.ring[this.count] = string;
        if (++this.count >= this.ring.length) {
            this.wrap = true;
            this.count = 0;
        }
    }

    void remove(int n) {
        if (this.wrap) {
            String[] stringArray = new String[this.ring.length];
            int n2 = 0;
            for (int i = 0; i < this.ring.length; ++i) {
                int n3 = this.virtualToPhysicalIndex(i);
                if (n == n3) continue;
                stringArray[n2++] = this.ring[n3];
            }
            this.ring = stringArray;
            this.count = n2;
            this.wrap = false;
        } else {
            System.arraycopy(this.ring, n + 1, this.ring, n, this.count - n - 1);
            --this.count;
        }
    }

    private int virtualToPhysicalIndex(int n) {
        if (this.wrap) {
            if (n < this.count) {
                return this.count - n - 1;
            }
            return this.count + this.ring.length - n - 1;
        }
        return this.count - n - 1;
    }

    private int indexOf(String string) {
        int n = this.wrap ? this.ring.length : this.count;
        for (int i = n - 1; i >= 0; --i) {
            if (!this.ring[i].equals(string)) continue;
            return i;
        }
        return -1;
    }
}

