/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.TaskManager;

public class CloseDialog
extends EnhancedDialog {
    private final View view;
    private final JList<String> bufferList;
    private final DefaultListModel<String> bufferModel;
    private final JButton save;
    private final JButton discard;
    private boolean ok;
    boolean selectAllFlag;

    public CloseDialog(View view) {
        this(view, jEdit.getBufferManager().getBuffers());
    }

    public CloseDialog(View view, Collection<Buffer> collection) {
        super(view, jEdit.getProperty("close.title"), true);
        this.view = view;
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        Box box = new Box(1);
        box.add(new JLabel(UIManager.getIcon("OptionPane.warningIcon")));
        box.add(Box.createGlue());
        jPanel.add("West", box);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(jEdit.getProperty("close.caption"));
        jLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel2.add("North", jLabel);
        this.bufferModel = new DefaultListModel();
        this.bufferList = new JList(this.bufferModel);
        this.bufferList.setVisibleRowCount(10);
        this.bufferList.addListSelectionListener(new ListHandler());
        boolean bl = jEdit.getBooleanProperty("suppressNotSavedConfirmUntitled");
        bl = bl || jEdit.getBooleanProperty("autosaveUntitled");
        for (Buffer object2 : collection) {
            if (!object2.isDirty() || object2.isUntitled() && bl) continue;
            this.bufferModel.addElement(object2.getPath());
        }
        jPanel2.add("Center", new JScrollPane(this.bufferList));
        jPanel.add("Center", jPanel2);
        Box box2 = new Box(0);
        box2.add(Box.createGlue());
        JButton jButton = new JButton(jEdit.getProperty("close.selectAll"));
        box2.add(jButton);
        jButton.setMnemonic(jEdit.getProperty("close.selectAll.mnemonic").charAt(0));
        jButton.addActionListener(actionEvent -> this.selectAll());
        box2.add(Box.createHorizontalStrut(6));
        this.save = new JButton(jEdit.getProperty("close.save"));
        box2.add(this.save);
        this.save.setMnemonic(jEdit.getProperty("close.save.mnemonic").charAt(0));
        this.save.addActionListener(actionEvent -> this.save());
        box2.add(Box.createHorizontalStrut(6));
        this.discard = new JButton(jEdit.getProperty("close.discard"));
        box2.add(this.discard);
        this.discard.setMnemonic(jEdit.getProperty("close.discard.mnemonic").charAt(0));
        this.discard.addActionListener(actionEvent -> this.discard());
        box2.add(Box.createHorizontalStrut(6));
        JButton jButton2 = new JButton(jEdit.getProperty("common.cancel"));
        box2.add(jButton2);
        jButton2.addActionListener(actionEvent -> this.cancel());
        box2.add(Box.createGlue());
        this.bufferList.setSelectedIndex(0);
        jPanel.add("South", box2);
        jPanel.getRootPane().setDefaultButton(jButton2);
        GenericGUIUtilities.requestFocus(this, this.bufferList);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public boolean isOK() {
        return this.ok;
    }

    @Override
    public void ok() {
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    private void updateButtons() {
        int n = this.bufferList.getSelectedIndex();
        this.save.getModel().setEnabled(n != -1);
        this.discard.getModel().setEnabled(n != -1);
    }

    private void discard() {
        List<String> list = this.bufferList.getSelectedValuesList();
        BufferManager bufferManager = jEdit.getBufferManager();
        for (String string : list) {
            bufferManager.getBuffer(string).ifPresent(buffer -> {
                jEdit._closeBuffer(this.view, buffer);
                this.bufferModel.removeElement(string);
            });
        }
        if (this.bufferModel.getSize() == 0) {
            this.ok = true;
            this.dispose();
        } else {
            this.bufferList.setSelectedIndex(0);
            this.bufferList.requestFocus();
        }
    }

    private void save() {
        List<String> list = this.bufferList.getSelectedValuesList();
        BufferManager bufferManager = jEdit.getBufferManager();
        for (String string : list) {
            bufferManager.getBuffer(string).filter(buffer -> buffer.save(this.view, null, true, true)).ifPresent(buffer -> {
                TaskManager.instance.waitForIoTasks();
                if (buffer.getBooleanProperty("BufferIORequest__error")) {
                    return;
                }
                jEdit._closeBuffer(this.view, buffer);
                this.bufferModel.removeElement(string);
            });
        }
        if (this.bufferModel.getSize() == 0) {
            this.ok = true;
            this.dispose();
        } else {
            this.bufferList.setSelectedIndex(0);
            this.bufferList.requestFocus();
        }
    }

    private void selectAll() {
        try {
            this.selectAllFlag = true;
            this.bufferList.setSelectionInterval(0, this.bufferModel.getSize() - 1);
        }
        finally {
            this.selectAllFlag = false;
        }
        this.bufferList.requestFocus();
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (CloseDialog.this.selectAllFlag) {
                return;
            }
            int n = CloseDialog.this.bufferList.getSelectedIndex();
            if (n != -1) {
                String string = CloseDialog.this.bufferModel.getElementAt(n);
                jEdit.getBufferManager().getBuffer(string).ifPresentOrElse(CloseDialog.this.view::showBuffer, () -> this.removeIndex(n, string));
            }
            CloseDialog.this.updateButtons();
        }

        private void removeIndex(int n, String string) {
            Log.log(1, this, "Buffer " + string + " is already closed");
            CloseDialog.this.bufferModel.removeElementAt(n);
        }
    }
}

