/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class ClockWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        ClockWidget clockWidget = new ClockWidget();
        return clockWidget;
    }

    private static class Clock
    extends JLabel
    implements ActionListener {
        private Timer timer;

        Clock() {
            this.setForeground(jEdit.getColorProperty("view.status.foreground"));
            this.setBackground(jEdit.getColorProperty("view.status.background"));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.update();
            int n = 60000;
            this.timer = new Timer(n, this);
            this.timer.setInitialDelay((int)((long)n - System.currentTimeMillis() % (long)n) + 500);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        @Override
        public String getToolTipText() {
            return new Date().toString();
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return new Point(mouseEvent.getX(), -20);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.update();
        }

        private static String getTime() {
            return DateFormat.getTimeInstance(3).format(new Date());
        }

        private void update() {
            this.setText(Clock.getTime());
        }
    }

    private static class ClockWidget
    implements Widget {
        private final Clock clock = new Clock();

        ClockWidget() {
        }

        @Override
        public JComponent getComponent() {
            return this.clock;
        }
    }
}

