/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.batik.bridge.AnimatableGenericSVGBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.FilterBridge;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.FilterChainRable8Bit;
import org.apache.batik.ext.awt.image.renderable.FloodRable8Bit;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFilterElementBridge
extends AnimatableGenericSVGBridge
implements FilterBridge,
ErrorConstants {
    protected static final Color TRANSPARENT_BLACK = new Color(0, true);

    public String getLocalName() {
        return "filter";
    }

    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode) {
        Rectangle2D rectangle2D = SVGUtilities.convertFilterChainRegion(element, element2, graphicsNode, bridgeContext);
        if (rectangle2D == null) {
            return null;
        }
        Filter filter = graphicsNode.getGraphicsNodeRable(true);
        filter = new PadRable8Bit(filter, rectangle2D, PadMode.ZERO_PAD);
        FilterChainRable8Bit filterChainRable8Bit = new FilterChainRable8Bit(filter, rectangle2D);
        float[] fArray = SVGUtilities.convertFilterRes(element, bridgeContext);
        filterChainRable8Bit.setFilterResolutionX((int)fArray[0]);
        filterChainRable8Bit.setFilterResolutionY((int)fArray[1]);
        HashMap<String, Filter> hashMap = new HashMap<String, Filter>(11);
        hashMap.put("SourceGraphic", filter);
        Filter filter2 = SVGFilterElementBridge.buildFilterPrimitives(element, rectangle2D, element2, graphicsNode, filter, hashMap, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        if (filter2 == filter) {
            filter2 = SVGFilterElementBridge.createEmptyFilter(element, rectangle2D, element2, graphicsNode, bridgeContext);
        }
        filterChainRable8Bit.setSource(filter2);
        return filterChainRable8Bit;
    }

    protected static Filter createEmptyFilter(Element element, Rectangle2D rectangle2D, Element element2, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Rectangle2D rectangle2D2 = SVGUtilities.convertFilterPrimitiveRegion(null, element, element2, graphicsNode, rectangle2D, rectangle2D, bridgeContext);
        return new FloodRable8Bit(rectangle2D2, TRANSPARENT_BLACK);
    }

    protected static Filter buildFilterPrimitives(Element element, Rectangle2D rectangle2D, Element element2, GraphicsNode graphicsNode, Filter filter, Map map, BridgeContext bridgeContext) {
        LinkedList<ParsedURL> linkedList = new LinkedList<ParsedURL>();
        Filter filter2;
        while ((filter2 = SVGFilterElementBridge.buildLocalFilterPrimitives(element, rectangle2D, element2, graphicsNode, filter, map, bridgeContext)) == filter) {
            String string = XLinkSupport.getXLinkHref(element);
            if (string.length() == 0) {
                return filter;
            }
            SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
            ParsedURL parsedURL = new ParsedURL(sVGOMDocument.getURLObject(), string);
            if (linkedList.contains(parsedURL)) {
                throw new BridgeException(bridgeContext, element, "xlink.href.circularDependencies", new Object[]{string});
            }
            linkedList.add(parsedURL);
            element = bridgeContext.getReferencedElement(element, string);
        }
        return filter2;
    }

    protected static Filter buildLocalFilterPrimitives(Element element, Rectangle2D rectangle2D, Element element2, GraphicsNode graphicsNode, Filter filter, Map map, BridgeContext bridgeContext) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element3;
            Bridge bridge;
            if (node.getNodeType() != 1 || (bridge = bridgeContext.getBridge(element3 = (Element)node)) == null || !(bridge instanceof FilterPrimitiveBridge)) continue;
            FilterPrimitiveBridge filterPrimitiveBridge = (FilterPrimitiveBridge)bridge;
            Filter filter2 = filterPrimitiveBridge.createFilter(bridgeContext, element3, element2, graphicsNode, filter, rectangle2D, map);
            if (filter2 == null) {
                return null;
            }
            filter = filter2;
        }
        return filter;
    }
}

