/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.protege.editor.core.Fonts;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.log.LogStatusLabel;
import org.protege.editor.core.log.LogStatusListener;
import org.protege.editor.core.plugin.AbstractPluginLoader;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.ui.RefreshableComponent;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.core.ui.action.ProtegeActionPluginJPFImpl;
import org.protege.editor.core.ui.error.ErrorLog;
import org.protege.editor.core.ui.error.SendErrorReportHandler;
import org.protege.editor.core.ui.progress.BackgroundTaskLabel;
import org.protege.editor.core.ui.workspace.CustomWorkspaceTabsManager;
import org.protege.editor.core.ui.workspace.TabbedWorkspace;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;
import org.protege.editor.core.ui.workspace.WorkspaceManager;
import org.protege.editor.core.ui.workspace.WorkspaceTab;
import org.protege.editor.core.ui.workspace.WorkspaceTabPlugin;
import org.protege.editor.core.util.HandlerRegistration;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLCustomWorkspaceTabsManager;
import org.protege.editor.owl.model.OWLEntityDisplayProvider;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.UIReasonerExceptionHandler;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.git.GitRepoStatusPresenter;
import org.protege.editor.owl.model.git.GitStatusView;
import org.protege.editor.owl.model.git.GitStatusViewImpl;
import org.protege.editor.owl.model.inference.OWLReasonerManager;
import org.protege.editor.owl.model.inference.OWLReasonerManagerImpl;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerInfo;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerPlugin;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerPluginJPFImpl;
import org.protege.editor.owl.model.inference.ReasonerDiedException;
import org.protege.editor.owl.model.inference.ReasonerInfoComparator;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.model.inference.ReasonerStatus;
import org.protege.editor.owl.model.inference.ReasonerUtilities;
import org.protege.editor.owl.model.selection.OWLSelectionHistoryManager;
import org.protege.editor.owl.model.selection.OWLSelectionHistoryManagerImpl;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.protege.editor.owl.model.selection.OWLSelectionModelImpl;
import org.protege.editor.owl.ui.OWLEntityCreationPanel;
import org.protege.editor.owl.ui.OWLWorkspaceViewsTab;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbTrailChangedHandler;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbTrailPresenter;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbTrailProvider;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbTrailProviderManager;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbTrailViewImpl;
import org.protege.editor.owl.ui.breadcrumb.HasBreadcrumbTrailProvider;
import org.protege.editor.owl.ui.inference.ConfigureReasonerAction;
import org.protege.editor.owl.ui.inference.ExplainInconsistentOntologyAction;
import org.protege.editor.owl.ui.inference.PrecomputeAction;
import org.protege.editor.owl.ui.inference.ReasonerProgressUI;
import org.protege.editor.owl.ui.inference.StopReasonerAction;
import org.protege.editor.owl.ui.navigation.OWLEntityNavPanel;
import org.protege.editor.owl.ui.ontology.OntologySourcesChangedHandlerUI;
import org.protege.editor.owl.ui.preferences.AnnotationPreferences;
import org.protege.editor.owl.ui.renderer.KeywordColourMap;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.renderer.OWLIconProvider;
import org.protege.editor.owl.ui.renderer.OWLIconProviderImpl;
import org.protege.editor.owl.ui.renderer.OWLOntologyCellRenderer;
import org.protege.editor.owl.ui.search.SearchDialogPanel;
import org.protege.editor.owl.ui.util.OWLComponentFactory;
import org.protege.editor.owl.ui.util.OWLComponentFactoryImpl;
import org.semanticweb.owlapi.model.ImportChange;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLEntityCollectingOntologyChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLWorkspace
extends TabbedWorkspace
implements SendErrorReportHandler,
HasBreadcrumbTrailProvider {
    public static final String REASONER_INITIALIZE = "Start reasoner";
    public static final String REASONER_RESYNC = "Synchronize reasoner";
    public static final String REASONER_STOP = "Stop reasoner";
    public static final String REASONER_EXPLAIN = "Explain inconsistent ontology";
    private static final String WINDOW_MODIFIED = "Window.documentModified";
    private final Logger logger = LoggerFactory.getLogger(OWLWorkspace.class);
    private final JComboBox<OWLOntology> ontologiesList = new JComboBox();
    private final ArrayList<OWLEntityDisplayProvider> entityDisplayProviders = new ArrayList();
    private final Map<String, Color> keyWordColorMap = new KeywordColourMap();
    private final OWLSelectionModel owlSelectionModel = new OWLSelectionModelImpl();
    private final OWLSelectionHistoryManager owlSelectionHistoryManager = new OWLSelectionHistoryManagerImpl(this.owlSelectionModel);
    private final OWLModelManagerListener owlModelManagerListener = event -> this.handleModelManagerEvent(event.getType());
    private final Set<EventType> reselectionEventTypes = new HashSet<EventType>();
    private final LogStatusLabel logStatusLabel = new LogStatusLabel();
    private final BackgroundTaskLabel backgroundTaskLabel = new BackgroundTaskLabel(ProtegeApplication.getBackgroundTaskManager());
    private final OWLEntityCollectingOntologyChangeListener listener = new OWLEntityCollectingOntologyChangeListener(){

        public void ontologiesChanged() {
            OWLWorkspace.this.verifySelection(this.getEntities());
        }

        public void ontologiesChanged(@Nonnull List<? extends OWLOntologyChange> changes) throws OWLException {
            super.ontologiesChanged(changes);
            OWLWorkspace.this.handleOntologiesChanged(changes);
        }
    };
    private final Set<URI> hiddenAnnotationURIs = new HashSet<URI>();
    private final PrecomputeAction startReasonerAction = new PrecomputeAction();
    private final PrecomputeAction synchronizeReasonerAction = new PrecomputeAction();
    private final ProtegeOWLAction stopReasonerAction = new StopReasonerAction();
    private final ExplainInconsistentOntologyAction explainInconsistentOntologyAction = new ExplainInconsistentOntologyAction();
    private final JLabel reasonerStatus = new JLabel();
    private final GitStatusView gitStatusView = new GitStatusViewImpl();
    private GitRepoStatusPresenter repoStatusPresenter;
    private final JCheckBox displayReasonerResults = new JCheckBox("Show Inferences");
    private final JPanel statusArea = new JPanel();
    private BreadcrumbTrailPresenter breadcrumbTrailPresenter;
    private final OWLIconProvider iconProvider = new OWLIconProviderImpl(c -> {
        for (OWLOntology ontology : this.getOWLModelManager().getActiveOntologies()) {
            if (EntitySearcher.isDefined((OWLClass)c, (OWLOntology)ontology)) {
                return true;
            }
            if (ontology.getDisjointUnionAxioms(c).isEmpty()) continue;
            return true;
        }
        return false;
    });
    private String altTitle;
    private boolean reasonerManagerStarted = false;
    private OWLComponentFactory owlComponentFactory;
    private JDialog searchDialog;
    private final BreadcrumbTrailProviderManager breadcrumbTrailProviderManager;
    private List<ProtegeAction> extraReasonerMenuActions;

    public OWLWorkspace() {
        this.statusArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 1, 2));
        this.statusArea.setLayout(new BoxLayout(this.statusArea, 0));
        this.statusArea.add(Box.createHorizontalGlue());
        this.statusArea.add(this.gitStatusView.asJComponent());
        this.statusArea.add(Box.createHorizontalStrut(30));
        this.statusArea.add(this.reasonerStatus);
        this.statusArea.add(Box.createHorizontalStrut(10));
        this.statusArea.add(this.displayReasonerResults);
        this.statusArea.add(Box.createHorizontalStrut(10));
        this.statusArea.add((Component)this.logStatusLabel);
        this.statusArea.add(Box.createHorizontalStrut(10));
        this.reselectionEventTypes.add(EventType.ACTIVE_ONTOLOGY_CHANGED);
        this.reselectionEventTypes.add(EventType.ONTOLOGY_RELOADED);
        this.reselectionEventTypes.add(EventType.ENTITY_RENDERER_CHANGED);
        this.reselectionEventTypes.add(EventType.ONTOLOGY_VISIBILITY_CHANGED);
        this.reselectionEventTypes.add(EventType.REASONER_CHANGED);
        this.reselectionEventTypes.add(EventType.ONTOLOGY_CLASSIFIED);
        this.hiddenAnnotationURIs.addAll(AnnotationPreferences.getHiddenAnnotationURIs());
        this.breadcrumbTrailProviderManager = new BreadcrumbTrailProviderManager(this);
    }

    public OWLEditorKit getOWLEditorKit() {
        return (OWLEditorKit)this.getEditorKit();
    }

    public OWLModelManager getOWLModelManager() {
        return this.getOWLEditorKit().getModelManager();
    }

    public void initialise() {
        super.initialise();
        ProtegeApplication.getLogManager().addErrorLogListener((LogStatusListener)this.logStatusLabel);
        this.breadcrumbTrailProviderManager.start();
        this.breadcrumbTrailPresenter = new BreadcrumbTrailPresenter(this, new BreadcrumbTrailViewImpl(this));
        this.breadcrumbTrailPresenter.start();
        this.createActiveOntologyPanel();
        this.owlComponentFactory = new OWLComponentFactoryImpl(this.getOWLEditorKit());
        OWLModelManager mngr = this.getOWLModelManager();
        mngr.addListener(this.owlModelManagerListener);
        mngr.addOntologyChangeListener((OWLOntologyChangeListener)this.listener);
        OWLReasonerManager reasonerManager = mngr.getOWLReasonerManager();
        reasonerManager.setReasonerProgressMonitor(new ReasonerProgressUI(this.getOWLEditorKit()));
        reasonerManager.setReasonerExceptionHandler(new UIReasonerExceptionHandler(this));
        this.reasonerManagerStarted = true;
        this.updateReasonerStatus(false);
        this.displayReasonerResults.setSelected(reasonerManager.getReasonerPreferences().isShowInferences());
        this.displayReasonerResults.addActionListener(e -> {
            ReasonerPreferences prefs = reasonerManager.getReasonerPreferences();
            prefs.setShowInferences(this.displayReasonerResults.isSelected());
        });
        this.reasonerStatus.setFont(Fonts.getSmallDialogFont());
        this.displayReasonerResults.putClientProperty("JComponent.sizeVariant", "small");
        this.displayReasonerResults.setFont(Fonts.getSmallDialogFont());
        this.repoStatusPresenter = new GitRepoStatusPresenter(mngr, this.gitStatusView);
        this.repoStatusPresenter.start();
        new OntologySourcesChangedHandlerUI(this);
    }

    public void handleActivated() {
        super.handleActivated();
        this.updateTitleBar();
        this.repoStatusPresenter.update();
    }

    private void handleOntologiesChanged(List<? extends OWLOntologyChange> changes) {
        boolean reasonerDirty = false;
        boolean ontologyIdsDirty = false;
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (oWLOntologyChange instanceof SetOntologyID) {
                ontologyIdsDirty = true;
                continue;
            }
            if (oWLOntologyChange instanceof ImportChange) {
                reasonerDirty = true;
                continue;
            }
            if (!(oWLOntologyChange instanceof OWLAxiomChange)) continue;
            reasonerDirty = true;
        }
        if (reasonerDirty) {
            this.updateReasonerStatus(true);
        }
        if (ontologyIdsDirty) {
            this.updateTitleBar();
        }
        this.updateDirtyFlag();
    }

    private void updateDirtyFlag() {
        WorkspaceManager workspaceManager = ProtegeManager.getInstance().getEditorKitManager().getWorkspaceManager();
        WorkspaceFrame frame = workspaceManager.getFrame((Workspace)this);
        Set<OWLOntology> dirtyOntologies = this.getOWLModelManager().getDirtyOntologies();
        boolean dirty = false;
        for (OWLOntology ont : this.getOWLModelManager().getOntologies()) {
            if (!dirtyOntologies.contains(ont)) continue;
            dirty = true;
            break;
        }
        frame.getRootPane().putClientProperty(WINDOW_MODIFIED, dirty);
    }

    private void handleModelManagerEvent(EventType type) {
        try {
            if (this.reselectionEventTypes.contains((Object)type)) {
                this.verifySelection();
            }
            switch (type) {
                case ACTIVE_ONTOLOGY_CHANGED: {
                    this.updateTitleBar();
                    this.updateReasonerStatus(false);
                    this.rebuildOntologyDropDown();
                    this.ontologiesList.repaint();
                    break;
                }
                case ONTOLOGY_CLASSIFIED: {
                    this.updateReasonerStatus(false);
                    break;
                }
                case ABOUT_TO_CLASSIFY: 
                case REASONER_CHANGED: {
                    this.updateReasonerStatus(false);
                    break;
                }
                case ONTOLOGY_LOADED: 
                case ONTOLOGY_CREATED: {
                    if (this.getTabCount() <= 0) break;
                    this.setSelectedTab(0);
                    break;
                }
                case ENTITY_RENDERER_CHANGED: 
                case ONTOLOGY_RELOADED: {
                    this.rebuildOntologyDropDown();
                    this.refreshComponents();
                    break;
                }
                case ONTOLOGY_SAVED: {
                    this.updateDirtyFlag();
                    this.updateTitleBar();
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("An error occurred whilst handling a Model Manager Event: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void refreshComponents() {
        this.refreshComponents(SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this)));
    }

    public void refreshComponents(Component component) {
        if (component == null) {
            return;
        }
        if (component instanceof Container) {
            Container cont = (Container)component;
            for (Component childComp : cont.getComponents()) {
                this.refreshComponents(childComp);
            }
        }
        if (component instanceof RefreshableComponent) {
            ((RefreshableComponent)component).refreshComponent();
        }
    }

    private void verifySelection(Set<? extends OWLEntity> entities) {
        HashSet<OWLEntity> unreferencedEntities = new HashSet<OWLEntity>();
        for (OWLEntity oWLEntity : entities) {
            if (oWLEntity == null || oWLEntity.isBuiltIn()) continue;
            boolean unreferenced = true;
            for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
                if (!ont.containsEntityInSignature(oWLEntity)) continue;
                unreferenced = false;
                break;
            }
            if (!unreferenced) continue;
            unreferencedEntities.add(oWLEntity);
        }
        for (OWLEntity oWLEntity : unreferencedEntities) {
            this.getOWLSelectionModel().clearLastSelectedEntity(oWLEntity);
        }
    }

    private void verifySelection() {
        this.logger.debug("--- Verifying selection ---");
        OWLSelectionModel selectionModel = this.getOWLSelectionModel();
        OWLClass lastSelectedClass = selectionModel.getLastSelectedClass();
        this.logger.debug("Last selected class: {}", (Object)lastSelectedClass);
        OWLObjectProperty lastSelectedObjectProperty = selectionModel.getLastSelectedObjectProperty();
        this.logger.debug("Last selected object property: {}", (Object)lastSelectedObjectProperty);
        OWLDataProperty lastSelectedDataProperty = selectionModel.getLastSelectedDataProperty();
        this.logger.debug("Last selected data property: {}", (Object)lastSelectedDataProperty);
        OWLAnnotationProperty lastSelectedAnnotationProperty = selectionModel.getLastSelectedAnnotationProperty();
        this.logger.debug("Last selected annotation property: " + lastSelectedAnnotationProperty);
        OWLNamedIndividual lastSelectedIndividual = selectionModel.getLastSelectedIndividual();
        this.logger.debug("Last selected individual: {}", (Object)lastSelectedIndividual);
        OWLDatatype lastSelectedDatatype = selectionModel.getLastSelectedDatatype();
        this.logger.debug("Last selected datatype: {}", (Object)lastSelectedDatatype);
        OWLEntity selectedEntity = selectionModel.getSelectedEntity();
        this.logger.debug("Last selected entity: {}", (Object)selectedEntity);
        this.verifySelection(CollectionFactory.createSet((Object[])new OWLEntity[]{lastSelectedClass, lastSelectedDataProperty, lastSelectedObjectProperty, lastSelectedAnnotationProperty, lastSelectedIndividual, lastSelectedDatatype, selectedEntity}));
        this.logger.debug("---------------------------");
    }

    public boolean isHiddenAnnotationURI(URI annotationURI) {
        return this.hiddenAnnotationURIs.contains(annotationURI);
    }

    public Set<URI> getHiddenAnnotationURIs() {
        return Collections.unmodifiableSet(this.hiddenAnnotationURIs);
    }

    public void setHiddenAnnotationURI(URI annotationURI, boolean hidden) {
        boolean changed = hidden ? this.hiddenAnnotationURIs.add(annotationURI) : this.hiddenAnnotationURIs.remove(annotationURI);
        if (changed) {
            AnnotationPreferences.setHiddenAnnotationURIs(this.hiddenAnnotationURIs);
            this.getOWLEditorKit().getModelManager().fireEvent(EventType.ACTIVE_ONTOLOGY_CHANGED);
        }
    }

    public void setHiddenAnnotationURIs(Set<URI> hiddenURIs) {
        if (!hiddenURIs.equals(this.hiddenAnnotationURIs)) {
            this.hiddenAnnotationURIs.clear();
            this.hiddenAnnotationURIs.addAll(hiddenURIs);
            AnnotationPreferences.setHiddenAnnotationURIs(this.hiddenAnnotationURIs);
            this.getOWLEditorKit().getModelManager().fireEvent(EventType.ACTIVE_ONTOLOGY_CHANGED);
        }
    }

    protected void initialiseExtraMenuItems(JMenuBar menuBar) {
        super.initialiseExtraMenuItems(menuBar);
        this.getOntologiesMenu(menuBar);
        this.extraReasonerMenuActions = this.initialiseExtraReasonerMenuActions();
        this.rebuildReasonerMenu(menuBar);
        this.addReasonerListener(menuBar);
        this.updateTitleBar();
        Optional<JMenu> menu = OWLWorkspace.getWindowMenu(menuBar);
        if (!menu.isPresent()) {
            return;
        }
        JMenu windowMenu = menu.get();
        windowMenu.addSeparator();
        windowMenu.add(new AbstractAction("Refresh user interface"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLWorkspace.this.refreshComponents();
            }
        });
    }

    private List<ProtegeAction> initialiseExtraReasonerMenuActions() {
        ArrayList<ProtegeAction> result = new ArrayList<ProtegeAction>();
        ExtraReasonerMenuActionPluginLoader loader = new ExtraReasonerMenuActionPluginLoader();
        for (ExtraReasonerMenuActionPlugin extraReasonerMenuActionPlugin : loader.getPlugins()) {
            try {
                String accelerator;
                ProtegeAction action = (ProtegeAction)extraReasonerMenuActionPlugin.newInstance();
                action.setEditorKit((EditorKit)this.getOWLEditorKit());
                String name = extraReasonerMenuActionPlugin.getName();
                if (name == null) {
                    this.logger.warn("Extra reasoner menu action plugin has no name: {}", (Object)extraReasonerMenuActionPlugin);
                }
                action.putValue("Name", (Object)name);
                String toolTipText = extraReasonerMenuActionPlugin.getToolTipText();
                if (toolTipText != null) {
                    action.putValue("ShortDescription", (Object)toolTipText);
                }
                if ((accelerator = extraReasonerMenuActionPlugin.getAccelerator()) != null) {
                    action.putValue("AcceleratorKey", (Object)accelerator);
                }
                result.add(action);
                this.logger.debug("action = {}", (Object)action);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.logger.error("Error whilst loading menu plugin", (Throwable)e);
            }
        }
        return result;
    }

    private void rebuildReasonerMenu(JMenuBar menuBar) {
        OWLModelManager mngr = this.getOWLModelManager();
        Optional<JMenu> menu = OWLWorkspace.getReasonerMenu(menuBar);
        if (!menu.isPresent()) {
            return;
        }
        JMenu reasonerMenu = menu.get();
        reasonerMenu.removeAll();
        this.startReasonerAction.setEditorKit((EditorKit)this.getOWLEditorKit());
        this.startReasonerAction.putValue("Name", REASONER_INITIALIZE);
        reasonerMenu.add((Action)((Object)this.startReasonerAction));
        this.synchronizeReasonerAction.setEditorKit((EditorKit)this.getOWLEditorKit());
        this.synchronizeReasonerAction.putValue("Name", REASONER_RESYNC);
        reasonerMenu.add((Action)((Object)this.synchronizeReasonerAction));
        this.stopReasonerAction.setEditorKit((EditorKit)this.getOWLEditorKit());
        this.stopReasonerAction.putValue("Name", REASONER_STOP);
        reasonerMenu.add((Action)((Object)this.stopReasonerAction));
        this.explainInconsistentOntologyAction.setEditorKit((EditorKit)this.getOWLEditorKit());
        this.explainInconsistentOntologyAction.putValue("Name", REASONER_EXPLAIN);
        this.explainInconsistentOntologyAction.setEnabled(false);
        reasonerMenu.add((Action)((Object)this.explainInconsistentOntologyAction));
        ConfigureReasonerAction configureAction = new ConfigureReasonerAction();
        configureAction.setEditorKit((EditorKit)this.getOWLEditorKit());
        configureAction.putValue("Name", "Configure...");
        reasonerMenu.add((Action)((Object)configureAction));
        if (this.extraReasonerMenuActions != null && this.extraReasonerMenuActions.size() > 0) {
            reasonerMenu.addSeparator();
            for (ProtegeAction action : this.extraReasonerMenuActions) {
                reasonerMenu.add((Action)action);
            }
        }
        reasonerMenu.addSeparator();
        ButtonGroup bg = new ButtonGroup();
        Set<ProtegeOWLReasonerInfo> factories = mngr.getOWLReasonerManager().getInstalledReasonerFactories();
        ArrayList<ProtegeOWLReasonerInfo> factoriesList = new ArrayList<ProtegeOWLReasonerInfo>(factories);
        Collections.sort(factoriesList, new ReasonerInfoComparator());
        for (ProtegeOWLReasonerInfo plugin : factoriesList) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(plugin.getReasonerName());
            item.setSelected(mngr.getOWLReasonerManager().getCurrentReasonerFactoryId().equals(plugin.getReasonerId()));
            reasonerMenu.add(item);
            bg.add(item);
            item.addActionListener(e -> mngr.getOWLReasonerManager().setCurrentReasonerFactoryId(plugin.getReasonerId()));
        }
    }

    private void addReasonerListener(final JMenuBar menuBar) {
        IExtensionRegistry registry = PluginUtilities.getInstance().getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.protege.editor.owl", "inference_reasonerfactory");
        registry.addListener(new IRegistryEventListener(){

            public void added(IExtension[] extensions) {
                OWLReasonerManagerImpl reasonerManager = (OWLReasonerManagerImpl)OWLWorkspace.this.getOWLModelManager().getOWLReasonerManager();
                HashSet<ProtegeOWLReasonerPlugin> plugins = new HashSet<ProtegeOWLReasonerPlugin>();
                for (IExtension extension : extensions) {
                    plugins.add(new ProtegeOWLReasonerPluginJPFImpl(OWLWorkspace.this.getOWLModelManager(), extension));
                }
                reasonerManager.addReasonerFactories(plugins);
                OWLWorkspace.this.rebuildReasonerMenu(menuBar);
                menuBar.repaint();
            }

            public void added(IExtensionPoint[] extensionPoints) {
            }

            public void removed(IExtension[] extensions) {
            }

            public void removed(IExtensionPoint[] extensionPoints) {
            }
        }, point.getUniqueIdentifier());
    }

    private Optional<JMenu> getOntologiesMenu(JMenuBar menuBar) {
        return OWLWorkspace.getMenu(menuBar, "Ontologies");
    }

    private static Optional<JMenu> getReasonerMenu(JMenuBar menuBar) {
        return OWLWorkspace.getMenu(menuBar, "Reasoner");
    }

    private static Optional<JMenu> getWindowMenu(JMenuBar menuBar) {
        return OWLWorkspace.getMenu(menuBar, "Window");
    }

    private static Optional<JMenu> getMenu(JMenuBar menuBar, String name) {
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (menu == null || menu.getText() == null || !menu.getText().equals(name)) continue;
            return Optional.of(menu);
        }
        return Optional.empty();
    }

    private void createActiveOntologyPanel() {
        JPanel topBarPanel = new JPanel(new GridBagLayout());
        topBarPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 2, 10));
        topBarPanel.add((Component)new OWLEntityNavPanel(this.getOWLEditorKit()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 256, 0, new Insets(0, 0, 0, 2), 0, 0));
        OWLModelManager mngr = this.getOWLModelManager();
        this.ontologiesList.setToolTipText("Active ontology");
        this.ontologiesList.setRenderer(new OWLOntologyCellRenderer(this.getOWLEditorKit()));
        this.rebuildOntologyDropDown();
        topBarPanel.add(this.ontologiesList, new GridBagConstraints(1, 0, 1, 1, 100.0, 0.0, 256, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.ontologiesList.addActionListener(e -> {
            OWLOntology ont = (OWLOntology)this.ontologiesList.getSelectedItem();
            if (ont != null) {
                mngr.setActiveOntology(ont);
            }
        });
        JButton searchButton = new JButton("Search...");
        searchButton.addActionListener(e -> this.showSearchDialog());
        topBarPanel.add((Component)searchButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 256, 0, new Insets(0, 2, 0, 2), 0, 0));
        topBarPanel.add((Component)this.backgroundTaskLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        topBarPanel.add((Component)this.breadcrumbTrailPresenter.getBreadcrumbTrailView().asJComponent(), new GridBagConstraints(0, 1, 4, 1, 100.0, 0.0, 512, 2, new Insets(1, 0, 0, 0), 0, 0));
        this.add(topBarPanel, "North");
        this.updateTitleBar();
    }

    public void setBreadcrumbTrailVisible(boolean visible) {
        this.breadcrumbTrailPresenter.getBreadcrumbTrailView().asJComponent().setVisible(visible);
    }

    public boolean isBreadcrumbTrailVisible() {
        return this.breadcrumbTrailPresenter.getBreadcrumbTrailView().asJComponent().isVisible();
    }

    public void showSearchDialog() {
        if (this.getOWLEditorKit() == null) {
            this.logger.info("The OWLWorkspace has not been initialised.  Not displaying the search dialog.");
            return;
        }
        if (this.searchDialog == null) {
            this.searchDialog = SearchDialogPanel.createDialog((JComponent)((Object)this), this.getOWLEditorKit());
            Point workspaceLocation = this.getLocation();
            Dimension workspaceSize = this.getSize();
            SwingUtilities.convertPointToScreen(workspaceLocation, (Component)((Object)this));
            workspaceLocation.translate(workspaceSize.width - this.searchDialog.getWidth() - 10, 0);
            this.searchDialog.setLocation(workspaceLocation);
        }
        this.searchDialog.setVisible(true);
    }

    public void setTitle(String title) {
        this.altTitle = title;
        this.updateTitleBar();
    }

    protected String getTitle() {
        if (this.altTitle != null) {
            return this.altTitle;
        }
        OWLModelManager mngr = this.getOWLModelManager();
        OWLOntology activeOntology = mngr.getActiveOntology();
        if (activeOntology == null) {
            return null;
        }
        URI locURI = mngr.getOntologyPhysicalURI(activeOntology);
        String location = "*";
        if (locURI != null && !locURI.toString().isEmpty()) {
            location = locURI.toString();
            if ("file".equals(locURI.getScheme())) {
                location = new File(locURI).getPath();
            }
        }
        String ontShortName = mngr.getRendering((OWLObject)activeOntology);
        com.google.common.base.Optional defaultDocumentIRI = activeOntology.getOntologyID().getDefaultDocumentIRI();
        String documentIRIPart = "";
        if (defaultDocumentIRI.isPresent()) {
            documentIRIPart = " (" + defaultDocumentIRI.get() + ") ";
        }
        return ontShortName + documentIRIPart + " : [" + location + "]";
    }

    private void updateTitleBar() {
        WorkspaceFrame f = ProtegeManager.getInstance().getFrame((Workspace)this);
        if (f != null) {
            f.setTitle(this.getTitle());
        }
        this.ontologiesList.repaint();
    }

    private void updateReasonerStatus(boolean changesInProgress) {
        ReasonerStatus newStatus;
        if (!this.reasonerManagerStarted) {
            return;
        }
        OWLReasonerManager reasonerManager = this.getOWLEditorKit().getOWLModelManager().getOWLReasonerManager();
        try {
            newStatus = reasonerManager.getReasonerStatus();
        }
        catch (ReasonerDiedException reasonerDied) {
            newStatus = ReasonerStatus.REASONER_NOT_INITIALIZED;
            ReasonerUtilities.warnThatReasonerDied(null, reasonerDied);
        }
        if (changesInProgress && (newStatus == ReasonerStatus.INITIALIZED || newStatus == ReasonerStatus.INCONSISTENT) && reasonerManager.getCurrentReasoner().getBufferingMode() == BufferingMode.BUFFERING) {
            newStatus = ReasonerStatus.OUT_OF_SYNC;
        }
        this.updateReasonerStatus(newStatus);
    }

    private void updateReasonerStatus(ReasonerStatus status) {
        this.reasonerStatus.setText(status.getDescription());
        this.startReasonerAction.setEnabled(status.isEnableInitialization());
        this.startReasonerAction.putValue("ShortDescription", status.getInitializationTooltip());
        this.synchronizeReasonerAction.setEnabled(status.isEnableSynchronization());
        this.synchronizeReasonerAction.putValue("ShortDescription", status.getSynchronizationTooltip());
        this.stopReasonerAction.setEnabled(status.isEnableStop());
        this.explainInconsistentOntologyAction.setEnabled(status == ReasonerStatus.INCONSISTENT);
        KeyStroke shortcut = KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.startReasonerAction.putValue("AcceleratorKey", status.isEnableInitialization() ? shortcut : null);
        this.synchronizeReasonerAction.putValue("AcceleratorKey", status.isEnableSynchronization() ? shortcut : null);
    }

    public void displayOWLEntity(OWLEntity owlEntity) {
        JComponent component;
        OWLEntityDisplayProvider candidate = null;
        for (OWLEntityDisplayProvider provider : this.entityDisplayProviders) {
            if (!provider.canDisplay(owlEntity)) continue;
            if (candidate == null) {
                candidate = provider;
            }
            if (!provider.getDisplayComponent().isShowing()) continue;
            candidate = provider;
            break;
        }
        if (candidate != null && (component = candidate.getDisplayComponent()) != null) {
            OWLWorkspace.bringComponentToFront(component);
        }
    }

    public CustomWorkspaceTabsManager getCustomTabsManager() {
        return new OWLCustomWorkspaceTabsManager();
    }

    private static void bringComponentToFront(Component component) {
        if (component.isShowing()) {
            return;
        }
        Container parent = component.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof JTabbedPane) {
            ((JTabbedPane)parent).setSelectedComponent(component);
        }
        OWLWorkspace.bringComponentToFront(parent);
    }

    public void registerOWLEntityDisplayProvider(OWLEntityDisplayProvider provider) {
        this.entityDisplayProviders.add(provider);
    }

    public void unregisterOWLEntityDisplayProvider(OWLEntityDisplayProvider provider) {
        this.entityDisplayProviders.remove(provider);
    }

    @Override
    public Optional<BreadcrumbTrailProvider> getBreadcrumbTrailProvider() {
        return this.breadcrumbTrailProviderManager.getActiveProvider();
    }

    @Nonnull
    public HandlerRegistration registerBreadcrumbTrailProvider(@Nonnull BreadcrumbTrailProvider provider) {
        return this.breadcrumbTrailProviderManager.registerBreadcrumbTrailProvider(provider);
    }

    @Nonnull
    public HandlerRegistration addBreadcrumbTrailChangedHandler(@Nonnull BreadcrumbTrailChangedHandler handler) {
        return this.breadcrumbTrailProviderManager.addBreadcrumbTrailChangedHandler(handler);
    }

    public void dispose() {
        super.dispose();
        this.owlComponentFactory.dispose();
        this.repoStatusPresenter.dispose();
        ProtegeApplication.getLogManager().removeErrorLogListener((LogStatusListener)this.logStatusLabel);
        this.getOWLModelManager().removeListener(this.owlModelManagerListener);
        this.getOWLModelManager().removeOntologyChangeListener((OWLOntologyChangeListener)this.listener);
    }

    private void rebuildOntologyDropDown() {
        try {
            TreeSet<OWLObject> ts = new TreeSet<OWLObject>(this.getOWLModelManager().getOWLObjectComparator());
            ts.addAll(this.getOWLModelManager().getOntologies());
            this.ontologiesList.setModel(new DefaultComboBoxModel<OWLOntology>(ts.toArray(new OWLOntology[ts.size()])));
            this.ontologiesList.setSelectedItem(this.getOWLModelManager().getActiveOntology());
        }
        catch (Exception e) {
            this.logger.error("An error occurred whilst building the ontology list: {}", (Throwable)e);
        }
    }

    public OWLIconProvider getOWLIconProvider() {
        return this.iconProvider;
    }

    public OWLCellRenderer createOWLCellRenderer() {
        return this.createOWLCellRenderer(true, true);
    }

    public OWLCellRenderer createOWLCellRenderer(boolean renderExpression, boolean renderIcon) {
        return new OWLCellRenderer(this.getOWLEditorKit(), renderExpression, renderIcon);
    }

    public Map<String, Color> getKeyWordColorMap() {
        return this.keyWordColorMap;
    }

    public OWLSelectionModel getOWLSelectionModel() {
        return this.owlSelectionModel;
    }

    public OWLSelectionHistoryManager getOWLSelectionHistoryManager() {
        return this.owlSelectionHistoryManager;
    }

    public OWLEntityCreationSet<OWLClass> createOWLClass() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), OWLClass.class);
    }

    public OWLEntityCreationSet<OWLObjectProperty> createOWLObjectProperty() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), OWLObjectProperty.class);
    }

    public OWLEntityCreationSet<OWLDataProperty> createOWLDataProperty() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), OWLDataProperty.class);
    }

    public OWLEntityCreationSet<OWLAnnotationProperty> createOWLAnnotationProperty() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), OWLAnnotationProperty.class);
    }

    public OWLEntityCreationSet<OWLNamedIndividual> createOWLIndividual() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), OWLNamedIndividual.class);
    }

    public OWLEntityCreationSet<OWLDatatype> createOWLDatatype() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), OWLDatatype.class);
    }

    public OWLComponentFactory getOWLComponentFactory() {
        if (this.owlComponentFactory == null) {
            throw new RuntimeException("The OWL Workspace has not been initialised.  OWLWorkspace.getOWLComponentFactory must not be called until the workspace has been initialised.");
        }
        return this.owlComponentFactory;
    }

    public static KeyStroke getCreateSubKeyStroke() {
        return KeyStroke.getKeyStroke(92, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public static KeyStroke getCreateSibKeyStroke() {
        return KeyStroke.getKeyStroke(47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public boolean sendErrorReport(ErrorLog errorLog) {
        return true;
    }

    public Optional<JComponent> getStatusArea() {
        return Optional.of(this.statusArea);
    }

    public WorkspaceTab createWorkspaceTab(final String name) {
        final OWLWorkspaceViewsTab tab = new OWLWorkspaceViewsTab();
        tab.setup(new WorkspaceTabPlugin(){

            public TabbedWorkspace getWorkspace() {
                return OWLWorkspace.this;
            }

            public String getLabel() {
                return name;
            }

            public Icon getIcon() {
                return null;
            }

            public String getIndex() {
                return "Z";
            }

            public URL getDefaultViewConfigFile() {
                try {
                    return new File(this.getId() + "-config.xml").toURI().toURL();
                }
                catch (MalformedURLException uriex) {
                    OWLWorkspace.this.logger.warn("The default view configuration file is malformed: " + uriex.getMessage());
                    return null;
                }
            }

            public String getId() {
                return "WorkspaceTab" + System.nanoTime();
            }

            public String getDocumentation() {
                return null;
            }

            public WorkspaceTab newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                return tab;
            }
        });
        return tab;
    }

    private class ExtraReasonerMenuActionPluginLoader
    extends AbstractPluginLoader<ExtraReasonerMenuActionPlugin> {
        public ExtraReasonerMenuActionPluginLoader() {
            super("org.protege.editor.owl", "ExtraReasonerMenuAction");
        }

        protected ExtraReasonerMenuActionPlugin createInstance(IExtension extension) {
            return new ExtraReasonerMenuActionPlugin((EditorKit)OWLWorkspace.this.getOWLEditorKit(), extension);
        }
    }

    private class ExtraReasonerMenuActionPlugin
    extends ProtegeActionPluginJPFImpl {
        protected ExtraReasonerMenuActionPlugin(EditorKit editorKit, IExtension extension) {
            super(editorKit, extension);
        }

        public String getAccelerator() {
            return PluginUtilities.getAttribute((IExtension)this.getIExtension(), (String)"accelerator");
        }
    }
}

