/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.entity;

import com.google.common.base.Preconditions;
import org.eclipse.jgit.annotations.NonNull;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.renderer.RenderingEscapeUtils;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class MarkdownRenderer {
    @NonNull
    private final OWLModelManager modelManager;

    public MarkdownRenderer(OWLModelManager modelManager) {
        this.modelManager = (OWLModelManager)Preconditions.checkNotNull((Object)modelManager);
    }

    public String renderMarkdown(OWLEntity entity) {
        String displayName = this.modelManager.getRendering((OWLObject)entity);
        String unqotedDisplayName = RenderingEscapeUtils.unescape(displayName);
        return String.format("[%s](%s)", unqotedDisplayName, entity.getIRI().toString());
    }
}

