/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.antadapter.AntAdapterMessages;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class JDTCompilerAdapter
extends DefaultCompilerAdapter {
    private static final char[] SEPARATOR_CHARS = new char[]{'/', '\\'};
    private static final char[] ADAPTER_PREFIX = "#ADAPTER#".toCharArray();
    private static final char[] ADAPTER_ENCODING = "ENCODING#".toCharArray();
    private static final char[] ADAPTER_ACCESS = "ACCESS#".toCharArray();
    private static String compilerClass = "org.eclipse.jdt.internal.compiler.batch.Main";
    String logFileName;
    Map customDefaultOptions;
    private Map fileEncodings = null;
    private Map dirEncodings = null;
    private List accessRules = null;

    public boolean execute() throws BuildException {
        this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.usingJDTCompiler"), 3);
        Commandline commandline = this.setupJavacCommand();
        try {
            Class<?> clazz = Class.forName(compilerClass);
            Constructor<?> constructor = clazz.getConstructor(PrintWriter.class, PrintWriter.class, Boolean.TYPE, Map.class);
            Object obj = constructor.newInstance(new PrintWriter(System.out), new PrintWriter(System.err), Boolean.TRUE, this.customDefaultOptions);
            Method method = clazz.getMethod("compile", String[].class);
            Object object = method.invoke(obj, new Object[]{commandline.getArguments()});
            boolean bl = (Boolean)object;
            if (!bl && this.logFileName != null) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.error.compilationFailed", this.logFileName));
            }
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException(AntAdapterMessages.getString("ant.jdtadapter.error.cannotFindJDTCompiler"));
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    protected Commandline setupJavacCommand() throws BuildException {
        int n;
        Object object;
        String string;
        Commandline commandline = new Commandline();
        this.customDefaultOptions = new CompilerOptions().getMap();
        Class<Javac> clazz = Javac.class;
        String[] stringArray = this.processCompilerArguments(clazz);
        commandline.createArgument().setValue("-noExit");
        if (this.bootclasspath != null) {
            commandline.createArgument().setValue("-bootclasspath");
            if (this.bootclasspath.size() != 0) {
                commandline.createArgument().setPath(this.bootclasspath);
            } else {
                commandline.createArgument().setValue(Util.EMPTY_STRING);
            }
        }
        if (this.extdirs != null) {
            commandline.createArgument().setValue("-extdirs");
            commandline.createArgument().setPath(this.extdirs);
        }
        Path path = new Path(this.project);
        path.append(this.getCompileClasspath());
        commandline.createArgument().setValue("-classpath");
        this.createClasspathArgument(commandline, path);
        Path path2 = null;
        Method method = null;
        try {
            method = clazz.getMethod("getSourcepath", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Path path3 = null;
        if (method != null) {
            try {
                path3 = (Path)method.invoke((Object)this.attributes, (Object[])null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        path2 = path3 != null ? path3 : this.src;
        commandline.createArgument().setValue("-sourcepath");
        this.createClasspathArgument(commandline, path2);
        String string2 = JavaEnvUtils.getJavaVersion();
        String string3 = string = string2.equals("1.1") ? "-J-" : "-J-X";
        if (this.memoryInitialSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.ignoringMemoryInitialSize"), 1);
            } else {
                commandline.createArgument().setValue(string + "ms" + this.memoryInitialSize);
            }
        }
        if (this.memoryMaximumSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.ignoringMemoryMaximumSize"), 1);
            } else {
                commandline.createArgument().setValue(string + "mx" + this.memoryMaximumSize);
            }
        }
        if (this.debug) {
            object = null;
            try {
                object = clazz.getMethod("getDebugLevel", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            String string4 = null;
            if (object != null) {
                try {
                    string4 = (String)object.invoke((Object)this.attributes, (Object[])null);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (string4 != null) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                if (string4.length() != 0) {
                    if (string4.indexOf("vars") != -1) {
                        this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                    }
                    if (string4.indexOf("lines") != -1) {
                        this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                    }
                    if (string4.indexOf("source") != -1) {
                        this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                    }
                }
            } else {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
            }
        } else {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
        }
        if (this.attributes.getNowarn()) {
            object = this.customDefaultOptions.entrySet().toArray();
            int n2 = ((Object[])object).length;
            for (int i = 0; i < n2; ++i) {
                Map.Entry entry = (Map.Entry)object[i];
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !((String)entry.getValue()).equals("warning")) continue;
                this.customDefaultOptions.put(entry.getKey(), "ignore");
            }
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.taskTags", Util.EMPTY_STRING);
            if (this.deprecation) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
            }
        } else if (this.deprecation) {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        } else {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
        }
        if (this.destDir != null) {
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.destDir.getAbsoluteFile());
        }
        if (this.verbose) {
            commandline.createArgument().setValue("-verbose");
        }
        if (!this.attributes.getFailonerror()) {
            commandline.createArgument().setValue("-proceedOnError");
        }
        if (this.target != null) {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.target);
        }
        if ((object = this.attributes.getSource()) != null) {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.source", object);
        }
        if (stringArray != null && (n = stringArray.length) != 0) {
            int n3 = n;
            for (int i = 0; i < n3; ++i) {
                String string5 = stringArray[i];
                if (this.logFileName == null && "-log".equals(string5) && i + 1 < n3) {
                    this.logFileName = stringArray[i + 1];
                }
                commandline.createArgument().setValue(string5);
            }
        }
        if (this.encoding != null) {
            commandline.createArgument().setValue("-encoding");
            commandline.createArgument().setValue(this.encoding);
        }
        this.logAndAddFilesToCompile(commandline);
        return commandline;
    }

    private String[] processCompilerArguments(Class clazz) {
        Method method = null;
        try {
            method = clazz.getMethod("getCurrentCompilerArgs", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        String[] stringArray = null;
        if (method != null) {
            try {
                stringArray = (String[])method.invoke((Object)this.attributes, (Object[])null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (stringArray != null) {
            this.checkCompilerArgs(stringArray);
        }
        return stringArray;
    }

    private void checkCompilerArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) != '@') continue;
            try {
                char[] cArray = Util.getFileCharContent(new File(stringArray[i].substring(1)), null);
                int n = 0;
                int n2 = ADAPTER_PREFIX.length;
                while ((n = CharOperation.indexOf(ADAPTER_PREFIX, cArray, true, n)) > -1) {
                    String string;
                    int n3;
                    int n4 = n + n2;
                    int n5 = CharOperation.indexOf('\n', cArray, n4);
                    if (n5 == -1) {
                        n5 = cArray.length;
                    }
                    while (CharOperation.isWhitespace(cArray[n5])) {
                        --n5;
                    }
                    if (CharOperation.equals(ADAPTER_ENCODING, cArray, n4, n4 + ADAPTER_ENCODING.length)) {
                        CharOperation.replace(cArray, SEPARATOR_CHARS, File.separatorChar, n4, n5 + 1);
                        n3 = CharOperation.lastIndexOf('[', cArray, n4 += ADAPTER_ENCODING.length, n5);
                        if (n4 < n3 && n3 < n5) {
                            boolean bl = CharOperation.equals(SuffixConstants.SUFFIX_java, cArray, n3 - 5, n3, false);
                            string = String.valueOf(cArray, n4, n3 - n4);
                            String string2 = String.valueOf(cArray, n3, n5 - n3 + 1);
                            if (bl) {
                                if (this.fileEncodings == null) {
                                    this.fileEncodings = new HashMap();
                                }
                                this.fileEncodings.put(string, string2);
                            } else {
                                if (this.dirEncodings == null) {
                                    this.dirEncodings = new HashMap();
                                }
                                this.dirEncodings.put(string, string2);
                            }
                        }
                    } else if (CharOperation.equals(ADAPTER_ACCESS, cArray, n4, n4 + ADAPTER_ACCESS.length)) {
                        n3 = CharOperation.indexOf('[', cArray, n4 += ADAPTER_ACCESS.length, n5);
                        CharOperation.replace(cArray, SEPARATOR_CHARS, File.separatorChar, n4, n3);
                        if (n4 < n3 && n3 < n5) {
                            String string3 = String.valueOf(cArray, n4, n3 - n4);
                            string = String.valueOf(cArray, n3, n5 - n3 + 1);
                            if (this.accessRules == null) {
                                this.accessRules = new ArrayList();
                            }
                            this.accessRules.add(string3);
                            this.accessRules.add(string);
                        }
                    }
                    n = n5;
                }
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void createClasspathArgument(Commandline commandline, Path path) {
        Commandline.Argument argument = commandline.createArgument();
        String[] stringArray = path.list();
        if (stringArray.length == 0) {
            argument.setValue(Util.EMPTY_STRING);
            return;
        }
        if (this.accessRules == null) {
            argument.setPath(path);
            return;
        }
        int n = this.accessRules.size();
        String[] stringArray2 = this.accessRules.toArray(new String[n]);
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = stringArray.length;
        block0: for (int i = 0; i < n3; ++i) {
            if (i > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            String string = stringArray[i];
            stringBuffer.append(string);
            for (int j = n2; j < n; j += 2) {
                int n4;
                String string2 = stringArray2[j];
                if (string.endsWith(string2)) {
                    stringBuffer.append(stringArray2[j + 1]);
                    n2 = j + 2;
                    continue block0;
                }
                if (string2.endsWith(File.separator)) {
                    n4 = string2.length();
                    if (!string.regionMatches(false, string.length() - n4 + 1, string2, 0, n4 - 1)) continue;
                    stringBuffer.append(stringArray2[j + 1]);
                    n2 = j + 2;
                    continue block0;
                }
                if (!string.endsWith(File.separator)) continue;
                n4 = string2.length();
                if (!string.regionMatches(false, string.length() - n4 - 1, string2, 0, n4)) continue;
                stringBuffer.append(stringArray2[j + 1]);
                n2 = j + 2;
                continue block0;
            }
        }
        argument.setValue(stringBuffer.toString());
    }

    protected void logAndAddFilesToCompile(Commandline commandline) {
        this.attributes.log("Compilation " + commandline.describeArguments(), 3);
        StringBuffer stringBuffer = new StringBuffer("File");
        if (this.compileList.length != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(" to be compiled:");
        stringBuffer.append(lSep);
        String[] stringArray = null;
        String[] stringArray2 = null;
        int n = 0;
        int n2 = 0;
        if (this.fileEncodings != null) {
            n = this.fileEncodings.size();
            stringArray = new String[n];
            this.fileEncodings.keySet().toArray(stringArray);
        }
        if (this.dirEncodings != null) {
            n2 = this.dirEncodings.size();
            stringArray2 = new String[n2];
            this.dirEncodings.keySet().toArray(stringArray2);
            Comparator comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((String)object2).length() - ((String)object).length();
                }
            };
            Arrays.sort(stringArray2, comparator);
        }
        for (int i = 0; i < this.compileList.length; ++i) {
            int n3;
            String string = this.compileList[i].getAbsolutePath();
            boolean bl = false;
            if (stringArray != null) {
                for (n3 = 0; n3 < n; ++n3) {
                    if (!string.endsWith(stringArray[n3])) continue;
                    string = string + (String)this.fileEncodings.get(stringArray[n3]);
                    if (n3 < n - 1) {
                        System.arraycopy(stringArray, n3 + 1, stringArray, n3, n - n3 - 1);
                    }
                    stringArray[--n] = null;
                    bl = true;
                    break;
                }
            }
            if (!bl && stringArray2 != null) {
                for (n3 = 0; n3 < n2; ++n3) {
                    if (string.lastIndexOf(stringArray2[n3]) == -1) continue;
                    string = string + (String)this.dirEncodings.get(stringArray2[n3]);
                    break;
                }
            }
            commandline.createArgument().setValue(string);
            stringBuffer.append("    " + string + lSep);
        }
        this.attributes.log(stringBuffer.toString(), 3);
    }
}

