/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;

public final class SyncCompilerFeatures
implements CompilerPass {
    private final AbstractCompiler compiler;

    SyncCompilerFeatures(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        FeatureSet featureSet = FeatureSet.BARE_MINIMUM;
        for (Node rootNode : ImmutableList.of(externs, root)) {
            for (Node childNode = rootNode.getFirstChild(); childNode != null; childNode = childNode.getNext()) {
                Preconditions.checkState(childNode.isScript());
                FeatureSet featuresInScript = NodeUtil.getFeatureSetOfScript(childNode);
                if (featuresInScript == null) continue;
                featureSet = featureSet.with(featuresInScript);
            }
        }
        this.compiler.setFeatureSet(featureSet);
    }
}

