/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.cfa.FirControlFlowAnalyzer;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J8\u0010\r\u001a\u00020\b\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\u0016\u001a\u00020\b\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ControlFlowAnalysisDiagnosticComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "collector", "Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;", "(Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;)V", "controlFlowAnalyzer", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirControlFlowAnalyzer;", "visitAnonymousObject", "", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitClass", "F", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "klass", "controlFlowGraphReference", "Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "function", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkers"})
public final class ControlFlowAnalysisDiagnosticComponent
extends AbstractDiagnosticCollectorComponent {
    @NotNull
    private final FirControlFlowAnalyzer controlFlowAnalyzer;

    public ControlFlowAnalysisDiagnosticComponent(@NotNull AbstractDiagnosticCollector collector2) {
        Intrinsics.checkNotNullParameter(collector2, "collector");
        super(collector2);
        this.controlFlowAnalyzer = new FirControlFlowAnalyzer(this.getSession());
    }

    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        Intrinsics.checkNotNullParameter(data, "data");
        this.visitClass(regularClass, regularClass.getControlFlowGraphReference(), data);
    }

    @Override
    public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        Intrinsics.checkNotNullParameter(data, "data");
        this.visitClass(anonymousObject, anonymousObject.getControlFlowGraphReference(), data);
    }

    private final <F extends FirClass<F>> void visitClass(FirClass<F> klass, FirControlFlowGraphReference controlFlowGraphReference, CheckerContext data) {
        ControlFlowGraph controlFlowGraph;
        FirControlFlowGraphReference firControlFlowGraphReference = controlFlowGraphReference;
        ControlFlowGraph controlFlowGraph2 = controlFlowGraph = firControlFlowGraphReference == null ? null : FirControlFlowGraphReferenceImplKt.getControlFlowGraph(firControlFlowGraphReference);
        if (controlFlowGraph == null) {
            return;
        }
        ControlFlowGraph graph2 = controlFlowGraph;
        this.controlFlowAnalyzer.analyzeClassInitializer(klass, graph2, data, this.getReporter());
    }

    @Override
    public void visitProperty(@NotNull FirProperty property2, @NotNull CheckerContext data) {
        ControlFlowGraph controlFlowGraph;
        Intrinsics.checkNotNullParameter(property2, "property");
        Intrinsics.checkNotNullParameter(data, "data");
        FirControlFlowGraphReference firControlFlowGraphReference = property2.getControlFlowGraphReference();
        ControlFlowGraph controlFlowGraph2 = controlFlowGraph = firControlFlowGraphReference == null ? null : FirControlFlowGraphReferenceImplKt.getControlFlowGraph(firControlFlowGraphReference);
        if (controlFlowGraph == null) {
            return;
        }
        ControlFlowGraph graph2 = controlFlowGraph;
        this.controlFlowAnalyzer.analyzePropertyInitializer(property2, graph2, data, this.getReporter());
    }

    @Override
    public <F extends FirFunction<F>> void visitFunction(@NotNull FirFunction<F> function2, @NotNull CheckerContext data) {
        ControlFlowGraph controlFlowGraph;
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(data, "data");
        FirControlFlowGraphReference firControlFlowGraphReference = function2.getControlFlowGraphReference();
        ControlFlowGraph controlFlowGraph2 = controlFlowGraph = firControlFlowGraphReference == null ? null : FirControlFlowGraphReferenceImplKt.getControlFlowGraph(firControlFlowGraphReference);
        if (controlFlowGraph == null) {
            return;
        }
        ControlFlowGraph graph2 = controlFlowGraph;
        this.controlFlowAnalyzer.analyzeFunction(function2, graph2, data, this.getReporter());
    }

    @Override
    public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        Intrinsics.checkNotNullParameter(data, "data");
        this.visitFunction((FirFunction)simpleFunction, data);
    }

    @Override
    public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @NotNull CheckerContext data) {
        ControlFlowGraph controlFlowGraph;
        Intrinsics.checkNotNullParameter(propertyAccessor, "propertyAccessor");
        Intrinsics.checkNotNullParameter(data, "data");
        FirControlFlowGraphReference firControlFlowGraphReference = propertyAccessor.getControlFlowGraphReference();
        ControlFlowGraph controlFlowGraph2 = controlFlowGraph = firControlFlowGraphReference == null ? null : FirControlFlowGraphReferenceImplKt.getControlFlowGraph(firControlFlowGraphReference);
        if (controlFlowGraph == null) {
            return;
        }
        ControlFlowGraph graph2 = controlFlowGraph;
        this.controlFlowAnalyzer.analyzePropertyAccessor(propertyAccessor, graph2, data, this.getReporter());
    }

    @Override
    public void visitConstructor(@NotNull FirConstructor constructor2, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        Intrinsics.checkNotNullParameter(data, "data");
        this.visitFunction((FirFunction)constructor2, data);
    }
}

