/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.Timer;
import org.openstreetmap.gui.jmapviewer.AttributionSupport;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileRange;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.Attributed;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.ImageryAdjustAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.CoordinateConversion;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.imagery.TileLoaderFactory;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.io.importexport.WMSLayerImporter;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.imagery.AutoLoadTilesAction;
import org.openstreetmap.josm.gui.layer.imagery.AutoZoomAction;
import org.openstreetmap.josm.gui.layer.imagery.DecreaseZoomAction;
import org.openstreetmap.josm.gui.layer.imagery.FlushTileCacheAction;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.gui.layer.imagery.IncreaseZoomAction;
import org.openstreetmap.josm.gui.layer.imagery.LoadAllTilesAction;
import org.openstreetmap.josm.gui.layer.imagery.LoadErroneousTilesAction;
import org.openstreetmap.josm.gui.layer.imagery.ReprojectionTile;
import org.openstreetmap.josm.gui.layer.imagery.ShowErrorsAction;
import org.openstreetmap.josm.gui.layer.imagery.TileAnchor;
import org.openstreetmap.josm.gui.layer.imagery.TileCoordinateConverter;
import org.openstreetmap.josm.gui.layer.imagery.TilePosition;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.gui.layer.imagery.ZoomToBestAction;
import org.openstreetmap.josm.gui.layer.imagery.ZoomToNativeLevelAction;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MemoryManager;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public abstract class AbstractTileSourceLayer<T extends AbstractTMSTileSource>
extends ImageryLayer
implements ImageObserver,
TileLoaderListener,
NavigatableComponent.ZoomChangeListener,
ImageryFilterSettings.FilterChangeListener,
TileSourceDisplaySettings.DisplaySettingsChangeListener {
    private static final String PREFERENCE_PREFIX = "imagery.generic";
    public static final int MAX_ZOOM = 30;
    public static final int MIN_ZOOM = 2;
    private static final Font InfoFont;
    private static final List<MenuAddition> menuAdditions;
    public static final IntegerProperty PROP_MIN_ZOOM_LVL;
    public static final IntegerProperty PROP_MAX_ZOOM_LVL;
    private int currentZoomLevel;
    private final AttributionSupport attribution = new AttributionSupport();
    public static final IntegerProperty ZOOM_OFFSET;
    private static final BooleanProperty POPUP_MENU_ENABLED;
    protected TileCache tileCache;
    protected T tileSource;
    protected TileLoader tileLoader;
    private final Timer invalidateLaterTimer = new Timer(100, e -> this.invalidate());
    private final MouseAdapter adapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!AbstractTileSourceLayer.this.isVisible()) {
                return;
            }
            if (e.getButton() == 3) {
                Component component = e.getComponent();
                if (POPUP_MENU_ENABLED.get().booleanValue() && component.isShowing()) {
                    new TileSourceLayerPopup(e.getX(), e.getY()).show(component, e.getX(), e.getY());
                }
            } else if (e.getButton() == 1) {
                AbstractTileSourceLayer.this.attribution.handleAttribution(e.getPoint(), true);
            }
        }
    };
    private final TileSourceDisplaySettings displaySettings = this.createDisplaySettings();
    private final ImageryAdjustAction adjustAction = new ImageryAdjustAction(this);
    protected TileCoordinateConverter coordinateConverter;
    private final long minimumTileExpire;
    private final TileSet nullTileSet = new TileSet();

    protected AbstractTileSourceLayer(ImageryInfo info) {
        super(info);
        this.setBackgroundLayer(true);
        this.setVisible(true);
        this.getFilterSettings().addFilterChangeListener(this);
        this.getDisplaySettings().addSettingsChangeListener(this);
        this.minimumTileExpire = info.getMinimumTileExpire();
    }

    protected TileSourceDisplaySettings createDisplaySettings() {
        return new TileSourceDisplaySettings();
    }

    public TileSourceDisplaySettings getDisplaySettings() {
        return this.displaySettings;
    }

    @Override
    public void filterChanged() {
        this.invalidate();
    }

    protected abstract TileLoaderFactory getTileLoaderFactory();

    public abstract Collection<String> getNativeProjections();

    protected abstract T getTileSource();

    protected Map<String, String> getHeaders(T tileSource) {
        if (tileSource instanceof TemplatedTileSource) {
            return ((TemplatedTileSource)tileSource).getHeaders();
        }
        return null;
    }

    protected void initTileSource(T tileSource) {
        this.coordinateConverter = new TileCoordinateConverter(MainApplication.getMap().mapView, (TileSource)tileSource, this.getDisplaySettings());
        this.attribution.initialize((Attributed)tileSource);
        this.currentZoomLevel = this.getBestZoom();
        Map<String, String> headers = this.getHeaders(tileSource);
        this.tileLoader = this.getTileLoaderFactory().makeTileLoader(this, headers, this.minimumTileExpire);
        try {
            if ("file".equalsIgnoreCase(new URL(((AbstractTMSTileSource)tileSource).getBaseUrl()).getProtocol())) {
                this.tileLoader = new OsmTileLoader(this);
            }
        }
        catch (MalformedURLException e) {
            Logging.log(Logging.LEVEL_DEBUG, e);
        }
        if (this.tileLoader == null) {
            this.tileLoader = new OsmTileLoader(this, headers);
        }
        this.tileCache = new MemoryTileCache(this.estimateTileCacheSize());
    }

    @Override
    public synchronized void tileLoadingFinished(Tile tile, boolean success) {
        if (tile.hasError()) {
            success = false;
            tile.setImage(null);
        }
        this.invalidateLater();
        Logging.debug("tileLoadingFinished() tile: {0} success: {1}", tile, success);
    }

    public void clearTileCache() {
        if (this.tileLoader instanceof CachedTileLoader) {
            ((CachedTileLoader)((Object)this.tileLoader)).clearCache((TileSource)this.tileSource);
        }
        this.tileCache.clear();
    }

    @Override
    public Object getInfoComponent() {
        EastNorth offset;
        JPanel panel = (JPanel)super.getInfoComponent();
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        Collection<String> nativeProjections = this.getNativeProjections();
        if (nativeProjections != null) {
            content.add(Arrays.asList(I18n.tr("Native projections", new Object[0]), String.join((CharSequence)", ", this.getNativeProjections())));
        }
        if ((offset = this.getDisplaySettings().getDisplacement()).distanceSq(0.0, 0.0) > 1.0E-10) {
            content.add(Arrays.asList(I18n.tr("Offset", new Object[0]), offset.east() + ";" + offset.north()));
        }
        if (this.coordinateConverter.requiresReprojection()) {
            content.add(Arrays.asList(I18n.tr("Tile download projection", new Object[0]), this.tileSource.getServerCRS()));
            content.add(Arrays.asList(I18n.tr("Tile display projection", new Object[0]), ProjectionRegistry.getProjection().toCode()));
        }
        content.add(Arrays.asList(I18n.tr("Current zoom", new Object[0]), Integer.toString(this.currentZoomLevel)));
        for (List list : content) {
            panel.add((Component)new JLabel((String)list.get(0) + ':'), GBC.std());
            panel.add(GBC.glue(5, 0), GBC.std());
            panel.add((Component)this.createTextField((String)list.get(1)), GBC.eol().fill(2));
        }
        return panel;
    }

    @Override
    protected Action getAdjustAction() {
        return this.adjustAction;
    }

    public double getScaleFactor(int zoom) {
        if (this.coordinateConverter != null) {
            return this.coordinateConverter.getScaleFactor(zoom);
        }
        return 1.0;
    }

    public int getBestZoom() {
        int maxZoom;
        double factor = this.getScaleFactor(1);
        double result = Math.log(factor) / Math.log(2.0) / 2.0;
        int intResult = (int)Math.round(result + 1.0 + (double)ZOOM_OFFSET.get().intValue() / 1.9);
        int minZoom = this.getMinZoomLvl();
        if (minZoom <= (maxZoom = this.getMaxZoomLvl())) {
            intResult = Utils.clamp(intResult, minZoom, maxZoom);
        } else if (intResult > maxZoom) {
            intResult = maxZoom;
        }
        return intResult;
    }

    public static boolean actionSupportLayers(List<Layer> layers) {
        return layers.size() == 1 && layers.get(0) instanceof TMSLayer;
    }

    private static void sendOsmTileRequest(Tile tile, String request) {
        if (tile != null) {
            try {
                new Notification(HttpClient.create(new URL(tile.getUrl() + '/' + request)).connect().fetchContent()).show();
            }
            catch (IOException ex) {
                Logging.error(ex);
            }
        }
    }

    @Override
    public void hookUpMapView() {
        this.initializeIfRequired();
        super.hookUpMapView();
    }

    @Override
    public MapViewPaintable.LayerPainter attachToMapView(MapViewPaintable.MapViewEvent event) {
        this.initializeIfRequired();
        event.getMapView().addMouseListener(this.adapter);
        MapView.addZoomChangeListener(this);
        if (this instanceof NativeScaleLayer && NavigatableComponent.PROP_ZOOM_SCALE_FOLLOW_NATIVE_RES_AT_LOAD.get().booleanValue()) {
            event.getMapView().setNativeScaleLayer((NativeScaleLayer)((Object)this));
        }
        event.getMapView().repaint(500L);
        return super.attachToMapView(event);
    }

    private void initializeIfRequired() {
        if (this.tileSource == null) {
            this.tileSource = this.getTileSource();
            if (this.tileSource == null) {
                throw new IllegalArgumentException(I18n.tr("Failed to create tile source", new Object[0]));
            }
            this.projectionChanged(null, ProjectionRegistry.getProjection());
            this.initTileSource(this.tileSource);
        }
    }

    @Override
    protected MapViewPaintable.LayerPainter createMapViewPainter(MapViewPaintable.MapViewEvent event) {
        return new TileSourcePainter();
    }

    protected int estimateTileCacheSize() {
        Dimension screenSize = GuiHelper.getMaximumScreenSize();
        int height = screenSize.height;
        int width = screenSize.width;
        int tileSize = 256;
        if (this.tileSource != null) {
            tileSize = ((AbstractTMSTileSource)this.tileSource).getTileSize();
        }
        int visibileTiles = (int)(Math.ceil((double)height / (double)tileSize + 1.0) * Math.ceil((double)width / (double)tileSize + 1.0));
        int ret = (int)Math.ceil(Math.pow(2.0, ZOOM_OFFSET.get().intValue()) * (double)visibileTiles * 4.0);
        Logging.info("AbstractTileSourceLayer: estimated visible tiles: {0}, estimated cache size: {1}", visibileTiles, ret);
        return ret;
    }

    @Override
    public void displaySettingsChanged(TileSourceDisplaySettings.DisplaySettingsChangeEvent e) {
        if (this.tileSource == null) {
            return;
        }
        switch (e.getChangedSetting()) {
            case "automatically-change-resolution": {
                if (!this.getDisplaySettings().isAutoZoom() || this.getBestZoom() == this.currentZoomLevel) break;
                this.setZoomLevel(this.getBestZoom());
                this.invalidate();
                break;
            }
            case "automatic-downloading": {
                if (!this.getDisplaySettings().isAutoLoad()) break;
                this.invalidate();
                break;
            }
            default: {
                this.invalidate();
            }
        }
    }

    public static int checkMaxZoomLvl(int maxZoomLvl, TileSource ts) {
        if (maxZoomLvl > 30) {
            maxZoomLvl = 30;
        }
        if (maxZoomLvl < PROP_MIN_ZOOM_LVL.get()) {
            maxZoomLvl = PROP_MIN_ZOOM_LVL.get();
        }
        if (ts != null && ts.getMaxZoom() != 0 && ts.getMaxZoom() < maxZoomLvl) {
            maxZoomLvl = ts.getMaxZoom();
        }
        return maxZoomLvl;
    }

    public static int checkMinZoomLvl(int minZoomLvl, TileSource ts) {
        if (minZoomLvl < 2) {
            minZoomLvl = 2;
        }
        if (minZoomLvl > PROP_MAX_ZOOM_LVL.get()) {
            minZoomLvl = AbstractTileSourceLayer.getMaxZoomLvl(ts);
        }
        if (ts != null && ts.getMinZoom() > minZoomLvl) {
            minZoomLvl = ts.getMinZoom();
        }
        return minZoomLvl;
    }

    public static int getMaxZoomLvl(TileSource ts) {
        return AbstractTileSourceLayer.checkMaxZoomLvl(PROP_MAX_ZOOM_LVL.get(), ts);
    }

    public static int getMinZoomLvl(TileSource ts) {
        return AbstractTileSourceLayer.checkMinZoomLvl(PROP_MIN_ZOOM_LVL.get(), ts);
    }

    public static void setMaxZoomLvl(int maxZoomLvl) {
        PROP_MAX_ZOOM_LVL.put(AbstractTileSourceLayer.checkMaxZoomLvl(maxZoomLvl, null));
    }

    public static void setMinZoomLvl(int minZoomLvl) {
        PROP_MIN_ZOOM_LVL.put(AbstractTileSourceLayer.checkMinZoomLvl(minZoomLvl, null));
    }

    @Override
    public void zoomChanged() {
        this.zoomChanged(true);
    }

    private void zoomChanged(boolean invalidate) {
        Logging.debug("zoomChanged(): {0}", this.currentZoomLevel);
        if (this.tileLoader instanceof TMSCachedTileLoader) {
            ((TMSCachedTileLoader)this.tileLoader).cancelOutstandingTasks();
        }
        if (invalidate) {
            this.invalidate();
        }
    }

    protected int getMaxZoomLvl() {
        if (this.info.getMaxZoom() != 0) {
            return AbstractTileSourceLayer.checkMaxZoomLvl(this.info.getMaxZoom(), this.tileSource);
        }
        return AbstractTileSourceLayer.getMaxZoomLvl(this.tileSource);
    }

    protected int getMinZoomLvl() {
        if (this.info.getMinZoom() != 0) {
            return AbstractTileSourceLayer.checkMinZoomLvl(this.info.getMinZoom(), this.tileSource);
        }
        return AbstractTileSourceLayer.getMinZoomLvl(this.tileSource);
    }

    public boolean zoomIncreaseAllowed() {
        boolean zia = this.currentZoomLevel < this.getMaxZoomLvl();
        Logging.debug("zoomIncreaseAllowed(): {0} {1} vs. {2}", zia, this.currentZoomLevel, this.getMaxZoomLvl());
        return zia;
    }

    public boolean increaseZoomLevel() {
        if (this.zoomIncreaseAllowed()) {
            ++this.currentZoomLevel;
        } else {
            Logging.warn("Current zoom level (" + this.currentZoomLevel + ") could not be increased. Max.zZoom Level " + this.getMaxZoomLvl() + " reached.");
            return false;
        }
        Logging.debug("increasing zoom level to: {0}", this.currentZoomLevel);
        this.zoomChanged();
        return true;
    }

    public int getZoomLevel() {
        return this.currentZoomLevel;
    }

    public boolean setZoomLevel(int zoom) {
        return this.setZoomLevel(zoom, true);
    }

    private boolean setZoomLevel(int zoom, boolean invalidate) {
        if (zoom == this.currentZoomLevel) {
            return true;
        }
        if (zoom > this.getMaxZoomLvl()) {
            return false;
        }
        if (zoom < this.getMinZoomLvl()) {
            return false;
        }
        this.currentZoomLevel = zoom;
        this.zoomChanged(invalidate);
        return true;
    }

    public boolean zoomDecreaseAllowed() {
        boolean zda = this.currentZoomLevel > this.getMinZoomLvl();
        Logging.debug("zoomDecreaseAllowed(): {0} {1} vs. {2}", zda, this.currentZoomLevel, this.getMinZoomLvl());
        return zda;
    }

    public boolean decreaseZoomLevel() {
        if (this.zoomDecreaseAllowed()) {
            Logging.debug("decreasing zoom level to: {0}", this.currentZoomLevel);
            --this.currentZoomLevel;
        } else {
            return false;
        }
        this.zoomChanged();
        return true;
    }

    private Tile getOrCreateTile(TilePosition tilePosition) {
        return this.getOrCreateTile(tilePosition.getX(), tilePosition.getY(), tilePosition.getZoom());
    }

    private Tile getOrCreateTile(int x, int y, int zoom) {
        Tile tile = this.getTile(x, y, zoom);
        if (tile == null) {
            tile = this.coordinateConverter.requiresReprojection() ? new ReprojectionTile((TileSource)this.tileSource, x, y, zoom) : new Tile((TileSource)this.tileSource, x, y, zoom);
            this.tileCache.addTile(tile);
        }
        return tile;
    }

    private Tile getTile(TilePosition tilePosition) {
        return this.getTile(tilePosition.getX(), tilePosition.getY(), tilePosition.getZoom());
    }

    private Tile getTile(int x, int y, int zoom) {
        if (x < ((AbstractTMSTileSource)this.tileSource).getTileXMin(zoom) || x > ((AbstractTMSTileSource)this.tileSource).getTileXMax(zoom) || y < ((AbstractTMSTileSource)this.tileSource).getTileYMin(zoom) || y > ((AbstractTMSTileSource)this.tileSource).getTileYMax(zoom)) {
            return null;
        }
        return this.tileCache.getTile((TileSource)this.tileSource, x, y, zoom);
    }

    private boolean loadTile(Tile tile, boolean force) {
        if (tile == null) {
            return false;
        }
        if (!force && tile.isLoaded()) {
            return false;
        }
        if (tile.isLoading()) {
            return false;
        }
        this.tileLoader.createTileLoaderJob(tile).submit(force);
        return true;
    }

    private TileSet getVisibleTileSet() {
        if (!MainApplication.isDisplayingMapView()) {
            return new TileSet();
        }
        ProjectionBounds bounds = MainApplication.getMap().mapView.getProjectionBounds();
        return this.getTileSet(bounds, this.currentZoomLevel);
    }

    public void loadAllTiles(boolean force) {
        TileSet ts = this.getVisibleTileSet();
        ts.loadAllTiles(force);
        this.invalidate();
    }

    public void loadAllErrorTiles(boolean force) {
        TileSet ts = this.getVisibleTileSet();
        ts.loadAllErrorTiles(force);
        this.invalidate();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean done = (infoflags & 0x70) != 0;
        Logging.debug("imageUpdate() done: {0} calling repaint", done);
        if (done) {
            this.invalidate();
        } else {
            this.invalidateLater();
        }
        return !done;
    }

    private void invalidateLater() {
        GuiHelper.runInEDT(() -> {
            if (!this.invalidateLaterTimer.isRunning()) {
                this.invalidateLaterTimer.setRepeats(false);
                this.invalidateLaterTimer.start();
            }
        });
    }

    private boolean imageLoaded(Image i) {
        if (i == null) {
            return false;
        }
        int status = Toolkit.getDefaultToolkit().checkImage(i, -1, -1, this);
        return (status & 0x20) != 0;
    }

    private BufferedImage getLoadedTileImage(Tile tile) {
        BufferedImage img = tile.getImage();
        if (!this.imageLoaded(img)) {
            return null;
        }
        return img;
    }

    private void drawImageInside(Graphics2D g, BufferedImage toDrawImg, TileAnchor anchorImage, TileAnchor anchorScreen, Shape clip) {
        AffineTransform imageToScreen = anchorImage.convert(anchorScreen);
        Point2D screen0 = imageToScreen.transform(new Point2D.Double(0.0, 0.0), null);
        Point2D screen1 = imageToScreen.transform(new Point2D.Double(toDrawImg.getWidth(), toDrawImg.getHeight()), null);
        Shape oldClip = null;
        if (clip != null) {
            oldClip = g.getClip();
            g.clip(clip);
        }
        g.drawImage(toDrawImg, (int)Math.round(screen0.getX()), (int)Math.round(screen0.getY()), (int)Math.round(screen1.getX()) - (int)Math.round(screen0.getX()), (int)Math.round(screen1.getY()) - (int)Math.round(screen0.getY()), this);
        if (clip != null) {
            g.setClip(oldClip);
        }
    }

    private List<Tile> paintTileImages(Graphics2D g, TileSet ts) {
        Object paintMutex = new Object();
        List missed = Collections.synchronizedList(new ArrayList());
        ts.visitTiles(tile -> {
            boolean miss = false;
            BufferedImage img = null;
            TileAnchor anchorImage = null;
            if (!tile.isLoaded() || tile.hasError()) {
                miss = true;
            } else {
                Tile tile2 = tile;
                synchronized (tile2) {
                    img = this.getLoadedTileImage((Tile)tile);
                    anchorImage = AbstractTileSourceLayer.getAnchor(tile, img);
                }
                if (img == null || anchorImage == null) {
                    miss = true;
                }
            }
            if (miss) {
                missed.add(new TilePosition((Tile)tile));
                return;
            }
            img = this.applyImageProcessors(img);
            TileAnchor anchorScreen = this.coordinateConverter.getScreenAnchorForTile((Tile)tile);
            Object object = paintMutex;
            synchronized (object) {
                this.drawImageInside(g, img, anchorImage, anchorScreen, null);
            }
            MapView mapView = MainApplication.getMap().mapView;
            if (tile instanceof ReprojectionTile && ((ReprojectionTile)tile).needsUpdate(mapView.getScale())) {
                ((ReprojectionTile)tile).invalidate();
                this.loadTile((Tile)tile, false);
            }
        }, missed::add);
        return missed.stream().map(this::getOrCreateTile).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Tile> paintTileImages(Graphics2D g, TileSet ts, int zoom, Tile border) {
        if (zoom <= 0) {
            return Collections.emptyList();
        }
        Shape borderClip = this.coordinateConverter.getTileShapeScreen(border);
        LinkedList<Tile> missedTiles = new LinkedList<Tile>();
        for (Tile tile : ts.allTilesCreate()) {
            Shape clip;
            boolean miss = false;
            BufferedImage img = null;
            TileAnchor anchorImage = null;
            if (!tile.isLoaded() || tile.hasError()) {
                miss = true;
            } else {
                Tile tile2 = tile;
                synchronized (tile2) {
                    img = this.getLoadedTileImage(tile);
                    anchorImage = AbstractTileSourceLayer.getAnchor(tile, img);
                }
                if (img == null || anchorImage == null) {
                    miss = true;
                }
            }
            if (miss) {
                missedTiles.add(tile);
                continue;
            }
            img = this.applyImageProcessors(img);
            if (this.tileSource.isInside(tile, border)) {
                clip = null;
            } else {
                if (!this.tileSource.isInside(border, tile)) continue;
                clip = borderClip;
            }
            TileAnchor anchorScreen = this.coordinateConverter.getScreenAnchorForTile(tile);
            this.drawImageInside(g, img, anchorImage, anchorScreen, clip);
        }
        return Collections.unmodifiableList(missedTiles);
    }

    private static TileAnchor getAnchor(Tile tile, BufferedImage image) {
        if (tile instanceof ReprojectionTile) {
            return ((ReprojectionTile)tile).getAnchor();
        }
        if (image != null) {
            return new TileAnchor(new Point2D.Double(0.0, 0.0), new Point2D.Double(image.getWidth(), image.getHeight()));
        }
        return null;
    }

    private void myDrawString(Graphics g, String text, int x, int y) {
        Color oldColor = g.getColor();
        String textToDraw = text;
        if (g.getFontMetrics().stringWidth(text) > ((AbstractTMSTileSource)this.tileSource).getTileSize()) {
            StringBuilder line = new StringBuilder();
            StringBuilder ret = new StringBuilder();
            String[] stringArray = text.split(" ", -1);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s = stringArray[i];
                if (g.getFontMetrics().stringWidth(line.toString() + s) > ((AbstractTMSTileSource)this.tileSource).getTileSize()) {
                    ret.append((CharSequence)line).append('\n');
                    line.setLength(0);
                }
                line.append(s).append(' ');
            }
            ret.append((CharSequence)line);
            textToDraw = ret.toString();
        }
        int offset = 0;
        for (String s : textToDraw.split("\n", -1)) {
            g.setColor(Color.black);
            g.drawString(s, x + 1, y + offset + 1);
            g.setColor(oldColor);
            g.drawString(s, x, y + offset);
            offset += g.getFontMetrics().getHeight() + 3;
        }
    }

    private void paintTileText(Tile tile, Graphics2D g) {
        String errorMessage;
        if (tile == null) {
            return;
        }
        Point2D p = this.coordinateConverter.getPixelForTile(tile);
        int fontHeight = g.getFontMetrics().getHeight();
        int x = (int)p.getX();
        int y = (int)p.getY();
        int texty = y + 2 + fontHeight;
        if (tile.hasError() && this.getDisplaySettings().isShowErrors() && (errorMessage = tile.getErrorMessage()) != null) {
            try {
                errorMessage = I18n.tr(tile.getErrorMessage(), new Object[0]);
            }
            catch (IllegalArgumentException e) {
                Logging.debug(e);
            }
            if (!errorMessage.startsWith("Error") && !errorMessage.startsWith(I18n.tr("Error", new Object[0]))) {
                errorMessage = I18n.tr("Error", new Object[0]) + ": " + errorMessage;
            }
            this.myDrawString(g, errorMessage, x + 2, texty);
        }
        if (Logging.isDebugEnabled()) {
            g.setColor(new Color(255, 0, 0, 50));
            g.draw(this.coordinateConverter.getTileShapeScreen(tile));
        }
    }

    private LatLon getShiftedLatLon(EastNorth en) {
        return this.coordinateConverter.getProjecting().eastNorth2latlonClamped(en);
    }

    private ICoordinate getShiftedCoord(EastNorth en) {
        return CoordinateConversion.llToCoor(this.getShiftedLatLon(en));
    }

    protected TileSet getTileSet(ProjectionBounds bounds, int zoom) {
        TileXY t2;
        TileXY t1;
        if (zoom == 0) {
            return new TileSet();
        }
        IProjected topLeftUnshifted = this.coordinateConverter.shiftDisplayToServer(bounds.getMin());
        IProjected botRightUnshifted = this.coordinateConverter.shiftDisplayToServer(bounds.getMax());
        if (this.coordinateConverter.requiresReprojection()) {
            Projection projServer = Projections.getProjectionByCode(this.tileSource.getServerCRS());
            if (projServer == null) {
                throw new IllegalStateException(((AbstractTMSTileSource)this.tileSource).toString());
            }
            ProjectionBounds projBounds = new ProjectionBounds(CoordinateConversion.projToEn(topLeftUnshifted), CoordinateConversion.projToEn(botRightUnshifted));
            ProjectionBounds bbox = projServer.getEastNorthBoundsBox(projBounds, ProjectionRegistry.getProjection());
            t1 = this.tileSource.projectedToTileXY(CoordinateConversion.enToProj(bbox.getMin()), zoom);
            t2 = this.tileSource.projectedToTileXY(CoordinateConversion.enToProj(bbox.getMax()), zoom);
        } else {
            t1 = this.tileSource.projectedToTileXY(topLeftUnshifted, zoom);
            t2 = this.tileSource.projectedToTileXY(botRightUnshifted, zoom);
        }
        return new TileSet(t1, t2, zoom);
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
    }

    private void drawInViewArea(Graphics2D g, MapView mv, ProjectionBounds pb) {
        int zoom = this.currentZoomLevel;
        if (this.getDisplaySettings().isAutoZoom()) {
            zoom = this.getBestZoom();
        }
        DeepTileSet dts = new DeepTileSet(pb, this.getMinZoomLvl(), zoom);
        int displayZoomLevel = zoom;
        boolean noTilesAtZoom = false;
        if (this.getDisplaySettings().isAutoZoom() && this.getDisplaySettings().isAutoLoad()) {
            TileSet ts0 = dts.getTileSet(zoom);
            if (!(ts0.hasVisibleTiles() || ts0.hasLoadingTiles() && !ts0.hasOverzoomedTiles())) {
                noTilesAtZoom = true;
            }
            for (int tmpZoom = zoom; tmpZoom > dts.minZoom; --tmpZoom) {
                if (!dts.getTileSet(tmpZoom).hasVisibleTiles()) continue;
                displayZoomLevel = tmpZoom;
                break;
            }
            while (zoom > displayZoomLevel && !ts0.hasVisibleTiles() && ts0.hasOverzoomedTiles()) {
                zoom = (zoom + displayZoomLevel) / 2;
                ts0 = dts.getTileSet(zoom);
            }
            this.setZoomLevel(zoom, false);
            if (zoom == displayZoomLevel && !ts0.hasLoadingTiles() && zoom < dts.maxZoom) {
                ts0 = dts.getTileSet(++zoom);
            }
            while (zoom > dts.minZoom && ts0.hasOverzoomedTiles() && !ts0.hasLoadingTiles()) {
                ts0 = dts.getTileSet(--zoom);
            }
        } else if (this.getDisplaySettings().isAutoZoom()) {
            this.setZoomLevel(zoom, false);
        }
        TileSet ts = dts.getTileSet(zoom);
        ts.loadAllTiles(false);
        if (displayZoomLevel != zoom) {
            ts = dts.getTileSet(displayZoomLevel);
            if (!dts.getTileSet(displayZoomLevel).hasAllLoadedTiles() && displayZoomLevel < zoom) {
                ts.loadAllTiles(false);
            }
        }
        g.setColor(Color.DARK_GRAY);
        List<Tile> missedTiles = this.paintTileImages(g, ts);
        if (this.getDisplaySettings().isAutoLoad()) {
            ts.overloadTiles();
        }
        int[] otherZooms = new int[]{1, 2, -1, -2, -3, -4, -5};
        for (int zoomOffset : otherZooms) {
            if (!this.getDisplaySettings().isAutoZoom()) break;
            int newzoom = displayZoomLevel + zoomOffset;
            if (newzoom < this.getMinZoomLvl() || newzoom > this.getMaxZoomLvl()) continue;
            if (missedTiles.isEmpty()) break;
            LinkedList<Tile> newlyMissedTiles = new LinkedList<Tile>();
            for (Tile missed : missedTiles) {
                if (zoomOffset > 0 && "no-tile".equals(missed.getValue("tile-info"))) {
                    newlyMissedTiles.add(missed);
                    continue;
                }
                TileSet ts2 = new TileSet(this.tileSource.getCoveringTileRange(missed, newzoom));
                if (ts2.allLoadedTiles().isEmpty()) {
                    if (zoomOffset > 0) {
                        newlyMissedTiles.add(missed);
                        continue;
                    }
                    ts2.loadAllTiles(false);
                }
                if (ts2.tooLarge()) continue;
                newlyMissedTiles.addAll(this.paintTileImages(g, ts2, newzoom, missed));
            }
            missedTiles = newlyMissedTiles;
        }
        if (Logging.isDebugEnabled() && !missedTiles.isEmpty()) {
            Logging.debug("still missed {0} in the end", missedTiles.size());
        }
        g.setColor(Color.red);
        g.setFont(InfoFont);
        Object object = ts.allExistingTiles().iterator();
        while (object.hasNext()) {
            Tile t = (Tile)object.next();
            this.paintTileText(t, g);
        }
        EastNorth min = pb.getMin();
        EastNorth max = pb.getMax();
        this.attribution.paintAttribution(g, mv.getWidth(), mv.getHeight(), this.getShiftedCoord(min), this.getShiftedCoord(max), displayZoomLevel, this);
        g.setColor(Color.lightGray);
        if (ts.insane()) {
            this.myDrawString(g, I18n.tr("zoom in to load any tiles", new Object[0]), 120, 120);
        } else if (ts.tooLarge()) {
            this.myDrawString(g, I18n.tr("zoom in to load more tiles", new Object[0]), 120, 120);
        } else if (!this.getDisplaySettings().isAutoZoom() && ts.tooSmall()) {
            this.myDrawString(g, I18n.tr("increase tiles zoom level (change resolution) to see more detail", new Object[0]), 120, 120);
        }
        if (noTilesAtZoom) {
            this.myDrawString(g, I18n.tr("No tiles at this zoom level", new Object[0]), 120, 120);
        }
        if (Logging.isDebugEnabled()) {
            this.myDrawString(g, I18n.tr("Current zoom: {0}", this.currentZoomLevel), 50, 140);
            this.myDrawString(g, I18n.tr("Display zoom: {0}", displayZoomLevel), 50, 155);
            this.myDrawString(g, I18n.tr("Pixel scale: {0}", this.getScaleFactor(this.currentZoomLevel)), 50, 170);
            this.myDrawString(g, I18n.tr("Best zoom: {0}", this.getBestZoom()), 50, 185);
            this.myDrawString(g, I18n.tr("Estimated cache size: {0}", this.estimateTileCacheSize()), 50, 200);
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                int offset = 200;
                for (String part : ((TMSCachedTileLoader)this.tileLoader).getStats().split("\n", -1)) {
                    this.myDrawString(g, I18n.tr("Cache stats: {0}", part), 50, offset += 15);
                }
            }
        }
    }

    private Tile getTileForPixelpos(int px, int py) {
        Logging.debug("getTileForPixelpos({0}, {1})", px, py);
        TileXY xy = this.coordinateConverter.getTileforPixel(px, py, this.currentZoomLevel);
        return this.getTile(xy.getXIndex(), xy.getYIndex(), this.currentZoomLevel);
    }

    public static void registerMenuAddition(Action addition) {
        menuAdditions.add(new MenuAddition(addition, AbstractTileSourceLayer.class));
    }

    public static void registerMenuAddition(Action addition, Class<? extends AbstractTileSourceLayer<?>> clazz) {
        menuAdditions.add(new MenuAddition(addition, clazz));
    }

    private List<Action> getMenuAdditions() {
        LinkedList menuAdds = menuAdditions.stream().filter(menuAdd -> menuAdd.clazz.isInstance(this)).map(menuAdd -> menuAdd.addition).collect(Collectors.toCollection(LinkedList::new));
        if (!menuAdds.isEmpty()) {
            menuAdds.addFirst(Layer.SeparatorLayerAction.INSTANCE);
        }
        return menuAdds;
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Arrays.asList(this.getLayerListEntries()));
        actions.addAll(Arrays.asList(this.getCommonEntries()));
        actions.addAll(this.getMenuAdditions());
        actions.add(Layer.SeparatorLayerAction.INSTANCE);
        actions.add(new LayerListPopup.InfoAction(this));
        return actions.toArray(new Action[0]);
    }

    public Action[] getLayerListEntries() {
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), MainApplication.getMenu().autoScaleActions.get((Object)AutoScaleAction.AutoScaleMode.LAYER), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new ImageryLayer.OffsetAction(this), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE};
    }

    public Action[] getCommonEntries() {
        return new Action[]{new AutoLoadTilesAction(this), new AutoZoomAction(this), new ShowErrorsAction(this), new IncreaseZoomAction(this), new DecreaseZoomAction(this), new ZoomToBestAction(this), new ZoomToNativeLevelAction(this), new FlushTileCacheAction(this), new LoadErroneousTilesAction(this), new LoadAllTilesAction(this)};
    }

    @Override
    public String getToolTipText() {
        if (this.getDisplaySettings().isAutoLoad()) {
            return I18n.tr("{0} ({1}), automatically downloading in zoom {2}", this.getClass().getSimpleName(), this.getName(), this.currentZoomLevel);
        }
        return I18n.tr("{0} ({1}), downloading in zoom {2}", this.getClass().getSimpleName(), this.getName(), this.currentZoomLevel);
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public PrecacheTask getDownloadAreaToCacheTask(ProgressMonitor progressMonitor, List<LatLon> points, double bufferX, double bufferY) {
        return new PrecacheTask(progressMonitor, points, bufferX, bufferY);
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save WMS file", new Object[0]), WMSLayerImporter.FILE_FILTER);
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        MapView.removeZoomChangeListener(this);
        this.adjustAction.destroy();
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
        super.projectionChanged(oldValue, newValue);
        this.displaySettings.setOffsetBookmark(this.displaySettings.getOffsetBookmark());
        if (this.tileCache != null) {
            this.tileCache.clear();
        }
    }

    @Override
    protected List<ImageryLayer.OffsetMenuEntry> getOffsetMenuEntries() {
        return OffsetBookmark.getBookmarks().stream().filter(b -> b.isUsable(this)).map(x$0 -> new OffsetMenuBookmarkEntry((OffsetBookmark)x$0)).collect(Collectors.toList());
    }

    static {
        new TileSourceDisplaySettings();
        InfoFont = new Font("sansserif", 1, 13);
        menuAdditions = new LinkedList<MenuAddition>();
        PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.generic.min_zoom_lvl", 2);
        PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.generic.max_zoom_lvl", 20);
        ZOOM_OFFSET = new IntegerProperty("imagery.generic.zoom_offset", 0);
        POPUP_MENU_ENABLED = new BooleanProperty("imagery.generic.popupmenu", true);
    }

    private class OffsetMenuBookmarkEntry
    implements ImageryLayer.OffsetMenuEntry {
        private final OffsetBookmark bookmark;

        OffsetMenuBookmarkEntry(OffsetBookmark bookmark) {
            this.bookmark = bookmark;
        }

        @Override
        public String getLabel() {
            return this.bookmark.getName();
        }

        @Override
        public boolean isActive() {
            EastNorth offset = this.bookmark.getDisplacement(ProjectionRegistry.getProjection());
            EastNorth active = AbstractTileSourceLayer.this.getDisplaySettings().getDisplacement();
            return Utils.equalsEpsilon(offset.east(), active.east()) && Utils.equalsEpsilon(offset.north(), active.north());
        }

        @Override
        public void actionPerformed() {
            AbstractTileSourceLayer.this.getDisplaySettings().setOffsetBookmark(this.bookmark);
        }
    }

    private class TileSourcePainter
    extends AbstractMapViewPaintable.CompatibilityModeLayerPainter {
        private MemoryManager.MemoryHandle<?> memory;

        private TileSourcePainter() {
        }

        @Override
        public void paint(MapViewGraphics graphics) {
            this.allocateCacheMemory();
            if (this.memory != null) {
                this.doPaint(graphics);
            }
        }

        private void doPaint(MapViewGraphics graphics) {
            try {
                AbstractTileSourceLayer.this.drawInViewArea(graphics.getDefaultGraphics(), graphics.getMapView(), graphics.getClipBounds().getProjectionBounds());
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw BugReport.intercept(e).put("graphics", graphics).put("tileSource", AbstractTileSourceLayer.this.tileSource).put("currentZoomLevel", AbstractTileSourceLayer.this.currentZoomLevel);
            }
        }

        private void allocateCacheMemory() {
            MemoryManager manager;
            if (this.memory == null && (manager = MemoryManager.getInstance()).isAvailable(this.getEstimatedCacheSize())) {
                try {
                    this.memory = manager.allocateMemory("tile source layer", this.getEstimatedCacheSize(), Object::new);
                }
                catch (MemoryManager.NotEnoughMemoryException e) {
                    Logging.warn("Could not allocate tile source memory", e);
                }
            }
        }

        protected long getEstimatedCacheSize() {
            return 4L * (long)((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileSize() * (long)((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileSize() * (long)AbstractTileSourceLayer.this.estimateTileCacheSize();
        }

        @Override
        public void detachFromMapView(MapViewPaintable.MapViewEvent event) {
            event.getMapView().removeMouseListener(AbstractTileSourceLayer.this.adapter);
            MapView.removeZoomChangeListener(AbstractTileSourceLayer.this);
            super.detachFromMapView(event);
            if (this.memory != null) {
                this.memory.free();
            }
        }
    }

    public class PrecacheTask
    implements TileLoaderListener {
        private final ProgressMonitor progressMonitor;
        private final int totalCount;
        private final AtomicInteger processedCount = new AtomicInteger(0);
        private final TileLoader tileLoader;
        private final Set<Tile> requestedTiles;

        public PrecacheTask(ProgressMonitor progressMonitor, List<LatLon> points, double bufferX, double bufferY) {
            this.progressMonitor = progressMonitor;
            this.tileLoader = AbstractTileSourceLayer.this.getTileLoaderFactory().makeTileLoader(this, AbstractTileSourceLayer.this.getHeaders(AbstractTileSourceLayer.this.tileSource), AbstractTileSourceLayer.this.minimumTileExpire);
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                ((TMSCachedTileLoader)this.tileLoader).setDownloadExecutor(TMSCachedTileLoader.getNewThreadPoolExecutor("Precache downloader"));
            }
            this.requestedTiles = new ConcurrentSkipListSet<Tile>((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey()));
            for (LatLon point : points) {
                TileXY minTile = AbstractTileSourceLayer.this.tileSource.latLonToTileXY(point.lat() - bufferY, point.lon() - bufferX, AbstractTileSourceLayer.this.currentZoomLevel);
                TileXY curTile = ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).latLonToTileXY(CoordinateConversion.llToCoor(point), AbstractTileSourceLayer.this.currentZoomLevel);
                TileXY maxTile = AbstractTileSourceLayer.this.tileSource.latLonToTileXY(point.lat() + bufferY, point.lon() + bufferX, AbstractTileSourceLayer.this.currentZoomLevel);
                int minY = Math.min(curTile.getYIndex() - 1, minTile.getYIndex());
                int maxY = Math.max(curTile.getYIndex() + 1, maxTile.getYIndex());
                int minX = Math.min(curTile.getXIndex() - 1, minTile.getXIndex());
                int maxX = Math.max(curTile.getXIndex() + 1, maxTile.getXIndex());
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        this.requestedTiles.add(new Tile((TileSource)AbstractTileSourceLayer.this.tileSource, x, y, AbstractTileSourceLayer.this.currentZoomLevel));
                    }
                }
            }
            this.totalCount = this.requestedTiles.size();
            this.progressMonitor.setTicksCount(this.requestedTiles.size());
        }

        public boolean isFinished() {
            return this.processedCount.get() >= this.totalCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public void cancel() {
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                ((TMSCachedTileLoader)this.tileLoader).cancelOutstandingTasks();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tileLoadingFinished(Tile tile, boolean success) {
            int processed = this.processedCount.incrementAndGet();
            if (success) {
                ProgressMonitor progressMonitor = this.progressMonitor;
                synchronized (progressMonitor) {
                    if (!this.progressMonitor.isCanceled()) {
                        this.progressMonitor.worked(1);
                        this.progressMonitor.setCustomText(I18n.tr("Downloaded {0}/{1} tiles", processed, this.totalCount));
                    }
                }
            } else {
                Logging.warn("Tile loading failure: " + tile + " - " + tile.getErrorMessage());
            }
        }

        public TileLoader getTileLoader() {
            return this.tileLoader;
        }

        public void run() {
            TileLoader loader = this.getTileLoader();
            for (Tile t : this.requestedTiles) {
                if (this.progressMonitor.isCanceled()) continue;
                loader.createTileLoaderJob(t).submit();
            }
        }
    }

    private static class MenuAddition {
        final Action addition;
        final Class<? extends AbstractTileSourceLayer> clazz;

        MenuAddition(Action addition, Class<? extends AbstractTileSourceLayer> clazz) {
            this.addition = addition;
            this.clazz = clazz;
        }
    }

    private class DeepTileSet {
        private final ProjectionBounds bounds;
        private final int minZoom;
        private final int maxZoom;
        private final TileSet[] tileSets;

        DeepTileSet(ProjectionBounds bounds, int minZoom, int maxZoom) {
            this.bounds = bounds;
            this.minZoom = minZoom;
            this.maxZoom = maxZoom;
            if (minZoom > maxZoom) {
                throw new IllegalArgumentException(minZoom + " > " + maxZoom);
            }
            this.tileSets = new TileSet[maxZoom - minZoom + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileSet getTileSet(int zoom) {
            if (zoom < this.minZoom) {
                return AbstractTileSourceLayer.this.nullTileSet;
            }
            TileSet[] tileSetArray = this.tileSets;
            synchronized (this.tileSets) {
                TileSet ts = this.tileSets[zoom - this.minZoom];
                if (ts == null) {
                    this.tileSets[zoom - this.minZoom] = ts = AbstractTileSourceLayer.this.getTileSet(this.bounds, zoom);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ts;
            }
        }
    }

    private static class TileSetInfo {
        boolean hasVisibleTiles;
        boolean hasOverzoomedTiles;
        boolean hasLoadingTiles;
        boolean hasAllLoadedTiles;

        private TileSetInfo() {
        }
    }

    protected class TileSet
    extends TileRange {
        private volatile TileSetInfo info;

        protected TileSet(TileXY t1, TileXY t2, int zoom) {
            super(t1, t2, zoom);
            this.sanitize();
        }

        protected TileSet(TileRange range) {
            super(range);
            this.sanitize();
        }

        private TileSet() {
        }

        protected void sanitize() {
            this.minX = Utils.clamp(this.minX, ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMin(this.zoom), ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMax(this.zoom));
            this.maxX = Utils.clamp(this.maxX, ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMin(this.zoom), ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMax(this.zoom));
            this.minY = Utils.clamp(this.minY, ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMin(this.zoom), ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMax(this.zoom));
            this.maxY = Utils.clamp(this.maxY, ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMin(this.zoom), ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMax(this.zoom));
        }

        private boolean tooSmall() {
            return this.tilesSpanned() < 2.1;
        }

        private boolean tooLarge() {
            return this.insane() || this.tilesSpanned() > 20.0;
        }

        private boolean insane() {
            return AbstractTileSourceLayer.this.tileCache == null || this.size() > AbstractTileSourceLayer.this.tileCache.getCacheSize();
        }

        private List<Tile> allExistingTiles() {
            return this.allTiles(x$0 -> AbstractTileSourceLayer.this.getTile(x$0));
        }

        private List<Tile> allTilesCreate() {
            return this.allTiles(x$0 -> AbstractTileSourceLayer.this.getOrCreateTile(x$0));
        }

        private List<Tile> allTiles(Function<TilePosition, Tile> mapper) {
            return this.tilePositions().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public Stream<TilePosition> tilePositions() {
            if (this.zoom == 0 || this.insane()) {
                return Stream.empty();
            }
            return IntStream.rangeClosed(this.minX, this.maxX).mapToObj(x -> IntStream.rangeClosed(this.minY, this.maxY).mapToObj(y -> new TilePosition(x, y, this.zoom))).flatMap(Function.identity());
        }

        private List<Tile> allLoadedTiles() {
            return this.allExistingTiles().stream().filter(Tile::isLoaded).collect(Collectors.toList());
        }

        private Comparator<Tile> getTileDistanceComparator() {
            int centerX = (int)Math.ceil((double)(this.minX + this.maxX) / 2.0);
            int centerY = (int)Math.ceil((double)(this.minY + this.maxY) / 2.0);
            return Comparator.comparingInt(t -> Math.abs(t.getXtile() - centerX) + Math.abs(t.getYtile() - centerY));
        }

        private void loadAllTiles(boolean force) {
            if (!AbstractTileSourceLayer.this.getDisplaySettings().isAutoLoad() && !force) {
                return;
            }
            if (this.tooLarge()) {
                Logging.warn("Not downloading all tiles because there is more than 18 tiles on an axis!");
                return;
            }
            List<Tile> allTiles = this.allTilesCreate();
            allTiles.sort(this.getTileDistanceComparator());
            for (Tile t : allTiles) {
                AbstractTileSourceLayer.this.loadTile(t, force);
            }
        }

        private void overloadTiles() {
            int overload = 1;
            int minXo = Utils.clamp(this.minX - overload, ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMin(this.zoom), ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMax(this.zoom));
            int maxXo = Utils.clamp(this.maxX + overload, ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMin(this.zoom), ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMax(this.zoom));
            int minYo = Utils.clamp(this.minY - overload, ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMin(this.zoom), ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMax(this.zoom));
            int maxYo = Utils.clamp(this.maxY + overload, ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMin(this.zoom), ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMax(this.zoom));
            TileSet ts = new TileSet(new TileXY(minXo, minYo), new TileXY(maxXo, maxYo), this.zoom);
            ts.loadAllTiles(false);
        }

        private void loadAllErrorTiles(boolean force) {
            if (!AbstractTileSourceLayer.this.getDisplaySettings().isAutoLoad() && !force) {
                return;
            }
            for (Tile t : this.allTilesCreate()) {
                if (!t.hasError()) continue;
                AbstractTileSourceLayer.this.tileLoader.createTileLoaderJob(t).submit(force);
            }
        }

        public void visitTiles(Consumer<Tile> visitor, Consumer<TilePosition> missed) {
            ((Stream)this.tilePositions().parallel()).forEach(tp -> this.visitTilePosition(visitor, (TilePosition)tp, missed));
        }

        private void visitTilePosition(Consumer<Tile> visitor, TilePosition tp, Consumer<TilePosition> missed) {
            Tile tile = AbstractTileSourceLayer.this.getTile(tp);
            if (tile == null) {
                missed.accept(tp);
            } else {
                visitor.accept(tile);
            }
        }

        public boolean hasVisibleTiles() {
            return this.getTileSetInfo().hasVisibleTiles;
        }

        public boolean hasOverzoomedTiles() {
            return this.getTileSetInfo().hasOverzoomedTiles;
        }

        public boolean hasLoadingTiles() {
            return this.getTileSetInfo().hasLoadingTiles;
        }

        public boolean hasAllLoadedTiles() {
            return this.getTileSetInfo().hasAllLoadedTiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TileSetInfo getTileSetInfo() {
            if (this.info == null) {
                TileSet tileSet = this;
                synchronized (tileSet) {
                    if (this.info == null) {
                        List<Tile> allTiles = this.allExistingTiles();
                        TileSetInfo newInfo = new TileSetInfo();
                        newInfo.hasLoadingTiles = allTiles.size() < this.size();
                        newInfo.hasAllLoadedTiles = true;
                        for (Tile t : allTiles) {
                            if ("no-tile".equals(t.getValue("tile-info"))) {
                                newInfo.hasOverzoomedTiles = true;
                            }
                            if (t.isLoaded()) {
                                if (t.hasError()) continue;
                                newInfo.hasVisibleTiles = true;
                                continue;
                            }
                            newInfo.hasAllLoadedTiles = false;
                            if (!t.isLoading()) continue;
                            newInfo.hasLoadingTiles = true;
                        }
                        this.info = newInfo;
                    }
                }
            }
            return this.info;
        }

        public String toString() {
            return this.getClass().getName() + ": zoom: " + this.zoom + " X(" + this.minX + ", " + this.maxX + ") Y(" + this.minY + ", " + this.maxY + ") size: " + this.size();
        }
    }

    public class TileSourceLayerPopup
    extends JPopupMenu {
        public TileSourceLayerPopup(int x, int y) {
            ArrayList submenus = new ArrayList();
            MainApplication.getLayerManager().getVisibleLayersInZOrder().stream().filter(AbstractTileSourceLayer.class::isInstance).map(AbstractTileSourceLayer.class::cast).forEachOrdered(layer -> {
                JMenu submenu = new JMenu(layer.getName());
                for (Action a : layer.getCommonEntries()) {
                    if (a instanceof Layer.LayerAction) {
                        submenu.add(((Layer.LayerAction)((Object)a)).createMenuComponent());
                        continue;
                    }
                    submenu.add(new JMenuItem(a));
                }
                submenu.add(new JSeparator());
                Tile tile = ((AbstractTileSourceLayer)layer).getTileForPixelpos(x, y);
                submenu.add(new JMenuItem(new LoadTileAction((AbstractTileSourceLayer)layer, tile)));
                submenu.add(new JMenuItem(new ShowTileInfoAction((AbstractTileSourceLayer)layer, tile)));
                if (ExpertToggleAction.isExpert() && AbstractTileSourceLayer.this.tileSource != null && ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).isModTileFeatures()) {
                    submenu.add(new JMenuItem(new GetOsmTileStatusAction((AbstractTileSourceLayer)layer, tile)));
                    submenu.add(new JMenuItem(new MarkOsmTileDirtyAction((AbstractTileSourceLayer)layer, tile)));
                }
                submenus.add(submenu);
            });
            if (submenus.size() == 1) {
                JMenu menu = (JMenu)submenus.get(0);
                Arrays.stream(menu.getMenuComponents()).forEachOrdered(this::add);
            } else if (submenus.size() > 1) {
                submenus.stream().forEachOrdered(this::add);
            }
        }
    }

    private static final class MarkOsmTileDirtyAction
    extends AbstractTileAction {
        private MarkOsmTileDirtyAction(AbstractTileSourceLayer<?> layer, Tile tile) {
            super(I18n.tr("Force tile rendering", new Object[0]), layer, tile);
            this.setEnabled(tile != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractTileSourceLayer.sendOsmTileRequest(this.tile, "dirty");
        }
    }

    private static final class GetOsmTileStatusAction
    extends AbstractTileAction {
        private GetOsmTileStatusAction(AbstractTileSourceLayer<?> layer, Tile tile) {
            super(I18n.tr("Get tile status", new Object[0]), layer, tile);
            this.setEnabled(tile != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractTileSourceLayer.sendOsmTileRequest(this.tile, "status");
        }
    }

    private static final class LoadTileAction
    extends AbstractTileAction {
        private LoadTileAction(AbstractTileSourceLayer<?> layer, Tile tile) {
            super(I18n.tr("Load tile", new Object[0]), layer, tile);
            this.setEnabled(tile != null);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.tile != null) {
                this.layer.loadTile(this.tile, true);
                this.layer.invalidate();
            }
        }
    }

    private static final class ShowTileInfoAction
    extends AbstractTileAction {
        private ShowTileInfoAction(AbstractTileSourceLayer<?> layer, Tile tile) {
            super(I18n.tr("Show tile info", new Object[0]), layer, tile);
            this.setEnabled(tile != null);
        }

        private static String getSizeString(int size) {
            return "" + size + 'x' + size;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.tile != null) {
                ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Tile Info", new Object[0]), I18n.tr("OK", new Object[0]));
                JPanel panel = new JPanel(new GridBagLayout());
                Rectangle2D displaySize = this.layer.coordinateConverter.getRectangleForTile(this.tile);
                String url = "";
                try {
                    url = this.tile.getUrl();
                }
                catch (IOException e) {
                    Logging.trace(e);
                }
                ArrayList<List<String>> content = new ArrayList<List<String>>();
                content.add(Arrays.asList(I18n.tr("Tile name", new Object[0]), this.tile.getKey()));
                content.add(Arrays.asList(I18n.tr("Tile URL", new Object[0]), url));
                if (this.tile.getTileSource() instanceof TemplatedTileSource) {
                    Map<String, String> headers = ((TemplatedTileSource)this.tile.getTileSource()).getHeaders();
                    for (String key : new TreeSet<String>(headers.keySet())) {
                        content.add(Arrays.asList(I18n.tr("Custom header: {0}", key), headers.get(key)));
                    }
                }
                content.add(Arrays.asList(I18n.tr("Tile size", new Object[0]), ShowTileInfoAction.getSizeString(this.tile.getTileSource().getTileSize())));
                content.add(Arrays.asList(I18n.tr("Tile display size", new Object[0]), "" + displaySize.getWidth() + 'x' + displaySize.getHeight()));
                if (this.layer.coordinateConverter.requiresReprojection()) {
                    content.add(Arrays.asList(I18n.tr("Reprojection", new Object[0]), this.tile.getTileSource().getServerCRS() + " -> " + ProjectionRegistry.getProjection().toCode()));
                    BufferedImage img = this.tile.getImage();
                    if (img != null) {
                        content.add(Arrays.asList(I18n.tr("Reprojected tile size", new Object[0]), img.getWidth() + "x" + img.getHeight()));
                    }
                }
                content.add(Arrays.asList(I18n.tr("Status", new Object[0]), I18n.tr(this.tile.getStatus(), new Object[0])));
                content.add(Arrays.asList(I18n.tr("Loaded", new Object[0]), I18n.tr(Boolean.toString(this.tile.isLoaded()), new Object[0])));
                content.add(Arrays.asList(I18n.tr("Loading", new Object[0]), I18n.tr(Boolean.toString(this.tile.isLoading()), new Object[0])));
                content.add(Arrays.asList(I18n.tr("Error", new Object[0]), I18n.tr(Boolean.toString(this.tile.hasError()), new Object[0])));
                for (List list : content) {
                    panel.add((Component)new JLabel((String)list.get(0) + ':'), GBC.std());
                    panel.add(GBC.glue(5, 0), GBC.std());
                    panel.add((Component)this.layer.createTextField((String)list.get(1)), GBC.eol().fill(2));
                }
                for (Map.Entry entry : this.tile.getMetadata().entrySet()) {
                    panel.add((Component)new JLabel(I18n.tr("Metadata ", new Object[0]) + I18n.tr((String)entry.getKey(), new Object[0]) + ':'), GBC.std());
                    panel.add(GBC.glue(5, 0), GBC.std());
                    String value = (String)entry.getValue();
                    if ("lastModification".equals(entry.getKey()) || "expirationTime".equals(entry.getKey())) {
                        value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(Long.parseLong(value)));
                    }
                    panel.add((Component)this.layer.createTextField(value), GBC.eol().fill(2));
                }
                ed.setIcon(1);
                ed.setContent(panel);
                ed.showDialog();
            }
        }
    }

    private static abstract class AbstractTileAction
    extends AbstractAction {
        protected final AbstractTileSourceLayer<?> layer;
        protected final Tile tile;

        AbstractTileAction(String name, AbstractTileSourceLayer<?> layer, Tile tile) {
            super(name);
            this.layer = layer;
            this.tile = tile;
        }
    }
}

