// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from STM32W108.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/STMicro

// +build stm32,stm32w108

// STM32W108
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32W108"
)

// Interrupt numbers.
const (
	IRQ_TIM1_IRQ    = 0  // General purpose timer 1
	IRQ_TIM2_IRQ    = 1  // General purpose timer 2
	IRQ_SLPTIM_IRQ  = 4  // Sleep timer
	IRQ_SC1_IRQ     = 5  // Serial controller 1
	IRQ_SC2_IRQ     = 6  // Serial controller 2
	IRQ_MAC_TIM_IRQ = 8  // MAC timer
	IRQ_ADC_IRQ     = 11 // Analog to Digital Converter
	IRQ_EXTIA_IRQ   = 12 // External interrupt/event controller
	IRQ_EXTIB_IRQ   = 13 // External interrupt/event controller
	IRQ_EXTIC_IRQ   = 14 // External interrupt/event controller
	IRQ_EXTID_IRQ   = 15 // External interrupt/event controller
	IRQ_max         = 15 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_TIM1_IRQ, "TIM1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2_IRQ, "TIM2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_SLPTIM_IRQ, "SLPTIM_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_SC1_IRQ, "SC1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_SC2_IRQ, "SC2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_MAC_TIM_IRQ, "MAC_TIM_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_ADC_IRQ, "ADC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTIA_IRQ, "EXTIA_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTIB_IRQ, "EXTIB_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTIC_IRQ, "EXTIC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTID_IRQ, "EXTID_IRQ_IRQHandler")
)

// Peripherals.
var (
	TIM1     = (*TIM_Type)(unsafe.Pointer(uintptr(0x4000a800)))            // General purpose timer 1
	TIM2     = (*TIM_Type)(unsafe.Pointer(uintptr(0x4000a804)))            // General purpose timer 2
	SC1      = (*SerialControll_Type)(unsafe.Pointer(uintptr(0x4000a808))) // Serial controller 1
	SC2      = (*SerialControll_Type)(unsafe.Pointer(uintptr(0x4000a80c))) // Serial controller 2
	ADC      = (*ADC_Type)(unsafe.Pointer(uintptr(0x4000a810)))            // Analog to Digital Converter
	EXTI     = (*EXTI_Type)(unsafe.Pointer(uintptr(0x4000a814)))           // External interrupt/event controller
	GPIOA    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x4000b000)))           // General purpose I/Os
	GPIOB    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x4000b400)))           // General purpose I/Os
	GPIOC    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x4000b800)))           // General purpose I/Os
	GPIO_DBG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40004028)))           // General purpose I/Os
	WDG      = (*WDG_Type)(unsafe.Pointer(uintptr(0x40006000)))            // Watchdog timer
	CLK      = (*CLK_Type)(unsafe.Pointer(uintptr(0x40000008)))            // Clock
	RST      = (*RST_Type)(unsafe.Pointer(uintptr(0x4000002c)))            // Reset event
	FLASH    = (*FLASH_Type)(unsafe.Pointer(uintptr(0x4000402c)))          // FLASH
	SLPTMR   = (*SLPTMR_Type)(unsafe.Pointer(uintptr(0x4000600c)))         // Sleep timer
	PWR      = (*PWR_Type)(unsafe.Pointer(uintptr(0x40000004)))            // Power control
	NVIC     = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e000)))           // Nested Vectored Interrupt Controller
	MEM      = (*RAM_Type)(unsafe.Pointer(uintptr(0x40005000)))            // Memory Control registers
	SC1_DMA  = (*SerialControll_Type)(unsafe.Pointer(uintptr(0x4000c800))) // Serial controller 1 (Direct memory access)
	SC1_UART = (*SerialControll_Type)(unsafe.Pointer(uintptr(0x4000c848))) // Serial controller 1 (Universal Asynchronous Receiver/Transmitter)
	SC1_I2C  = (*SerialControll_Type)(unsafe.Pointer(uintptr(0x4000c844))) // Serial controller 1 (Serial peripheral interface)
	SC1_SPI  = (*SerialControll_Type)(unsafe.Pointer(uintptr(0x4000c840))) // Serial controller 1 (Serial peripheral interface)
	SC2_DMA  = (*SerialControll_Type)(unsafe.Pointer(uintptr(0x4000c000))) // Serial controller 2 (Direct memory access)
	SC2_I2C  = (*SerialControll_Type)(unsafe.Pointer(uintptr(0x4000c044))) // Serial controller 2 (Serial peripheral interface)
	SC2_SPI  = (*SerialControll_Type)(unsafe.Pointer(uintptr(0x4000c040))) // Serial controller 2 (Serial peripheral interface)
	MAC_TIM  = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002038)))            // MAC timer
)

// General purpose timer 1
type TIM_Type struct {
	TIM1_ISR         volatile.Register32 // 0x0
	_                [20]byte
	TIM1_MISSR       volatile.Register32 // 0x18
	_                [36]byte
	TIM1_IER         volatile.Register32 // 0x40
	_                [14268]byte
	TIM1_CR1         volatile.Register32 // 0x3800
	TIM1_CR2         volatile.Register32 // 0x3804
	TIM1_SMCR        volatile.Register32 // 0x3808
	_                [8]byte
	TIM1_EGR         volatile.Register32 // 0x3814
	TIM1_CCMR1_Input volatile.Register32 // 0x3818
	TIM1_CCMR2_Input volatile.Register32 // 0x381C
	TIM1_CCER        volatile.Register32 // 0x3820
	TIM1_CNT         volatile.Register32 // 0x3824
	TIM1_PSC         volatile.Register32 // 0x3828
	TIM1_ARR         volatile.Register32 // 0x382C
	_                [4]byte
	TIM1_CCR1        volatile.Register32 // 0x3834
	TIM1_CCR2        volatile.Register32 // 0x3838
	TIM1_CCR3        volatile.Register32 // 0x383C
	TIM1_CCR4        volatile.Register32 // 0x3840
	_                [12]byte
	TIM1_OR          volatile.Register32 // 0x3850
}

// Serial controller 1
type SerialControll_Type struct {
	SC1_ISR  volatile.Register32 // 0x0
	_        [60]byte
	SC1_IER  volatile.Register32 // 0x40
	_        [8]byte
	SC1_ICR  volatile.Register32 // 0x4C
	_        [8164]byte
	SC1_DR   volatile.Register32 // 0x2034
	_        [20]byte
	SC1_CR   volatile.Register32 // 0x204C
	_        [8]byte
	SC1_CRR1 volatile.Register32 // 0x2058
	SC1_CRR2 volatile.Register32 // 0x205C
}

// Analog to Digital Converter
type ADC_Type struct {
	ADC_ISR      volatile.Register32 // 0x0
	_            [60]byte
	ADC_IER      volatile.Register32 // 0x40
	_            [10160]byte
	ADC_CR       volatile.Register32 // 0x27F4
	ADC_OFFSETR  volatile.Register32 // 0x27F8
	ADC_GAINR    volatile.Register32 // 0x27FC
	ADC_DMACR    volatile.Register32 // 0x2800
	ADC_DMASR    volatile.Register32 // 0x2804
	ADC_DMAMSAR  volatile.Register32 // 0x2808
	ADC_DMANDTR  volatile.Register32 // 0x280C
	ADC_DMAMNAR  volatile.Register32 // 0x2810
	ADC_DMACNDTR volatile.Register32 // 0x2814
}

// External interrupt/event controller
type EXTI_Type struct {
	EXTI_PR   volatile.Register32 // 0x0
	_         [72]byte
	EXTIA_TSR volatile.Register32 // 0x4C
	EXTIB_TSR volatile.Register32 // 0x50
	EXTIC_TSR volatile.Register32 // 0x54
	EXTID_TSR volatile.Register32 // 0x58
	_         [5028]byte
	EXTIC_CR  volatile.Register32 // 0x1400
	EXTID_CR  volatile.Register32 // 0x1404
}

// General purpose I/Os
type GPIO_Type struct {
	GPIOA_CRL volatile.Register32 // 0x0
	GPIOA_CRH volatile.Register32 // 0x4
	GPIOA_IDR volatile.Register32 // 0x8
	GPIOA_ODR volatile.Register32 // 0xC
	GPIOA_BSR volatile.Register32 // 0x10
	GPIOA_BRR volatile.Register32 // 0x14
}

// Watchdog timer
type WDG_Type struct {
	WDG_CR     volatile.Register32 // 0x0
	WDG_KR     volatile.Register32 // 0x4
	WDG_KICKSR volatile.Register32 // 0x8
}

// Clock
type CLK_Type struct {
	CLK_SLEEPCR  volatile.Register32 // 0x0
	CLK_LSI10KCR volatile.Register32 // 0x4
	CLK_LSI1KCR  volatile.Register32 // 0x8
	_            [16368]byte
	CLK_HSECR1   volatile.Register32 // 0x3FFC
	CLK_HSICR    volatile.Register32 // 0x4000
	_            [4]byte
	CLK_PERIODCR volatile.Register32 // 0x4008
	CLK_PERIODSR volatile.Register32 // 0x400C
	CLK_DITHERCR volatile.Register32 // 0x4010
	CLK_HSECR2   volatile.Register32 // 0x4014
	CLK_CPUCR    volatile.Register32 // 0x4018
}

// Reset event
type RST_Type struct {
	RST_SR volatile.Register32 // 0x0
}

// FLASH
type FLASH_Type struct {
	FLASH_CLKER   volatile.Register32 // 0x0
	FLASH_CLKSR   volatile.Register32 // 0x4
	_             [16332]byte
	FLASH_ACR     volatile.Register32 // 0x3FD4
	FLASH_KEYR    volatile.Register32 // 0x3FD8
	FLASH_OPTKEYR volatile.Register32 // 0x3FDC
	FLASH_SR      volatile.Register32 // 0x3FE0
	FLASH_CR      volatile.Register32 // 0x3FE4
	FLASH_AR      volatile.Register32 // 0x3FE8
	_             [4]byte
	FLASH_OBR     volatile.Register32 // 0x3FF0
	FLASH_WRPR    volatile.Register32 // 0x3FF4
}

// Sleep timer
type SLPTMR_Type struct {
	SLPTMR_CR    volatile.Register32 // 0x0
	SLPTMR_CNTH  volatile.Register32 // 0x4
	SLPTMR_CNTL  volatile.Register32 // 0x8
	SLPTMR_CMPAH volatile.Register32 // 0xC
	SLPTMR_CMPAL volatile.Register32 // 0x10
	SLPTMR_CMPBH volatile.Register32 // 0x14
	SLPTMR_CMPBL volatile.Register32 // 0x18
	_            [16364]byte
	SLPTMR_ISR   volatile.Register32 // 0x4008
	_            [8]byte
	SLPTMR_IFR   volatile.Register32 // 0x4014
	_            [48]byte
	SLPTMR_IER   volatile.Register32 // 0x4048
}

// Power control
type PWR_Type struct {
	PWR_DSLEEPCR1      volatile.Register32 // 0x0
	_                  [12]byte
	PWR_DSLEEPCR2      volatile.Register32 // 0x10
	PWR_VREGCR         volatile.Register32 // 0x14
	_                  [4]byte
	PWR_WAKECR1        volatile.Register32 // 0x1C
	PWR_WAKECR2        volatile.Register32 // 0x20
	PWR_WAKESR         volatile.Register32 // 0x24
	_                  [8]byte
	PWR_CPWRUPREQSR    volatile.Register32 // 0x30
	PWR_CSYSPWRUPREQSR volatile.Register32 // 0x34
	PWR_CSYSPWRUPACKSR volatile.Register32 // 0x38
	PWR_CSYSPWRUPACKCR volatile.Register32 // 0x3C
	_                  [48068]byte
	PWR_WAKEPAR        volatile.Register32 // 0xBC04
	PWR_WAKEPBR        volatile.Register32 // 0xBC08
	PWR_WAKEPCR        volatile.Register32 // 0xBC0C
	_                  [8]byte
	PWR_WAKEFILTR      volatile.Register32 // 0xBC18
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	_     [4]byte
	ICTR  volatile.Register32 // 0x4
	_     [248]byte
	ISER0 volatile.Register32 // 0x100
	_     [124]byte
	ICER0 volatile.Register32 // 0x180
	_     [124]byte
	ISPR0 volatile.Register32 // 0x200
	_     [124]byte
	ICPR0 volatile.Register32 // 0x280
	_     [124]byte
	IABR0 volatile.Register32 // 0x300
	_     [252]byte
	IPR0  volatile.Register32 // 0x400
	IPR1  volatile.Register32 // 0x404
	IPR2  volatile.Register32 // 0x408
	IPR3  volatile.Register32 // 0x40C
	IPR4  volatile.Register32 // 0x410
	_     [2796]byte
	STIR  volatile.Register32 // 0xF00
}

// Memory Control registers
type RAM_Type struct {
	RAMPROTR1 volatile.Register32 // 0x0
	RAMPROTR2 volatile.Register32 // 0x4
	RAMPROTR3 volatile.Register32 // 0x8
	RAMPROTR4 volatile.Register32 // 0xC
	RAMPROTR5 volatile.Register32 // 0x10
	RAMPROTR6 volatile.Register32 // 0x14
	RAMPROTR7 volatile.Register32 // 0x18
	RAMPROTR8 volatile.Register32 // 0x1C
	DMAPROTR1 volatile.Register32 // 0x20
	DMAPROTR2 volatile.Register32 // 0x24
	RAMCR     volatile.Register32 // 0x28
}

// Bitfields for TIM1: General purpose timer 1
const (
	// TIM1_ISR: TIM Interrupt Status Register
	TIM_TIM1_ISR_RSVD_Pos  = 0x8    // Position of RSVD field.
	TIM_TIM1_ISR_RSVD_Msk  = 0x1f00 // Bit mask of RSVD field.
	TIM_TIM1_ISR_TIF_Pos   = 0x6    // Position of TIF field.
	TIM_TIM1_ISR_TIF_Msk   = 0x40   // Bit mask of TIF field.
	TIM_TIM1_ISR_TIF       = 0x40   // Bit TIF.
	TIM_TIM1_ISR_CC4IF_Pos = 0x4    // Position of CC4IF field.
	TIM_TIM1_ISR_CC4IF_Msk = 0x10   // Bit mask of CC4IF field.
	TIM_TIM1_ISR_CC4IF     = 0x10   // Bit CC4IF.
	TIM_TIM1_ISR_CC3IF_Pos = 0x3    // Position of CC3IF field.
	TIM_TIM1_ISR_CC3IF_Msk = 0x8    // Bit mask of CC3IF field.
	TIM_TIM1_ISR_CC3IF     = 0x8    // Bit CC3IF.
	TIM_TIM1_ISR_CC2IF_Pos = 0x2    // Position of CC2IF field.
	TIM_TIM1_ISR_CC2IF_Msk = 0x4    // Bit mask of CC2IF field.
	TIM_TIM1_ISR_CC2IF     = 0x4    // Bit CC2IF.
	TIM_TIM1_ISR_CC1IF_Pos = 0x1    // Position of CC1IF field.
	TIM_TIM1_ISR_CC1IF_Msk = 0x2    // Bit mask of CC1IF field.
	TIM_TIM1_ISR_CC1IF     = 0x2    // Bit CC1IF.
	TIM_TIM1_ISR_UIF_Pos   = 0x0    // Position of UIF field.
	TIM_TIM1_ISR_UIF_Msk   = 0x1    // Bit mask of UIF field.
	TIM_TIM1_ISR_UIF       = 0x1    // Bit UIF.

	// TIM1_MISSR: TIM interrupt missed register
	TIM_TIM1_MISSR_CC4IM_Pos = 0xc    // Position of CC4IM field.
	TIM_TIM1_MISSR_CC4IM_Msk = 0x1000 // Bit mask of CC4IM field.
	TIM_TIM1_MISSR_CC4IM     = 0x1000 // Bit CC4IM.
	TIM_TIM1_MISSR_CC3IM_Pos = 0xb    // Position of CC3IM field.
	TIM_TIM1_MISSR_CC3IM_Msk = 0x800  // Bit mask of CC3IM field.
	TIM_TIM1_MISSR_CC3IM     = 0x800  // Bit CC3IM.
	TIM_TIM1_MISSR_CC2IM_Pos = 0xa    // Position of CC2IM field.
	TIM_TIM1_MISSR_CC2IM_Msk = 0x400  // Bit mask of CC2IM field.
	TIM_TIM1_MISSR_CC2IM     = 0x400  // Bit CC2IM.
	TIM_TIM1_MISSR_CC1IM_Pos = 0x9    // Position of CC1IM field.
	TIM_TIM1_MISSR_CC1IM_Msk = 0x200  // Bit mask of CC1IM field.
	TIM_TIM1_MISSR_CC1IM     = 0x200  // Bit CC1IM.
	TIM_TIM1_MISSR_RSVD_Pos  = 0x0    // Position of RSVD field.
	TIM_TIM1_MISSR_RSVD_Msk  = 0x7f   // Bit mask of RSVD field.

	// TIM1_IER: TIM Interrupt Enable Register
	TIM_TIM1_IER_TIE_Pos   = 0x6  // Position of TIE field.
	TIM_TIM1_IER_TIE_Msk   = 0x40 // Bit mask of TIE field.
	TIM_TIM1_IER_TIE       = 0x40 // Bit TIE.
	TIM_TIM1_IER_CC4IE_Pos = 0x4  // Position of CC4IE field.
	TIM_TIM1_IER_CC4IE_Msk = 0x10 // Bit mask of CC4IE field.
	TIM_TIM1_IER_CC4IE     = 0x10 // Bit CC4IE.
	TIM_TIM1_IER_CC3IE_Pos = 0x3  // Position of CC3IE field.
	TIM_TIM1_IER_CC3IE_Msk = 0x8  // Bit mask of CC3IE field.
	TIM_TIM1_IER_CC3IE     = 0x8  // Bit CC3IE.
	TIM_TIM1_IER_CC2IE_Pos = 0x2  // Position of CC2IE field.
	TIM_TIM1_IER_CC2IE_Msk = 0x4  // Bit mask of CC2IE field.
	TIM_TIM1_IER_CC2IE     = 0x4  // Bit CC2IE.
	TIM_TIM1_IER_CC1IE_Pos = 0x1  // Position of CC1IE field.
	TIM_TIM1_IER_CC1IE_Msk = 0x2  // Bit mask of CC1IE field.
	TIM_TIM1_IER_CC1IE     = 0x2  // Bit CC1IE.
	TIM_TIM1_IER_UIE_Pos   = 0x0  // Position of UIE field.
	TIM_TIM1_IER_UIE_Msk   = 0x1  // Bit mask of UIE field.
	TIM_TIM1_IER_UIE       = 0x1  // Bit UIE.

	// TIM1_CR1: control register 1
	TIM_TIM1_CR1_ARBE_Pos = 0x7  // Position of ARBE field.
	TIM_TIM1_CR1_ARBE_Msk = 0x80 // Bit mask of ARBE field.
	TIM_TIM1_CR1_ARBE     = 0x80 // Bit ARBE.
	TIM_TIM1_CR1_CMS_Pos  = 0x5  // Position of CMS field.
	TIM_TIM1_CR1_CMS_Msk  = 0x60 // Bit mask of CMS field.
	TIM_TIM1_CR1_DIR_Pos  = 0x4  // Position of DIR field.
	TIM_TIM1_CR1_DIR_Msk  = 0x10 // Bit mask of DIR field.
	TIM_TIM1_CR1_DIR      = 0x10 // Bit DIR.
	TIM_TIM1_CR1_OPM_Pos  = 0x3  // Position of OPM field.
	TIM_TIM1_CR1_OPM_Msk  = 0x8  // Bit mask of OPM field.
	TIM_TIM1_CR1_OPM      = 0x8  // Bit OPM.
	TIM_TIM1_CR1_URS_Pos  = 0x2  // Position of URS field.
	TIM_TIM1_CR1_URS_Msk  = 0x4  // Bit mask of URS field.
	TIM_TIM1_CR1_URS      = 0x4  // Bit URS.
	TIM_TIM1_CR1_UDIS_Pos = 0x1  // Position of UDIS field.
	TIM_TIM1_CR1_UDIS_Msk = 0x2  // Bit mask of UDIS field.
	TIM_TIM1_CR1_UDIS     = 0x2  // Bit UDIS.
	TIM_TIM1_CR1_CEN_Pos  = 0x0  // Position of CEN field.
	TIM_TIM1_CR1_CEN_Msk  = 0x1  // Bit mask of CEN field.
	TIM_TIM1_CR1_CEN      = 0x1  // Bit CEN.

	// TIM1_CR2: control register 2
	TIM_TIM1_CR2_TI1S_Pos = 0x7  // Position of TI1S field.
	TIM_TIM1_CR2_TI1S_Msk = 0x80 // Bit mask of TI1S field.
	TIM_TIM1_CR2_TI1S     = 0x80 // Bit TI1S.
	TIM_TIM1_CR2_MMS_Pos  = 0x4  // Position of MMS field.
	TIM_TIM1_CR2_MMS_Msk  = 0x70 // Bit mask of MMS field.

	// TIM1_SMCR: slave Mode Control register
	TIM_TIM1_SMCR_ETP_Pos  = 0xf    // Position of ETP field.
	TIM_TIM1_SMCR_ETP_Msk  = 0x8000 // Bit mask of ETP field.
	TIM_TIM1_SMCR_ETP      = 0x8000 // Bit ETP.
	TIM_TIM1_SMCR_ECE_Pos  = 0xe    // Position of ECE field.
	TIM_TIM1_SMCR_ECE_Msk  = 0x4000 // Bit mask of ECE field.
	TIM_TIM1_SMCR_ECE      = 0x4000 // Bit ECE.
	TIM_TIM1_SMCR_ETPS_Pos = 0xc    // Position of ETPS field.
	TIM_TIM1_SMCR_ETPS_Msk = 0x3000 // Bit mask of ETPS field.
	TIM_TIM1_SMCR_ETF_Pos  = 0x8    // Position of ETF field.
	TIM_TIM1_SMCR_ETF_Msk  = 0xf00  // Bit mask of ETF field.
	TIM_TIM1_SMCR_MSM_Pos  = 0x7    // Position of MSM field.
	TIM_TIM1_SMCR_MSM_Msk  = 0x80   // Bit mask of MSM field.
	TIM_TIM1_SMCR_MSM      = 0x80   // Bit MSM.
	TIM_TIM1_SMCR_TS_Pos   = 0x4    // Position of TS field.
	TIM_TIM1_SMCR_TS_Msk   = 0x70   // Bit mask of TS field.
	TIM_TIM1_SMCR_SMS_Pos  = 0x0    // Position of SMS field.
	TIM_TIM1_SMCR_SMS_Msk  = 0x7    // Bit mask of SMS field.

	// TIM1_EGR: TIM event generation register
	TIM_TIM1_EGR_TG_Pos   = 0x6  // Position of TG field.
	TIM_TIM1_EGR_TG_Msk   = 0x40 // Bit mask of TG field.
	TIM_TIM1_EGR_TG       = 0x40 // Bit TG.
	TIM_TIM1_EGR_CC4G_Pos = 0x4  // Position of CC4G field.
	TIM_TIM1_EGR_CC4G_Msk = 0x10 // Bit mask of CC4G field.
	TIM_TIM1_EGR_CC4G     = 0x10 // Bit CC4G.
	TIM_TIM1_EGR_CC3G_Pos = 0x3  // Position of CC3G field.
	TIM_TIM1_EGR_CC3G_Msk = 0x8  // Bit mask of CC3G field.
	TIM_TIM1_EGR_CC3G     = 0x8  // Bit CC3G.
	TIM_TIM1_EGR_CC2G_Pos = 0x2  // Position of CC2G field.
	TIM_TIM1_EGR_CC2G_Msk = 0x4  // Bit mask of CC2G field.
	TIM_TIM1_EGR_CC2G     = 0x4  // Bit CC2G.
	TIM_TIM1_EGR_CC1G_Pos = 0x1  // Position of CC1G field.
	TIM_TIM1_EGR_CC1G_Msk = 0x2  // Bit mask of CC1G field.
	TIM_TIM1_EGR_CC1G     = 0x2  // Bit CC1G.
	TIM_TIM1_EGR_UG_Pos   = 0x0  // Position of UG field.
	TIM_TIM1_EGR_UG_Msk   = 0x1  // Bit mask of UG field.
	TIM_TIM1_EGR_UG       = 0x1  // Bit UG.

	// TIM1_CCMR1_Input: capture/compare mode register 1 (Input           mode)
	TIM_TIM1_CCMR1_Input_CC1S_Pos   = 0x0    // Position of CC1S field.
	TIM_TIM1_CCMR1_Input_CC1S_Msk   = 0x3    // Bit mask of CC1S field.
	TIM_TIM1_CCMR1_Input_IC1PSC_Pos = 0x2    // Position of IC1PSC field.
	TIM_TIM1_CCMR1_Input_IC1PSC_Msk = 0xc    // Bit mask of IC1PSC field.
	TIM_TIM1_CCMR1_Input_IC1F_Pos   = 0x4    // Position of IC1F field.
	TIM_TIM1_CCMR1_Input_IC1F_Msk   = 0xf0   // Bit mask of IC1F field.
	TIM_TIM1_CCMR1_Input_CC2S_Pos   = 0x8    // Position of CC2S field.
	TIM_TIM1_CCMR1_Input_CC2S_Msk   = 0x300  // Bit mask of CC2S field.
	TIM_TIM1_CCMR1_Input_IC2PSC_Pos = 0xa    // Position of IC2PSC field.
	TIM_TIM1_CCMR1_Input_IC2PSC_Msk = 0xc00  // Bit mask of IC2PSC field.
	TIM_TIM1_CCMR1_Input_IC2F_Pos   = 0xc    // Position of IC2F field.
	TIM_TIM1_CCMR1_Input_IC2F_Msk   = 0xf000 // Bit mask of IC2F field.

	// TIM1_CCMR1_Output: capture/compare mode register 1 (output           mode)
	TIM_TIM1_CCMR1_Output_OC2M_Pos  = 0xc    // Position of OC2M field.
	TIM_TIM1_CCMR1_Output_OC2M_Msk  = 0x7000 // Bit mask of OC2M field.
	TIM_TIM1_CCMR1_Output_OC2PE_Pos = 0xb    // Position of OC2PE field.
	TIM_TIM1_CCMR1_Output_OC2PE_Msk = 0x800  // Bit mask of OC2PE field.
	TIM_TIM1_CCMR1_Output_OC2PE     = 0x800  // Bit OC2PE.
	TIM_TIM1_CCMR1_Output_OC2FE_Pos = 0xa    // Position of OC2FE field.
	TIM_TIM1_CCMR1_Output_OC2FE_Msk = 0x400  // Bit mask of OC2FE field.
	TIM_TIM1_CCMR1_Output_OC2FE     = 0x400  // Bit OC2FE.
	TIM_TIM1_CCMR1_Output_CC2S_Pos  = 0x8    // Position of CC2S field.
	TIM_TIM1_CCMR1_Output_CC2S_Msk  = 0x300  // Bit mask of CC2S field.
	TIM_TIM1_CCMR1_Output_OC1M_Pos  = 0x4    // Position of OC1M field.
	TIM_TIM1_CCMR1_Output_OC1M_Msk  = 0x70   // Bit mask of OC1M field.
	TIM_TIM1_CCMR1_Output_OC1PE_Pos = 0x3    // Position of OC1PE field.
	TIM_TIM1_CCMR1_Output_OC1PE_Msk = 0x8    // Bit mask of OC1PE field.
	TIM_TIM1_CCMR1_Output_OC1PE     = 0x8    // Bit OC1PE.
	TIM_TIM1_CCMR1_Output_OC1FE_Pos = 0x2    // Position of OC1FE field.
	TIM_TIM1_CCMR1_Output_OC1FE_Msk = 0x4    // Bit mask of OC1FE field.
	TIM_TIM1_CCMR1_Output_OC1FE     = 0x4    // Bit OC1FE.
	TIM_TIM1_CCMR1_Output_CC1S_Pos  = 0x0    // Position of CC1S field.
	TIM_TIM1_CCMR1_Output_CC1S_Msk  = 0x3    // Bit mask of CC1S field.

	// TIM1_CCMR2_Input: capture/compare mode register 2 (input           mode)
	TIM_TIM1_CCMR2_Input_CC3S_Pos   = 0x0    // Position of CC3S field.
	TIM_TIM1_CCMR2_Input_CC3S_Msk   = 0x3    // Bit mask of CC3S field.
	TIM_TIM1_CCMR2_Input_IC3PSC_Pos = 0x2    // Position of IC3PSC field.
	TIM_TIM1_CCMR2_Input_IC3PSC_Msk = 0xc    // Bit mask of IC3PSC field.
	TIM_TIM1_CCMR2_Input_IC3F_Pos   = 0x4    // Position of IC3F field.
	TIM_TIM1_CCMR2_Input_IC3F_Msk   = 0xf0   // Bit mask of IC3F field.
	TIM_TIM1_CCMR2_Input_CC4S_Pos   = 0x8    // Position of CC4S field.
	TIM_TIM1_CCMR2_Input_CC4S_Msk   = 0x300  // Bit mask of CC4S field.
	TIM_TIM1_CCMR2_Input_IC4PSC_Pos = 0xa    // Position of IC4PSC field.
	TIM_TIM1_CCMR2_Input_IC4PSC_Msk = 0xc00  // Bit mask of IC4PSC field.
	TIM_TIM1_CCMR2_Input_IC4F_Pos   = 0xc    // Position of IC4F field.
	TIM_TIM1_CCMR2_Input_IC4F_Msk   = 0xf000 // Bit mask of IC4F field.

	// TIM1_CCMR2_Output: capture/compare mode register 2 (output           mode)
	TIM_TIM1_CCMR2_Output_OC4M_Pos  = 0xc    // Position of OC4M field.
	TIM_TIM1_CCMR2_Output_OC4M_Msk  = 0x7000 // Bit mask of OC4M field.
	TIM_TIM1_CCMR2_Output_OC4PE_Pos = 0xb    // Position of OC4PE field.
	TIM_TIM1_CCMR2_Output_OC4PE_Msk = 0x800  // Bit mask of OC4PE field.
	TIM_TIM1_CCMR2_Output_OC4PE     = 0x800  // Bit OC4PE.
	TIM_TIM1_CCMR2_Output_OC4FE_Pos = 0xa    // Position of OC4FE field.
	TIM_TIM1_CCMR2_Output_OC4FE_Msk = 0x400  // Bit mask of OC4FE field.
	TIM_TIM1_CCMR2_Output_OC4FE     = 0x400  // Bit OC4FE.
	TIM_TIM1_CCMR2_Output_CC4S_Pos  = 0x8    // Position of CC4S field.
	TIM_TIM1_CCMR2_Output_CC4S_Msk  = 0x300  // Bit mask of CC4S field.
	TIM_TIM1_CCMR2_Output_OC3M_Pos  = 0x4    // Position of OC3M field.
	TIM_TIM1_CCMR2_Output_OC3M_Msk  = 0x70   // Bit mask of OC3M field.
	TIM_TIM1_CCMR2_Output_OC3PE_Pos = 0x3    // Position of OC3PE field.
	TIM_TIM1_CCMR2_Output_OC3PE_Msk = 0x8    // Bit mask of OC3PE field.
	TIM_TIM1_CCMR2_Output_OC3PE     = 0x8    // Bit OC3PE.
	TIM_TIM1_CCMR2_Output_OC3FE_Pos = 0x2    // Position of OC3FE field.
	TIM_TIM1_CCMR2_Output_OC3FE_Msk = 0x4    // Bit mask of OC3FE field.
	TIM_TIM1_CCMR2_Output_OC3FE     = 0x4    // Bit OC3FE.
	TIM_TIM1_CCMR2_Output_CC3S_Pos  = 0x0    // Position of CC3S field.
	TIM_TIM1_CCMR2_Output_CC3S_Msk  = 0x3    // Bit mask of CC3S field.

	// TIM1_CCER: TIM capture/compare enable           register
	TIM_TIM1_CCER_CC4P_Pos = 0xd    // Position of CC4P field.
	TIM_TIM1_CCER_CC4P_Msk = 0x2000 // Bit mask of CC4P field.
	TIM_TIM1_CCER_CC4P     = 0x2000 // Bit CC4P.
	TIM_TIM1_CCER_CC4E_Pos = 0xc    // Position of CC4E field.
	TIM_TIM1_CCER_CC4E_Msk = 0x1000 // Bit mask of CC4E field.
	TIM_TIM1_CCER_CC4E     = 0x1000 // Bit CC4E.
	TIM_TIM1_CCER_CC3P_Pos = 0x9    // Position of CC3P field.
	TIM_TIM1_CCER_CC3P_Msk = 0x200  // Bit mask of CC3P field.
	TIM_TIM1_CCER_CC3P     = 0x200  // Bit CC3P.
	TIM_TIM1_CCER_CC3E_Pos = 0x8    // Position of CC3E field.
	TIM_TIM1_CCER_CC3E_Msk = 0x100  // Bit mask of CC3E field.
	TIM_TIM1_CCER_CC3E     = 0x100  // Bit CC3E.
	TIM_TIM1_CCER_CC2P_Pos = 0x5    // Position of CC2P field.
	TIM_TIM1_CCER_CC2P_Msk = 0x20   // Bit mask of CC2P field.
	TIM_TIM1_CCER_CC2P     = 0x20   // Bit CC2P.
	TIM_TIM1_CCER_CC2E_Pos = 0x4    // Position of CC2E field.
	TIM_TIM1_CCER_CC2E_Msk = 0x10   // Bit mask of CC2E field.
	TIM_TIM1_CCER_CC2E     = 0x10   // Bit CC2E.
	TIM_TIM1_CCER_CC1P_Pos = 0x1    // Position of CC1P field.
	TIM_TIM1_CCER_CC1P_Msk = 0x2    // Bit mask of CC1P field.
	TIM_TIM1_CCER_CC1P     = 0x2    // Bit CC1P.
	TIM_TIM1_CCER_CC1E_Pos = 0x0    // Position of CC1E field.
	TIM_TIM1_CCER_CC1E_Msk = 0x1    // Bit mask of CC1E field.
	TIM_TIM1_CCER_CC1E     = 0x1    // Bit CC1E.

	// TIM1_CNT: TIM counter register
	TIM_TIM1_CNT_CNT_Pos = 0x0    // Position of CNT field.
	TIM_TIM1_CNT_CNT_Msk = 0xffff // Bit mask of CNT field.

	// TIM1_PSC: TIM prescaler register
	TIM_TIM1_PSC_PSC_Pos = 0x0    // Position of PSC field.
	TIM_TIM1_PSC_PSC_Msk = 0xffff // Bit mask of PSC field.

	// TIM1_ARR: TIM auto-reload register
	TIM_TIM1_ARR_ARR_Pos = 0x0    // Position of ARR field.
	TIM_TIM1_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.

	// TIM1_CCR1: IM capture/compare register 1
	TIM_TIM1_CCR1_CCR_Pos = 0x0    // Position of CCR field.
	TIM_TIM1_CCR1_CCR_Msk = 0xffff // Bit mask of CCR field.

	// TIM1_CCR2: TIM capture/compare register 2
	TIM_TIM1_CCR2_CCR_Pos = 0x0    // Position of CCR field.
	TIM_TIM1_CCR2_CCR_Msk = 0xffff // Bit mask of CCR field.

	// TIM1_CCR3: TIM capture/compare register 3
	TIM_TIM1_CCR3_CCR_Pos = 0x0    // Position of CCR field.
	TIM_TIM1_CCR3_CCR_Msk = 0xffff // Bit mask of CCR field.

	// TIM1_CCR4: TIM capture/compare register 4
	TIM_TIM1_CCR4_CCR_Pos = 0x0    // Position of CCR field.
	TIM_TIM1_CCR4_CCR_Msk = 0xffff // Bit mask of CCR field.

	// TIM1_OR: TIM option register
	TIM_TIM1_OR_ORRSVD_Pos    = 0x3 // Position of ORRSVD field.
	TIM_TIM1_OR_ORRSVD_Msk    = 0x8 // Bit mask of ORRSVD field.
	TIM_TIM1_OR_ORRSVD        = 0x8 // Bit ORRSVD.
	TIM_TIM1_OR_CLKMSKEN_Pos  = 0x2 // Position of CLKMSKEN field.
	TIM_TIM1_OR_CLKMSKEN_Msk  = 0x4 // Bit mask of CLKMSKEN field.
	TIM_TIM1_OR_CLKMSKEN      = 0x4 // Bit CLKMSKEN.
	TIM_TIM1_OR_EXTRIGSEL_Pos = 0x0 // Position of EXTRIGSEL field.
	TIM_TIM1_OR_EXTRIGSEL_Msk = 0x3 // Bit mask of EXTRIGSEL field.
)

// Bitfields for SC1: Serial controller 1
const (
	// SC1_ISR: Serial controller interrupt status           register
	SerialControll_SC1_ISR_PE_Pos      = 0xe    // Position of PE field.
	SerialControll_SC1_ISR_PE_Msk      = 0x4000 // Bit mask of PE field.
	SerialControll_SC1_ISR_PE          = 0x4000 // Bit PE.
	SerialControll_SC1_ISR_FE_Pos      = 0xd    // Position of FE field.
	SerialControll_SC1_ISR_FE_Msk      = 0x2000 // Bit mask of FE field.
	SerialControll_SC1_ISR_FE          = 0x2000 // Bit FE.
	SerialControll_SC1_ISR_TXULODB_Pos = 0xc    // Position of TXULODB field.
	SerialControll_SC1_ISR_TXULODB_Msk = 0x1000 // Bit mask of TXULODB field.
	SerialControll_SC1_ISR_TXULODB     = 0x1000 // Bit TXULODB.
	SerialControll_SC1_ISR_TXULODA_Pos = 0xb    // Position of TXULODA field.
	SerialControll_SC1_ISR_TXULODA_Msk = 0x800  // Bit mask of TXULODA field.
	SerialControll_SC1_ISR_TXULODA     = 0x800  // Bit TXULODA.
	SerialControll_SC1_ISR_RXULODB_Pos = 0xa    // Position of RXULODB field.
	SerialControll_SC1_ISR_RXULODB_Msk = 0x400  // Bit mask of RXULODB field.
	SerialControll_SC1_ISR_RXULODB     = 0x400  // Bit RXULODB.
	SerialControll_SC1_ISR_RXULODA_Pos = 0x9    // Position of RXULODA field.
	SerialControll_SC1_ISR_RXULODA_Msk = 0x200  // Bit mask of RXULODA field.
	SerialControll_SC1_ISR_RXULODA     = 0x200  // Bit RXULODA.
	SerialControll_SC1_ISR_NACK_Pos    = 0x8    // Position of NACK field.
	SerialControll_SC1_ISR_NACK_Msk    = 0x100  // Bit mask of NACK field.
	SerialControll_SC1_ISR_NACK        = 0x100  // Bit NACK.
	SerialControll_SC1_ISR_CMDFIN_Pos  = 0x7    // Position of CMDFIN field.
	SerialControll_SC1_ISR_CMDFIN_Msk  = 0x80   // Bit mask of CMDFIN field.
	SerialControll_SC1_ISR_CMDFIN      = 0x80   // Bit CMDFIN.
	SerialControll_SC1_ISR_BTF_Pos     = 0x6    // Position of BTF field.
	SerialControll_SC1_ISR_BTF_Msk     = 0x40   // Bit mask of BTF field.
	SerialControll_SC1_ISR_BTF         = 0x40   // Bit BTF.
	SerialControll_SC1_ISR_BRF_Pos     = 0x5    // Position of BRF field.
	SerialControll_SC1_ISR_BRF_Msk     = 0x20   // Bit mask of BRF field.
	SerialControll_SC1_ISR_BRF         = 0x20   // Bit BRF.
	SerialControll_SC1_ISR_UDR_Pos     = 0x4    // Position of UDR field.
	SerialControll_SC1_ISR_UDR_Msk     = 0x10   // Bit mask of UDR field.
	SerialControll_SC1_ISR_UDR         = 0x10   // Bit UDR.
	SerialControll_SC1_ISR_OVR_Pos     = 0x3    // Position of OVR field.
	SerialControll_SC1_ISR_OVR_Msk     = 0x8    // Bit mask of OVR field.
	SerialControll_SC1_ISR_OVR         = 0x8    // Bit OVR.
	SerialControll_SC1_ISR_IDLE_Pos    = 0x2    // Position of IDLE field.
	SerialControll_SC1_ISR_IDLE_Msk    = 0x4    // Bit mask of IDLE field.
	SerialControll_SC1_ISR_IDLE        = 0x4    // Bit IDLE.
	SerialControll_SC1_ISR_TXE_Pos     = 0x1    // Position of TXE field.
	SerialControll_SC1_ISR_TXE_Msk     = 0x2    // Bit mask of TXE field.
	SerialControll_SC1_ISR_TXE         = 0x2    // Bit TXE.
	SerialControll_SC1_ISR_RXNE_Pos    = 0x0    // Position of RXNE field.
	SerialControll_SC1_ISR_RXNE_Msk    = 0x1    // Bit mask of RXNE field.
	SerialControll_SC1_ISR_RXNE        = 0x1    // Bit RXNE.

	// SC1_IER: Serial controller interrupt enable           register
	SerialControll_SC1_IER_PEIE_Pos      = 0xe    // Position of PEIE field.
	SerialControll_SC1_IER_PEIE_Msk      = 0x4000 // Bit mask of PEIE field.
	SerialControll_SC1_IER_PEIE          = 0x4000 // Bit PEIE.
	SerialControll_SC1_IER_FEIE_Pos      = 0xd    // Position of FEIE field.
	SerialControll_SC1_IER_FEIE_Msk      = 0x2000 // Bit mask of FEIE field.
	SerialControll_SC1_IER_FEIE          = 0x2000 // Bit FEIE.
	SerialControll_SC1_IER_TXULODBIE_Pos = 0xc    // Position of TXULODBIE field.
	SerialControll_SC1_IER_TXULODBIE_Msk = 0x1000 // Bit mask of TXULODBIE field.
	SerialControll_SC1_IER_TXULODBIE     = 0x1000 // Bit TXULODBIE.
	SerialControll_SC1_IER_TXULODAIE_Pos = 0xb    // Position of TXULODAIE field.
	SerialControll_SC1_IER_TXULODAIE_Msk = 0x800  // Bit mask of TXULODAIE field.
	SerialControll_SC1_IER_TXULODAIE     = 0x800  // Bit TXULODAIE.
	SerialControll_SC1_IER_RXULODBIE_Pos = 0xa    // Position of RXULODBIE field.
	SerialControll_SC1_IER_RXULODBIE_Msk = 0x400  // Bit mask of RXULODBIE field.
	SerialControll_SC1_IER_RXULODBIE     = 0x400  // Bit RXULODBIE.
	SerialControll_SC1_IER_RXULODAIE_Pos = 0x9    // Position of RXULODAIE field.
	SerialControll_SC1_IER_RXULODAIE_Msk = 0x200  // Bit mask of RXULODAIE field.
	SerialControll_SC1_IER_RXULODAIE     = 0x200  // Bit RXULODAIE.
	SerialControll_SC1_IER_NACKIE_Pos    = 0x8    // Position of NACKIE field.
	SerialControll_SC1_IER_NACKIE_Msk    = 0x100  // Bit mask of NACKIE field.
	SerialControll_SC1_IER_NACKIE        = 0x100  // Bit NACKIE.
	SerialControll_SC1_IER_CMDFINIE_Pos  = 0x7    // Position of CMDFINIE field.
	SerialControll_SC1_IER_CMDFINIE_Msk  = 0x80   // Bit mask of CMDFINIE field.
	SerialControll_SC1_IER_CMDFINIE      = 0x80   // Bit CMDFINIE.
	SerialControll_SC1_IER_BTFIE_Pos     = 0x6    // Position of BTFIE field.
	SerialControll_SC1_IER_BTFIE_Msk     = 0x40   // Bit mask of BTFIE field.
	SerialControll_SC1_IER_BTFIE         = 0x40   // Bit BTFIE.
	SerialControll_SC1_IER_BRFIE_Pos     = 0x5    // Position of BRFIE field.
	SerialControll_SC1_IER_BRFIE_Msk     = 0x20   // Bit mask of BRFIE field.
	SerialControll_SC1_IER_BRFIE         = 0x20   // Bit BRFIE.
	SerialControll_SC1_IER_UDRIE_Pos     = 0x4    // Position of UDRIE field.
	SerialControll_SC1_IER_UDRIE_Msk     = 0x10   // Bit mask of UDRIE field.
	SerialControll_SC1_IER_UDRIE         = 0x10   // Bit UDRIE.
	SerialControll_SC1_IER_OVRIE_Pos     = 0x3    // Position of OVRIE field.
	SerialControll_SC1_IER_OVRIE_Msk     = 0x8    // Bit mask of OVRIE field.
	SerialControll_SC1_IER_OVRIE         = 0x8    // Bit OVRIE.
	SerialControll_SC1_IER_IDLEIE_Pos    = 0x2    // Position of IDLEIE field.
	SerialControll_SC1_IER_IDLEIE_Msk    = 0x4    // Bit mask of IDLEIE field.
	SerialControll_SC1_IER_IDLEIE        = 0x4    // Bit IDLEIE.
	SerialControll_SC1_IER_TXEIE_Pos     = 0x1    // Position of TXEIE field.
	SerialControll_SC1_IER_TXEIE_Msk     = 0x2    // Bit mask of TXEIE field.
	SerialControll_SC1_IER_TXEIE         = 0x2    // Bit TXEIE.
	SerialControll_SC1_IER_RXNEIE_Pos    = 0x0    // Position of RXNEIE field.
	SerialControll_SC1_IER_RXNEIE_Msk    = 0x1    // Bit mask of RXNEIE field.
	SerialControll_SC1_IER_RXNEIE        = 0x1    // Bit RXNEIE.

	// SC1_ICR: Serial controller interrupt control           register
	SerialControll_SC1_ICR_IDLELEVEL_Pos = 0x2 // Position of IDLELEVEL field.
	SerialControll_SC1_ICR_IDLELEVEL_Msk = 0x4 // Bit mask of IDLELEVEL field.
	SerialControll_SC1_ICR_IDLELEVEL     = 0x4 // Bit IDLELEVEL.
	SerialControll_SC1_ICR_TXELEVEL_Pos  = 0x1 // Position of TXELEVEL field.
	SerialControll_SC1_ICR_TXELEVEL_Msk  = 0x2 // Bit mask of TXELEVEL field.
	SerialControll_SC1_ICR_TXELEVEL      = 0x2 // Bit TXELEVEL.
	SerialControll_SC1_ICR_RXNELEVEL_Pos = 0x0 // Position of RXNELEVEL field.
	SerialControll_SC1_ICR_RXNELEVEL_Msk = 0x1 // Bit mask of RXNELEVEL field.
	SerialControll_SC1_ICR_RXNELEVEL     = 0x1 // Bit RXNELEVEL.

	// SC1_DR: Serial control Data register
	SerialControll_SC1_DR_DR_Pos = 0x0  // Position of DR field.
	SerialControll_SC1_DR_DR_Msk = 0xff // Bit mask of DR field.

	// SC1_CR: Serial controller control           register
	SerialControll_SC1_CR_MODE_Pos = 0x0 // Position of MODE field.
	SerialControll_SC1_CR_MODE_Msk = 0x3 // Bit mask of MODE field.

	// SC1_CRR1: Serial controller clock rate           register
	SerialControll_SC1_CRR1_LIN_Pos = 0x0 // Position of LIN field.
	SerialControll_SC1_CRR1_LIN_Msk = 0xf // Bit mask of LIN field.

	// SC1_CRR2: Serial controller clock rate register           2
	SerialControll_SC1_CRR2_EXP_Pos = 0x0 // Position of EXP field.
	SerialControll_SC1_CRR2_EXP_Msk = 0xf // Bit mask of EXP field.
)

// Bitfields for ADC: Analog to Digital Converter
const (
	// ADC_ISR: ADC interrupt status register
	ADC_ADC_ISR_DMAOVF_Pos = 0x4  // Position of DMAOVF field.
	ADC_ADC_ISR_DMAOVF_Msk = 0x10 // Bit mask of DMAOVF field.
	ADC_ADC_ISR_DMAOVF     = 0x10 // Bit DMAOVF.
	ADC_ADC_ISR_SAT_Pos    = 0x3  // Position of SAT field.
	ADC_ADC_ISR_SAT_Msk    = 0x8  // Bit mask of SAT field.
	ADC_ADC_ISR_SAT        = 0x8  // Bit SAT.
	ADC_ADC_ISR_DMABF_Pos  = 0x2  // Position of DMABF field.
	ADC_ADC_ISR_DMABF_Msk  = 0x4  // Bit mask of DMABF field.
	ADC_ADC_ISR_DMABF      = 0x4  // Bit DMABF.
	ADC_ADC_ISR_DMABHF_Pos = 0x1  // Position of DMABHF field.
	ADC_ADC_ISR_DMABHF_Msk = 0x2  // Bit mask of DMABHF field.
	ADC_ADC_ISR_DMABHF     = 0x2  // Bit DMABHF.

	// ADC_IER: ADC interrupt enable register
	ADC_ADC_IER_DMAOVFIE_Pos = 0x4  // Position of DMAOVFIE field.
	ADC_ADC_IER_DMAOVFIE_Msk = 0x10 // Bit mask of DMAOVFIE field.
	ADC_ADC_IER_DMAOVFIE     = 0x10 // Bit DMAOVFIE.
	ADC_ADC_IER_SATIE_Pos    = 0x3  // Position of SATIE field.
	ADC_ADC_IER_SATIE_Msk    = 0x8  // Bit mask of SATIE field.
	ADC_ADC_IER_SATIE        = 0x8  // Bit SATIE.
	ADC_ADC_IER_DMABFIE_Pos  = 0x2  // Position of DMABFIE field.
	ADC_ADC_IER_DMABFIE_Msk  = 0x4  // Bit mask of DMABFIE field.
	ADC_ADC_IER_DMABFIE      = 0x4  // Bit DMABFIE.
	ADC_ADC_IER_DMABHFIE_Pos = 0x1  // Position of DMABHFIE field.
	ADC_ADC_IER_DMABHFIE_Msk = 0x2  // Bit mask of DMABHFIE field.
	ADC_ADC_IER_DMABHFIE     = 0x2  // Bit DMABHFIE.

	// ADC_CR: ADC control register
	ADC_ADC_CR_SMP_Pos    = 0xd    // Position of SMP field.
	ADC_ADC_CR_SMP_Msk    = 0xe000 // Bit mask of SMP field.
	ADC_ADC_CR_HVSELP_Pos = 0xc    // Position of HVSELP field.
	ADC_ADC_CR_HVSELP_Msk = 0x1000 // Bit mask of HVSELP field.
	ADC_ADC_CR_HVSELP     = 0x1000 // Bit HVSELP.
	ADC_ADC_CR_HVSELN_Pos = 0xb    // Position of HVSELN field.
	ADC_ADC_CR_HVSELN_Msk = 0x800  // Bit mask of HVSELN field.
	ADC_ADC_CR_HVSELN     = 0x800  // Bit HVSELN.
	ADC_ADC_CR_CHSELP_Pos = 0x7    // Position of CHSELP field.
	ADC_ADC_CR_CHSELP_Msk = 0x780  // Bit mask of CHSELP field.
	ADC_ADC_CR_CHSELN_Pos = 0x3    // Position of CHSELN field.
	ADC_ADC_CR_CHSELN_Msk = 0x78   // Bit mask of CHSELN field.
	ADC_ADC_CR_CLK_Pos    = 0x2    // Position of CLK field.
	ADC_ADC_CR_CLK_Msk    = 0x4    // Bit mask of CLK field.
	ADC_ADC_CR_CLK        = 0x4    // Bit CLK.
	ADC_ADC_CR_ADON_Pos   = 0x0    // Position of ADON field.
	ADC_ADC_CR_ADON_Msk   = 0x1    // Bit mask of ADON field.
	ADC_ADC_CR_ADON       = 0x1    // Bit ADON.

	// ADC_OFFSETR: ADC offset register
	ADC_ADC_OFFSETR_OFFSET_Pos = 0x0    // Position of OFFSET field.
	ADC_ADC_OFFSETR_OFFSET_Msk = 0xffff // Bit mask of OFFSET field.

	// ADC_GAINR: ADC gain register
	ADC_ADC_GAINR_GAIN_Pos = 0x0    // Position of GAIN field.
	ADC_ADC_GAINR_GAIN_Msk = 0xffff // Bit mask of GAIN field.

	// ADC_DMACR: ADC DMA control register
	ADC_ADC_DMACR_RST_Pos      = 0x4  // Position of RST field.
	ADC_ADC_DMACR_RST_Msk      = 0x10 // Bit mask of RST field.
	ADC_ADC_DMACR_RST          = 0x10 // Bit RST.
	ADC_ADC_DMACR_AUTOWRAP_Pos = 0x1  // Position of AUTOWRAP field.
	ADC_ADC_DMACR_AUTOWRAP_Msk = 0x2  // Bit mask of AUTOWRAP field.
	ADC_ADC_DMACR_AUTOWRAP     = 0x2  // Bit AUTOWRAP.
	ADC_ADC_DMACR_LOAD_Pos     = 0x0  // Position of LOAD field.
	ADC_ADC_DMACR_LOAD_Msk     = 0x1  // Bit mask of LOAD field.
	ADC_ADC_DMACR_LOAD         = 0x1  // Bit LOAD.

	// ADC_DMASR: ADC DMA status register
	ADC_ADC_DMASR_AOVF_Pos = 0x1 // Position of AOVF field.
	ADC_ADC_DMASR_AOVF_Msk = 0x2 // Bit mask of AOVF field.
	ADC_ADC_DMASR_AOVF     = 0x2 // Bit AOVF.
	ADC_ADC_DMASR_ACT_Pos  = 0x0 // Position of ACT field.
	ADC_ADC_DMASR_ACT_Msk  = 0x1 // Bit mask of ACT field.
	ADC_ADC_DMASR_ACT      = 0x1 // Bit ACT.

	// ADC_DMAMSAR: ADC DMA memory start address           register
	ADC_ADC_DMAMSAR_MSA_Pos = 0x0    // Position of MSA field.
	ADC_ADC_DMAMSAR_MSA_Msk = 0x1fff // Bit mask of MSA field.

	// ADC_DMANDTR: ADC DMA number of data to transfer           register
	ADC_ADC_DMANDTR_NDT_Pos = 0x0    // Position of NDT field.
	ADC_ADC_DMANDTR_NDT_Msk = 0x1fff // Bit mask of NDT field.

	// ADC_DMAMNAR: ADC DMA memory next address           register
	ADC_ADC_DMAMNAR_MNA_Pos = 0x1    // Position of MNA field.
	ADC_ADC_DMAMNAR_MNA_Msk = 0x3ffe // Bit mask of MNA field.

	// ADC_DMACNDTR: ADC DMA count number of data transferred           register
	ADC_ADC_DMACNDTR_CNDT_Pos = 0x0    // Position of CNDT field.
	ADC_ADC_DMACNDTR_CNDT_Msk = 0x1fff // Bit mask of CNDT field.
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// EXTIA_TSR: EXTIA trigger source register
	EXTI_EXTIA_TSR_FILTEN_Pos = 0x8   // Position of FILTEN field.
	EXTI_EXTIA_TSR_FILTEN_Msk = 0x100 // Bit mask of FILTEN field.
	EXTI_EXTIA_TSR_FILTEN     = 0x100 // Bit FILTEN.
	EXTI_EXTIA_TSR_INTMOD_Pos = 0x5   // Position of INTMOD field.
	EXTI_EXTIA_TSR_INTMOD_Msk = 0xe0  // Bit mask of INTMOD field.

	// EXTIB_TSR: EXTIB trigger source register
	EXTI_EXTIB_TSR_FILTEN_Pos = 0x8   // Position of FILTEN field.
	EXTI_EXTIB_TSR_FILTEN_Msk = 0x100 // Bit mask of FILTEN field.
	EXTI_EXTIB_TSR_FILTEN     = 0x100 // Bit FILTEN.
	EXTI_EXTIB_TSR_INTMOD_Pos = 0x5   // Position of INTMOD field.
	EXTI_EXTIB_TSR_INTMOD_Msk = 0xe0  // Bit mask of INTMOD field.

	// EXTIC_TSR: EXTIC trigger source register
	EXTI_EXTIC_TSR_FILTEN_Pos = 0x8   // Position of FILTEN field.
	EXTI_EXTIC_TSR_FILTEN_Msk = 0x100 // Bit mask of FILTEN field.
	EXTI_EXTIC_TSR_FILTEN     = 0x100 // Bit FILTEN.
	EXTI_EXTIC_TSR_INTMOD_Pos = 0x5   // Position of INTMOD field.
	EXTI_EXTIC_TSR_INTMOD_Msk = 0xe0  // Bit mask of INTMOD field.

	// EXTID_TSR: EXTID trigger source register
	EXTI_EXTID_TSR_FILTEN_Pos = 0x8   // Position of FILTEN field.
	EXTI_EXTID_TSR_FILTEN_Msk = 0x100 // Bit mask of FILTEN field.
	EXTI_EXTID_TSR_FILTEN     = 0x100 // Bit FILTEN.
	EXTI_EXTID_TSR_INTMOD_Pos = 0x5   // Position of INTMOD field.
	EXTI_EXTID_TSR_INTMOD_Msk = 0xe0  // Bit mask of INTMOD field.

	// EXTIC_CR: EXTIC configuration register
	EXTI_EXTIC_CR_GPIO_SEL_Pos = 0x0  // Position of GPIO_SEL field.
	EXTI_EXTIC_CR_GPIO_SEL_Msk = 0x1f // Bit mask of GPIO_SEL field.

	// EXTID_CR: EXTID configuration register
	EXTI_EXTID_CR_GPIO_SEL_Pos = 0x0  // Position of GPIO_SEL field.
	EXTI_EXTID_CR_GPIO_SEL_Msk = 0x1f // Bit mask of GPIO_SEL field.
)

// Bitfields for GPIOA: General purpose I/Os
const (
	// GPIOA_CRL: Port A configuration register           (Low)
	GPIO_GPIOA_CRL_CNFMODE3_Pos = 0xc    // Position of CNFMODE3 field.
	GPIO_GPIOA_CRL_CNFMODE3_Msk = 0xf000 // Bit mask of CNFMODE3 field.
	GPIO_GPIOA_CRL_CNFMODE2_Pos = 0x8    // Position of CNFMODE2 field.
	GPIO_GPIOA_CRL_CNFMODE2_Msk = 0xf00  // Bit mask of CNFMODE2 field.
	GPIO_GPIOA_CRL_CNFMODE1_Pos = 0x4    // Position of CNFMODE1 field.
	GPIO_GPIOA_CRL_CNFMODE1_Msk = 0xf0   // Bit mask of CNFMODE1 field.
	GPIO_GPIOA_CRL_CNFMODE0_Pos = 0x0    // Position of CNFMODE0 field.
	GPIO_GPIOA_CRL_CNFMODE0_Msk = 0xf    // Bit mask of CNFMODE0 field.

	// GPIOA_CRH: Port A configuration register           (High)
	GPIO_GPIOA_CRH_CNFMODE7_Pos = 0xc    // Position of CNFMODE7 field.
	GPIO_GPIOA_CRH_CNFMODE7_Msk = 0xf000 // Bit mask of CNFMODE7 field.
	GPIO_GPIOA_CRH_CNFMODE6_Pos = 0x8    // Position of CNFMODE6 field.
	GPIO_GPIOA_CRH_CNFMODE6_Msk = 0xf00  // Bit mask of CNFMODE6 field.
	GPIO_GPIOA_CRH_CNFMODE5_Pos = 0x4    // Position of CNFMODE5 field.
	GPIO_GPIOA_CRH_CNFMODE5_Msk = 0xf0   // Bit mask of CNFMODE5 field.
	GPIO_GPIOA_CRH_CNFMODE4_Pos = 0x0    // Position of CNFMODE4 field.
	GPIO_GPIOA_CRH_CNFMODE4_Msk = 0xf    // Bit mask of CNFMODE4 field.

	// GPIOA_IDR: Port A input data register
	GPIO_GPIOA_IDR_IDR7_Pos = 0x7  // Position of IDR7 field.
	GPIO_GPIOA_IDR_IDR7_Msk = 0x80 // Bit mask of IDR7 field.
	GPIO_GPIOA_IDR_IDR7     = 0x80 // Bit IDR7.
	GPIO_GPIOA_IDR_IDR6_Pos = 0x6  // Position of IDR6 field.
	GPIO_GPIOA_IDR_IDR6_Msk = 0x40 // Bit mask of IDR6 field.
	GPIO_GPIOA_IDR_IDR6     = 0x40 // Bit IDR6.
	GPIO_GPIOA_IDR_IDR5_Pos = 0x5  // Position of IDR5 field.
	GPIO_GPIOA_IDR_IDR5_Msk = 0x20 // Bit mask of IDR5 field.
	GPIO_GPIOA_IDR_IDR5     = 0x20 // Bit IDR5.
	GPIO_GPIOA_IDR_IDR4_Pos = 0x4  // Position of IDR4 field.
	GPIO_GPIOA_IDR_IDR4_Msk = 0x10 // Bit mask of IDR4 field.
	GPIO_GPIOA_IDR_IDR4     = 0x10 // Bit IDR4.
	GPIO_GPIOA_IDR_IDR3_Pos = 0x3  // Position of IDR3 field.
	GPIO_GPIOA_IDR_IDR3_Msk = 0x8  // Bit mask of IDR3 field.
	GPIO_GPIOA_IDR_IDR3     = 0x8  // Bit IDR3.
	GPIO_GPIOA_IDR_IDR2_Pos = 0x2  // Position of IDR2 field.
	GPIO_GPIOA_IDR_IDR2_Msk = 0x4  // Bit mask of IDR2 field.
	GPIO_GPIOA_IDR_IDR2     = 0x4  // Bit IDR2.
	GPIO_GPIOA_IDR_IDR1_Pos = 0x1  // Position of IDR1 field.
	GPIO_GPIOA_IDR_IDR1_Msk = 0x2  // Bit mask of IDR1 field.
	GPIO_GPIOA_IDR_IDR1     = 0x2  // Bit IDR1.
	GPIO_GPIOA_IDR_IDR0_Pos = 0x0  // Position of IDR0 field.
	GPIO_GPIOA_IDR_IDR0_Msk = 0x1  // Bit mask of IDR0 field.
	GPIO_GPIOA_IDR_IDR0     = 0x1  // Bit IDR0.

	// GPIOA_ODR: Port A output data register
	GPIO_GPIOA_ODR_ODR7_Pos = 0x7  // Position of ODR7 field.
	GPIO_GPIOA_ODR_ODR7_Msk = 0x80 // Bit mask of ODR7 field.
	GPIO_GPIOA_ODR_ODR7     = 0x80 // Bit ODR7.
	GPIO_GPIOA_ODR_ODR6_Pos = 0x6  // Position of ODR6 field.
	GPIO_GPIOA_ODR_ODR6_Msk = 0x40 // Bit mask of ODR6 field.
	GPIO_GPIOA_ODR_ODR6     = 0x40 // Bit ODR6.
	GPIO_GPIOA_ODR_ODR5_Pos = 0x5  // Position of ODR5 field.
	GPIO_GPIOA_ODR_ODR5_Msk = 0x20 // Bit mask of ODR5 field.
	GPIO_GPIOA_ODR_ODR5     = 0x20 // Bit ODR5.
	GPIO_GPIOA_ODR_ODR4_Pos = 0x4  // Position of ODR4 field.
	GPIO_GPIOA_ODR_ODR4_Msk = 0x10 // Bit mask of ODR4 field.
	GPIO_GPIOA_ODR_ODR4     = 0x10 // Bit ODR4.
	GPIO_GPIOA_ODR_ODR3_Pos = 0x3  // Position of ODR3 field.
	GPIO_GPIOA_ODR_ODR3_Msk = 0x8  // Bit mask of ODR3 field.
	GPIO_GPIOA_ODR_ODR3     = 0x8  // Bit ODR3.
	GPIO_GPIOA_ODR_ODR2_Pos = 0x2  // Position of ODR2 field.
	GPIO_GPIOA_ODR_ODR2_Msk = 0x4  // Bit mask of ODR2 field.
	GPIO_GPIOA_ODR_ODR2     = 0x4  // Bit ODR2.
	GPIO_GPIOA_ODR_ODR1_Pos = 0x1  // Position of ODR1 field.
	GPIO_GPIOA_ODR_ODR1_Msk = 0x2  // Bit mask of ODR1 field.
	GPIO_GPIOA_ODR_ODR1     = 0x2  // Bit ODR1.
	GPIO_GPIOA_ODR_ODR0_Pos = 0x0  // Position of ODR0 field.
	GPIO_GPIOA_ODR_ODR0_Msk = 0x1  // Bit mask of ODR0 field.
	GPIO_GPIOA_ODR_ODR0     = 0x1  // Bit ODR0.

	// GPIOA_BSR: Port A bit set register
	GPIO_GPIOA_BSR_BS7_Pos = 0x7  // Position of BS7 field.
	GPIO_GPIOA_BSR_BS7_Msk = 0x80 // Bit mask of BS7 field.
	GPIO_GPIOA_BSR_BS7     = 0x80 // Bit BS7.
	GPIO_GPIOA_BSR_BS6_Pos = 0x6  // Position of BS6 field.
	GPIO_GPIOA_BSR_BS6_Msk = 0x40 // Bit mask of BS6 field.
	GPIO_GPIOA_BSR_BS6     = 0x40 // Bit BS6.
	GPIO_GPIOA_BSR_BS5_Pos = 0x5  // Position of BS5 field.
	GPIO_GPIOA_BSR_BS5_Msk = 0x20 // Bit mask of BS5 field.
	GPIO_GPIOA_BSR_BS5     = 0x20 // Bit BS5.
	GPIO_GPIOA_BSR_BS4_Pos = 0x4  // Position of BS4 field.
	GPIO_GPIOA_BSR_BS4_Msk = 0x10 // Bit mask of BS4 field.
	GPIO_GPIOA_BSR_BS4     = 0x10 // Bit BS4.
	GPIO_GPIOA_BSR_BS3_Pos = 0x3  // Position of BS3 field.
	GPIO_GPIOA_BSR_BS3_Msk = 0x8  // Bit mask of BS3 field.
	GPIO_GPIOA_BSR_BS3     = 0x8  // Bit BS3.
	GPIO_GPIOA_BSR_BS2_Pos = 0x2  // Position of BS2 field.
	GPIO_GPIOA_BSR_BS2_Msk = 0x4  // Bit mask of BS2 field.
	GPIO_GPIOA_BSR_BS2     = 0x4  // Bit BS2.
	GPIO_GPIOA_BSR_BS1_Pos = 0x1  // Position of BS1 field.
	GPIO_GPIOA_BSR_BS1_Msk = 0x2  // Bit mask of BS1 field.
	GPIO_GPIOA_BSR_BS1     = 0x2  // Bit BS1.
	GPIO_GPIOA_BSR_BS0_Pos = 0x0  // Position of BS0 field.
	GPIO_GPIOA_BSR_BS0_Msk = 0x1  // Bit mask of BS0 field.
	GPIO_GPIOA_BSR_BS0     = 0x1  // Bit BS0.

	// GPIOA_BRR: Port A output clear register
	GPIO_GPIOA_BRR_BR7_Pos = 0x7  // Position of BR7 field.
	GPIO_GPIOA_BRR_BR7_Msk = 0x80 // Bit mask of BR7 field.
	GPIO_GPIOA_BRR_BR7     = 0x80 // Bit BR7.
	GPIO_GPIOA_BRR_BR6_Pos = 0x6  // Position of BR6 field.
	GPIO_GPIOA_BRR_BR6_Msk = 0x40 // Bit mask of BR6 field.
	GPIO_GPIOA_BRR_BR6     = 0x40 // Bit BR6.
	GPIO_GPIOA_BRR_BR5_Pos = 0x5  // Position of BR5 field.
	GPIO_GPIOA_BRR_BR5_Msk = 0x20 // Bit mask of BR5 field.
	GPIO_GPIOA_BRR_BR5     = 0x20 // Bit BR5.
	GPIO_GPIOA_BRR_BR4_Pos = 0x4  // Position of BR4 field.
	GPIO_GPIOA_BRR_BR4_Msk = 0x10 // Bit mask of BR4 field.
	GPIO_GPIOA_BRR_BR4     = 0x10 // Bit BR4.
	GPIO_GPIOA_BRR_BR3_Pos = 0x3  // Position of BR3 field.
	GPIO_GPIOA_BRR_BR3_Msk = 0x8  // Bit mask of BR3 field.
	GPIO_GPIOA_BRR_BR3     = 0x8  // Bit BR3.
	GPIO_GPIOA_BRR_BR2_Pos = 0x2  // Position of BR2 field.
	GPIO_GPIOA_BRR_BR2_Msk = 0x4  // Bit mask of BR2 field.
	GPIO_GPIOA_BRR_BR2     = 0x4  // Bit BR2.
	GPIO_GPIOA_BRR_BR1_Pos = 0x1  // Position of BR1 field.
	GPIO_GPIOA_BRR_BR1_Msk = 0x2  // Bit mask of BR1 field.
	GPIO_GPIOA_BRR_BR1     = 0x2  // Bit BR1.
	GPIO_GPIOA_BRR_BR0_Pos = 0x0  // Position of BR0 field.
	GPIO_GPIOA_BRR_BR0_Msk = 0x1  // Bit mask of BR0 field.
	GPIO_GPIOA_BRR_BR0     = 0x1  // Bit BR0.
)

// Bitfields for WDG: Watchdog timer
const (
	// WDG_CR: WDG configuration register
	WDG_WDG_CR_WDGDIS_Pos = 0x1 // Position of WDGDIS field.
	WDG_WDG_CR_WDGDIS_Msk = 0x2 // Bit mask of WDGDIS field.
	WDG_WDG_CR_WDGDIS     = 0x2 // Bit WDGDIS.
	WDG_WDG_CR_WDGEN_Pos  = 0x0 // Position of WDGEN field.
	WDG_WDG_CR_WDGEN_Msk  = 0x1 // Bit mask of WDGEN field.
	WDG_WDG_CR_WDGEN      = 0x1 // Bit WDGEN.

	// WDG_KR: WDG key register
	WDG_WDG_KR_KEY_Pos = 0x0    // Position of KEY field.
	WDG_WDG_KR_KEY_Msk = 0xffff // Bit mask of KEY field.

	// WDG_KICKSR: WDG kick-start register
	WDG_WDG_KICKSR_KS_Pos = 0x0    // Position of KS field.
	WDG_WDG_KICKSR_KS_Msk = 0xffff // Bit mask of KS field.
)

// Bitfields for CLK: Clock
const (
	// CLK_SLEEPCR: Sleep timer control register
	CLK_CLK_SLEEPCR_LSEEN_Pos    = 0x0 // Position of LSEEN field.
	CLK_CLK_SLEEPCR_LSEEN_Msk    = 0x1 // Bit mask of LSEEN field.
	CLK_CLK_SLEEPCR_LSEEN        = 0x1 // Bit LSEEN.
	CLK_CLK_SLEEPCR_LSI10KEN_Pos = 0x1 // Position of LSI10KEN field.
	CLK_CLK_SLEEPCR_LSI10KEN_Msk = 0x2 // Bit mask of LSI10KEN field.
	CLK_CLK_SLEEPCR_LSI10KEN     = 0x2 // Bit LSI10KEN.

	// CLK_LSI10KCR: LSI Clock (10KHz) control           register
	CLK_CLK_LSI10KCR_TUNE_Pos = 0x0 // Position of TUNE field.
	CLK_CLK_LSI10KCR_TUNE_Msk = 0xf // Bit mask of TUNE field.

	// CLK_LSI1KCR: LSI Clock (1KHz) control           register
	CLK_CLK_LSI1KCR_CLKFRAC_Pos = 0x0       // Position of CLKFRAC field.
	CLK_CLK_LSI1KCR_CLKFRAC_Msk = 0x7ff     // Bit mask of CLKFRAC field.
	CLK_CLK_LSI1KCR_CALINT_Pos  = 0xb       // Position of CALINT field.
	CLK_CLK_LSI1KCR_CALINT_Msk  = 0x3fff800 // Bit mask of CALINT field.

	// CLK_HSECR1: HSE Clock (24MHz) control register           1
	CLK_CLK_HSECR1_BIASTRIM_Pos = 0x0 // Position of BIASTRIM field.
	CLK_CLK_HSECR1_BIASTRIM_Msk = 0xf // Bit mask of BIASTRIM field.

	// CLK_HSICR: HSI Clock (12MHz) trim           register
	CLK_CLK_HSICR_TUNE_Pos = 0x0  // Position of TUNE field.
	CLK_CLK_HSICR_TUNE_Msk = 0x1f // Bit mask of TUNE field.

	// CLK_PERIODCR: Clock period control register
	CLK_CLK_PERIODCR_MODE_Pos = 0x0 // Position of MODE field.
	CLK_CLK_PERIODCR_MODE_Msk = 0x3 // Bit mask of MODE field.

	// CLK_PERIODSR: Clock period status register
	CLK_CLK_PERIODSR_PERIOD_Pos = 0x0    // Position of PERIOD field.
	CLK_CLK_PERIODSR_PERIOD_Msk = 0xffff // Bit mask of PERIOD field.

	// CLK_DITHERCR: Clock dither control register
	CLK_CLK_DITHERCR_DIS_Pos = 0x0 // Position of DIS field.
	CLK_CLK_DITHERCR_DIS_Msk = 0x1 // Bit mask of DIS field.
	CLK_CLK_DITHERCR_DIS     = 0x1 // Bit DIS.

	// CLK_HSECR2: HSE Clock (24MHz) control register           2
	CLK_CLK_HSECR2_SW1_Pos = 0x0 // Position of SW1 field.
	CLK_CLK_HSECR2_SW1_Msk = 0x1 // Bit mask of SW1 field.
	CLK_CLK_HSECR2_SW1     = 0x1 // Bit SW1.
	CLK_CLK_HSECR2_EN_Pos  = 0x1 // Position of EN field.
	CLK_CLK_HSECR2_EN_Msk  = 0x2 // Bit mask of EN field.
	CLK_CLK_HSECR2_EN      = 0x2 // Bit EN.

	// CLK_CPUCR: Clock source select register
	CLK_CLK_CPUCR_SW2_Pos = 0x0 // Position of SW2 field.
	CLK_CLK_CPUCR_SW2_Msk = 0x1 // Bit mask of SW2 field.
	CLK_CLK_CPUCR_SW2     = 0x1 // Bit SW2.
)

// Bitfields for RST: Reset event
const (
	// RST_SR: Reset Status Register
	RST_RST_SR_LKUP_Pos   = 0x7  // Position of LKUP field.
	RST_RST_SR_LKUP_Msk   = 0x80 // Bit mask of LKUP field.
	RST_RST_SR_LKUP       = 0x80 // Bit LKUP.
	RST_RST_SR_OBFAIL_Pos = 0x6  // Position of OBFAIL field.
	RST_RST_SR_OBFAIL_Msk = 0x40 // Bit mask of OBFAIL field.
	RST_RST_SR_OBFAIL     = 0x40 // Bit OBFAIL.
	RST_RST_SR_WKUP_Pos   = 0x5  // Position of WKUP field.
	RST_RST_SR_WKUP_Msk   = 0x20 // Bit mask of WKUP field.
	RST_RST_SR_WKUP       = 0x20 // Bit WKUP.
	RST_RST_SR_SWRST_Pos  = 0x4  // Position of SWRST field.
	RST_RST_SR_SWRST_Msk  = 0x10 // Bit mask of SWRST field.
	RST_RST_SR_SWRST      = 0x10 // Bit SWRST.
	RST_RST_SR_WDG_Pos    = 0x3  // Position of WDG field.
	RST_RST_SR_WDG_Msk    = 0x8  // Bit mask of WDG field.
	RST_RST_SR_WDG        = 0x8  // Bit WDG.
	RST_RST_SR_PIN_Pos    = 0x2  // Position of PIN field.
	RST_RST_SR_PIN_Msk    = 0x4  // Bit mask of PIN field.
	RST_RST_SR_PIN        = 0x4  // Bit PIN.
	RST_RST_SR_PWRLV_Pos  = 0x1  // Position of PWRLV field.
	RST_RST_SR_PWRLV_Msk  = 0x2  // Bit mask of PWRLV field.
	RST_RST_SR_PWRLV      = 0x2  // Bit PWRLV.
	RST_RST_SR_PWRHV_Pos  = 0x0  // Position of PWRHV field.
	RST_RST_SR_PWRHV_Msk  = 0x1  // Bit mask of PWRHV field.
	RST_RST_SR_PWRHV      = 0x1  // Bit PWRHV.
)

// Bitfields for FLASH: FLASH
const (
	// FLASH_CLKER: FLASH controller clock enable           register
	FLASH_FLASH_CLKER_EN_Pos = 0x0 // Position of EN field.
	FLASH_FLASH_CLKER_EN_Msk = 0x1 // Bit mask of EN field.
	FLASH_FLASH_CLKER_EN     = 0x1 // Bit EN.

	// FLASH_CLKSR: FLASH controller clock status           register
	FLASH_FLASH_CLKSR_BSY_Pos = 0x1 // Position of BSY field.
	FLASH_FLASH_CLKSR_BSY_Msk = 0x2 // Bit mask of BSY field.
	FLASH_FLASH_CLKSR_BSY     = 0x2 // Bit BSY.
	FLASH_FLASH_CLKSR_ACK_Pos = 0x0 // Position of ACK field.
	FLASH_FLASH_CLKSR_ACK_Msk = 0x1 // Bit mask of ACK field.
	FLASH_FLASH_CLKSR_ACK     = 0x1 // Bit ACK.

	// FLASH_ACR: FLASH access control register
	FLASH_FLASH_ACR_PRFTBS_Pos  = 0x5  // Position of PRFTBS field.
	FLASH_FLASH_ACR_PRFTBS_Msk  = 0x20 // Bit mask of PRFTBS field.
	FLASH_FLASH_ACR_PRFTBS      = 0x20 // Bit PRFTBS.
	FLASH_FLASH_ACR_PRFTBE_Pos  = 0x4  // Position of PRFTBE field.
	FLASH_FLASH_ACR_PRFTBE_Msk  = 0x10 // Bit mask of PRFTBE field.
	FLASH_FLASH_ACR_PRFTBE      = 0x10 // Bit PRFTBE.
	FLASH_FLASH_ACR_HLFCYA_Pos  = 0x3  // Position of HLFCYA field.
	FLASH_FLASH_ACR_HLFCYA_Msk  = 0x8  // Bit mask of HLFCYA field.
	FLASH_FLASH_ACR_HLFCYA      = 0x8  // Bit HLFCYA.
	FLASH_FLASH_ACR_LATENCY_Pos = 0x0  // Position of LATENCY field.
	FLASH_FLASH_ACR_LATENCY_Msk = 0x7  // Bit mask of LATENCY field.

	// FLASH_KEYR: FLASH key register
	FLASH_FLASH_KEYR_FKEYR_Pos = 0x0        // Position of FKEYR field.
	FLASH_FLASH_KEYR_FKEYR_Msk = 0xffffffff // Bit mask of FKEYR field.

	// FLASH_OPTKEYR: FLASH OPT key register
	FLASH_FLASH_OPTKEYR_OPTKEYR_Pos = 0x0        // Position of OPTKEYR field.
	FLASH_FLASH_OPTKEYR_OPTKEYR_Msk = 0xffffffff // Bit mask of OPTKEYR field.

	// FLASH_SR: FLASH status register
	FLASH_FLASH_SR_EOP_Pos      = 0x5  // Position of EOP field.
	FLASH_FLASH_SR_EOP_Msk      = 0x20 // Bit mask of EOP field.
	FLASH_FLASH_SR_EOP          = 0x20 // Bit EOP.
	FLASH_FLASH_SR_WRPRTERR_Pos = 0x4  // Position of WRPRTERR field.
	FLASH_FLASH_SR_WRPRTERR_Msk = 0x10 // Bit mask of WRPRTERR field.
	FLASH_FLASH_SR_WRPRTERR     = 0x10 // Bit WRPRTERR.
	FLASH_FLASH_SR_PGERR_Pos    = 0x2  // Position of PGERR field.
	FLASH_FLASH_SR_PGERR_Msk    = 0x4  // Bit mask of PGERR field.
	FLASH_FLASH_SR_PGERR        = 0x4  // Bit PGERR.
	FLASH_FLASH_SR_BSY_Pos      = 0x0  // Position of BSY field.
	FLASH_FLASH_SR_BSY_Msk      = 0x1  // Bit mask of BSY field.
	FLASH_FLASH_SR_BSY          = 0x1  // Bit BSY.

	// FLASH_CR: FLASH control register
	FLASH_FLASH_CR_EOPIE_Pos  = 0xc    // Position of EOPIE field.
	FLASH_FLASH_CR_EOPIE_Msk  = 0x1000 // Bit mask of EOPIE field.
	FLASH_FLASH_CR_EOPIE      = 0x1000 // Bit EOPIE.
	FLASH_FLASH_CR_ERRIE_Pos  = 0xa    // Position of ERRIE field.
	FLASH_FLASH_CR_ERRIE_Msk  = 0x400  // Bit mask of ERRIE field.
	FLASH_FLASH_CR_ERRIE      = 0x400  // Bit ERRIE.
	FLASH_FLASH_CR_OPTWRE_Pos = 0x9    // Position of OPTWRE field.
	FLASH_FLASH_CR_OPTWRE_Msk = 0x200  // Bit mask of OPTWRE field.
	FLASH_FLASH_CR_OPTWRE     = 0x200  // Bit OPTWRE.
	FLASH_FLASH_CR_LOCK_Pos   = 0x7    // Position of LOCK field.
	FLASH_FLASH_CR_LOCK_Msk   = 0x80   // Bit mask of LOCK field.
	FLASH_FLASH_CR_LOCK       = 0x80   // Bit LOCK.
	FLASH_FLASH_CR_STRT_Pos   = 0x6    // Position of STRT field.
	FLASH_FLASH_CR_STRT_Msk   = 0x40   // Bit mask of STRT field.
	FLASH_FLASH_CR_STRT       = 0x40   // Bit STRT.
	FLASH_FLASH_CR_OPTER_Pos  = 0x5    // Position of OPTER field.
	FLASH_FLASH_CR_OPTER_Msk  = 0x20   // Bit mask of OPTER field.
	FLASH_FLASH_CR_OPTER      = 0x20   // Bit OPTER.
	FLASH_FLASH_CR_OPTPG_Pos  = 0x4    // Position of OPTPG field.
	FLASH_FLASH_CR_OPTPG_Msk  = 0x10   // Bit mask of OPTPG field.
	FLASH_FLASH_CR_OPTPG      = 0x10   // Bit OPTPG.
	FLASH_FLASH_CR_MER_Pos    = 0x2    // Position of MER field.
	FLASH_FLASH_CR_MER_Msk    = 0x4    // Bit mask of MER field.
	FLASH_FLASH_CR_MER        = 0x4    // Bit MER.
	FLASH_FLASH_CR_PER_Pos    = 0x1    // Position of PER field.
	FLASH_FLASH_CR_PER_Msk    = 0x2    // Bit mask of PER field.
	FLASH_FLASH_CR_PER        = 0x2    // Bit PER.
	FLASH_FLASH_CR_PG_Pos     = 0x0    // Position of PG field.
	FLASH_FLASH_CR_PG_Msk     = 0x1    // Bit mask of PG field.
	FLASH_FLASH_CR_PG         = 0x1    // Bit PG.

	// FLASH_AR: FLASH address register
	FLASH_FLASH_AR_FAR_Pos = 0x0        // Position of FAR field.
	FLASH_FLASH_AR_FAR_Msk = 0xffffffff // Bit mask of FAR field.

	// FLASH_OBR: FLASH option bytes register
	FLASH_FLASH_OBR_RDPRT_Pos  = 0x1 // Position of RDPRT field.
	FLASH_FLASH_OBR_RDPRT_Msk  = 0x2 // Bit mask of RDPRT field.
	FLASH_FLASH_OBR_RDPRT      = 0x2 // Bit RDPRT.
	FLASH_FLASH_OBR_OPTERR_Pos = 0x0 // Position of OPTERR field.
	FLASH_FLASH_OBR_OPTERR_Msk = 0x1 // Bit mask of OPTERR field.
	FLASH_FLASH_OBR_OPTERR     = 0x1 // Bit OPTERR.

	// FLASH_WRPR: FLASH write protection           register
	FLASH_FLASH_WRPR_WRP_Pos = 0x0        // Position of WRP field.
	FLASH_FLASH_WRPR_WRP_Msk = 0xffffffff // Bit mask of WRP field.
)

// Bitfields for SLPTMR: Sleep timer
const (
	// SLPTMR_CR: SLPTMR configuration register
	SLPTMR_SLPTMR_CR_REVERSE_Pos = 0xc    // Position of REVERSE field.
	SLPTMR_SLPTMR_CR_REVERSE_Msk = 0x1000 // Bit mask of REVERSE field.
	SLPTMR_SLPTMR_CR_REVERSE     = 0x1000 // Bit REVERSE.
	SLPTMR_SLPTMR_CR_EN_Pos      = 0xb    // Position of EN field.
	SLPTMR_SLPTMR_CR_EN_Msk      = 0x800  // Bit mask of EN field.
	SLPTMR_SLPTMR_CR_EN          = 0x800  // Bit EN.
	SLPTMR_SLPTMR_CR_DBGP_Pos    = 0xa    // Position of DBGP field.
	SLPTMR_SLPTMR_CR_DBGP_Msk    = 0x400  // Bit mask of DBGP field.
	SLPTMR_SLPTMR_CR_DBGP        = 0x400  // Bit DBGP.
	SLPTMR_SLPTMR_CR_PSC_Pos     = 0x4    // Position of PSC field.
	SLPTMR_SLPTMR_CR_PSC_Msk     = 0xf0   // Bit mask of PSC field.
	SLPTMR_SLPTMR_CR_CLKSEL_Pos  = 0x0    // Position of CLKSEL field.
	SLPTMR_SLPTMR_CR_CLKSEL_Msk  = 0x1    // Bit mask of CLKSEL field.
	SLPTMR_SLPTMR_CR_CLKSEL      = 0x1    // Bit CLKSEL.

	// SLPTMR_CNTH: SLPTMR counter high register
	SLPTMR_SLPTMR_CNTH_CNTH_Pos = 0x0    // Position of CNTH field.
	SLPTMR_SLPTMR_CNTH_CNTH_Msk = 0xffff // Bit mask of CNTH field.

	// SLPTMR_CNTL: SLPTMR counter high register
	SLPTMR_SLPTMR_CNTL_CNTL_Pos = 0x0    // Position of CNTL field.
	SLPTMR_SLPTMR_CNTL_CNTL_Msk = 0xffff // Bit mask of CNTL field.

	// SLPTMR_CMPAH: SLPTMR compare A high register
	SLPTMR_SLPTMR_CMPAH_CMPAH_Pos = 0x0    // Position of CMPAH field.
	SLPTMR_SLPTMR_CMPAH_CMPAH_Msk = 0xffff // Bit mask of CMPAH field.

	// SLPTMR_CMPAL: SLPTMR compare A low register
	SLPTMR_SLPTMR_CMPAL_CMPAL_Pos = 0x0    // Position of CMPAL field.
	SLPTMR_SLPTMR_CMPAL_CMPAL_Msk = 0xffff // Bit mask of CMPAL field.

	// SLPTMR_CMPBH: SLPTMR compare B high register
	SLPTMR_SLPTMR_CMPBH_CMPBH_Pos = 0x0    // Position of CMPBH field.
	SLPTMR_SLPTMR_CMPBH_CMPBH_Msk = 0xffff // Bit mask of CMPBH field.

	// SLPTMR_CMPBL: SLPTMR compare B low register
	SLPTMR_SLPTMR_CMPBL_CMPBL_Pos = 0x0    // Position of CMPBL field.
	SLPTMR_SLPTMR_CMPBL_CMPBL_Msk = 0xffff // Bit mask of CMPBL field.

	// SLPTMR_ISR: SLPTMR interrupt status           register
	SLPTMR_SLPTMR_ISR_CMPB_Pos = 0x2 // Position of CMPB field.
	SLPTMR_SLPTMR_ISR_CMPB_Msk = 0x4 // Bit mask of CMPB field.
	SLPTMR_SLPTMR_ISR_CMPB     = 0x4 // Bit CMPB.
	SLPTMR_SLPTMR_ISR_CMPA_Pos = 0x1 // Position of CMPA field.
	SLPTMR_SLPTMR_ISR_CMPA_Msk = 0x2 // Bit mask of CMPA field.
	SLPTMR_SLPTMR_ISR_CMPA     = 0x2 // Bit CMPA.
	SLPTMR_SLPTMR_ISR_OW_Pos   = 0x0 // Position of OW field.
	SLPTMR_SLPTMR_ISR_OW_Msk   = 0x1 // Bit mask of OW field.
	SLPTMR_SLPTMR_ISR_OW       = 0x1 // Bit OW.

	// SLPTMR_IFR: SLPTMR force interrupts           register
	SLPTMR_SLPTMR_IFR_CMPB_Pos = 0x2 // Position of CMPB field.
	SLPTMR_SLPTMR_IFR_CMPB_Msk = 0x4 // Bit mask of CMPB field.
	SLPTMR_SLPTMR_IFR_CMPB     = 0x4 // Bit CMPB.
	SLPTMR_SLPTMR_IFR_CMPA_Pos = 0x1 // Position of CMPA field.
	SLPTMR_SLPTMR_IFR_CMPA_Msk = 0x2 // Bit mask of CMPA field.
	SLPTMR_SLPTMR_IFR_CMPA     = 0x2 // Bit CMPA.
	SLPTMR_SLPTMR_IFR_OW_Pos   = 0x0 // Position of OW field.
	SLPTMR_SLPTMR_IFR_OW_Msk   = 0x1 // Bit mask of OW field.
	SLPTMR_SLPTMR_IFR_OW       = 0x1 // Bit OW.

	// SLPTMR_IER: SLPTMR interrupt enable           register
	SLPTMR_SLPTMR_IER_WRAP_Pos = 0x0 // Position of WRAP field.
	SLPTMR_SLPTMR_IER_WRAP_Msk = 0x1 // Bit mask of WRAP field.
	SLPTMR_SLPTMR_IER_WRAP     = 0x1 // Bit WRAP.
	SLPTMR_SLPTMR_IER_CMPA_Pos = 0x1 // Position of CMPA field.
	SLPTMR_SLPTMR_IER_CMPA_Msk = 0x2 // Bit mask of CMPA field.
	SLPTMR_SLPTMR_IER_CMPA     = 0x2 // Bit CMPA.
	SLPTMR_SLPTMR_IER_CMPB_Pos = 0x2 // Position of CMPB field.
	SLPTMR_SLPTMR_IER_CMPB_Msk = 0x4 // Bit mask of CMPB field.
	SLPTMR_SLPTMR_IER_CMPB     = 0x4 // Bit CMPB.
)

// Bitfields for PWR: Power control
const (
	// PWR_DSLEEPCR1: PWR_DSLEEPCR1
	PWR_PWR_DSLEEPCR1_PWR_CSYSPWRUPACKCR_Pos = 0x1 // Position of PWR_CSYSPWRUPACKCR field.
	PWR_PWR_DSLEEPCR1_PWR_CSYSPWRUPACKCR_Msk = 0x2 // Bit mask of PWR_CSYSPWRUPACKCR field.
	PWR_PWR_DSLEEPCR1_PWR_CSYSPWRUPACKCR     = 0x2 // Bit PWR_CSYSPWRUPACKCR.

	// PWR_DSLEEPCR2: PWR_DSLEEPCR2
	PWR_PWR_DSLEEPCR2_MODE_Pos = 0x0 // Position of MODE field.
	PWR_PWR_DSLEEPCR2_MODE_Msk = 0x1 // Bit mask of MODE field.
	PWR_PWR_DSLEEPCR2_MODE     = 0x1 // Bit MODE.

	// PWR_VREGCR: Voltage regulator Control           register
	PWR_PWR_VREGCR_PWR_VREGCR_1V2TRIM_Pos = 0x0    // Position of PWR_VREGCR_1V2TRIM field.
	PWR_PWR_VREGCR_PWR_VREGCR_1V2TRIM_Msk = 0x7    // Bit mask of PWR_VREGCR_1V2TRIM field.
	PWR_PWR_VREGCR_PWR_VREGCR_1V2EN_Pos   = 0x4    // Position of PWR_VREGCR_1V2EN field.
	PWR_PWR_VREGCR_PWR_VREGCR_1V2EN_Msk   = 0x10   // Bit mask of PWR_VREGCR_1V2EN field.
	PWR_PWR_VREGCR_PWR_VREGCR_1V2EN       = 0x10   // Bit PWR_VREGCR_1V2EN.
	PWR_PWR_VREGCR_PWR_VREGCR_1V8TRIM_Pos = 0x7    // Position of PWR_VREGCR_1V8TRIM field.
	PWR_PWR_VREGCR_PWR_VREGCR_1V8TRIM_Msk = 0x380  // Bit mask of PWR_VREGCR_1V8TRIM field.
	PWR_PWR_VREGCR_PWR_VREGCR_1V8EN_Pos   = 0xb    // Position of PWR_VREGCR_1V8EN field.
	PWR_PWR_VREGCR_PWR_VREGCR_1V8EN_Msk   = 0x800  // Bit mask of PWR_VREGCR_1V8EN field.
	PWR_PWR_VREGCR_PWR_VREGCR_1V8EN       = 0x800  // Bit PWR_VREGCR_1V8EN.
	PWR_PWR_VREGCR_PWR_VREGCR_VREFEN_Pos  = 0xf    // Position of PWR_VREGCR_VREFEN field.
	PWR_PWR_VREGCR_PWR_VREGCR_VREFEN_Msk  = 0x8000 // Bit mask of PWR_VREGCR_VREFEN field.
	PWR_PWR_VREGCR_PWR_VREGCR_VREFEN      = 0x8000 // Bit PWR_VREGCR_VREFEN.

	// PWR_WAKECR1: PWR_WAKECR1
	PWR_PWR_WAKECR1_WAKEEN_Pos       = 0x0   // Position of WAKEEN field.
	PWR_PWR_WAKECR1_WAKEEN_Msk       = 0x1   // Bit mask of WAKEEN field.
	PWR_PWR_WAKECR1_WAKEEN           = 0x1   // Bit WAKEEN.
	PWR_PWR_WAKECR1_SC1_Pos          = 0x1   // Position of SC1 field.
	PWR_PWR_WAKECR1_SC1_Msk          = 0x2   // Bit mask of SC1 field.
	PWR_PWR_WAKECR1_SC1              = 0x2   // Bit SC1.
	PWR_PWR_WAKECR1_SC2_Pos          = 0x2   // Position of SC2 field.
	PWR_PWR_WAKECR1_SC2_Msk          = 0x4   // Bit mask of SC2 field.
	PWR_PWR_WAKECR1_SC2              = 0x4   // Bit SC2.
	PWR_PWR_WAKECR1_IRQD_Pos         = 0x3   // Position of IRQD field.
	PWR_PWR_WAKECR1_IRQD_Msk         = 0x8   // Bit mask of IRQD field.
	PWR_PWR_WAKECR1_IRQD             = 0x8   // Bit IRQD.
	PWR_PWR_WAKECR1_COMPA_Pos        = 0x4   // Position of COMPA field.
	PWR_PWR_WAKECR1_COMPA_Msk        = 0x10  // Bit mask of COMPA field.
	PWR_PWR_WAKECR1_COMPA            = 0x10  // Bit COMPA.
	PWR_PWR_WAKECR1_COMPB_Pos        = 0x5   // Position of COMPB field.
	PWR_PWR_WAKECR1_COMPB_Msk        = 0x20  // Bit mask of COMPB field.
	PWR_PWR_WAKECR1_COMPB            = 0x20  // Bit COMPB.
	PWR_PWR_WAKECR1_WRAP_Pos         = 0x6   // Position of WRAP field.
	PWR_PWR_WAKECR1_WRAP_Msk         = 0x40  // Bit mask of WRAP field.
	PWR_PWR_WAKECR1_WRAP             = 0x40  // Bit WRAP.
	PWR_PWR_WAKECR1_CORE_Pos         = 0x7   // Position of CORE field.
	PWR_PWR_WAKECR1_CORE_Msk         = 0x80  // Bit mask of CORE field.
	PWR_PWR_WAKECR1_CORE             = 0x80  // Bit CORE.
	PWR_PWR_WAKECR1_CPWRRUPREQ_Pos   = 0x8   // Position of CPWRRUPREQ field.
	PWR_PWR_WAKECR1_CPWRRUPREQ_Msk   = 0x100 // Bit mask of CPWRRUPREQ field.
	PWR_PWR_WAKECR1_CPWRRUPREQ       = 0x100 // Bit CPWRRUPREQ.
	PWR_PWR_WAKECR1_CSYSPWRUPREQ_Pos = 0x9   // Position of CSYSPWRUPREQ field.
	PWR_PWR_WAKECR1_CSYSPWRUPREQ_Msk = 0x200 // Bit mask of CSYSPWRUPREQ field.
	PWR_PWR_WAKECR1_CSYSPWRUPREQ     = 0x200 // Bit CSYSPWRUPREQ.

	// PWR_WAKECR2: PWR_WAKECR2
	PWR_PWR_WAKECR2_COREWAKE_Pos = 0x5  // Position of COREWAKE field.
	PWR_PWR_WAKECR2_COREWAKE_Msk = 0x20 // Bit mask of COREWAKE field.
	PWR_PWR_WAKECR2_COREWAKE     = 0x20 // Bit COREWAKE.

	// PWR_WAKESR: PWR_WAKESR
	PWR_PWR_WAKESR_GPIOPIN_Pos      = 0x0   // Position of GPIOPIN field.
	PWR_PWR_WAKESR_GPIOPIN_Msk      = 0x1   // Bit mask of GPIOPIN field.
	PWR_PWR_WAKESR_GPIOPIN          = 0x1   // Bit GPIOPIN.
	PWR_PWR_WAKESR_SC1_Pos          = 0x1   // Position of SC1 field.
	PWR_PWR_WAKESR_SC1_Msk          = 0x2   // Bit mask of SC1 field.
	PWR_PWR_WAKESR_SC1              = 0x2   // Bit SC1.
	PWR_PWR_WAKESR_SC2_Pos          = 0x2   // Position of SC2 field.
	PWR_PWR_WAKESR_SC2_Msk          = 0x4   // Bit mask of SC2 field.
	PWR_PWR_WAKESR_SC2              = 0x4   // Bit SC2.
	PWR_PWR_WAKESR_IRQD_Pos         = 0x3   // Position of IRQD field.
	PWR_PWR_WAKESR_IRQD_Msk         = 0x8   // Bit mask of IRQD field.
	PWR_PWR_WAKESR_IRQD             = 0x8   // Bit IRQD.
	PWR_PWR_WAKESR_COMPA_Pos        = 0x4   // Position of COMPA field.
	PWR_PWR_WAKESR_COMPA_Msk        = 0x10  // Bit mask of COMPA field.
	PWR_PWR_WAKESR_COMPA            = 0x10  // Bit COMPA.
	PWR_PWR_WAKESR_COMPB_Pos        = 0x5   // Position of COMPB field.
	PWR_PWR_WAKESR_COMPB_Msk        = 0x20  // Bit mask of COMPB field.
	PWR_PWR_WAKESR_COMPB            = 0x20  // Bit COMPB.
	PWR_PWR_WAKESR_WRAP_Pos         = 0x6   // Position of WRAP field.
	PWR_PWR_WAKESR_WRAP_Msk         = 0x40  // Bit mask of WRAP field.
	PWR_PWR_WAKESR_WRAP             = 0x40  // Bit WRAP.
	PWR_PWR_WAKESR_CORE_Pos         = 0x7   // Position of CORE field.
	PWR_PWR_WAKESR_CORE_Msk         = 0x80  // Bit mask of CORE field.
	PWR_PWR_WAKESR_CORE             = 0x80  // Bit CORE.
	PWR_PWR_WAKESR_CPWRRUPREQ_Pos   = 0x8   // Position of CPWRRUPREQ field.
	PWR_PWR_WAKESR_CPWRRUPREQ_Msk   = 0x100 // Bit mask of CPWRRUPREQ field.
	PWR_PWR_WAKESR_CPWRRUPREQ       = 0x100 // Bit CPWRRUPREQ.
	PWR_PWR_WAKESR_CSYSPWRUPREQ_Pos = 0x9   // Position of CSYSPWRUPREQ field.
	PWR_PWR_WAKESR_CSYSPWRUPREQ_Msk = 0x200 // Bit mask of CSYSPWRUPREQ field.
	PWR_PWR_WAKESR_CSYSPWRUPREQ     = 0x200 // Bit CSYSPWRUPREQ.

	// PWR_CPWRUPREQSR: PWR_CPWRUPREQSR
	PWR_PWR_CPWRUPREQSR_REQ_Pos = 0x0 // Position of REQ field.
	PWR_PWR_CPWRUPREQSR_REQ_Msk = 0x1 // Bit mask of REQ field.
	PWR_PWR_CPWRUPREQSR_REQ     = 0x1 // Bit REQ.

	// PWR_CSYSPWRUPREQSR: PWR_CSYSPWRUPREQSR
	PWR_PWR_CSYSPWRUPREQSR_REQ_Pos = 0x0 // Position of REQ field.
	PWR_PWR_CSYSPWRUPREQSR_REQ_Msk = 0x1 // Bit mask of REQ field.
	PWR_PWR_CSYSPWRUPREQSR_REQ     = 0x1 // Bit REQ.

	// PWR_CSYSPWRUPACKSR: PWR_CSYSPWRUPACKSR
	PWR_PWR_CSYSPWRUPACKSR_ACK_Pos = 0x0 // Position of ACK field.
	PWR_PWR_CSYSPWRUPACKSR_ACK_Msk = 0x1 // Bit mask of ACK field.
	PWR_PWR_CSYSPWRUPACKSR_ACK     = 0x1 // Bit ACK.

	// PWR_CSYSPWRUPACKCR: PWR_CSYSPWRUPACKCR
	PWR_PWR_CSYSPWRUPACKCR_INHIBIT_Pos = 0x0 // Position of INHIBIT field.
	PWR_PWR_CSYSPWRUPACKCR_INHIBIT_Msk = 0x1 // Bit mask of INHIBIT field.
	PWR_PWR_CSYSPWRUPACKCR_INHIBIT     = 0x1 // Bit INHIBIT.

	// PWR_WAKEPAR: Wake GPIO Port A register
	PWR_PWR_WAKEPAR_PA0_Pos = 0x0  // Position of PA0 field.
	PWR_PWR_WAKEPAR_PA0_Msk = 0x1  // Bit mask of PA0 field.
	PWR_PWR_WAKEPAR_PA0     = 0x1  // Bit PA0.
	PWR_PWR_WAKEPAR_PA1_Pos = 0x1  // Position of PA1 field.
	PWR_PWR_WAKEPAR_PA1_Msk = 0x2  // Bit mask of PA1 field.
	PWR_PWR_WAKEPAR_PA1     = 0x2  // Bit PA1.
	PWR_PWR_WAKEPAR_PA2_Pos = 0x2  // Position of PA2 field.
	PWR_PWR_WAKEPAR_PA2_Msk = 0x4  // Bit mask of PA2 field.
	PWR_PWR_WAKEPAR_PA2     = 0x4  // Bit PA2.
	PWR_PWR_WAKEPAR_PA3_Pos = 0x3  // Position of PA3 field.
	PWR_PWR_WAKEPAR_PA3_Msk = 0x8  // Bit mask of PA3 field.
	PWR_PWR_WAKEPAR_PA3     = 0x8  // Bit PA3.
	PWR_PWR_WAKEPAR_PA4_Pos = 0x4  // Position of PA4 field.
	PWR_PWR_WAKEPAR_PA4_Msk = 0x10 // Bit mask of PA4 field.
	PWR_PWR_WAKEPAR_PA4     = 0x10 // Bit PA4.
	PWR_PWR_WAKEPAR_PA5_Pos = 0x5  // Position of PA5 field.
	PWR_PWR_WAKEPAR_PA5_Msk = 0x20 // Bit mask of PA5 field.
	PWR_PWR_WAKEPAR_PA5     = 0x20 // Bit PA5.
	PWR_PWR_WAKEPAR_PA6_Pos = 0x6  // Position of PA6 field.
	PWR_PWR_WAKEPAR_PA6_Msk = 0x40 // Bit mask of PA6 field.
	PWR_PWR_WAKEPAR_PA6     = 0x40 // Bit PA6.
	PWR_PWR_WAKEPAR_PA7_Pos = 0x7  // Position of PA7 field.
	PWR_PWR_WAKEPAR_PA7_Msk = 0x80 // Bit mask of PA7 field.
	PWR_PWR_WAKEPAR_PA7     = 0x80 // Bit PA7.

	// PWR_WAKEPBR: Wake GPIO Port B register
	PWR_PWR_WAKEPBR_PB0_Pos = 0x0  // Position of PB0 field.
	PWR_PWR_WAKEPBR_PB0_Msk = 0x1  // Bit mask of PB0 field.
	PWR_PWR_WAKEPBR_PB0     = 0x1  // Bit PB0.
	PWR_PWR_WAKEPBR_PB1_Pos = 0x1  // Position of PB1 field.
	PWR_PWR_WAKEPBR_PB1_Msk = 0x2  // Bit mask of PB1 field.
	PWR_PWR_WAKEPBR_PB1     = 0x2  // Bit PB1.
	PWR_PWR_WAKEPBR_PB2_Pos = 0x2  // Position of PB2 field.
	PWR_PWR_WAKEPBR_PB2_Msk = 0x4  // Bit mask of PB2 field.
	PWR_PWR_WAKEPBR_PB2     = 0x4  // Bit PB2.
	PWR_PWR_WAKEPBR_PB3_Pos = 0x3  // Position of PB3 field.
	PWR_PWR_WAKEPBR_PB3_Msk = 0x8  // Bit mask of PB3 field.
	PWR_PWR_WAKEPBR_PB3     = 0x8  // Bit PB3.
	PWR_PWR_WAKEPBR_PB4_Pos = 0x4  // Position of PB4 field.
	PWR_PWR_WAKEPBR_PB4_Msk = 0x10 // Bit mask of PB4 field.
	PWR_PWR_WAKEPBR_PB4     = 0x10 // Bit PB4.
	PWR_PWR_WAKEPBR_PB5_Pos = 0x5  // Position of PB5 field.
	PWR_PWR_WAKEPBR_PB5_Msk = 0x20 // Bit mask of PB5 field.
	PWR_PWR_WAKEPBR_PB5     = 0x20 // Bit PB5.
	PWR_PWR_WAKEPBR_PB6_Pos = 0x6  // Position of PB6 field.
	PWR_PWR_WAKEPBR_PB6_Msk = 0x40 // Bit mask of PB6 field.
	PWR_PWR_WAKEPBR_PB6     = 0x40 // Bit PB6.
	PWR_PWR_WAKEPBR_PB7_Pos = 0x7  // Position of PB7 field.
	PWR_PWR_WAKEPBR_PB7_Msk = 0x80 // Bit mask of PB7 field.
	PWR_PWR_WAKEPBR_PB7     = 0x80 // Bit PB7.

	// PWR_WAKEPCR: Wake GPIO Port C register
	PWR_PWR_WAKEPCR_PC0_Pos = 0x0  // Position of PC0 field.
	PWR_PWR_WAKEPCR_PC0_Msk = 0x1  // Bit mask of PC0 field.
	PWR_PWR_WAKEPCR_PC0     = 0x1  // Bit PC0.
	PWR_PWR_WAKEPCR_PC1_Pos = 0x1  // Position of PC1 field.
	PWR_PWR_WAKEPCR_PC1_Msk = 0x2  // Bit mask of PC1 field.
	PWR_PWR_WAKEPCR_PC1     = 0x2  // Bit PC1.
	PWR_PWR_WAKEPCR_PC2_Pos = 0x2  // Position of PC2 field.
	PWR_PWR_WAKEPCR_PC2_Msk = 0x4  // Bit mask of PC2 field.
	PWR_PWR_WAKEPCR_PC2     = 0x4  // Bit PC2.
	PWR_PWR_WAKEPCR_PC3_Pos = 0x3  // Position of PC3 field.
	PWR_PWR_WAKEPCR_PC3_Msk = 0x8  // Bit mask of PC3 field.
	PWR_PWR_WAKEPCR_PC3     = 0x8  // Bit PC3.
	PWR_PWR_WAKEPCR_PC4_Pos = 0x4  // Position of PC4 field.
	PWR_PWR_WAKEPCR_PC4_Msk = 0x10 // Bit mask of PC4 field.
	PWR_PWR_WAKEPCR_PC4     = 0x10 // Bit PC4.
	PWR_PWR_WAKEPCR_PC5_Pos = 0x5  // Position of PC5 field.
	PWR_PWR_WAKEPCR_PC5_Msk = 0x20 // Bit mask of PC5 field.
	PWR_PWR_WAKEPCR_PC5     = 0x20 // Bit PC5.
	PWR_PWR_WAKEPCR_PC6_Pos = 0x6  // Position of PC6 field.
	PWR_PWR_WAKEPCR_PC6_Msk = 0x40 // Bit mask of PC6 field.
	PWR_PWR_WAKEPCR_PC6     = 0x40 // Bit PC6.
	PWR_PWR_WAKEPCR_PC7_Pos = 0x7  // Position of PC7 field.
	PWR_PWR_WAKEPCR_PC7_Msk = 0x80 // Bit mask of PC7 field.
	PWR_PWR_WAKEPCR_PC7     = 0x80 // Bit PC7.

	// PWR_WAKEFILTR: Wake filter register
	PWR_PWR_WAKEFILTR_GPIO_Pos = 0x0 // Position of GPIO field.
	PWR_PWR_WAKEFILTR_GPIO_Msk = 0x1 // Bit mask of GPIO field.
	PWR_PWR_WAKEFILTR_GPIO     = 0x1 // Bit GPIO.
	PWR_PWR_WAKEFILTR_SC1_Pos  = 0x1 // Position of SC1 field.
	PWR_PWR_WAKEFILTR_SC1_Msk  = 0x2 // Bit mask of SC1 field.
	PWR_PWR_WAKEFILTR_SC1      = 0x2 // Bit SC1.
	PWR_PWR_WAKEFILTR_SC2_Pos  = 0x2 // Position of SC2 field.
	PWR_PWR_WAKEFILTR_SC2_Msk  = 0x4 // Bit mask of SC2 field.
	PWR_PWR_WAKEFILTR_SC2      = 0x4 // Bit SC2.
	PWR_PWR_WAKEFILTR_IRQD_Pos = 0x3 // Position of IRQD field.
	PWR_PWR_WAKEFILTR_IRQD_Msk = 0x8 // Bit mask of IRQD field.
	PWR_PWR_WAKEFILTR_IRQD     = 0x8 // Bit IRQD.
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ICTR: Interrupt Controller Type           Register
	NVIC_ICTR_INTLINESNUM_Pos = 0x0 // Position of INTLINESNUM field.
	NVIC_ICTR_INTLINESNUM_Msk = 0xf // Bit mask of INTLINESNUM field.

	// ISER0: Interrupt Set-Enable Register
	NVIC_ISER0_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ICER0: Interrupt Clear-Enable           Register
	NVIC_ICER0_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ISPR0: Interrupt Set-Pending Register
	NVIC_ISPR0_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ICPR0: Interrupt Clear-Pending           Register
	NVIC_ICPR0_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// IABR0: Interrupt Active Bit Register
	NVIC_IABR0_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IPR0: Interrupt Priority Register
	NVIC_IPR0_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR1: Interrupt Priority Register
	NVIC_IPR1_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR2: Interrupt Priority Register
	NVIC_IPR2_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR3: Interrupt Priority Register
	NVIC_IPR3_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR4: Interrupt Priority Register
	NVIC_IPR4_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// STIR: Software Triggered Interrupt           Register
	NVIC_STIR_INTID_Pos = 0x0   // Position of INTID field.
	NVIC_STIR_INTID_Msk = 0x1ff // Bit mask of INTID field.
)

// Bitfields for MEM: Memory Control registers
const (
	// RAMPROTR1: Memory protection register1
	RAM_RAMPROTR1_RAMPROT1_Pos = 0x0        // Position of RAMPROT1 field.
	RAM_RAMPROTR1_RAMPROT1_Msk = 0xffffffff // Bit mask of RAMPROT1 field.

	// RAMPROTR2: Memory protection register2
	RAM_RAMPROTR2_RAMPROT2_Pos = 0x0        // Position of RAMPROT2 field.
	RAM_RAMPROTR2_RAMPROT2_Msk = 0xffffffff // Bit mask of RAMPROT2 field.

	// RAMPROTR3: Memory protection register3
	RAM_RAMPROTR3_RAMPROT3_Pos = 0x0        // Position of RAMPROT3 field.
	RAM_RAMPROTR3_RAMPROT3_Msk = 0xffffffff // Bit mask of RAMPROT3 field.

	// RAMPROTR4: Memory protection register4
	RAM_RAMPROTR4_RAMPROT4_Pos = 0x0        // Position of RAMPROT4 field.
	RAM_RAMPROTR4_RAMPROT4_Msk = 0xffffffff // Bit mask of RAMPROT4 field.

	// RAMPROTR5: Memory protection register5
	RAM_RAMPROTR5_RAMPROT5_Pos = 0x0        // Position of RAMPROT5 field.
	RAM_RAMPROTR5_RAMPROT5_Msk = 0xffffffff // Bit mask of RAMPROT5 field.

	// RAMPROTR6: Memory protection register6
	RAM_RAMPROTR6_RAMPROT6_Pos = 0x0        // Position of RAMPROT6 field.
	RAM_RAMPROTR6_RAMPROT6_Msk = 0xffffffff // Bit mask of RAMPROT6 field.

	// RAMPROTR7: Memory protection register7
	RAM_RAMPROTR7_RAMPROT7_Pos = 0x0        // Position of RAMPROT7 field.
	RAM_RAMPROTR7_RAMPROT7_Msk = 0xffffffff // Bit mask of RAMPROT7 field.

	// RAMPROTR8: Memory protection register8
	RAM_RAMPROTR8_RAMPROT8_Pos = 0x0        // Position of RAMPROT8 field.
	RAM_RAMPROTR8_RAMPROT8_Msk = 0xffffffff // Bit mask of RAMPROT8 field.

	// DMAPROTR1: DMA protection register1
	RAM_DMAPROTR1_ADDRESS_Pos = 0x0        // Position of ADDRESS field.
	RAM_DMAPROTR1_ADDRESS_Msk = 0x3fff     // Bit mask of ADDRESS field.
	RAM_DMAPROTR1_OFFSET_Pos  = 0xe        // Position of OFFSET field.
	RAM_DMAPROTR1_OFFSET_Msk  = 0xffffc000 // Bit mask of OFFSET field.

	// DMAPROTR2: DMA protection register2
	RAM_DMAPROTR2_CHANNEL_Pos = 0x0 // Position of CHANNEL field.
	RAM_DMAPROTR2_CHANNEL_Msk = 0x7 // Bit mask of CHANNEL field.

	// RAMCR: Memory configuration register
	RAM_RAMCR_WEN_Pos = 0x2 // Position of WEN field.
	RAM_RAMCR_WEN_Msk = 0x4 // Bit mask of WEN field.
	RAM_RAMCR_WEN     = 0x4 // Bit WEN.
)
