/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilePermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

final class FilePermissionCollection
extends PermissionCollection
implements Serializable {
    private transient List<Permission> perms = new ArrayList<Permission>();
    private static final long serialVersionUID = 2202956749081564585L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Vector.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        FilePermissionCollection filePermissionCollection = this;
        synchronized (filePermissionCollection) {
            this.perms.add(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            return false;
        }
        FilePermission fp = (FilePermission)permission;
        int desired = fp.getMask();
        int effective = 0;
        int needed = desired;
        FilePermissionCollection filePermissionCollection = this;
        synchronized (filePermissionCollection) {
            int len = this.perms.size();
            for (int i = 0; i < len; ++i) {
                FilePermission x = (FilePermission)this.perms.get(i);
                if ((needed & x.getMask()) == 0 || !x.impliesIgnoreMask(fp)) continue;
                if (((effective |= x.getMask()) & desired) == desired) {
                    return true;
                }
                needed = desired ^ effective;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Permission> elements() {
        FilePermissionCollection filePermissionCollection = this;
        synchronized (filePermissionCollection) {
            return Collections.enumeration(this.perms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Vector<Permission> permissions = new Vector<Permission>(this.perms.size());
        FilePermissionCollection filePermissionCollection = this;
        synchronized (filePermissionCollection) {
            permissions.addAll(this.perms);
        }
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", permissions);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        Vector permissions = (Vector)gfields.get("permissions", null);
        this.perms = new ArrayList<Permission>(permissions.size());
        for (Permission perm : permissions) {
            this.perms.add(perm);
        }
    }
}

