/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.JarURLConnection;

public class Handler
extends URLStreamHandler {
    private static final String separator = "!/";

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new JarURLConnection(u, this);
    }

    private static int indexOfBangSlash(String spec) {
        int indexOfBang = spec.length();
        while ((indexOfBang = spec.lastIndexOf(33, indexOfBang)) != -1) {
            if (indexOfBang != spec.length() - 1 && spec.charAt(indexOfBang + 1) == '/') {
                return indexOfBang + 1;
            }
            --indexOfBang;
        }
        return -1;
    }

    @Override
    protected boolean sameFile(URL u1, URL u2) {
        String entry2;
        if (!u1.getProtocol().equals("jar") || !u2.getProtocol().equals("jar")) {
            return false;
        }
        String file1 = u1.getFile();
        String file2 = u2.getFile();
        int sep1 = file1.indexOf(separator);
        int sep2 = file2.indexOf(separator);
        if (sep1 == -1 || sep2 == -1) {
            return super.sameFile(u1, u2);
        }
        String entry1 = file1.substring(sep1 + 2);
        if (!entry1.equals(entry2 = file2.substring(sep2 + 2))) {
            return false;
        }
        URL enclosedURL1 = null;
        URL enclosedURL2 = null;
        try {
            enclosedURL1 = new URL(file1.substring(0, sep1));
            enclosedURL2 = new URL(file2.substring(0, sep2));
        }
        catch (MalformedURLException unused) {
            return super.sameFile(u1, u2);
        }
        return super.sameFile(enclosedURL1, enclosedURL2);
    }

    @Override
    protected int hashCode(URL u) {
        String file;
        int sep;
        int h = 0;
        String protocol = u.getProtocol();
        if (protocol != null) {
            h += protocol.hashCode();
        }
        if ((sep = (file = u.getFile()).indexOf(separator)) == -1) {
            return h + file.hashCode();
        }
        URL enclosedURL = null;
        String fileWithoutEntry = file.substring(0, sep);
        try {
            enclosedURL = new URL(fileWithoutEntry);
            h += enclosedURL.hashCode();
        }
        catch (MalformedURLException unused) {
            h += fileWithoutEntry.hashCode();
        }
        String entry = file.substring(sep + 2);
        return h += entry.hashCode();
    }

    public String checkNestedProtocol(String spec) {
        if (spec.regionMatches(true, 0, "jar:", 0, 4)) {
            return "Nested JAR URLs are not supported";
        }
        return null;
    }

    @Override
    protected void parseURL(URL url, String spec, int start, int limit) {
        String exceptionMessage;
        boolean refOnly;
        String file = null;
        String ref = null;
        int refPos = spec.indexOf(35, limit);
        boolean bl = refOnly = refPos == start;
        if (refPos > -1) {
            ref = spec.substring(refPos + 1, spec.length());
            if (refOnly) {
                file = url.getFile();
            }
        }
        boolean absoluteSpec = false;
        if (spec.length() >= 4) {
            absoluteSpec = spec.substring(0, 4).equalsIgnoreCase("jar:");
        }
        if ((exceptionMessage = this.checkNestedProtocol(spec = spec.substring(start, limit))) != null) {
            throw new NullPointerException(exceptionMessage);
        }
        if (absoluteSpec) {
            file = this.parseAbsoluteSpec(spec);
        } else if (!refOnly) {
            file = this.parseContextSpec(url, spec);
            int bangSlash = Handler.indexOfBangSlash(file);
            String toBangSlash = file.substring(0, bangSlash);
            String afterBangSlash = file.substring(bangSlash);
            ParseUtil canonizer = new ParseUtil();
            afterBangSlash = canonizer.canonizeString(afterBangSlash);
            file = toBangSlash + afterBangSlash;
        }
        this.setURL(url, "jar", "", -1, file, ref);
    }

    private String parseAbsoluteSpec(String spec) {
        URL url = null;
        int index = -1;
        index = Handler.indexOfBangSlash(spec);
        if (index == -1) {
            throw new NullPointerException("no !/ in spec");
        }
        try {
            String innerSpec = spec.substring(0, index - 1);
            url = new URL(innerSpec);
        }
        catch (MalformedURLException e) {
            throw new NullPointerException("invalid url: " + spec + " (" + e + ")");
        }
        return spec;
    }

    private String parseContextSpec(URL url, String spec) {
        String ctxFile = url.getFile();
        if (spec.startsWith("/")) {
            int bangSlash = Handler.indexOfBangSlash(ctxFile);
            if (bangSlash == -1) {
                throw new NullPointerException("malformed context url:" + url + ": no !/");
            }
            ctxFile = ctxFile.substring(0, bangSlash);
        }
        if (!ctxFile.endsWith("/") && !spec.startsWith("/")) {
            int lastSlash = ctxFile.lastIndexOf(47);
            if (lastSlash == -1) {
                throw new NullPointerException("malformed context url:" + url);
            }
            ctxFile = ctxFile.substring(0, lastSlash + 1);
        }
        return ctxFile + spec;
    }
}

