/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.impl;

import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.OnCompleteRunnable;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class CallbackRunnable
implements Runnable,
OnCompleteRunnable {
    private final ExecutionContext executor;
    private final Function1 onComplete;
    private Try value;

    @Override
    public final void run() {
        Predef$.require(this.value != null);
        try {
            this.onComplete.apply(this.value);
            return;
        }
        catch (Throwable throwable) {
            Option option = NonFatal$.unapply(throwable);
            if (option.isEmpty()) {
                throw throwable;
            }
            this.executor.reportFailure((Throwable)option.get());
            return;
        }
    }

    public final void executeWithValue(Try try_) {
        Try try_2;
        Predef$.require(this.value == null);
        this.value = try_2 = try_;
        try {
            this.executor.execute(this);
            return;
        }
        catch (Throwable throwable) {
            Option option = NonFatal$.unapply(throwable);
            if (option.isEmpty()) {
                throw throwable;
            }
            this.executor.reportFailure((Throwable)option.get());
            return;
        }
    }

    public CallbackRunnable(ExecutionContext executionContext, Function1 function1) {
        this.executor = executionContext;
        this.onComplete = function1;
        this.value = null;
    }
}

