
#ifndef PLASMA_EXPORT_H
#define PLASMA_EXPORT_H

#ifdef PLASMA_STATIC_DEFINE
#  define PLASMA_EXPORT
#  define PLASMA_NO_EXPORT
#else
#  ifndef PLASMA_EXPORT
#    ifdef KF5Plasma_EXPORTS
        /* We are building this library */
#      define PLASMA_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define PLASMA_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef PLASMA_NO_EXPORT
#    define PLASMA_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef PLASMA_DECL_DEPRECATED
#  define PLASMA_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef PLASMA_DECL_DEPRECATED_EXPORT
#  define PLASMA_DECL_DEPRECATED_EXPORT PLASMA_EXPORT PLASMA_DECL_DEPRECATED
#endif

#ifndef PLASMA_DECL_DEPRECATED_NO_EXPORT
#  define PLASMA_DECL_DEPRECATED_NO_EXPORT PLASMA_NO_EXPORT PLASMA_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef PLASMA_NO_DEPRECATED
#    define PLASMA_NO_DEPRECATED
#  endif
#endif

#define PLASMA_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(PLASMA_NO_DEPRECATED) && !defined(PLASMA_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define PLASMA_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define PLASMA_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(PLASMA_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define PLASMA_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(PLASMA_NO_DEPRECATED_WARNINGS) && !defined(PLASMA_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define PLASMA_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define PLASMA_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(PLASMA_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define PLASMA_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(PLASMA_NO_DEPRECATED)
#  undef PLASMA_DEPRECATED
#  define PLASMA_DEPRECATED_EXPORT PLASMA_EXPORT
#  define PLASMA_DEPRECATED_NO_EXPORT PLASMA_NO_EXPORT
#elif defined(PLASMA_NO_DEPRECATED_WARNINGS)
#  define PLASMA_DEPRECATED
#  define PLASMA_DEPRECATED_EXPORT PLASMA_EXPORT
#  define PLASMA_DEPRECATED_NO_EXPORT PLASMA_NO_EXPORT
#else
#  define PLASMA_DEPRECATED PLASMA_DECL_DEPRECATED
#  define PLASMA_DEPRECATED_EXPORT PLASMA_DECL_DEPRECATED_EXPORT
#  define PLASMA_DEPRECATED_NO_EXPORT PLASMA_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define PLASMA_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define PLASMA_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef PLASMA_NO_DEPRECATED
#  define PLASMA_DISABLE_DEPRECATED_BEFORE_AND_AT 0x54e00
#endif
#ifdef PLASMA_NO_DEPRECATED_WARNINGS
#  define PLASMA_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef PLASMA_DEPRECATED_WARNINGS_SINCE
#  ifdef PLASMA_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define PLASMA_DEPRECATED_WARNINGS_SINCE PLASMA_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define PLASMA_DEPRECATED_WARNINGS_SINCE 0x54e00
#  endif
#endif

#ifndef PLASMA_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define PLASMA_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef PLASMA_DEPRECATED
#  define PLASMA_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > PLASMA_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define PLASMA_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if PLASMA_DEPRECATED_WARNINGS_SINCE >= 0x50600
#  define PLASMA_DEPRECATED_VERSION_5_6(text) PLASMA_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA_DEPRECATED_VERSION_5_6(text)
#endif

#if PLASMA_DEPRECATED_WARNINGS_SINCE >= 0x51300
#  define PLASMA_DEPRECATED_VERSION_5_19(text) PLASMA_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA_DEPRECATED_VERSION_5_19(text)
#endif

#if PLASMA_DEPRECATED_WARNINGS_SINCE >= 0x51c00
#  define PLASMA_DEPRECATED_VERSION_5_28(text) PLASMA_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA_DEPRECATED_VERSION_5_28(text)
#endif

#if PLASMA_DEPRECATED_WARNINGS_SINCE >= 0x51e00
#  define PLASMA_DEPRECATED_VERSION_5_30(text) PLASMA_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA_DEPRECATED_VERSION_5_30(text)
#endif

#if PLASMA_DEPRECATED_WARNINGS_SINCE >= 0x52400
#  define PLASMA_DEPRECATED_VERSION_5_36(text) PLASMA_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA_DEPRECATED_VERSION_5_36(text)
#endif

#if PLASMA_DEPRECATED_WARNINGS_SINCE >= 0x52e00
#  define PLASMA_DEPRECATED_VERSION_5_46(text) PLASMA_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA_DEPRECATED_VERSION_5_46(text)
#endif

#if PLASMA_DEPRECATED_WARNINGS_SINCE >= 0x54300
#  define PLASMA_DEPRECATED_VERSION_5_67(text) PLASMA_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA_DEPRECATED_VERSION_5_67(text)
#endif

#if PLASMA_DEPRECATED_WARNINGS_SINCE >= 0x54d00
#  define PLASMA_DEPRECATED_VERSION_5_77(text) PLASMA_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA_DEPRECATED_VERSION_5_77(text)
#endif

#if PLASMA_DEPRECATED_WARNINGS_SINCE >= 0x54e00
#  define PLASMA_DEPRECATED_VERSION_5_78(text) PLASMA_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMA_DEPRECATED_VERSION_5_78(text)
#endif
#define PLASMA_DEPRECATED_VERSION_5(minor, text)      PLASMA_DEPRECATED_VERSION_5_##minor(text)
#define PLASMA_DEPRECATED_VERSION(major, minor, text) PLASMA_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define PLASMA_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) PLASMA_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)

#endif /* PLASMA_EXPORT_H */
