/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.IllegalFormatException;
import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateGPSDateTime;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class SetOffsetTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(SetOffsetTask.class);
    private int offset;
    private int currentProgress = 0;
    private ImagesTableModel imagesTableModel;
    private List<ImageInfo> imageInfos;

    public SetOffsetTask(String group, String name, ImagesTableModel imagesTableModel, int offset, List<ImageInfo> imageInfos) {
        super(group, name);
        this.offset = offset;
        this.imageInfos = imageInfos;
        this.imagesTableModel = imagesTableModel;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getMaxProgress() {
        return this.imageInfos.size();
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        for (ImageInfo imageInfo : this.imageInfos) {
            if (this.interruptRequested()) break;
            ++this.currentProgress;
            this.setProgressMessage();
            try {
                String gmtDate = imageInfo.subtractOffset(imageInfo.getCameraDate(), this.offset);
                new UpdateGPSDateTime(imageInfo, gmtDate);
                this.publish(imageInfo);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        String result = null;
        if (this.currentProgress == 1) {
            result = i18n.tr("Copied time offset to one image.");
        } else {
            try {
                result = String.format(i18n.tr("Copied time offset to %d images."), this.currentProgress);
            }
            catch (IllegalFormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    protected void process(List<ImageInfo> images) {
        for (ImageInfo imageInfo : images) {
            int imageRow = this.imagesTableModel.getRow(imageInfo);
            this.imagesTableModel.fireTableRowsUpdated(imageRow, imageRow);
        }
    }

    @Override
    protected void done() {
        this.imagesTableModel.sortRows();
        super.done();
    }
}

