/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import tim.prune.function.srtm.SrtmTile;

public class TileFinder {
    private byte[] _tileData = null;
    private static final String URL_PREFIX = "https://dds.cr.usgs.gov/srtm/version2_1/SRTM3/";
    private static final String[] CONTINENTS = new String[]{"", "Eurasia", "North_America", "Australia", "Islands", "South_America", "Africa"};

    public URL getUrl(SrtmTile srtmTile) {
        if (srtmTile == null) {
            return null;
        }
        if (this._tileData == null) {
            this._tileData = TileFinder.readDatFile();
            if (this._tileData == null) {
                System.err.println("Build error: resource srtmtiles.dat missing!");
                return null;
            }
        }
        URL uRL = null;
        int n = (srtmTile.getLatitude() + 59) * 360 + (srtmTile.getLongitude() + 180);
        try {
            byte by = this._tileData[n];
            if (by > 0) {
                try {
                    uRL = new URL(URL_PREFIX + CONTINENTS[by] + "/" + srtmTile.getTileName());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return uRL;
    }

    private static byte[] readDatFile() {
        InputStream inputStream = null;
        try {
            inputStream = TileFinder.class.getResourceAsStream("/tim/prune/function/srtm/srtmtiles.dat");
            if (inputStream != null) {
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                inputStream.close();
                byte[] byArray2 = byArray;
                return byArray2;
            }
        }
        catch (IOException iOException) {
            System.err.println("Exception trying to read srtmtiles.dat : " + iOException.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

