/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.RecentFile;
import tim.prune.data.SourceInfo;
import tim.prune.data.Timestamp;
import tim.prune.data.TrackInfo;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.DialogCloser;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.PointTypeSelector;
import tim.prune.save.SettingsForExport;
import tim.prune.save.xml.GpxCacherList;
import tim.prune.save.xml.XmlUtils;

public class GpxExporter
extends GenericFunction
implements Runnable {
    private TrackInfo _trackInfo = null;
    private JDialog _dialog = null;
    private JTextField _nameField = null;
    private JTextField _descriptionField = null;
    private PointTypeSelector _pointTypeSelector = null;
    private JCheckBox _timestampsCheckbox = null;
    private JCheckBox _copySourceCheckbox = null;
    private JPanel _encodingsPanel = null;
    private JRadioButton _useSystemRadio = null;
    private JRadioButton _forceUtf8Radio = null;
    private File _exportFile = null;
    private SourceInfo _previousSourceInfo = null;
    private static final String GPX_CREATOR = "GpsPrune v20.2 activityworkshop.net";

    public GpxExporter(App app) {
        super(app);
        this._trackInfo = app.getTrackInfo();
    }

    @Override
    public String getNameKey() {
        return "function.exportgpx";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._pointTypeSelector.init(this._app.getTrackInfo());
        this._encodingsPanel.setVisible(!XmlUtils.isSystemUtf8());
        if (!XmlUtils.isSystemUtf8()) {
            String string = XmlUtils.getSystemEncoding();
            this._useSystemRadio.setText(String.valueOf(I18nManager.getText("dialog.exportgpx.encoding.system")) + " (" + (string == null ? "unknown" : string) + ")");
        }
        this.setFileTitle();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        Serializable serializable;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 2));
        jPanel4.add(new JLabel(I18nManager.getText("dialog.exportgpx.name")));
        this._nameField = new JTextField(10);
        jPanel4.add(this._nameField);
        jPanel4.add(new JLabel(I18nManager.getText("dialog.exportgpx.desc")));
        this._descriptionField = new JTextField(10);
        jPanel4.add(this._descriptionField);
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createVerticalStrut(5));
        this._pointTypeSelector = new PointTypeSelector();
        jPanel3.add(this._pointTypeSelector);
        JPanel jPanel5 = new JPanel();
        this._timestampsCheckbox = new JCheckBox(I18nManager.getText("dialog.exportgpx.includetimestamps"));
        this._timestampsCheckbox.setSelected(true);
        jPanel5.add(this._timestampsCheckbox);
        this._copySourceCheckbox = new JCheckBox(I18nManager.getText("dialog.exportgpx.copysource"));
        this._copySourceCheckbox.setSelected(true);
        jPanel5.add(this._copySourceCheckbox);
        jPanel3.add(jPanel5);
        this._encodingsPanel = new JPanel();
        if (!XmlUtils.isSystemUtf8()) {
            this._encodingsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this._encodingsPanel.setLayout(new BorderLayout());
            this._encodingsPanel.add((Component)new JLabel(I18nManager.getText("dialog.exportgpx.encoding")), "North");
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            serializable = new ButtonGroup();
            this._useSystemRadio = new JRadioButton(I18nManager.getText("dialog.exportgpx.encoding.system"));
            this._forceUtf8Radio = new JRadioButton(I18nManager.getText("dialog.exportgpx.encoding.utf8"));
            ((ButtonGroup)serializable).add(this._useSystemRadio);
            ((ButtonGroup)serializable).add(this._forceUtf8Radio);
            jPanel.add(this._useSystemRadio);
            jPanel.add(this._forceUtf8Radio);
            this._useSystemRadio.setSelected(true);
            this._encodingsPanel.add((Component)jPanel, "Center");
            jPanel3.add(this._encodingsPanel);
        }
        jPanel2.add((Component)jPanel3, "Center");
        this._nameField.addKeyListener(new DialogCloser(this._dialog));
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        serializable = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpxExporter.this.startExport();
            }
        };
        ((AbstractButton)serializable).addActionListener(actionListener);
        this._descriptionField.addActionListener(actionListener);
        jPanel.add((Component)serializable);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpxExporter.this._dialog.dispose();
            }
        });
        jPanel.add(jButton);
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel2;
    }

    private void setFileTitle() {
        String string;
        SourceInfo sourceInfo = this._app.getTrackInfo().getFileInfo().getLastFileInfo();
        if (sourceInfo != this._previousSourceInfo && (string = sourceInfo.getFileTitle()) != null && !string.equals("")) {
            this._nameField.setText(string);
        }
        if (this._nameField.getText().equals("") && (string = this._app.getTrackInfo().getFileInfo().getLastFileTitle()) != null && !string.equals("")) {
            this._nameField.setText(string);
        }
        this._previousSourceInfo = sourceInfo;
    }

    private void startExport() {
        if (!this._pointTypeSelector.getAnythingSelected()) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.save.notypesselected"), I18nManager.getText("dialog.saveoptions.title"), 2);
            return;
        }
        File file = GpxExporter.chooseGpxFile(this._parentFrame);
        if (file != null) {
            this._exportFile = file;
            new Thread(this).start();
        }
    }

    public static File chooseGpxFile(JFrame jFrame) {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setFileFilter(new GenericFileFilter("filetype.gpx", new String[]{"gpx"}));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        String string = Config.getConfigString("prune.trackdirectory");
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        boolean bl = false;
        do {
            bl = false;
            if (jFileChooser.showSaveDialog(jFrame) != 0) continue;
            File file2 = jFileChooser.getSelectedFile();
            if (!file2.getName().toLowerCase().endsWith(".gpx")) {
                file2 = new File(String.valueOf(file2.getAbsolutePath()) + ".gpx");
            }
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file2.exists() || JOptionPane.showOptionDialog(jFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                file = file2;
                continue;
            }
            bl = true;
        } while (bl);
        return file;
    }

    @Override
    public void run() {
        GpxCacherList gpxCacherList = null;
        if (this._copySourceCheckbox.isSelected()) {
            gpxCacherList = new GpxCacherList(this._trackInfo.getFileInfo());
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = this._forceUtf8Radio != null && this._forceUtf8Radio.isSelected() ? new OutputStreamWriter((OutputStream)new FileOutputStream(this._exportFile), "UTF-8") : new OutputStreamWriter(new FileOutputStream(this._exportFile));
            SettingsForExport settingsForExport = new SettingsForExport();
            settingsForExport.setExportTrackPoints(this._pointTypeSelector.getTrackpointsSelected());
            settingsForExport.setExportWaypoints(this._pointTypeSelector.getWaypointsSelected());
            settingsForExport.setExportPhotoPoints(this._pointTypeSelector.getPhotopointsSelected());
            settingsForExport.setExportAudiopoints(this._pointTypeSelector.getAudiopointsSelected());
            settingsForExport.setExportJustSelection(this._pointTypeSelector.getJustSelection());
            settingsForExport.setExportTimestamps(this._timestampsCheckbox.isSelected());
            int n = GpxExporter.exportData(outputStreamWriter, this._trackInfo, this._nameField.getText(), this._descriptionField.getText(), settingsForExport, gpxCacherList);
            outputStreamWriter.close();
            Config.setConfigString("prune.trackdirectory", this._exportFile.getParentFile().getAbsolutePath());
            Config.getRecentFileList().addFile(new RecentFile(this._exportFile, true));
            UpdateMessageBroker.informSubscribers();
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n + " " + I18nManager.getText("confirm.save.ok2") + " " + this._exportFile.getAbsolutePath());
            this._dialog.dispose();
            return;
        }
        catch (IOException iOException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            this.startExport();
            return;
        }
    }

    public static int exportData(OutputStreamWriter outputStreamWriter, TrackInfo trackInfo, String string, String string2, SettingsForExport settingsForExport, GpxCacherList gpxCacherList) throws IOException {
        outputStreamWriter.write(GpxExporter.getXmlHeaderString(outputStreamWriter));
        String string3 = GpxExporter.getGpxHeaderString(gpxCacherList);
        boolean bl = string3.toUpperCase().indexOf("GPX/1/1") > 0;
        outputStreamWriter.write(string3);
        String string4 = string != null && !string.equals("") ? XmlUtils.fixCdata(string) : "GpsPruneTrack";
        String string5 = string2 != null && !string2.equals("") ? XmlUtils.fixCdata(string2) : "Export from GpsPrune";
        GpxExporter.writeNameAndDescription(outputStreamWriter, string4, string5, bl);
        DataPoint dataPoint = null;
        boolean bl2 = settingsForExport.getExportWaypoints();
        boolean bl3 = settingsForExport.getExportJustSelection();
        boolean bl4 = settingsForExport.getExportTimestamps();
        int n = -1;
        int n2 = -1;
        if (bl3) {
            n = trackInfo.getSelection().getStart();
            n2 = trackInfo.getSelection().getEnd();
        }
        int n3 = trackInfo.getTrack().getNumPoints();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            dataPoint = trackInfo.getTrack().getPoint(n5);
            if ((!bl3 || n5 >= n && n5 <= n2) && dataPoint.isWaypoint() && bl2) {
                String string6;
                String string7 = string6 = gpxCacherList == null ? null : GpxExporter.getPointSource(gpxCacherList, dataPoint);
                if (string6 != null) {
                    if (!bl4) {
                        string6 = GpxExporter.stripTime(string6);
                    }
                    outputStreamWriter.write(9);
                    outputStreamWriter.write(string6);
                    outputStreamWriter.write(10);
                } else {
                    GpxExporter.exportWaypoint(dataPoint, outputStreamWriter, settingsForExport);
                }
                ++n4;
            }
            ++n5;
        }
        if (settingsForExport.getExportTrackPoints() || settingsForExport.getExportPhotoPoints() || settingsForExport.getExportAudioPoints()) {
            n4 += GpxExporter.writeTrackPoints(outputStreamWriter, trackInfo, settingsForExport, true, gpxCacherList, "<rtept", "\t<rte><number>1</number>\n", null, "\t</rte>\n");
            String string8 = "\t<trk>\n\t\t<name>" + string4 + "</name>\n\t\t<number>1</number>\n\t\t<trkseg>\n";
            n4 += GpxExporter.writeTrackPoints(outputStreamWriter, trackInfo, settingsForExport, false, gpxCacherList, "<trkpt", string8, "\t</trkseg>\n\t<trkseg>\n", "\t\t</trkseg>\n\t</trk>\n");
        }
        outputStreamWriter.write("</gpx>\n");
        return n4;
    }

    private static void writeNameAndDescription(OutputStreamWriter outputStreamWriter, String string, String string2, boolean bl) throws IOException {
        if (bl) {
            outputStreamWriter.write("\t<metadata>\n");
        }
        if (string != null && !string.equals("")) {
            if (bl) {
                outputStreamWriter.write(9);
            }
            outputStreamWriter.write("\t<name>");
            outputStreamWriter.write(string);
            outputStreamWriter.write("</name>\n");
        }
        if (bl) {
            outputStreamWriter.write(9);
        }
        outputStreamWriter.write("\t<desc>");
        outputStreamWriter.write(string2);
        outputStreamWriter.write("</desc>\n");
        if (bl) {
            outputStreamWriter.write("\t</metadata>\n");
        }
    }

    private static int writeTrackPoints(OutputStreamWriter outputStreamWriter, TrackInfo trackInfo, SettingsForExport settingsForExport, boolean bl, GpxCacherList gpxCacherList, String string, String string2, String string3, String string4) throws IOException {
        int n = trackInfo.getTrack().getNumPoints();
        int n2 = trackInfo.getSelection().getStart();
        int n3 = trackInfo.getSelection().getEnd();
        int n4 = 0;
        boolean bl2 = settingsForExport.getExportJustSelection();
        boolean bl3 = settingsForExport.getExportTrackPoints();
        boolean bl4 = settingsForExport.getExportPhotoPoints();
        boolean bl5 = settingsForExport.getExportAudioPoints();
        boolean bl6 = settingsForExport.getExportTimestamps();
        int n5 = 0;
        while (n5 < n) {
            DataPoint dataPoint = trackInfo.getTrack().getPoint(n5);
            if ((!bl2 || n5 >= n2 && n5 <= n3) && !dataPoint.isWaypoint() && (dataPoint.getPhoto() == null && bl3 || dataPoint.getPhoto() != null && bl4 || dataPoint.getAudio() != null && bl5)) {
                String string5 = GpxExporter.getPointSource(gpxCacherList, dataPoint);
                if (string5 != null && !string5.trim().toLowerCase().startsWith(string)) {
                    string5 = null;
                }
                if (string5 != null || !bl) {
                    if (n4 > 0 && dataPoint.getSegmentStart() && string3 != null) {
                        outputStreamWriter.write(string3);
                    }
                    if (n4 == 0) {
                        outputStreamWriter.write(string2);
                    }
                    if (string5 != null) {
                        if (!bl6) {
                            string5 = GpxExporter.stripTime(string5);
                        }
                        outputStreamWriter.write(string5);
                        outputStreamWriter.write(10);
                    } else if (!bl) {
                        GpxExporter.exportTrackpoint(dataPoint, outputStreamWriter, settingsForExport);
                    }
                    ++n4;
                }
            }
            ++n5;
        }
        if (n4 > 0) {
            outputStreamWriter.write(string4);
        }
        return n4;
    }

    private static String getPointSource(GpxCacherList gpxCacherList, DataPoint dataPoint) {
        if (gpxCacherList == null || dataPoint == null) {
            return null;
        }
        String string = gpxCacherList.getSourceString(dataPoint);
        if (string == null || !dataPoint.isModified()) {
            return string;
        }
        string = GpxExporter.replaceGpxTags(string, "lat=\"", "\"", dataPoint.getLatitude().output(17));
        string = GpxExporter.replaceGpxTags(string, "lon=\"", "\"", dataPoint.getLongitude().output(17));
        string = GpxExporter.replaceGpxTags(string, "<ele>", "</ele>", dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES));
        string = GpxExporter.replaceGpxTags(string, "<time>", "</time>", dataPoint.getTimestamp().getText(Timestamp.Format.ISO8601, null));
        if (dataPoint.isWaypoint()) {
            if ((string = GpxExporter.replaceGpxTags(string, "<name>", "</name>", XmlUtils.fixCdata(dataPoint.getWaypointName()))) != null) {
                string = string.replaceAll("<description>", "<desc>").replaceAll("</description>", "</desc>");
            }
            string = GpxExporter.replaceGpxTags(string, "<desc>", "</desc>", XmlUtils.fixCdata(dataPoint.getFieldValue(Field.DESCRIPTION)));
            string = GpxExporter.replaceGpxTags(string, "<cmt>", "</cmt>", dataPoint.getFieldValue(Field.COMMENT));
        }
        if (string != null && (dataPoint.hasMedia() || string.indexOf("</link>") > 0)) {
            string = GpxExporter.replaceMediaLinks(string, GpxExporter.makeMediaLink(dataPoint));
        }
        return string;
    }

    private static String replaceGpxTags(String string, String string2, String string3, String string4) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        int n2 = string.indexOf(string3, n + string2.length());
        if (n > 0 && n2 > 0) {
            String string5 = string.substring(n + string2.length(), n2);
            if (string4 != null && string5.equals(string4)) {
                return string;
            }
            if (string4 == null || string4.equals("")) {
                return String.valueOf(string.substring(0, n)) + string.substring(n2 + string3.length());
            }
            return String.valueOf(string.substring(0, n + string2.length())) + string4 + string.substring(n2);
        }
        if (string4 == null || string4.equals("")) {
            return string;
        }
        return null;
    }

    private static String replaceMediaLinks(String string, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = "<link";
        String string4 = "</link>";
        int n = string.indexOf("<link");
        int n2 = string.lastIndexOf("</link>");
        if (n > 0 && n2 > 0) {
            String string5 = string.substring(n, n2 + "</link>".length());
            if (string2 != null && string5.equals(string2)) {
                return string;
            }
            if (string2 == null || string2.equals("")) {
                return String.valueOf(string.substring(0, n)) + string.substring(n2 + "</link>".length());
            }
            return String.valueOf(string.substring(0, n)) + string2 + string.substring(n2 + "</link>".length());
        }
        if (string2 == null || string2.equals("")) {
            return string;
        }
        return null;
    }

    private static String getXmlHeaderString(OutputStreamWriter outputStreamWriter) {
        return "<?xml version=\"1.0\" encoding=\"" + XmlUtils.getEncoding(outputStreamWriter) + "\"?>\n";
    }

    private static String getGpxHeaderString(GpxCacherList gpxCacherList) {
        String string = null;
        if (gpxCacherList != null) {
            string = gpxCacherList.getFirstHeader();
        }
        if (string == null || string.length() < 5) {
            string = "<gpx version=\"1.0\" creator=\"GpsPrune v20.2 activityworkshop.net\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns=\"http://www.topografix.com/GPX/1/0\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd\">\n";
        }
        return String.valueOf(string) + "\n";
    }

    private static void exportWaypoint(DataPoint dataPoint, Writer writer, SettingsForExport settingsForExport) throws IOException {
        String string;
        String string2;
        writer.write("\t<wpt lat=\"");
        writer.write(dataPoint.getLatitude().output(17));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write("\">\n");
        if (dataPoint.hasAltitude() || settingsForExport.getExportMissingAltitudesAsZero()) {
            writer.write("\t\t<ele>");
            writer.write(dataPoint.hasAltitude() ? dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES) : "0");
            writer.write("</ele>\n");
        }
        if (dataPoint.hasTimestamp() && settingsForExport.getExportTimestamps()) {
            writer.write("\t\t<time>");
            writer.write(dataPoint.getTimestamp().getText(Timestamp.Format.ISO8601, null));
            writer.write("</time>\n");
        }
        writer.write("\t\t<name>");
        writer.write(XmlUtils.fixCdata(dataPoint.getWaypointName().trim()));
        writer.write("</name>\n");
        String string3 = XmlUtils.fixCdata(dataPoint.getFieldValue(Field.DESCRIPTION));
        if (string3 != null && !string3.equals("")) {
            writer.write("\t\t<desc>");
            writer.write(string3);
            writer.write("</desc>\n");
        }
        if ((string2 = XmlUtils.fixCdata(dataPoint.getFieldValue(Field.COMMENT))) != null && !string2.equals("")) {
            writer.write("\t\t<cmt>");
            writer.write(string2);
            writer.write("</cmt>\n");
        }
        if (settingsForExport.getExportPhotoPoints() && dataPoint.getPhoto() != null) {
            writer.write("\t\t");
            writer.write(GpxExporter.makeMediaLink(dataPoint.getPhoto()));
            writer.write(10);
        }
        if (settingsForExport.getExportAudioPoints() && dataPoint.getAudio() != null) {
            writer.write("\t\t");
            writer.write(GpxExporter.makeMediaLink(dataPoint.getAudio()));
            writer.write(10);
        }
        if ((string = dataPoint.getFieldValue(Field.WAYPT_TYPE)) != null && !(string = string.trim()).equals("")) {
            writer.write("\t\t<type>");
            writer.write(string);
            writer.write("</type>\n");
        }
        writer.write("\t</wpt>\n");
    }

    private static void exportTrackpoint(DataPoint dataPoint, Writer writer, SettingsForExport settingsForExport) throws IOException {
        Timestamp timestamp;
        writer.write("\t\t\t<trkpt lat=\"");
        writer.write(dataPoint.getLatitude().output(17));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write("\">\n");
        if (dataPoint.hasAltitude() || settingsForExport.getExportMissingAltitudesAsZero()) {
            writer.write("\t\t\t\t<ele>");
            writer.write(dataPoint.hasAltitude() ? dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES) : "0");
            writer.write("</ele>\n");
        }
        if ((timestamp = GpxExporter.getPointTimestamp(dataPoint, settingsForExport)) != null && settingsForExport.getExportTimestamps()) {
            writer.write("\t\t\t\t<time>");
            writer.write(timestamp.getText(Timestamp.Format.ISO8601, null));
            writer.write("</time>\n");
        }
        if (dataPoint.getPhoto() != null && settingsForExport.getExportPhotoPoints()) {
            writer.write("\t\t\t\t");
            writer.write(GpxExporter.makeMediaLink(dataPoint.getPhoto()));
            writer.write("\n");
        }
        if (dataPoint.getAudio() != null && settingsForExport.getExportAudioPoints()) {
            writer.write(GpxExporter.makeMediaLink(dataPoint.getAudio()));
        }
        writer.write("\t\t\t</trkpt>\n");
    }

    private static String makeMediaLink(DataPoint dataPoint) {
        Photo photo = dataPoint.getPhoto();
        AudioClip audioClip = dataPoint.getAudio();
        if (photo == null && audioClip == null) {
            return null;
        }
        String string = "";
        if (photo != null) {
            string = GpxExporter.makeMediaLink(photo);
        }
        if (audioClip != null) {
            string = String.valueOf(string) + GpxExporter.makeMediaLink(audioClip);
        }
        return string;
    }

    private static String makeMediaLink(MediaObject mediaObject) {
        if (mediaObject.getFile() != null) {
            return "<link href=\"" + mediaObject.getFile().getAbsolutePath() + "\"><text>" + mediaObject.getName() + "</text></link>";
        }
        if (mediaObject.getUrl() != null) {
            return "<link href=\"" + mediaObject.getUrl() + "\"><text>" + mediaObject.getName() + "</text></link>";
        }
        return "";
    }

    private static String stripTime(String string) {
        return string.replaceAll("[ \t]*<time>.*?</time>", "");
    }

    private static Timestamp getPointTimestamp(DataPoint dataPoint, SettingsForExport settingsForExport) {
        if (dataPoint.hasTimestamp()) {
            return dataPoint.getTimestamp();
        }
        if (dataPoint.getPhoto() != null && settingsForExport.getExportPhotoPoints() && dataPoint.getPhoto().hasTimestamp()) {
            return dataPoint.getPhoto().getTimestamp();
        }
        if (dataPoint.getAudio() != null && settingsForExport.getExportAudioPoints() && dataPoint.getAudio().hasTimestamp()) {
            return dataPoint.getAudio().getTimestamp();
        }
        return null;
    }
}

