/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.InsnNode;

public class SelectTypeVisitor {
    private SelectTypeVisitor() {
    }

    public static void visit(DexNode dex, InsnNode insn) {
        RegisterArg res = insn.getResult();
        if (res != null && !res.getType().isTypeKnown()) {
            SelectTypeVisitor.selectType(dex, res);
        }
        for (InsnArg arg : insn.getArguments()) {
            if (arg.getType().isTypeKnown()) continue;
            SelectTypeVisitor.selectType(dex, arg);
        }
    }

    private static void selectType(DexNode dex, InsnArg arg) {
        ArgType t = arg.getType();
        ArgType newType = ArgType.merge(dex, t, t.selectFirst());
        arg.setType(newType);
    }
}

