/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.prometheus.exporter.MetricsQueryTemplate;
import org.w3c.dom.Node;

public class MetricsQuery {
    private final String path;
    private final ModifiableSolrParams parameters;
    private final String core;
    private final String collection;
    private final List<JsonQuery> jsonQueries;

    private MetricsQuery(String path, ModifiableSolrParams parameters, String core, String collection, List<JsonQuery> jsonQueries) {
        this.path = path;
        this.parameters = parameters;
        this.core = core;
        this.collection = collection;
        this.jsonQueries = jsonQueries;
    }

    public MetricsQuery withCore(String core) {
        return new MetricsQuery(this.getPath(), this.getParameters(), core, this.getCollection().orElse(null), this.getJsonQueries());
    }

    public MetricsQuery withCollection(String collection) {
        return new MetricsQuery(this.getPath(), this.getParameters(), this.getCore().orElse(null), collection, this.getJsonQueries());
    }

    public String getPath() {
        return this.path;
    }

    public Optional<String> getCore() {
        return Optional.ofNullable(this.core);
    }

    public Optional<String> getCollection() {
        return Optional.ofNullable(this.collection);
    }

    public List<JsonQuery> getJsonQueries() {
        return this.jsonQueries;
    }

    public static List<MetricsQuery> from(Node node, Map<String, MetricsQueryTemplate> jqTemplates) throws JsonQueryException {
        ArrayList<MetricsQuery> metricsQueries = new ArrayList<MetricsQuery>();
        NamedList config = DOMUtil.childNodesToNamedList((Node)node);
        List requests = config.getAll("request");
        for (NamedList request : requests) {
            NamedList query = (NamedList)request.get("query");
            NamedList queryParameters = (NamedList)query.get("params");
            String path = (String)query.get("path");
            String core = (String)query.get("core");
            String collection = (String)query.get("collection");
            ArrayList jsonQueries = (ArrayList)request.get("jsonQueries");
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (queryParameters != null) {
                for (Map.Entry entrySet : queryParameters.asShallowMap().entrySet()) {
                    params.add((String)entrySet.getKey(), new String[]{(String)entrySet.getValue()});
                }
            }
            QueryRequest queryRequest = new QueryRequest((SolrParams)params);
            queryRequest.setPath(path);
            ArrayList<JsonQuery> compiledQueries = new ArrayList<JsonQuery>();
            if (jsonQueries != null) {
                for (String jsonQuery : jsonQueries) {
                    Optional<Matcher> maybeMatcher;
                    String jsonQueryCollapseWs = jsonQuery.replaceAll("\\s+", " ").trim();
                    if (jsonQueryCollapseWs.startsWith("$jq:") && (maybeMatcher = MetricsQueryTemplate.matches(jsonQueryCollapseWs)).isPresent()) {
                        Matcher matcher = maybeMatcher.get();
                        String templateName = matcher.group("TEMPLATE");
                        MetricsQueryTemplate template = jqTemplates.get(templateName);
                        if (template == null) {
                            throw new IllegalStateException("jq template '" + matcher.group("TEMPLATE") + "' not found!");
                        }
                        jsonQuery = template.applyTemplate(matcher);
                    }
                    JsonQuery compiledJsonQuery = JsonQuery.compile((String)jsonQuery);
                    compiledQueries.add(compiledJsonQuery);
                }
            }
            metricsQueries.add(new MetricsQuery(path, params, core, collection, compiledQueries));
        }
        return metricsQueries;
    }

    public ModifiableSolrParams getParameters() {
        return this.parameters;
    }
}

