/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import javax.swing.JMenuItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

public class PopupMenuExportResponse
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    private static final String NEWLINE = System.lineSeparator();
    private static Logger log = LogManager.getLogger(PopupMenuExportResponse.class);
    private ExtensionHistory extension = null;

    public PopupMenuExportResponse() {
        super(Constant.messages.getString("history.export.response.popup"));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<HistoryReference> hrefs = PopupMenuExportResponse.this.extension.getSelectedHistoryReferences();
                if (hrefs.size() == 0) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("history.export.response.select.warning"));
                    return;
                }
                File file = PopupMenuExportResponse.this.getOutputFile();
                if (file == null) {
                    return;
                }
                boolean isAppend = true;
                if (file.exists()) {
                    int rc = PopupMenuExportResponse.this.extension.getView().showYesNoCancelDialog(Constant.messages.getString("file.overwrite.warning"));
                    if (rc == 2) {
                        return;
                    }
                    if (rc == 0) {
                        isAppend = false;
                    }
                }
                try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, isAppend));){
                    for (HistoryReference href : hrefs) {
                        HttpMessage msg = null;
                        msg = href.getHttpMessage();
                        PopupMenuExportResponse.this.exportHistory(msg, bos);
                    }
                }
                catch (Exception e1) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("file.save.error") + file.getAbsolutePath() + ".");
                    log.warn(e1.getMessage(), (Throwable)e1);
                }
            }
        });
    }

    void setExtension(ExtensionHistory extension) {
        this.extension = extension;
    }

    private void exportHistory(HttpMessage msg, BufferedOutputStream bos) {
        try {
            if (!msg.getResponseHeader().isEmpty()) {
                String boundary = NEWLINE + "==== " + msg.getHistoryRef().getHistoryId() + " ==========" + NEWLINE;
                bos.write(boundary.getBytes());
                bos.write(msg.getResponseBody().getBytes());
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private File getOutputFile() {
        String filename = "untitled.txt";
        WritableFileChooser chooser = new WritableFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory());
        if (filename.length() > 0) {
            chooser.setSelectedFile(new File(filename));
        }
        File file = null;
        int rc = chooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (rc == 0) {
            file = chooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            return file;
        }
        return file;
    }
}

