"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.signAuthnRequestPost = exports.signSamlPost = void 0;
const xml_crypto_1 = require("xml-crypto");
const algorithms = __importStar(require("./algorithms"));
const authnRequestXPath = '/*[local-name(.)="AuthnRequest" and namespace-uri(.)="urn:oasis:names:tc:SAML:2.0:protocol"]';
const issuerXPath = '/*[local-name(.)="Issuer" and namespace-uri(.)="urn:oasis:names:tc:SAML:2.0:assertion"]';
const defaultTransforms = ['http://www.w3.org/2000/09/xmldsig#enveloped-signature', 'http://www.w3.org/2001/10/xml-exc-c14n#'];
function signSamlPost(samlMessage, xpath, options) {
    if (!samlMessage)
        throw new Error('samlMessage is required');
    if (!xpath)
        throw new Error('xpath is required');
    if (!options || !options.privateCert)
        throw new Error('options.privateCert is required');
    const transforms = options.xmlSignatureTransforms || defaultTransforms;
    const sig = new xml_crypto_1.SignedXml();
    if (options.signatureAlgorithm) {
        sig.signatureAlgorithm = algorithms.getSigningAlgorithm(options.signatureAlgorithm);
    }
    sig.addReference(xpath, transforms, algorithms.getDigestAlgorithm(options.digestAlgorithm));
    sig.signingKey = options.privateCert;
    sig.computeSignature(samlMessage, { location: { reference: xpath + issuerXPath, action: 'after' } });
    return sig.getSignedXml();
}
exports.signSamlPost = signSamlPost;
function signAuthnRequestPost(authnRequest, options) {
    return signSamlPost(authnRequest, authnRequestXPath, options);
}
exports.signAuthnRequestPost = signAuthnRequestPost;
//# sourceMappingURL=saml-post-signing.js.map