"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var stubs = require("../../parser/stubs");
var def = require("raml-definition-system");
var core = require("../../parser/wrapped-ast/parserCore");
var apiLoader = require("../../parser/apiLoader");
var helper = require("../../parser/wrapped-ast/wrapperHelper08");
var ApiImpl = /** @class */ (function (_super) {
    __extends(ApiImpl, _super);
    function ApiImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * The title property is a short plain text description of the RESTful API. The value SHOULD be suitable for use as a title for the contained user documentation.
     **/
    ApiImpl.prototype.title = function () {
        return _super.prototype.attribute.call(this, 'title', this.toString);
    };
    /**
     * @hidden
     * Set title value
     **/
    ApiImpl.prototype.setTitle = function (param) {
        this.highLevel().attrOrCreate("title").setValue("" + param);
        return this;
    };
    /**
     * If the RAML API definition is targeted to a specific API version, the API definition MUST contain a version property. The version property is OPTIONAL and should not be used if: The API itself is not versioned. The API definition does not change between versions. The API architect can decide whether a change to user documentation elements, but no change to the API's resources, constitutes a version change. The API architect MAY use any versioning scheme so long as version numbers retain the same format. For example, 'v3', 'v3.0', and 'V3' are all allowed, but are not considered to be equal.
     **/
    ApiImpl.prototype.version = function () {
        return _super.prototype.attribute.call(this, 'version', this.toString);
    };
    /**
     * @hidden
     * Set version value
     **/
    ApiImpl.prototype.setVersion = function (param) {
        this.highLevel().attrOrCreate("version").setValue("" + param);
        return this;
    };
    /**
     * (Optional during development; Required after implementation) A RESTful API's resources are defined relative to the API's base URI. The use of the baseUri field is OPTIONAL to allow describing APIs that have not yet been implemented. After the API is implemented (even a mock implementation) and can be accessed at a service endpoint, the API definition MUST contain a baseUri property. The baseUri property's value MUST conform to the URI specification RFC2396 or a Level 1 Template URI as defined in RFC6570. The baseUri property SHOULD only be used as a reference value.
     **/
    ApiImpl.prototype.baseUri = function () {
        return _super.prototype.attribute.call(this, 'baseUri', function (attr) { return new FullUriTemplateStringImpl(attr); });
    };
    /**
     * Base uri parameters are named parameters which described template parameters in the base uri
     * @hidden
     **/
    ApiImpl.prototype.baseUriParameters_original = function () {
        return _super.prototype.elements.call(this, 'baseUriParameters');
    };
    /**
     * URI parameters can be further defined by using the uriParameters property. The use of uriParameters is OPTIONAL. The uriParameters property MUST be a map in which each key MUST be the name of the URI parameter as defined in the baseUri property. The uriParameters CANNOT contain a key named version because it is a reserved URI parameter name. The value of the uriParameters property is itself a map that specifies  the property's attributes as named parameters
     **/
    ApiImpl.prototype.uriParameters = function () {
        return _super.prototype.elements.call(this, 'uriParameters');
    };
    /**
     * A RESTful API can be reached HTTP, HTTPS, or both. The protocols property MAY be used to specify the protocols that an API supports. If the protocols property is not specified, the protocol specified at the baseUri property is used. The protocols property MUST be an array of strings, of values `HTTP` and/or `HTTPS`.
     **/
    ApiImpl.prototype.protocols = function () {
        return _super.prototype.attributes.call(this, 'protocols', this.toString);
    };
    /**
     * @hidden
     * Set protocols value
     **/
    ApiImpl.prototype.setProtocols = function (param) {
        this.highLevel().attrOrCreate("protocols").setValue("" + param);
        return this;
    };
    /**
     * (Optional) The media types returned by API responses, and expected from API requests that accept a body, MAY be defaulted by specifying the mediaType property. This property is specified at the root level of the API definition. The property's value MAY be a single string with a valid media type described in the specification.
     **/
    ApiImpl.prototype.mediaType = function () {
        return _super.prototype.attribute.call(this, 'mediaType', function (attr) { return new MimeTypeImpl(attr); });
    };
    /**
     * To better achieve consistency and simplicity, the API definition SHOULD include an OPTIONAL schemas property in the root section. The schemas property specifies collections of schemas that could be used anywhere in the API definition. The value of the schemas property is an array of maps; in each map, the keys are the schema name, and the values are schema definitions. The schema definitions MAY be included inline or by using the RAML !include user-defined data type.
     **/
    ApiImpl.prototype.schemas = function () {
        return _super.prototype.elements.call(this, 'schemas');
    };
    /**
     * Declarations of traits used in this API
     * @hidden
     **/
    ApiImpl.prototype.traits_original = function () {
        return _super.prototype.elements.call(this, 'traits');
    };
    /**
     * A list of the security schemes to apply to all methods, these must be defined in the securitySchemes declaration.
     **/
    ApiImpl.prototype.securedBy = function () {
        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemeRefImpl(attr); });
    };
    /**
     * Security schemes that can be applied using securedBy
     **/
    ApiImpl.prototype.securitySchemes = function () {
        return _super.prototype.elements.call(this, 'securitySchemes');
    };
    /**
     * Declaration of resource types used in this API
     * @hidden
     **/
    ApiImpl.prototype.resourceTypes_original = function () {
        return _super.prototype.elements.call(this, 'resourceTypes');
    };
    /**
     * Resources are identified by their relative URI, which MUST begin with a slash (/). A resource defined as a root-level property is called a top-level resource. Its property's key is the resource's URI relative to the baseUri. A resource defined as a child property of another resource is called a nested resource, and its property's key is its URI relative to its parent resource's URI. Every property whose key begins with a slash (/), and is either at the root of the API definition or is the child property of a resource property, is a resource property. The key of a resource, i.e. its relative URI, MAY consist of multiple URI path fragments separated by slashes; e.g. `/bom/items` may indicate the collection of items in a bill of materials as a single resource. However, if the individual URI path fragments are themselves resources, the API definition SHOULD use nested resources to describe this structure; e.g. if `/bom` is itself a resource then `/items` should be a nested resource of `/bom`, while `/bom/items` should not be used.
     **/
    ApiImpl.prototype.resources = function () {
        return _super.prototype.elements.call(this, 'resources');
    };
    /**
     * The API definition can include a variety of documents that serve as a user guides and reference documentation for the API. Such documents can clarify how the API works or provide business context. Documentation-generators MUST include all the sections in an API definition's documentation property in the documentation output, and they MUST preserve the order in which the documentation is declared. To add user documentation to the API, include the documentation property at the root of the API definition. The documentation property MUST be an array of documents. Each document MUST contain title and content attributes, both of which are REQUIRED. If the documentation property is specified, it MUST include at least one document. Documentation-generators MUST process the content field as if it was defined using Markdown.
     **/
    ApiImpl.prototype.documentation = function () {
        return _super.prototype.elements.call(this, 'documentation');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ApiImpl.prototype.wrapperClassName = function () { return "ApiImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ApiImpl.prototype.kind = function () { return "Api"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    ApiImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("Api"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    ApiImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.ApiImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    ApiImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.ApiImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     * @hidden
     **/
    ApiImpl.prototype.RAMLVersion_original = function () { return "RAML08"; };
    /**
     * Equivalent API with traits and resource types expanded
     **/
    ApiImpl.prototype.expand = function () {
        return helper.expandTraitsAndResourceTypes(this);
    };
    /**
     * Declarations of traits used in this API
     **/
    ApiImpl.prototype.traits = function () {
        return helper.traitsPrimary(this);
    };
    /**
     * Retrieve all traits including those defined in libraries *
     * @deprecated
     **/
    ApiImpl.prototype.allTraits = function () {
        return helper.allTraits(this);
    };
    /**
     * Declaration of resource types used in this API
     **/
    ApiImpl.prototype.resourceTypes = function () {
        return helper.resourceTypesPrimary(this);
    };
    /**
     * Retrieve all resource types including those defined in libraries
     * @deprecated
     **/
    ApiImpl.prototype.allResourceTypes = function () {
        return helper.allResourceTypes(this);
    };
    /**
     * Get child resource by its relative path
     **/
    ApiImpl.prototype.childResource = function (relPath) {
        return helper.childResource(this, relPath);
    };
    /**
     * Retrieve all resources of the Api
     **/
    ApiImpl.prototype.allResources = function () {
        return helper.allResources(this);
    };
    /**
     * Base uri parameters are named parameters which described template parameters in the base uri
     **/
    ApiImpl.prototype.baseUriParameters = function () {
        return helper.baseUriParametersPrimary(this);
    };
    /**
     * Retrieve an ordered list of all base uri parameters regardless of whether they are described in `baseUriParameters` or not
     * Consider a fragment of RAML specification:
     * ```yaml
     * version: v1
     * baseUri: https://{organization}.example.com/{version}/{service}
     * baseUriParameters:
     * service:
     * ```
     * Here `version` and `organization` are base uri parameters which are not described in the `baseUriParameters` node,
     * Thus, they are not among `Api.baseUriParameters()`, but they are among `Api.allBaseUriParameters()`.
     * @deprecated
     **/
    ApiImpl.prototype.allBaseUriParameters = function () {
        return helper.baseUriParameters(this);
    };
    /**
     * Protocols used by the API. Returns the `protocols` property value if it is specified.
     * Otherwise, returns protocol, specified in the base URI.
     * @deprecated
     **/
    ApiImpl.prototype.allProtocols = function () {
        return helper.allProtocols(this);
    };
    /**
     * @return RAML version of the node
     **/
    ApiImpl.prototype.RAMLVersion = function () {
        return helper.RAMLVersion(this);
    };
    return ApiImpl;
}(core.BasicNodeImpl));
exports.ApiImpl = ApiImpl;
var ValueTypeImpl = /** @class */ (function (_super) {
    __extends(ValueTypeImpl, _super);
    function ValueTypeImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ValueTypeImpl.prototype.wrapperClassName = function () { return "ValueTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ValueTypeImpl.prototype.kind = function () { return "ValueType"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    ValueTypeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("ValueType"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    ValueTypeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("undefined.ValueTypeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    ValueTypeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "undefined.ValueTypeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    ValueTypeImpl.prototype.RAMLVersion = function () { return "undefined"; };
    /**
     * @return JS representation of the node value
     **/
    ValueTypeImpl.prototype.value = function () { return this.attr.value(); };
    return ValueTypeImpl;
}(core.AttributeNodeImpl));
exports.ValueTypeImpl = ValueTypeImpl;
var AnyTypeImpl = /** @class */ (function (_super) {
    __extends(AnyTypeImpl, _super);
    function AnyTypeImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    AnyTypeImpl.prototype.wrapperClassName = function () { return "AnyTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    AnyTypeImpl.prototype.kind = function () { return "AnyType"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    AnyTypeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("AnyType"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    AnyTypeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.AnyTypeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    AnyTypeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.AnyTypeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    AnyTypeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return AnyTypeImpl;
}(ValueTypeImpl));
exports.AnyTypeImpl = AnyTypeImpl;
var NumberTypeImpl = /** @class */ (function (_super) {
    __extends(NumberTypeImpl, _super);
    function NumberTypeImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    NumberTypeImpl.prototype.wrapperClassName = function () { return "NumberTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    NumberTypeImpl.prototype.kind = function () { return "NumberType"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    NumberTypeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("NumberType"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    NumberTypeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.NumberTypeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    NumberTypeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.NumberTypeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    NumberTypeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    /**
     * @return Number representation of the node value
     **/
    NumberTypeImpl.prototype.value = function () { return this.attr.value(); };
    return NumberTypeImpl;
}(ValueTypeImpl));
exports.NumberTypeImpl = NumberTypeImpl;
var BooleanTypeImpl = /** @class */ (function (_super) {
    __extends(BooleanTypeImpl, _super);
    function BooleanTypeImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    BooleanTypeImpl.prototype.wrapperClassName = function () { return "BooleanTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    BooleanTypeImpl.prototype.kind = function () { return "BooleanType"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    BooleanTypeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("BooleanType"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    BooleanTypeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.BooleanTypeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    BooleanTypeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.BooleanTypeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    BooleanTypeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    /**
     * @return Boolean representation of the node value
     **/
    BooleanTypeImpl.prototype.value = function () { return this.attr.value(); };
    return BooleanTypeImpl;
}(ValueTypeImpl));
exports.BooleanTypeImpl = BooleanTypeImpl;
var ReferenceImpl = /** @class */ (function (_super) {
    __extends(ReferenceImpl, _super);
    function ReferenceImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ReferenceImpl.prototype.wrapperClassName = function () { return "ReferenceImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ReferenceImpl.prototype.kind = function () { return "Reference"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    ReferenceImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("Reference"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    ReferenceImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.ReferenceImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    ReferenceImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.ReferenceImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    ReferenceImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    /**
     * @return StructuredValue object representing the node value
     **/
    ReferenceImpl.prototype.value = function () { return core.toStructuredValue(this.attr); };
    ReferenceImpl.prototype.structuredValue = function () {
        return helper.structuredValue(this);
    };
    ReferenceImpl.prototype.name = function () {
        return helper.referenceName(this);
    };
    return ReferenceImpl;
}(core.AttributeNodeImpl));
exports.ReferenceImpl = ReferenceImpl;
var ResourceTypeRefImpl = /** @class */ (function (_super) {
    __extends(ResourceTypeRefImpl, _super);
    function ResourceTypeRefImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ResourceTypeRefImpl.prototype.wrapperClassName = function () { return "ResourceTypeRefImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ResourceTypeRefImpl.prototype.kind = function () { return "ResourceTypeRef"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    ResourceTypeRefImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("ResourceTypeRef"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    ResourceTypeRefImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.ResourceTypeRefImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    ResourceTypeRefImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.ResourceTypeRefImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    ResourceTypeRefImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    ResourceTypeRefImpl.prototype.resourceType = function () {
        return helper.referencedResourceType(this);
    };
    return ResourceTypeRefImpl;
}(ReferenceImpl));
exports.ResourceTypeRefImpl = ResourceTypeRefImpl;
var ResourceTypeImpl = /** @class */ (function (_super) {
    __extends(ResourceTypeImpl, _super);
    function ResourceTypeImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Name of the resource type
     **/
    ResourceTypeImpl.prototype.name = function () {
        return _super.prototype.attribute.call(this, 'name', this.toString);
    };
    /**
     * @hidden
     * Set name value
     **/
    ResourceTypeImpl.prototype.setName = function (param) {
        this.highLevel().attrOrCreate("name").setValue("" + param);
        return this;
    };
    /**
     * Instructions on how and when the resource type should be used.
     **/
    ResourceTypeImpl.prototype.usage = function () {
        return _super.prototype.attribute.call(this, 'usage', this.toString);
    };
    /**
     * @hidden
     * Set usage value
     **/
    ResourceTypeImpl.prototype.setUsage = function (param) {
        this.highLevel().attrOrCreate("usage").setValue("" + param);
        return this;
    };
    /**
     * Methods that are part of this resource type definition
     **/
    ResourceTypeImpl.prototype.methods = function () {
        return _super.prototype.elements.call(this, 'methods');
    };
    /**
     * Instantiation of applyed traits
     **/
    ResourceTypeImpl.prototype.is = function () {
        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
    };
    /**
     * Instantiation of applyed resource type
     **/
    ResourceTypeImpl.prototype["type"] = function () {
        return _super.prototype.attribute.call(this, 'type', function (attr) { return new ResourceTypeRefImpl(attr); });
    };
    /**
     * securityScheme may also be applied to a resource by using the securedBy key, which is equivalent to applying the securityScheme to all methods that may be declared, explicitly or implicitly, by defining the resourceTypes or traits property for that resource. To indicate that the method may be called without applying any securityScheme, the method may be annotated with the null securityScheme.
     **/
    ResourceTypeImpl.prototype.securedBy = function () {
        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemeRefImpl(attr); });
    };
    /**
     * Uri parameters of this resource
     **/
    ResourceTypeImpl.prototype.uriParameters = function () {
        return _super.prototype.elements.call(this, 'uriParameters');
    };
    /**
     * An alternate, human-friendly name for the resource type
     **/
    ResourceTypeImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    ResourceTypeImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    /**
     * A resource or a method can override a base URI template's values. This is useful to restrict or change the default or parameter selection in the base URI. The baseUriParameters property MAY be used to override any or all parameters defined at the root level baseUriParameters property, as well as base URI parameters not specified at the root level.
     **/
    ResourceTypeImpl.prototype.baseUriParameters = function () {
        return _super.prototype.elements.call(this, 'baseUriParameters');
    };
    /**
     * The description attribute describes the intended use or meaning of the $self. This value MAY be formatted using Markdown.
     **/
    ResourceTypeImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ResourceTypeImpl.prototype.wrapperClassName = function () { return "ResourceTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ResourceTypeImpl.prototype.kind = function () { return "ResourceType"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    ResourceTypeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("ResourceType"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    ResourceTypeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.ResourceTypeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    ResourceTypeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.ResourceTypeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    ResourceTypeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    ResourceTypeImpl.prototype.parametrizedProperties = function () {
        return helper.getTemplateParametrizedProperties(this);
    };
    return ResourceTypeImpl;
}(core.BasicNodeImpl));
exports.ResourceTypeImpl = ResourceTypeImpl;
/**
 * Method object allows description of http methods
 **/
var MethodBaseImpl = /** @class */ (function (_super) {
    __extends(MethodBaseImpl, _super);
    function MethodBaseImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Resource methods MAY have one or more responses. Responses MAY be described using the description property, and MAY include example attributes or schema properties.
     **/
    MethodBaseImpl.prototype.responses = function () {
        return _super.prototype.elements.call(this, 'responses');
    };
    /**
     * Some method verbs expect the resource to be sent as a request body. For example, to create a resource, the request must include the details of the resource to create. Resources CAN have alternate representations. For example, an API might support both JSON and XML representations. A method's body is defined in the body property as a hashmap, in which the key MUST be a valid media type.
     **/
    MethodBaseImpl.prototype.body = function () {
        return _super.prototype.elements.call(this, 'body');
    };
    /**
     * A method can override an API's protocols value for that single method by setting a different value for the fields.
     **/
    MethodBaseImpl.prototype.protocols = function () {
        return _super.prototype.attributes.call(this, 'protocols', this.toString);
    };
    /**
     * @hidden
     * Set protocols value
     **/
    MethodBaseImpl.prototype.setProtocols = function (param) {
        this.highLevel().attrOrCreate("protocols").setValue("" + param);
        return this;
    };
    /**
     * A list of the security schemas to apply, these must be defined in the securitySchemes declaration. To indicate that the method may be called without applying any securityScheme, the method may be annotated with the null securityScheme. Security schemas may also be applied to a resource with securedBy, which is equivalent to applying the security schemas to all methods that may be declared, explicitly or implicitly, by defining the resourceTypes or traits property for that resource.
     **/
    MethodBaseImpl.prototype.securedBy = function () {
        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemeRefImpl(attr); });
    };
    /**
     * A resource or a method can override a base URI template's values. This is useful to restrict or change the default or parameter selection in the base URI. The baseUriParameters property MAY be used to override any or all parameters defined at the root level baseUriParameters property, as well as base URI parameters not specified at the root level.
     **/
    MethodBaseImpl.prototype.baseUriParameters = function () {
        return _super.prototype.elements.call(this, 'baseUriParameters');
    };
    /**
     * An APIs resources MAY be filtered (to return a subset of results) or altered (such as transforming a response body from JSON to XML format) by the use of query strings. If the resource or its method supports a query string, the query string MUST be defined by the queryParameters property
     **/
    MethodBaseImpl.prototype.queryParameters = function () {
        return _super.prototype.elements.call(this, 'queryParameters');
    };
    /**
     * Headers that allowed at this position
     **/
    MethodBaseImpl.prototype.headers = function () {
        return _super.prototype.elements.call(this, 'headers');
    };
    MethodBaseImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    MethodBaseImpl.prototype.wrapperClassName = function () { return "MethodBaseImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    MethodBaseImpl.prototype.kind = function () { return "MethodBase"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    MethodBaseImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("MethodBase"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    MethodBaseImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.MethodBaseImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    MethodBaseImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.MethodBaseImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    MethodBaseImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return MethodBaseImpl;
}(core.BasicNodeImpl));
exports.MethodBaseImpl = MethodBaseImpl;
var ResponseImpl = /** @class */ (function (_super) {
    __extends(ResponseImpl, _super);
    function ResponseImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Responses MUST be a map of one or more HTTP status codes, where each status code itself is a map that describes that status code.
     **/
    ResponseImpl.prototype.code = function () {
        return _super.prototype.attribute.call(this, 'code', function (attr) { return new StatusCodeStringImpl(attr); });
    };
    /**
     * An API's methods may support custom header values in responses. The custom, non-standard HTTP headers MUST be specified by the headers property. API's may include the the placeholder token {?} in a header name to indicate that any number of headers that conform to the specified format can be sent in responses. This is particularly useful for APIs that allow HTTP headers that conform to some naming convention to send arbitrary, custom data.
     **/
    ResponseImpl.prototype.headers = function () {
        return _super.prototype.elements.call(this, 'headers');
    };
    /**
     * Each response MAY contain a body property, which conforms to the same structure as request body properties (see Body). Responses that can return more than one response code MAY therefore have multiple bodies defined. For APIs without a priori knowledge of the response types for their responses, `* /*` MAY be used to indicate that responses that do not matching other defined data types MUST be accepted. Processing applications MUST match the most descriptive media type first if `* /*` is used.
     **/
    ResponseImpl.prototype.body = function () {
        return _super.prototype.elements.call(this, 'body');
    };
    /**
     * The description attribute describes the intended use or meaning of the $self. This value MAY be formatted using Markdown.
     **/
    ResponseImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ResponseImpl.prototype.wrapperClassName = function () { return "ResponseImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ResponseImpl.prototype.kind = function () { return "Response"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    ResponseImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("Response"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    ResponseImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.ResponseImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    ResponseImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.ResponseImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    ResponseImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    /**
     * true for codes < 400 and false otherwise
     **/
    ResponseImpl.prototype.isOkRange = function () {
        return helper.isOkRange(this);
    };
    ResponseImpl.prototype.parametrizedProperties = function () {
        return helper.getTemplateParametrizedProperties(this);
    };
    return ResponseImpl;
}(core.BasicNodeImpl));
exports.ResponseImpl = ResponseImpl;
var StringTypeImpl = /** @class */ (function (_super) {
    __extends(StringTypeImpl, _super);
    function StringTypeImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    StringTypeImpl.prototype.wrapperClassName = function () { return "StringTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    StringTypeImpl.prototype.kind = function () { return "StringType"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    StringTypeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("StringType"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    StringTypeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.StringTypeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    StringTypeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.StringTypeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    StringTypeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    /**
     * @return String representation of the node value
     **/
    StringTypeImpl.prototype.value = function () { return this.attr.value(); };
    return StringTypeImpl;
}(ValueTypeImpl));
exports.StringTypeImpl = StringTypeImpl;
var StatusCodeStringImpl = /** @class */ (function (_super) {
    __extends(StatusCodeStringImpl, _super);
    function StatusCodeStringImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    StatusCodeStringImpl.prototype.wrapperClassName = function () { return "StatusCodeStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    StatusCodeStringImpl.prototype.kind = function () { return "StatusCodeString"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    StatusCodeStringImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("StatusCodeString"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    StatusCodeStringImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.StatusCodeStringImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    StatusCodeStringImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.StatusCodeStringImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    StatusCodeStringImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return StatusCodeStringImpl;
}(StringTypeImpl));
exports.StatusCodeStringImpl = StatusCodeStringImpl;
var ParameterImpl = /** @class */ (function (_super) {
    __extends(ParameterImpl, _super);
    function ParameterImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * name of the parameter
     **/
    ParameterImpl.prototype.name = function () {
        return _super.prototype.attribute.call(this, 'name', this.toString);
    };
    /**
     * @hidden
     * Set name value
     **/
    ParameterImpl.prototype.setName = function (param) {
        this.highLevel().attrOrCreate("name").setValue("" + param);
        return this;
    };
    /**
     * An alternate, human-friendly name for the parameter
     **/
    ParameterImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    ParameterImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    /**
     * The type attribute specifies the primitive type of the parameter's resolved value. API clients MUST return/throw an error if the parameter's resolved value does not match the specified type. If type is not specified, it defaults to string.
     **/
    ParameterImpl.prototype["type"] = function () {
        return _super.prototype.attribute.call(this, 'type', this.toString);
    };
    /**
     * @hidden
     * Set type value
     **/
    ParameterImpl.prototype.setType = function (param) {
        this.highLevel().attrOrCreate("type").setValue("" + param);
        return this;
    };
    /**
     * Location of the parameter (can not be edited by user)
     **/
    ParameterImpl.prototype.location = function () {
        return _super.prototype.attribute.call(this, 'location', function (attr) { return new ParameterLocationImpl(attr); });
    };
    /**
     * Set to true if parameter is required
     **/
    ParameterImpl.prototype.required = function () {
        return _super.prototype.attribute.call(this, 'required', this.toBoolean);
    };
    /**
     * @hidden
     * Set required value
     **/
    ParameterImpl.prototype.setRequired = function (param) {
        this.highLevel().attrOrCreate("required").setValue("" + param);
        return this;
    };
    /**
     * The default attribute specifies the default value to use for the property if the property is omitted or its value is not specified. This SHOULD NOT be interpreted as a requirement for the client to send the default attribute's value if there is no other value to send. Instead, the default attribute's value is the value the server uses if the client does not send a value.
     **/
    ParameterImpl.prototype["default"] = function () {
        return _super.prototype.attribute.call(this, 'default', this.toAny);
    };
    /**
     * @hidden
     * Set default value
     **/
    ParameterImpl.prototype.setDefault = function (param) {
        this.highLevel().attrOrCreate("default").setValue("" + param);
        return this;
    };
    /**
     * (Optional) The example attribute shows an example value for the property. This can be used, e.g., by documentation generators to generate sample values for the property.
     **/
    ParameterImpl.prototype.example = function () {
        return _super.prototype.attribute.call(this, 'example', this.toAny);
    };
    /**
     * @hidden
     * Set example value
     **/
    ParameterImpl.prototype.setExample = function (param) {
        this.highLevel().attrOrCreate("example").setValue("" + param);
        return this;
    };
    /**
     * The repeat attribute specifies that the parameter can be repeated. If the parameter can be used multiple times, the repeat parameter value MUST be set to 'true'. Otherwise, the default value is 'false' and the parameter may not be repeated.
     **/
    ParameterImpl.prototype.repeat = function () {
        return _super.prototype.attribute.call(this, 'repeat', this.toBoolean);
    };
    /**
     * @hidden
     * Set repeat value
     **/
    ParameterImpl.prototype.setRepeat = function (param) {
        this.highLevel().attrOrCreate("repeat").setValue("" + param);
        return this;
    };
    /**
     * The description attribute describes the intended use or meaning of the $self. This value MAY be formatted using Markdown.
     **/
    ParameterImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ParameterImpl.prototype.wrapperClassName = function () { return "ParameterImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ParameterImpl.prototype.kind = function () { return "Parameter"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    ParameterImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("Parameter"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    ParameterImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.ParameterImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    ParameterImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.ParameterImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    ParameterImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    ParameterImpl.prototype.parametrizedProperties = function () {
        return helper.getTemplateParametrizedProperties(this);
    };
    return ParameterImpl;
}(core.BasicNodeImpl));
exports.ParameterImpl = ParameterImpl;
var ParameterLocationImpl = /** @class */ (function () {
    function ParameterLocationImpl(attr) {
        this.attr = attr;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ParameterLocationImpl.prototype.wrapperClassName = function () { return "ParameterLocationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ParameterLocationImpl.prototype.kind = function () { return "ParameterLocation"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    ParameterLocationImpl.prototype.allKinds = function () { return ["ParameterLocation"]; };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    ParameterLocationImpl.prototype.allWrapperClassNames = function () { return ["RAML08.ParameterLocationImpl"]; };
    /**
     * @return Whether specified object is an instance of this class
     **/
    ParameterLocationImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.ParameterLocationImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    ParameterLocationImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return ParameterLocationImpl;
}());
exports.ParameterLocationImpl = ParameterLocationImpl;
/**
 * Mardown string is a string which can contain markdown as an extension this markdown should support links with RAML Pointers since 1.0
 **/
var MarkdownStringImpl = /** @class */ (function (_super) {
    __extends(MarkdownStringImpl, _super);
    function MarkdownStringImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    MarkdownStringImpl.prototype.wrapperClassName = function () { return "MarkdownStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    MarkdownStringImpl.prototype.kind = function () { return "MarkdownString"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    MarkdownStringImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("MarkdownString"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    MarkdownStringImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.MarkdownStringImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    MarkdownStringImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.MarkdownStringImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    MarkdownStringImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return MarkdownStringImpl;
}(StringTypeImpl));
exports.MarkdownStringImpl = MarkdownStringImpl;
/**
 * Value must be a string
 **/
var StringTypeDeclarationImpl = /** @class */ (function (_super) {
    __extends(StringTypeDeclarationImpl, _super);
    function StringTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createStringTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * (Optional, applicable only for parameters of type string) The pattern attribute is a regular expression that a parameter of type string MUST match. Regular expressions MUST follow the regular expression specification from ECMA 262/Perl 5. The pattern MAY be enclosed in double quotes for readability and clarity.
     **/
    StringTypeDeclarationImpl.prototype.pattern = function () {
        return _super.prototype.attribute.call(this, 'pattern', this.toString);
    };
    /**
     * @hidden
     * Set pattern value
     **/
    StringTypeDeclarationImpl.prototype.setPattern = function (param) {
        this.highLevel().attrOrCreate("pattern").setValue("" + param);
        return this;
    };
    /**
     * (Optional, applicable only for parameters of type string) The enum attribute provides an enumeration of the parameter's valid values. This MUST be an array. If the enum attribute is defined, API clients and servers MUST verify that a parameter's value matches a value in the enum array. If there is no matching value, the clients and servers MUST treat this as an error.
     **/
    StringTypeDeclarationImpl.prototype.enum = function () {
        return _super.prototype.attributes.call(this, 'enum', this.toString);
    };
    /**
     * @hidden
     * Set enum value
     **/
    StringTypeDeclarationImpl.prototype.setEnum = function (param) {
        this.highLevel().attrOrCreate("enum").setValue("" + param);
        return this;
    };
    /**
     * (Optional, applicable only for parameters of type string) The minLength attribute specifies the parameter value's minimum number of characters.
     **/
    StringTypeDeclarationImpl.prototype.minLength = function () {
        return _super.prototype.attribute.call(this, 'minLength', this.toNumber);
    };
    /**
     * @hidden
     * Set minLength value
     **/
    StringTypeDeclarationImpl.prototype.setMinLength = function (param) {
        this.highLevel().attrOrCreate("minLength").setValue("" + param);
        return this;
    };
    /**
     * (Optional, applicable only for parameters of type string) The maxLength attribute specifies the parameter value's maximum number of characters.
     **/
    StringTypeDeclarationImpl.prototype.maxLength = function () {
        return _super.prototype.attribute.call(this, 'maxLength', this.toNumber);
    };
    /**
     * @hidden
     * Set maxLength value
     **/
    StringTypeDeclarationImpl.prototype.setMaxLength = function (param) {
        this.highLevel().attrOrCreate("maxLength").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    StringTypeDeclarationImpl.prototype.wrapperClassName = function () { return "StringTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    StringTypeDeclarationImpl.prototype.kind = function () { return "StringTypeDeclaration"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    StringTypeDeclarationImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("StringTypeDeclaration"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    StringTypeDeclarationImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.StringTypeDeclarationImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    StringTypeDeclarationImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.StringTypeDeclarationImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    StringTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return StringTypeDeclarationImpl;
}(ParameterImpl));
exports.StringTypeDeclarationImpl = StringTypeDeclarationImpl;
/**
 * Value must be a boolean
 **/
var BooleanTypeDeclarationImpl = /** @class */ (function (_super) {
    __extends(BooleanTypeDeclarationImpl, _super);
    function BooleanTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createBooleanTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    BooleanTypeDeclarationImpl.prototype.wrapperClassName = function () { return "BooleanTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    BooleanTypeDeclarationImpl.prototype.kind = function () { return "BooleanTypeDeclaration"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    BooleanTypeDeclarationImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("BooleanTypeDeclaration"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    BooleanTypeDeclarationImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.BooleanTypeDeclarationImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    BooleanTypeDeclarationImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.BooleanTypeDeclarationImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    BooleanTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return BooleanTypeDeclarationImpl;
}(ParameterImpl));
exports.BooleanTypeDeclarationImpl = BooleanTypeDeclarationImpl;
/**
 * Value MUST be a number. Indicate floating point numbers as defined by YAML.
 **/
var NumberTypeDeclarationImpl = /** @class */ (function (_super) {
    __extends(NumberTypeDeclarationImpl, _super);
    function NumberTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createNumberTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * (Optional, applicable only for parameters of type number or integer) The minimum attribute specifies the parameter's minimum value.
     **/
    NumberTypeDeclarationImpl.prototype.minimum = function () {
        return _super.prototype.attribute.call(this, 'minimum', this.toNumber);
    };
    /**
     * @hidden
     * Set minimum value
     **/
    NumberTypeDeclarationImpl.prototype.setMinimum = function (param) {
        this.highLevel().attrOrCreate("minimum").setValue("" + param);
        return this;
    };
    /**
     * (Optional, applicable only for parameters of type number or integer) The maximum attribute specifies the parameter's maximum value.
     **/
    NumberTypeDeclarationImpl.prototype.maximum = function () {
        return _super.prototype.attribute.call(this, 'maximum', this.toNumber);
    };
    /**
     * @hidden
     * Set maximum value
     **/
    NumberTypeDeclarationImpl.prototype.setMaximum = function (param) {
        this.highLevel().attrOrCreate("maximum").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    NumberTypeDeclarationImpl.prototype.wrapperClassName = function () { return "NumberTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    NumberTypeDeclarationImpl.prototype.kind = function () { return "NumberTypeDeclaration"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    NumberTypeDeclarationImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("NumberTypeDeclaration"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    NumberTypeDeclarationImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.NumberTypeDeclarationImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    NumberTypeDeclarationImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.NumberTypeDeclarationImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    NumberTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return NumberTypeDeclarationImpl;
}(ParameterImpl));
exports.NumberTypeDeclarationImpl = NumberTypeDeclarationImpl;
/**
 * Value MUST be a integer.
 **/
var IntegerTypeDeclarationImpl = /** @class */ (function (_super) {
    __extends(IntegerTypeDeclarationImpl, _super);
    function IntegerTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createIntegerTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    IntegerTypeDeclarationImpl.prototype.wrapperClassName = function () { return "IntegerTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    IntegerTypeDeclarationImpl.prototype.kind = function () { return "IntegerTypeDeclaration"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    IntegerTypeDeclarationImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("IntegerTypeDeclaration"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    IntegerTypeDeclarationImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.IntegerTypeDeclarationImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    IntegerTypeDeclarationImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.IntegerTypeDeclarationImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    IntegerTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return IntegerTypeDeclarationImpl;
}(NumberTypeDeclarationImpl));
exports.IntegerTypeDeclarationImpl = IntegerTypeDeclarationImpl;
/**
 * Value MUST be a string representation of a date as defined in RFC2616 Section 3.3.
 **/
var DateTypeDeclarationImpl = /** @class */ (function (_super) {
    __extends(DateTypeDeclarationImpl, _super);
    function DateTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createDateTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    DateTypeDeclarationImpl.prototype.wrapperClassName = function () { return "DateTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    DateTypeDeclarationImpl.prototype.kind = function () { return "DateTypeDeclaration"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    DateTypeDeclarationImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("DateTypeDeclaration"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    DateTypeDeclarationImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.DateTypeDeclarationImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    DateTypeDeclarationImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.DateTypeDeclarationImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    DateTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return DateTypeDeclarationImpl;
}(ParameterImpl));
exports.DateTypeDeclarationImpl = DateTypeDeclarationImpl;
/**
 * (Applicable only to Form properties) Value is a file. Client generators SHOULD use this type to handle file uploads correctly.
 **/
var FileTypeDeclarationImpl = /** @class */ (function (_super) {
    __extends(FileTypeDeclarationImpl, _super);
    function FileTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createFileTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    FileTypeDeclarationImpl.prototype.wrapperClassName = function () { return "FileTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    FileTypeDeclarationImpl.prototype.kind = function () { return "FileTypeDeclaration"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    FileTypeDeclarationImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("FileTypeDeclaration"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    FileTypeDeclarationImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.FileTypeDeclarationImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    FileTypeDeclarationImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.FileTypeDeclarationImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    FileTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return FileTypeDeclarationImpl;
}(ParameterImpl));
exports.FileTypeDeclarationImpl = FileTypeDeclarationImpl;
var BodyLikeImpl = /** @class */ (function (_super) {
    __extends(BodyLikeImpl, _super);
    function BodyLikeImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Mime type of the request or response body
     **/
    BodyLikeImpl.prototype.name = function () {
        return _super.prototype.attribute.call(this, 'name', this.toString);
    };
    /**
     * @hidden
     * Set name value
     **/
    BodyLikeImpl.prototype.setName = function (param) {
        this.highLevel().attrOrCreate("name").setValue("" + param);
        return this;
    };
    /**
     * The structure of a request or response body MAY be further specified by the schema property under the appropriate media type. The schema key CANNOT be specified if a body's media type is application/x-www-form-urlencoded or multipart/form-data. All parsers of RAML MUST be able to interpret JSON Schema and XML Schema. Schema MAY be declared inline or in an external file. However, if the schema is sufficiently large so as to make it difficult for a person to read the API definition, or the schema is reused across multiple APIs or across multiple miles in the same API, the !include user-defined data type SHOULD be used instead of including the content inline. Alternatively, the value of the schema field MAY be the name of a schema specified in the root-level schemas property, or it MAY be declared in an external file and included by using the by using the RAML !include user-defined data type.
     **/
    BodyLikeImpl.prototype.schema = function () {
        return _super.prototype.attribute.call(this, 'schema', function (attr) { return new SchemaStringImpl(attr); });
    };
    /**
     * Documentation generators MUST use body properties' example attributes to generate example invocations.
     **/
    BodyLikeImpl.prototype.example = function () {
        return _super.prototype.attribute.call(this, 'example', function (attr) { return new ExampleStringImpl(attr); });
    };
    /**
     * Web forms REQUIRE special encoding and custom declaration. If the API's media type is either application/x-www-form-urlencoded or multipart/form-data, the formParameters property MUST specify the name-value pairs that the API is expecting. The formParameters property is a map in which the key is the name of the web form parameter, and the value is itself a map the specifies the web form parameter's attributes.
     **/
    BodyLikeImpl.prototype.formParameters = function () {
        return _super.prototype.elements.call(this, 'formParameters');
    };
    /**
     * Human readable description of the body
     **/
    BodyLikeImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    BodyLikeImpl.prototype.wrapperClassName = function () { return "BodyLikeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    BodyLikeImpl.prototype.kind = function () { return "BodyLike"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    BodyLikeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("BodyLike"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    BodyLikeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.BodyLikeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    BodyLikeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.BodyLikeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    BodyLikeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    BodyLikeImpl.prototype.schemaContent = function () {
        return helper.schemaContent(this);
    };
    BodyLikeImpl.prototype.parametrizedProperties = function () {
        return helper.getTemplateParametrizedProperties(this);
    };
    return BodyLikeImpl;
}(core.BasicNodeImpl));
exports.BodyLikeImpl = BodyLikeImpl;
/**
 * Schema at this moment only two subtypes are supported (json schema and xsd)
 **/
var SchemaStringImpl = /** @class */ (function (_super) {
    __extends(SchemaStringImpl, _super);
    function SchemaStringImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    SchemaStringImpl.prototype.wrapperClassName = function () { return "SchemaStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    SchemaStringImpl.prototype.kind = function () { return "SchemaString"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    SchemaStringImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("SchemaString"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    SchemaStringImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.SchemaStringImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    SchemaStringImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.SchemaStringImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    SchemaStringImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return SchemaStringImpl;
}(StringTypeImpl));
exports.SchemaStringImpl = SchemaStringImpl;
/**
 * JSON schema
 **/
var JSonSchemaStringImpl = /** @class */ (function (_super) {
    __extends(JSonSchemaStringImpl, _super);
    function JSonSchemaStringImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    JSonSchemaStringImpl.prototype.wrapperClassName = function () { return "JSonSchemaStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    JSonSchemaStringImpl.prototype.kind = function () { return "JSonSchemaString"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    JSonSchemaStringImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("JSonSchemaString"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    JSonSchemaStringImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.JSonSchemaStringImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    JSonSchemaStringImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.JSonSchemaStringImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    JSonSchemaStringImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return JSonSchemaStringImpl;
}(SchemaStringImpl));
exports.JSonSchemaStringImpl = JSonSchemaStringImpl;
/**
 * XSD schema
 **/
var XMLSchemaStringImpl = /** @class */ (function (_super) {
    __extends(XMLSchemaStringImpl, _super);
    function XMLSchemaStringImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    XMLSchemaStringImpl.prototype.wrapperClassName = function () { return "XMLSchemaStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    XMLSchemaStringImpl.prototype.kind = function () { return "XMLSchemaString"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    XMLSchemaStringImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("XMLSchemaString"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    XMLSchemaStringImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.XMLSchemaStringImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    XMLSchemaStringImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.XMLSchemaStringImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    XMLSchemaStringImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return XMLSchemaStringImpl;
}(SchemaStringImpl));
exports.XMLSchemaStringImpl = XMLSchemaStringImpl;
var ExampleStringImpl = /** @class */ (function (_super) {
    __extends(ExampleStringImpl, _super);
    function ExampleStringImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ExampleStringImpl.prototype.wrapperClassName = function () { return "ExampleStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ExampleStringImpl.prototype.kind = function () { return "ExampleString"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    ExampleStringImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("ExampleString"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    ExampleStringImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.ExampleStringImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    ExampleStringImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.ExampleStringImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    ExampleStringImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return ExampleStringImpl;
}(StringTypeImpl));
exports.ExampleStringImpl = ExampleStringImpl;
var JSONExampleImpl = /** @class */ (function (_super) {
    __extends(JSONExampleImpl, _super);
    function JSONExampleImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    JSONExampleImpl.prototype.wrapperClassName = function () { return "JSONExampleImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    JSONExampleImpl.prototype.kind = function () { return "JSONExample"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    JSONExampleImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("JSONExample"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    JSONExampleImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.JSONExampleImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    JSONExampleImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.JSONExampleImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    JSONExampleImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return JSONExampleImpl;
}(ExampleStringImpl));
exports.JSONExampleImpl = JSONExampleImpl;
var XMLExampleImpl = /** @class */ (function (_super) {
    __extends(XMLExampleImpl, _super);
    function XMLExampleImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    XMLExampleImpl.prototype.wrapperClassName = function () { return "XMLExampleImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    XMLExampleImpl.prototype.kind = function () { return "XMLExample"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    XMLExampleImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("XMLExample"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    XMLExampleImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.XMLExampleImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    XMLExampleImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.XMLExampleImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    XMLExampleImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return XMLExampleImpl;
}(ExampleStringImpl));
exports.XMLExampleImpl = XMLExampleImpl;
/**
 * Needed to set connection between xml related mime types and xsd schema
 **/
var XMLBodyImpl = /** @class */ (function (_super) {
    __extends(XMLBodyImpl, _super);
    function XMLBodyImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createXMLBody(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * XSD Schema
     **/
    XMLBodyImpl.prototype.schema = function () {
        return _super.prototype.attribute.call(this, 'schema', function (attr) { return new XMLSchemaStringImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    XMLBodyImpl.prototype.wrapperClassName = function () { return "XMLBodyImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    XMLBodyImpl.prototype.kind = function () { return "XMLBody"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    XMLBodyImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("XMLBody"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    XMLBodyImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.XMLBodyImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    XMLBodyImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.XMLBodyImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    XMLBodyImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return XMLBodyImpl;
}(BodyLikeImpl));
exports.XMLBodyImpl = XMLBodyImpl;
/**
 * Needed to set connection between json related mime types and json schema
 **/
var JSONBodyImpl = /** @class */ (function (_super) {
    __extends(JSONBodyImpl, _super);
    function JSONBodyImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createJSONBody(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * JSON Schema
     **/
    JSONBodyImpl.prototype.schema = function () {
        return _super.prototype.attribute.call(this, 'schema', function (attr) { return new JSonSchemaStringImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    JSONBodyImpl.prototype.wrapperClassName = function () { return "JSONBodyImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    JSONBodyImpl.prototype.kind = function () { return "JSONBody"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    JSONBodyImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("JSONBody"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    JSONBodyImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.JSONBodyImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    JSONBodyImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.JSONBodyImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    JSONBodyImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return JSONBodyImpl;
}(BodyLikeImpl));
exports.JSONBodyImpl = JSONBodyImpl;
var SecuritySchemeRefImpl = /** @class */ (function (_super) {
    __extends(SecuritySchemeRefImpl, _super);
    function SecuritySchemeRefImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    SecuritySchemeRefImpl.prototype.wrapperClassName = function () { return "SecuritySchemeRefImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    SecuritySchemeRefImpl.prototype.kind = function () { return "SecuritySchemeRef"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    SecuritySchemeRefImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("SecuritySchemeRef"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    SecuritySchemeRefImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.SecuritySchemeRefImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    SecuritySchemeRefImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.SecuritySchemeRefImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    SecuritySchemeRefImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    SecuritySchemeRefImpl.prototype.securitySchemeName = function () {
        return helper.securitySchemeName(this);
    };
    SecuritySchemeRefImpl.prototype.securityScheme = function () {
        return helper.securityScheme(this);
    };
    return SecuritySchemeRefImpl;
}(ReferenceImpl));
exports.SecuritySchemeRefImpl = SecuritySchemeRefImpl;
/**
 * Declares globally referable security schema definition
 **/
var AbstractSecuritySchemeImpl = /** @class */ (function (_super) {
    __extends(AbstractSecuritySchemeImpl, _super);
    function AbstractSecuritySchemeImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Name of the security scheme
     **/
    AbstractSecuritySchemeImpl.prototype.name = function () {
        return _super.prototype.attribute.call(this, 'name', this.toString);
    };
    /**
     * @hidden
     * Set name value
     **/
    AbstractSecuritySchemeImpl.prototype.setName = function (param) {
        this.highLevel().attrOrCreate("name").setValue("" + param);
        return this;
    };
    /**
     * The securitySchemes property MUST be used to specify an API's security mechanisms, including the required settings and the authentication methods that the API supports. one authentication method is allowed if the API supports them.
     **/
    AbstractSecuritySchemeImpl.prototype["type"] = function () {
        return _super.prototype.attribute.call(this, 'type', this.toString);
    };
    /**
     * @hidden
     * Set type value
     **/
    AbstractSecuritySchemeImpl.prototype.setType = function (param) {
        this.highLevel().attrOrCreate("type").setValue("" + param);
        return this;
    };
    /**
     * The description attribute MAY be used to describe a security schemes property.
     **/
    AbstractSecuritySchemeImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * A description of the request components related to Security that are determined by the scheme: the headers, query parameters or responses. As a best practice, even for standard security schemes, API designers SHOULD describe these properties of security schemes. Including the security scheme description completes an API documentation.
     **/
    AbstractSecuritySchemeImpl.prototype.describedBy = function () {
        return _super.prototype.element.call(this, 'describedBy');
    };
    /**
     * The settings attribute MAY be used to provide security scheme-specific information. The required attributes vary depending on the type of security scheme is being declared. It describes the minimum set of properties which any processing application MUST provide and validate if it chooses to implement the security scheme. Processing applications MAY choose to recognize other properties for things such as token lifetime, preferred cryptographic algorithms, and more.
     **/
    AbstractSecuritySchemeImpl.prototype.settings = function () {
        return _super.prototype.element.call(this, 'settings');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    AbstractSecuritySchemeImpl.prototype.wrapperClassName = function () { return "AbstractSecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    AbstractSecuritySchemeImpl.prototype.kind = function () { return "AbstractSecurityScheme"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    AbstractSecuritySchemeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("AbstractSecurityScheme"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    AbstractSecuritySchemeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.AbstractSecuritySchemeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    AbstractSecuritySchemeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.AbstractSecuritySchemeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    AbstractSecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return AbstractSecuritySchemeImpl;
}(core.BasicNodeImpl));
exports.AbstractSecuritySchemeImpl = AbstractSecuritySchemeImpl;
var SecuritySchemePartImpl = /** @class */ (function (_super) {
    __extends(SecuritySchemePartImpl, _super);
    function SecuritySchemePartImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createSecuritySchemePart(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * An alternate, human-friendly name for the security scheme part
     **/
    SecuritySchemePartImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    SecuritySchemePartImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    /**
     * Instantiation of applyed traits
     **/
    SecuritySchemePartImpl.prototype.is = function () {
        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
    };
    /**
     * Headers that allowed at this position
     **/
    SecuritySchemePartImpl.prototype.headers = function () {
        return _super.prototype.elements.call(this, 'headers');
    };
    /**
     * An APIs resources MAY be filtered (to return a subset of results) or altered (such as transforming a response body from JSON to XML format) by the use of query strings. If the resource or its method supports a query string, the query string MUST be defined by the queryParameters property
     **/
    SecuritySchemePartImpl.prototype.queryParameters = function () {
        return _super.prototype.elements.call(this, 'queryParameters');
    };
    /**
     * Optional array of responses, describing the possible responses that could be sent.
     **/
    SecuritySchemePartImpl.prototype.responses = function () {
        return _super.prototype.elements.call(this, 'responses');
    };
    /**
     * A longer, human-friendly description of the security scheme part
     **/
    SecuritySchemePartImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    SecuritySchemePartImpl.prototype.wrapperClassName = function () { return "SecuritySchemePartImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    SecuritySchemePartImpl.prototype.kind = function () { return "SecuritySchemePart"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    SecuritySchemePartImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("SecuritySchemePart"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    SecuritySchemePartImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.SecuritySchemePartImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    SecuritySchemePartImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.SecuritySchemePartImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    SecuritySchemePartImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return SecuritySchemePartImpl;
}(MethodBaseImpl));
exports.SecuritySchemePartImpl = SecuritySchemePartImpl;
var TraitRefImpl = /** @class */ (function (_super) {
    __extends(TraitRefImpl, _super);
    function TraitRefImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    TraitRefImpl.prototype.wrapperClassName = function () { return "TraitRefImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    TraitRefImpl.prototype.kind = function () { return "TraitRef"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    TraitRefImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("TraitRef"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    TraitRefImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.TraitRefImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    TraitRefImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.TraitRefImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    TraitRefImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    TraitRefImpl.prototype.trait = function () {
        return helper.referencedTrait(this);
    };
    return TraitRefImpl;
}(ReferenceImpl));
exports.TraitRefImpl = TraitRefImpl;
var TraitImpl = /** @class */ (function (_super) {
    __extends(TraitImpl, _super);
    function TraitImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createTrait(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * Name of the trait
     **/
    TraitImpl.prototype.name = function () {
        return _super.prototype.attribute.call(this, 'name', this.toString);
    };
    /**
     * @hidden
     * Set name value
     **/
    TraitImpl.prototype.setName = function (param) {
        this.highLevel().attrOrCreate("name").setValue("" + param);
        return this;
    };
    /**
     * Instructions on how and when the trait should be used.
     **/
    TraitImpl.prototype.usage = function () {
        return _super.prototype.attribute.call(this, 'usage', this.toString);
    };
    /**
     * @hidden
     * Set usage value
     **/
    TraitImpl.prototype.setUsage = function (param) {
        this.highLevel().attrOrCreate("usage").setValue("" + param);
        return this;
    };
    /**
     * An alternate, human-friendly name for the trait
     **/
    TraitImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    TraitImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    TraitImpl.prototype.wrapperClassName = function () { return "TraitImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    TraitImpl.prototype.kind = function () { return "Trait"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    TraitImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("Trait"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    TraitImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.TraitImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    TraitImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.TraitImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    TraitImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    TraitImpl.prototype.parametrizedProperties = function () {
        return helper.getTemplateParametrizedProperties(this);
    };
    return TraitImpl;
}(MethodBaseImpl));
exports.TraitImpl = TraitImpl;
var SecuritySchemeSettingsImpl = /** @class */ (function (_super) {
    __extends(SecuritySchemeSettingsImpl, _super);
    function SecuritySchemeSettingsImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    SecuritySchemeSettingsImpl.prototype.wrapperClassName = function () { return "SecuritySchemeSettingsImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    SecuritySchemeSettingsImpl.prototype.kind = function () { return "SecuritySchemeSettings"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    SecuritySchemeSettingsImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("SecuritySchemeSettings"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    SecuritySchemeSettingsImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.SecuritySchemeSettingsImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    SecuritySchemeSettingsImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.SecuritySchemeSettingsImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    SecuritySchemeSettingsImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return SecuritySchemeSettingsImpl;
}(core.BasicNodeImpl));
exports.SecuritySchemeSettingsImpl = SecuritySchemeSettingsImpl;
var OAuth1SecuritySchemeSettingsImpl = /** @class */ (function (_super) {
    __extends(OAuth1SecuritySchemeSettingsImpl, _super);
    function OAuth1SecuritySchemeSettingsImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createOAuth1SecuritySchemeSettings(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * The URI of the Temporary Credential Request endpoint as defined in RFC5849 Section 2.1
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.requestTokenUri = function () {
        return _super.prototype.attribute.call(this, 'requestTokenUri', function (attr) { return new FixedUriImpl(attr); });
    };
    /**
     * The URI of the Resource Owner Authorization endpoint as defined in RFC5849 Section 2.2
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.authorizationUri = function () {
        return _super.prototype.attribute.call(this, 'authorizationUri', function (attr) { return new FixedUriImpl(attr); });
    };
    /**
     * The URI of the Token Request endpoint as defined in RFC5849 Section 2.3
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.tokenCredentialsUri = function () {
        return _super.prototype.attribute.call(this, 'tokenCredentialsUri', function (attr) { return new FixedUriImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.wrapperClassName = function () { return "OAuth1SecuritySchemeSettingsImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.kind = function () { return "OAuth1SecuritySchemeSettings"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("OAuth1SecuritySchemeSettings"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.OAuth1SecuritySchemeSettingsImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    OAuth1SecuritySchemeSettingsImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.OAuth1SecuritySchemeSettingsImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return OAuth1SecuritySchemeSettingsImpl;
}(SecuritySchemeSettingsImpl));
exports.OAuth1SecuritySchemeSettingsImpl = OAuth1SecuritySchemeSettingsImpl;
/**
 * This  type describes fixed uris
 **/
var FixedUriImpl = /** @class */ (function (_super) {
    __extends(FixedUriImpl, _super);
    function FixedUriImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    FixedUriImpl.prototype.wrapperClassName = function () { return "FixedUriImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    FixedUriImpl.prototype.kind = function () { return "FixedUri"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    FixedUriImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("FixedUri"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    FixedUriImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.FixedUriImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    FixedUriImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.FixedUriImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    FixedUriImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return FixedUriImpl;
}(StringTypeImpl));
exports.FixedUriImpl = FixedUriImpl;
var OAuth2SecuritySchemeSettingsImpl = /** @class */ (function (_super) {
    __extends(OAuth2SecuritySchemeSettingsImpl, _super);
    function OAuth2SecuritySchemeSettingsImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createOAuth2SecuritySchemeSettings(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * The URI of the Token Endpoint as defined in RFC6749 Section 3.2. Not required forby implicit grant type.
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.accessTokenUri = function () {
        return _super.prototype.attribute.call(this, 'accessTokenUri', function (attr) { return new FixedUriImpl(attr); });
    };
    /**
     * The URI of the Authorization Endpoint as defined in RFC6749 Section 3.1. Required forby authorization_code and implicit grant types.
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.authorizationUri = function () {
        return _super.prototype.attribute.call(this, 'authorizationUri', function (attr) { return new FixedUriImpl(attr); });
    };
    /**
     * A list of the Authorization grants supported by the API as defined in RFC6749 Sections 4.1, 4.2, 4.3 and 4.4, can be any of: authorization_code, password, client_credentials, implicit, or refresh_token.
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.authorizationGrants = function () {
        return _super.prototype.attributes.call(this, 'authorizationGrants', this.toString);
    };
    /**
     * @hidden
     * Set authorizationGrants value
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.setAuthorizationGrants = function (param) {
        this.highLevel().attrOrCreate("authorizationGrants").setValue("" + param);
        return this;
    };
    /**
     * A list of scopes supported by the security scheme as defined in RFC6749 Section 3.3
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.scopes = function () {
        return _super.prototype.attributes.call(this, 'scopes', this.toString);
    };
    /**
     * @hidden
     * Set scopes value
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.setScopes = function (param) {
        this.highLevel().attrOrCreate("scopes").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.wrapperClassName = function () { return "OAuth2SecuritySchemeSettingsImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.kind = function () { return "OAuth2SecuritySchemeSettings"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("OAuth2SecuritySchemeSettings"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.OAuth2SecuritySchemeSettingsImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    OAuth2SecuritySchemeSettingsImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.OAuth2SecuritySchemeSettingsImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return OAuth2SecuritySchemeSettingsImpl;
}(SecuritySchemeSettingsImpl));
exports.OAuth2SecuritySchemeSettingsImpl = OAuth2SecuritySchemeSettingsImpl;
/**
 * Declares globally referable security schema definition
 **/
var OAuth2SecuritySchemeImpl = /** @class */ (function (_super) {
    __extends(OAuth2SecuritySchemeImpl, _super);
    function OAuth2SecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createOAuth2SecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    OAuth2SecuritySchemeImpl.prototype.settings = function () {
        return _super.prototype.element.call(this, 'settings');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    OAuth2SecuritySchemeImpl.prototype.wrapperClassName = function () { return "OAuth2SecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    OAuth2SecuritySchemeImpl.prototype.kind = function () { return "OAuth2SecurityScheme"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    OAuth2SecuritySchemeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("OAuth2SecurityScheme"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    OAuth2SecuritySchemeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.OAuth2SecuritySchemeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    OAuth2SecuritySchemeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.OAuth2SecuritySchemeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    OAuth2SecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return OAuth2SecuritySchemeImpl;
}(AbstractSecuritySchemeImpl));
exports.OAuth2SecuritySchemeImpl = OAuth2SecuritySchemeImpl;
/**
 * Declares globally referable security schema definition
 **/
var OAuth1SecuritySchemeImpl = /** @class */ (function (_super) {
    __extends(OAuth1SecuritySchemeImpl, _super);
    function OAuth1SecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createOAuth1SecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    OAuth1SecuritySchemeImpl.prototype.settings = function () {
        return _super.prototype.element.call(this, 'settings');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    OAuth1SecuritySchemeImpl.prototype.wrapperClassName = function () { return "OAuth1SecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    OAuth1SecuritySchemeImpl.prototype.kind = function () { return "OAuth1SecurityScheme"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    OAuth1SecuritySchemeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("OAuth1SecurityScheme"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    OAuth1SecuritySchemeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.OAuth1SecuritySchemeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    OAuth1SecuritySchemeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.OAuth1SecuritySchemeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    OAuth1SecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return OAuth1SecuritySchemeImpl;
}(AbstractSecuritySchemeImpl));
exports.OAuth1SecuritySchemeImpl = OAuth1SecuritySchemeImpl;
/**
 * Declares globally referable security schema definition
 **/
var BasicSecuritySchemeImpl = /** @class */ (function (_super) {
    __extends(BasicSecuritySchemeImpl, _super);
    function BasicSecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createBasicSecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    BasicSecuritySchemeImpl.prototype.wrapperClassName = function () { return "BasicSecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    BasicSecuritySchemeImpl.prototype.kind = function () { return "BasicSecurityScheme"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    BasicSecuritySchemeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("BasicSecurityScheme"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    BasicSecuritySchemeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.BasicSecuritySchemeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    BasicSecuritySchemeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.BasicSecuritySchemeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    BasicSecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return BasicSecuritySchemeImpl;
}(AbstractSecuritySchemeImpl));
exports.BasicSecuritySchemeImpl = BasicSecuritySchemeImpl;
/**
 * Declares globally referable security schema definition
 **/
var DigestSecuritySchemeImpl = /** @class */ (function (_super) {
    __extends(DigestSecuritySchemeImpl, _super);
    function DigestSecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createDigestSecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    DigestSecuritySchemeImpl.prototype.wrapperClassName = function () { return "DigestSecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    DigestSecuritySchemeImpl.prototype.kind = function () { return "DigestSecurityScheme"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    DigestSecuritySchemeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("DigestSecurityScheme"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    DigestSecuritySchemeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.DigestSecuritySchemeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    DigestSecuritySchemeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.DigestSecuritySchemeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    DigestSecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return DigestSecuritySchemeImpl;
}(AbstractSecuritySchemeImpl));
exports.DigestSecuritySchemeImpl = DigestSecuritySchemeImpl;
/**
 * Declares globally referable security schema definition
 **/
var CustomSecuritySchemeImpl = /** @class */ (function (_super) {
    __extends(CustomSecuritySchemeImpl, _super);
    function CustomSecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createCustomSecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    CustomSecuritySchemeImpl.prototype.wrapperClassName = function () { return "CustomSecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    CustomSecuritySchemeImpl.prototype.kind = function () { return "CustomSecurityScheme"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    CustomSecuritySchemeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("CustomSecurityScheme"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    CustomSecuritySchemeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.CustomSecuritySchemeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    CustomSecuritySchemeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.CustomSecuritySchemeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    CustomSecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return CustomSecuritySchemeImpl;
}(AbstractSecuritySchemeImpl));
exports.CustomSecuritySchemeImpl = CustomSecuritySchemeImpl;
var MethodImpl = /** @class */ (function (_super) {
    __extends(MethodImpl, _super);
    function MethodImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createMethod(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * Method that can be called
     **/
    MethodImpl.prototype.method = function () {
        return _super.prototype.attribute.call(this, 'method', this.toString);
    };
    /**
     * @hidden
     * Set method value
     **/
    MethodImpl.prototype.setMethod = function (param) {
        this.highLevel().attrOrCreate("method").setValue("" + param);
        return this;
    };
    /**
     * Instantiation of applyed traits
     **/
    MethodImpl.prototype.is = function () {
        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    MethodImpl.prototype.wrapperClassName = function () { return "MethodImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    MethodImpl.prototype.kind = function () { return "Method"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    MethodImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("Method"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    MethodImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.MethodImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    MethodImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.MethodImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    MethodImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    /**
     * For methods of Resources returns parent resource. For methods of ResourceTypes returns null.
     **/
    MethodImpl.prototype.parentResource = function () {
        return helper.parentResource(this);
    };
    /**
     * Api owning the resource as a sibling
     **/
    MethodImpl.prototype.ownerApi = function () {
        return helper.ownerApi(this);
    };
    /**
     * For methods of Resources: `{parent Resource relative path} {methodName}`.
     * For methods of ResourceTypes: `{parent ResourceType name} {methodName}`.
     * For other methods throws Exception.
     **/
    MethodImpl.prototype.methodId = function () {
        return helper.methodId(this);
    };
    /**
     * Returns security schemes, resource or method is secured with. If no security schemes are set at resource or method level,
     * returns schemes defined with `securedBy` at API level.
     * @deprecated
     **/
    MethodImpl.prototype.allSecuredBy = function () {
        return helper.allSecuredBy(this);
    };
    MethodImpl.prototype.parametrizedProperties = function () {
        return helper.getTemplateParametrizedProperties(this);
    };
    return MethodImpl;
}(MethodBaseImpl));
exports.MethodImpl = MethodImpl;
/**
 * This sub type of the string represents mime types
 **/
var MimeTypeImpl = /** @class */ (function (_super) {
    __extends(MimeTypeImpl, _super);
    function MimeTypeImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    MimeTypeImpl.prototype.wrapperClassName = function () { return "MimeTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    MimeTypeImpl.prototype.kind = function () { return "MimeType"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    MimeTypeImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("MimeType"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    MimeTypeImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.MimeTypeImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    MimeTypeImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.MimeTypeImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    MimeTypeImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return MimeTypeImpl;
}(StringTypeImpl));
exports.MimeTypeImpl = MimeTypeImpl;
/**
 * This type currently serves both for absolute and relative urls
 **/
var UriTemplateImpl = /** @class */ (function (_super) {
    __extends(UriTemplateImpl, _super);
    function UriTemplateImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    UriTemplateImpl.prototype.wrapperClassName = function () { return "UriTemplateImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    UriTemplateImpl.prototype.kind = function () { return "UriTemplate"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    UriTemplateImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("UriTemplate"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    UriTemplateImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.UriTemplateImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    UriTemplateImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.UriTemplateImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    UriTemplateImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return UriTemplateImpl;
}(StringTypeImpl));
exports.UriTemplateImpl = UriTemplateImpl;
/**
 * This  type describes relative uri templates
 **/
var RelativeUriStringImpl = /** @class */ (function (_super) {
    __extends(RelativeUriStringImpl, _super);
    function RelativeUriStringImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    RelativeUriStringImpl.prototype.wrapperClassName = function () { return "RelativeUriStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    RelativeUriStringImpl.prototype.kind = function () { return "RelativeUriString"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    RelativeUriStringImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("RelativeUriString"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    RelativeUriStringImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.RelativeUriStringImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    RelativeUriStringImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.RelativeUriStringImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    RelativeUriStringImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return RelativeUriStringImpl;
}(UriTemplateImpl));
exports.RelativeUriStringImpl = RelativeUriStringImpl;
/**
 * This  type describes absolute uri templates
 **/
var FullUriTemplateStringImpl = /** @class */ (function (_super) {
    __extends(FullUriTemplateStringImpl, _super);
    function FullUriTemplateStringImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    FullUriTemplateStringImpl.prototype.wrapperClassName = function () { return "FullUriTemplateStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    FullUriTemplateStringImpl.prototype.kind = function () { return "FullUriTemplateString"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    FullUriTemplateStringImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("FullUriTemplateString"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    FullUriTemplateStringImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.FullUriTemplateStringImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    FullUriTemplateStringImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.FullUriTemplateStringImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    FullUriTemplateStringImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return FullUriTemplateStringImpl;
}(UriTemplateImpl));
exports.FullUriTemplateStringImpl = FullUriTemplateStringImpl;
var RAMLSimpleElementImpl = /** @class */ (function (_super) {
    __extends(RAMLSimpleElementImpl, _super);
    function RAMLSimpleElementImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    RAMLSimpleElementImpl.prototype.wrapperClassName = function () { return "RAMLSimpleElementImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    RAMLSimpleElementImpl.prototype.kind = function () { return "RAMLSimpleElement"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    RAMLSimpleElementImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("RAMLSimpleElement"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    RAMLSimpleElementImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.RAMLSimpleElementImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    RAMLSimpleElementImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.RAMLSimpleElementImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    RAMLSimpleElementImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return RAMLSimpleElementImpl;
}(core.BasicNodeImpl));
exports.RAMLSimpleElementImpl = RAMLSimpleElementImpl;
var DocumentationItemImpl = /** @class */ (function (_super) {
    __extends(DocumentationItemImpl, _super);
    function DocumentationItemImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createDocumentationItem(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * title of documentation section
     **/
    DocumentationItemImpl.prototype.title = function () {
        return _super.prototype.attribute.call(this, 'title', this.toString);
    };
    /**
     * @hidden
     * Set title value
     **/
    DocumentationItemImpl.prototype.setTitle = function (param) {
        this.highLevel().attrOrCreate("title").setValue("" + param);
        return this;
    };
    /**
     * Content of documentation section
     **/
    DocumentationItemImpl.prototype.content = function () {
        return _super.prototype.attribute.call(this, 'content', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    DocumentationItemImpl.prototype.wrapperClassName = function () { return "DocumentationItemImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    DocumentationItemImpl.prototype.kind = function () { return "DocumentationItem"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    DocumentationItemImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("DocumentationItem"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    DocumentationItemImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.DocumentationItemImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    DocumentationItemImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.DocumentationItemImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    DocumentationItemImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return DocumentationItemImpl;
}(RAMLSimpleElementImpl));
exports.DocumentationItemImpl = DocumentationItemImpl;
/**
 * Content of the schema
 **/
var GlobalSchemaImpl = /** @class */ (function (_super) {
    __extends(GlobalSchemaImpl, _super);
    function GlobalSchemaImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        var _this = _super.call(this, (typeof nodeOrKey == "string") ? createGlobalSchema(nodeOrKey) : nodeOrKey, setAsTopLevel) || this;
        _this.nodeOrKey = nodeOrKey;
        _this.setAsTopLevel = setAsTopLevel;
        return _this;
    }
    /**
     * Name of the global schema, used to refer on schema content
     **/
    GlobalSchemaImpl.prototype.key = function () {
        return _super.prototype.attribute.call(this, 'key', this.toString);
    };
    /**
     * @hidden
     * Set key value
     **/
    GlobalSchemaImpl.prototype.setKey = function (param) {
        this.highLevel().attrOrCreate("key").setValue("" + param);
        return this;
    };
    /**
     * Content of the schema
     **/
    GlobalSchemaImpl.prototype.value = function () {
        return _super.prototype.attribute.call(this, 'value', function (attr) { return new SchemaStringImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    GlobalSchemaImpl.prototype.wrapperClassName = function () { return "GlobalSchemaImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    GlobalSchemaImpl.prototype.kind = function () { return "GlobalSchema"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    GlobalSchemaImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("GlobalSchema"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    GlobalSchemaImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.GlobalSchemaImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    GlobalSchemaImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.GlobalSchemaImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    GlobalSchemaImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    return GlobalSchemaImpl;
}(RAMLSimpleElementImpl));
exports.GlobalSchemaImpl = GlobalSchemaImpl;
var ResourceImpl = /** @class */ (function (_super) {
    __extends(ResourceImpl, _super);
    function ResourceImpl() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Relative URL of this resource from the parent resource
     **/
    ResourceImpl.prototype.relativeUri = function () {
        return _super.prototype.attribute.call(this, 'relativeUri', function (attr) { return new RelativeUriStringImpl(attr); });
    };
    /**
     * Instantiation of applyed resource type
     **/
    ResourceImpl.prototype["type"] = function () {
        return _super.prototype.attribute.call(this, 'type', function (attr) { return new ResourceTypeRefImpl(attr); });
    };
    /**
     * Instantiation of applyed traits
     **/
    ResourceImpl.prototype.is = function () {
        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
    };
    /**
     * securityScheme may also be applied to a resource by using the securedBy key, which is equivalent to applying the securityScheme to all methods that may be declared, explicitly or implicitly, by defining the resourceTypes or traits property for that resource. To indicate that the method may be called without applying any securityScheme, the method may be annotated with the null securityScheme.
     **/
    ResourceImpl.prototype.securedBy = function () {
        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemeRefImpl(attr); });
    };
    /**
     * Uri parameters of this resource
     * @hidden
     **/
    ResourceImpl.prototype.uriParameters_original = function () {
        return _super.prototype.elements.call(this, 'uriParameters');
    };
    /**
     * Methods that can be called on this resource
     **/
    ResourceImpl.prototype.methods = function () {
        return _super.prototype.elements.call(this, 'methods');
    };
    /**
     * Children resources
     **/
    ResourceImpl.prototype.resources = function () {
        return _super.prototype.elements.call(this, 'resources');
    };
    /**
     * An alternate, human-friendly name for the resource
     **/
    ResourceImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    ResourceImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    /**
     * A resource or a method can override a base URI template's values. This is useful to restrict or change the default or parameter selection in the base URI. The baseUriParameters property MAY be used to override any or all parameters defined at the root level baseUriParameters property, as well as base URI parameters not specified at the root level.
     **/
    ResourceImpl.prototype.baseUriParameters = function () {
        return _super.prototype.elements.call(this, 'baseUriParameters');
    };
    /**
     * The description attribute describes the intended use or meaning of the $self. This value MAY be formatted using Markdown.
     **/
    ResourceImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ResourceImpl.prototype.wrapperClassName = function () { return "ResourceImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ResourceImpl.prototype.kind = function () { return "Resource"; };
    /**
     * @return Actual name of instance interface and all of its superinterfaces
     **/
    ResourceImpl.prototype.allKinds = function () { return _super.prototype.allKinds.call(this).concat("Resource"); };
    /**
     * @return Actual name of instance class and all of its superclasses
     **/
    ResourceImpl.prototype.allWrapperClassNames = function () { return _super.prototype.allWrapperClassNames.call(this).concat("RAML08.ResourceImpl"); };
    /**
     * @return Whether specified object is an instance of this class
     **/
    ResourceImpl.isInstance = function (instance) {
        if (instance != null && instance.allWrapperClassNames
            && typeof (instance.allWrapperClassNames) == "function") {
            for (var _i = 0, _a = instance.allWrapperClassNames(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == "RAML08.ResourceImpl")
                    return true;
            }
        }
        return false;
    };
    /**
     * @return RAML version of the node
     **/
    ResourceImpl.prototype.RAMLVersion = function () { return "RAML08"; };
    /**
     * Path relative to API root
     **/
    ResourceImpl.prototype.completeRelativeUri = function () {
        return helper.completeRelativeUri(this);
    };
    /**
     * baseUri of owning Api concatenated with completeRelativeUri
     **/
    ResourceImpl.prototype.absoluteUri = function () {
        return helper.absoluteUri(this);
    };
    /**
     * Parent resource for non top level resources
     **/
    ResourceImpl.prototype.parentResource = function () {
        return helper.parent(this);
    };
    /**
     * Get child resource by its relative path
     **/
    ResourceImpl.prototype.childResource = function (relPath) {
        return helper.childResource(this, relPath);
    };
    /**
     * Get child method by its name
     **/
    ResourceImpl.prototype.childMethod = function (method) {
        return helper.childMethod(this, method);
    };
    /**
     * Api owning the resource as a sibling
     **/
    ResourceImpl.prototype.ownerApi = function () {
        return helper.ownerApi(this);
    };
    /**
     * Uri parameters of this resource
     **/
    ResourceImpl.prototype.uriParameters = function () {
        return helper.uriParametersPrimary(this);
    };
    /**
     * Retrieve an ordered list of all uri parameters including those which are not described in the `uriParameters` node.
     * Consider a fragment of RAML specification:
     * ```yaml
     * /resource/{objectId}/{propertyId}:
     * uriParameters:
     * objectId:
     * ```
     * Here `propertyId` uri parameter is not described in the `uriParameters` node,
     * Thus, it is not among Resource.uriParameters(), but it is among Resource.allUriParameters().
     * @deprecated
     **/
    ResourceImpl.prototype.allUriParameters = function () {
        return helper.uriParameters(this);
    };
    /**
     * Retrieve an ordered list of all absolute uri parameters. Returns a union of `Api.allBaseUriParameters()`
     * for `Api` owning the `Resource` and `Resource.allUriParameters()`.
     **/
    ResourceImpl.prototype.absoluteUriParameters = function () {
        return helper.absoluteUriParameters(this);
    };
    /**
     * Returns security schemes, resource or method is secured with. If no security schemes are set at resource or method level,
     * returns schemes defined with `securedBy` at API level.
     * @deprecated
     **/
    ResourceImpl.prototype.allSecuredBy = function () {
        return helper.allSecuredBy(this);
    };
    return ResourceImpl;
}(core.BasicNodeImpl));
exports.ResourceImpl = ResourceImpl;
/**
 * @hidden
 **/
function createApi(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("Api");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createTypeInstance(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("TypeInstance");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createTypeInstanceProperty(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("TypeInstanceProperty");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createResourceType(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("ResourceType");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createMethod(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("Method");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createMethodBase(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("MethodBase");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createResponse(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("Response");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createParameter(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("Parameter");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createStringTypeDeclaration(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("StringTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createBooleanTypeDeclaration(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("BooleanTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createNumberTypeDeclaration(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("NumberTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createIntegerTypeDeclaration(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("IntegerTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createDateTypeDeclaration(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("DateTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createFileTypeDeclaration(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("FileTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createBodyLike(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("BodyLike");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createXMLBody(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("XMLBody");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createJSONBody(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("JSONBody");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createAbstractSecurityScheme(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("AbstractSecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createSecuritySchemePart(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("SecuritySchemePart");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createTrait(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("Trait");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createSecuritySchemeSettings(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("SecuritySchemeSettings");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createOAuth1SecuritySchemeSettings(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("OAuth1SecuritySchemeSettings");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createOAuth2SecuritySchemeSettings(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("OAuth2SecuritySchemeSettings");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createOAuth2SecurityScheme(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("OAuth2SecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createOAuth1SecurityScheme(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("OAuth1SecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createBasicSecurityScheme(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("BasicSecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createDigestSecurityScheme(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("DigestSecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createCustomSecurityScheme(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("CustomSecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createGlobalSchema(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("GlobalSchema");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createRAMLSimpleElement(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("RAMLSimpleElement");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createDocumentationItem(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("DocumentationItem");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createResource(key) {
    var universe = def.getUniverse("RAML08");
    var nc = universe.type("Resource");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
function loadApiSync(apiPath, arg1, arg2) {
    return apiLoader.loadApi(apiPath, arg1, arg2).getOrElse(null);
}
exports.loadApiSync = loadApiSync;
function loadRAMLSync(ramlPath, arg1, arg2) {
    return apiLoader.loadApi(ramlPath, arg1, arg2).getOrElse(null);
}
exports.loadRAMLSync = loadRAMLSync;
function loadApi(apiPath, arg1, arg2) {
    return apiLoader.loadApiAsync(apiPath, arg1, arg2);
}
exports.loadApi = loadApi;
function loadRAML(ramlPath, arg1, arg2) {
    return apiLoader.loadRAMLAsync(ramlPath, arg1, arg2);
}
exports.loadRAML = loadRAML;
/**
 * Gets AST node by runtime type, if runtime type matches any.
 * @param runtimeType - runtime type to find the match for
 */
function getLanguageElementByRuntimeType(runtimeType) {
    return apiLoader.getLanguageElementByRuntimeType(runtimeType);
}
exports.getLanguageElementByRuntimeType = getLanguageElementByRuntimeType;
//# sourceMappingURL=raml08parser.js.map