# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Imports external packages that replace or emulate internal packages.
If the external module is not present, the build-in module is imported.
"""

try:
    import pathlib2

    pathlib = pathlib2
except ImportError:
    pathlib2 = None
    import pathlib

    pathlib = pathlib

try:
    import scandir

    use_scandir_package = True
    use_builtin_scandir = False
except ImportError:
    try:
        from os import scandir  # noqa: F401

        use_builtin_scandir = True
        use_scandir_package = False
    except ImportError:
        use_builtin_scandir = False
        use_scandir_package = False

use_scandir = use_scandir_package or use_builtin_scandir
