/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PropertyMap;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.TypeStringBuilder;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Collections;

public class ProxyObjectType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    private static final JSTypeClass TYPE_CLASS = JSTypeClass.PROXY_OBJECT;
    private JSType referencedType;
    private ObjectType referencedObjType;

    ProxyObjectType(JSTypeRegistry registry, JSType referencedType) {
        this(registry, referencedType, null);
    }

    ProxyObjectType(JSTypeRegistry registry, JSType referencedType, TemplateTypeMap templateTypeMap) {
        super(registry, templateTypeMap);
        this.setReferencedType(Preconditions.checkNotNull(referencedType));
        registry.getResolver().resolveIfClosed(this, TYPE_CLASS);
    }

    @Override
    JSTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @Override
    public final JSType.HasPropertyKind getPropertyKind(String propertyName, boolean autobox) {
        return this.referencedType.getPropertyKind(propertyName, autobox);
    }

    @Override
    final PropertyMap getPropertyMap() {
        return this.referencedObjType == null ? PropertyMap.immutableEmptyMap() : this.referencedObjType.getPropertyMap();
    }

    final JSType getReferencedTypeInternal() {
        return this.referencedType;
    }

    final ObjectType getReferencedObjTypeInternal() {
        return this.referencedObjType;
    }

    final void setReferencedType(JSType referencedType) {
        Preconditions.checkNotNull(referencedType);
        this.referencedType = referencedType;
        this.referencedObjType = referencedType instanceof ObjectType ? (ObjectType)referencedType : null;
    }

    @Override
    public final boolean loosenTypecheckingDueToForwardReferencedSupertype() {
        return this.referencedType.loosenTypecheckingDueToForwardReferencedSupertype();
    }

    @Override
    public boolean setValidator(Predicate<JSType> validator) {
        return this.referencedType.setValidator(validator);
    }

    @Override
    public String getReferenceName() {
        return this.referencedObjType == null ? "" : this.referencedObjType.getReferenceName();
    }

    @Override
    public final boolean matchesNumberContext() {
        return this.referencedType.matchesNumberContext();
    }

    @Override
    public final boolean matchesStringContext() {
        return this.referencedType.matchesStringContext();
    }

    @Override
    public final boolean matchesSymbolContext() {
        return this.referencedType.matchesSymbolContext();
    }

    @Override
    public final boolean matchesObjectContext() {
        return this.referencedType.matchesObjectContext();
    }

    @Override
    public final boolean canBeCalled() {
        return this.referencedType.canBeCalled();
    }

    @Override
    public final boolean isStructuralType() {
        return this.referencedType.isStructuralType();
    }

    @Override
    public final boolean isNoType() {
        return this.referencedType.isNoType();
    }

    @Override
    public final boolean isNoObjectType() {
        return this.referencedType.isNoObjectType();
    }

    @Override
    public final boolean isNoResolvedType() {
        return this.referencedType.isNoResolvedType();
    }

    @Override
    public final boolean isUnknownType() {
        return this.referencedType.isUnknownType();
    }

    @Override
    public final boolean isCheckedUnknownType() {
        return this.referencedType.isCheckedUnknownType();
    }

    @Override
    public final boolean isNullable() {
        return this.referencedType.isNullable();
    }

    @Override
    public final boolean isVoidable() {
        return this.referencedType.isVoidable();
    }

    @Override
    public final EnumType toMaybeEnumType() {
        return this.referencedType.toMaybeEnumType();
    }

    @Override
    public final boolean isConstructor() {
        return this.referencedType.isConstructor();
    }

    @Override
    public boolean isNominalType() {
        return this.referencedType.isNominalType();
    }

    @Override
    public final boolean isInstanceType() {
        return this.referencedType.isInstanceType();
    }

    @Override
    public final boolean isInterface() {
        return this.referencedType.isInterface();
    }

    @Override
    public final boolean isOrdinaryFunction() {
        return this.referencedType.isOrdinaryFunction();
    }

    @Override
    public final boolean isAllType() {
        return this.referencedType.isAllType();
    }

    @Override
    public final boolean isStruct() {
        return this.referencedType.isStruct();
    }

    @Override
    public final boolean isDict() {
        return this.referencedType.isDict();
    }

    @Override
    public final boolean isNativeObjectType() {
        return this.referencedObjType == null ? false : this.referencedObjType.isNativeObjectType();
    }

    @Override
    public final RecordType toMaybeRecordType() {
        return this.referencedType.toMaybeRecordType();
    }

    @Override
    public final UnionType toMaybeUnionType() {
        return this.referencedType.toMaybeUnionType();
    }

    @Override
    public final FunctionType toMaybeFunctionType() {
        return this.referencedType.toMaybeFunctionType();
    }

    @Override
    public final EnumElementType toMaybeEnumElementType() {
        return this.referencedType.toMaybeEnumElementType();
    }

    @Override
    public final TernaryValue testForEquality(JSType that) {
        return this.referencedType.testForEquality(that);
    }

    @Override
    public final FunctionType getOwnerFunction() {
        return this.referencedObjType == null ? null : this.referencedObjType.getOwnerFunction();
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.referencedObjType == null ? ImmutableList.of() : this.referencedObjType.getCtorImplementedInterfaces();
    }

    @Override
    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return this.referencedObjType == null ? Collections.emptyList() : this.referencedObjType.getCtorExtendedInterfaces();
    }

    @Override
    int recursionUnsafeHashCode() {
        return this.referencedType.hashCode();
    }

    @Override
    void appendTo(TypeStringBuilder sb) {
        this.referencedType.appendTo(sb);
    }

    @Override
    public final ObjectType getImplicitPrototype() {
        return this.referencedObjType == null ? null : this.referencedObjType.getImplicitPrototype();
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        return this.referencedObjType == null || this.referencedObjType.defineProperty(propertyName, type, inferred, propertyNode);
    }

    @Override
    public final boolean removeProperty(String name) {
        return this.referencedObjType == null ? false : this.referencedObjType.removeProperty(name);
    }

    @Override
    protected JSType findPropertyTypeWithoutConsideringTemplateTypes(String propertyName) {
        return this.referencedType.findPropertyType(propertyName);
    }

    @Override
    public final JSDocInfo getJSDocInfo() {
        return this.referencedType.getJSDocInfo();
    }

    @Override
    public final void setJSDocInfo(JSDocInfo info) {
        if (this.referencedObjType != null) {
            this.referencedObjType.setJSDocInfo(info);
        }
    }

    @Override
    public final void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
        if (this.referencedObjType != null) {
            this.referencedObjType.setPropertyJSDocInfo(propertyName, info);
        }
    }

    @Override
    public final FunctionType getConstructor() {
        return this.referencedObjType == null ? null : this.referencedObjType.getConstructor();
    }

    @Override
    public ImmutableList<JSType> getTemplateTypes() {
        return this.referencedObjType == null ? null : this.referencedObjType.getTemplateTypes();
    }

    @Override
    public int getTemplateParamCount() {
        return this.referencedType.getTemplateParamCount();
    }

    public final <T> T visitReferenceType(Visitor<T> visitor) {
        return this.referencedType.visit(visitor);
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseProxyObjectType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return this.referencedType.visit(visitor, that);
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        this.setReferencedType(this.referencedType.resolve(reporter));
        return this;
    }

    @Override
    public final JSType getTypeOfThis() {
        if (this.referencedObjType != null) {
            return this.referencedObjType.getTypeOfThis();
        }
        return super.getTypeOfThis();
    }

    @Override
    public final JSType collapseUnion() {
        if (this.referencedType.isUnionType()) {
            return this.referencedType.collapseUnion();
        }
        return this;
    }

    @Override
    public final void matchConstraint(JSType constraint) {
        this.referencedType.matchConstraint(constraint);
    }

    @Override
    public TemplatizedType toMaybeTemplatizedType() {
        return this.referencedType.toMaybeTemplatizedType();
    }

    @Override
    public TemplateType toMaybeTemplateType() {
        return this.referencedType.toMaybeTemplateType();
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return this.referencedType.hasAnyTemplateTypes();
    }

    @Override
    public TemplateTypeMap getTemplateTypeMap() {
        return this.referencedType.getTemplateTypeMap();
    }
}

