/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.MathUtils;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Solvers;
import org.sunflow.math.Vector3;

public class Torus
implements PrimitiveList {
    private float ri2 = this.ri * this.ri;
    private float ro2 = this.ro * this.ro;
    private float ri = 0.25f;
    private float ro = 1.0f;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.ri = parameterList.getFloat("radiusInner", this.ri);
        this.ro = parameterList.getFloat("radiusOuter", this.ro);
        this.ri2 = this.ri * this.ri;
        this.ro2 = this.ro * this.ro;
        return true;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox(-this.ro - this.ri, -this.ro - this.ri, -this.ri);
        boundingBox.include(this.ro + this.ri, this.ro + this.ri, this.ri);
        if (matrix4 != null) {
            boundingBox = matrix4.transform(boundingBox);
        }
        return boundingBox;
    }

    public float getPrimitiveBound(int n, int n2) {
        switch (n2) {
            case 0: 
            case 2: {
                return -this.ro - this.ri;
            }
            case 1: 
            case 3: {
                return this.ro + this.ri;
            }
            case 4: {
                return -this.ri;
            }
            case 5: {
                return this.ri;
            }
        }
        return 0.0f;
    }

    public int getNumPrimitives() {
        return 1;
    }

    public void prepareShadingState(ShadingState shadingState) {
        shadingState.init();
        shadingState.getRay().getPoint(shadingState.getPoint());
        Instance instance = shadingState.getInstance();
        Point3 point3 = shadingState.transformWorldToObject(shadingState.getPoint());
        float f = point3.x * point3.x + point3.y * point3.y + point3.z * point3.z - this.ri2 - this.ro2;
        shadingState.getNormal().set(point3.x * f, point3.y * f, point3.z * f + 2.0f * this.ro2 * point3.z);
        shadingState.getNormal().normalize();
        double d = Math.asin(MathUtils.clamp(point3.z / this.ri, -1.0f, 1.0f));
        double d2 = Math.atan2(point3.y, point3.x);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        shadingState.getUV().x = (float)(d2 / (Math.PI * 2));
        shadingState.getUV().y = (float)((d + 1.5707963267948966) / Math.PI);
        shadingState.setShader(instance.getShader(0));
        shadingState.setModifier(instance.getModifier(0));
        Vector3 vector3 = shadingState.transformNormalObjectToWorld(shadingState.getNormal());
        shadingState.getNormal().set(vector3);
        shadingState.getNormal().normalize();
        shadingState.getGeoNormal().set(shadingState.getNormal());
        shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        float f = ray.dx * ray.dx;
        float f2 = ray.dy * ray.dy;
        float f3 = ray.dz * ray.dz;
        double d = f + f2 + f3;
        double d2 = d * d;
        double d3 = 2.0f * (ray.ox * ray.dx + ray.oy * ray.dy + ray.oz * ray.dz);
        double d4 = 2.0 * d * d3;
        float f4 = ray.ox * ray.ox;
        float f5 = ray.oy * ray.oy;
        float f6 = ray.oz * ray.oz;
        double d5 = f4 + f5 + f6 - this.ri2 - this.ro2;
        double d6 = d3 * d3 + 2.0 * d * d5 + (double)(4.0f * this.ro2 * f3);
        double d7 = 2.0 * d3 * d5 + (double)(8.0f * this.ro2 * ray.oz * ray.dz);
        double d8 = d5 * d5 + (double)(4.0f * this.ro2 * f6) - (double)(4.0f * this.ro2 * this.ri2);
        double[] dArray = Solvers.solveQuartic(d2, d4, d6, d7, d8);
        if (dArray != null) {
            if (dArray[0] >= (double)ray.getMax() || dArray[dArray.length - 1] <= (double)ray.getMin()) {
                return;
            }
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] > (double)ray.getMin())) continue;
                ray.setMax((float)dArray[i]);
                intersectionState.setIntersection(0);
                return;
            }
        }
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

