/*
 * Decompiled with CFR 0.152.
 */
package jdepend.textui;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageComparator;
import jdepend.framework.PackageFilter;

public class JDepend {
    private jdepend.framework.JDepend analyzer = new jdepend.framework.JDepend();
    private PrintWriter writer;
    protected NumberFormat formatter = NumberFormat.getInstance();

    public JDepend() {
        this(new PrintWriter(System.out));
    }

    public JDepend(PrintWriter writer) {
        this.formatter.setMaximumFractionDigits(2);
        this.setWriter(writer);
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    protected PrintWriter getWriter() {
        return this.writer;
    }

    public void setFilter(PackageFilter filter) {
        this.analyzer.setFilter(filter);
    }

    public void setComponents(String components) {
        this.analyzer.setComponents(components);
    }

    public void addDirectory(String name) throws IOException {
        this.analyzer.addDirectory(name);
    }

    public void analyzeInnerClasses(boolean b) {
        this.analyzer.analyzeInnerClasses(b);
    }

    public void analyze() {
        this.printHeader();
        Collection packages = this.analyzer.analyze();
        ArrayList packageList = new ArrayList(packages);
        Collections.sort(packageList, new PackageComparator(PackageComparator.byName()));
        this.printPackages(packageList);
        this.printCycles(packageList);
        this.printSummary(packageList);
        this.printFooter();
        this.getWriter().flush();
    }

    protected void printPackages(Collection packages) {
        this.printPackagesHeader();
        Iterator i = packages.iterator();
        while (i.hasNext()) {
            this.printPackage((JavaPackage)i.next());
        }
        this.printPackagesFooter();
    }

    protected void printPackage(JavaPackage jPackage) {
        this.printPackageHeader(jPackage);
        if (jPackage.getClasses().size() == 0) {
            this.printNoStats();
            this.printPackageFooter(jPackage);
            return;
        }
        this.printStatistics(jPackage);
        this.printSectionBreak();
        this.printAbstractClasses(jPackage);
        this.printSectionBreak();
        this.printConcreteClasses(jPackage);
        this.printSectionBreak();
        this.printEfferents(jPackage);
        this.printSectionBreak();
        this.printAfferents(jPackage);
        this.printPackageFooter(jPackage);
    }

    protected void printAbstractClasses(JavaPackage jPackage) {
        this.printAbstractClassesHeader();
        ArrayList members = new ArrayList(jPackage.getClasses());
        Collections.sort(members, new JavaClass.ClassComparator());
        for (JavaClass jClass : members) {
            if (!jClass.isAbstract()) continue;
            this.printClassName(jClass);
        }
        this.printAbstractClassesFooter();
    }

    protected void printConcreteClasses(JavaPackage jPackage) {
        this.printConcreteClassesHeader();
        ArrayList members = new ArrayList(jPackage.getClasses());
        Collections.sort(members, new JavaClass.ClassComparator());
        for (JavaClass concrete : members) {
            if (concrete.isAbstract()) continue;
            this.printClassName(concrete);
        }
        this.printConcreteClassesFooter();
    }

    protected void printEfferents(JavaPackage jPackage) {
        this.printEfferentsHeader();
        ArrayList efferents = new ArrayList(jPackage.getEfferents());
        Collections.sort(efferents, new PackageComparator(PackageComparator.byName()));
        for (JavaPackage efferent : efferents) {
            this.printPackageName(efferent);
        }
        if (efferents.size() == 0) {
            this.printEfferentsError();
        }
        this.printEfferentsFooter();
    }

    protected void printAfferents(JavaPackage jPackage) {
        this.printAfferentsHeader();
        ArrayList afferents = new ArrayList(jPackage.getAfferents());
        Collections.sort(afferents, new PackageComparator(PackageComparator.byName()));
        for (JavaPackage afferent : afferents) {
            this.printPackageName(afferent);
        }
        if (afferents.size() == 0) {
            this.printAfferentsError();
        }
        this.printAfferentsFooter();
    }

    protected void printCycles(Collection packages) {
        this.printCyclesHeader();
        Iterator i = packages.iterator();
        while (i.hasNext()) {
            this.printCycle((JavaPackage)i.next());
        }
        this.printCyclesFooter();
    }

    protected void printCycle(JavaPackage jPackage) {
        ArrayList list = new ArrayList();
        jPackage.collectCycle(list);
        if (!jPackage.containsCycle()) {
            return;
        }
        JavaPackage cyclePackage = (JavaPackage)list.get(list.size() - 1);
        String cyclePackageName = cyclePackage.getName();
        int i = 0;
        for (JavaPackage pkg : list) {
            if (++i == 1) {
                this.printCycleHeader(pkg);
                continue;
            }
            if (pkg.getName().equals(cyclePackageName)) {
                this.printCycleTarget(pkg);
                continue;
            }
            this.printCycleContributor(pkg);
        }
        this.printCycleFooter();
    }

    protected void printHeader() {
    }

    protected void printFooter() {
    }

    protected void printPackagesHeader() {
    }

    protected void printPackagesFooter() {
    }

    protected void printNoStats() {
        this.getWriter().println("No stats available: package referenced, but not analyzed.");
    }

    protected void printPackageHeader(JavaPackage jPackage) {
        this.getWriter().println("\n--------------------------------------------------");
        this.getWriter().println("- Package: " + jPackage.getName());
        this.getWriter().println("--------------------------------------------------");
    }

    protected void printPackageFooter(JavaPackage jPackage) {
    }

    protected void printStatistics(JavaPackage jPackage) {
        this.getWriter().println("\nStats:");
        this.getWriter().println(this.tab() + "Total Classes: " + jPackage.getClassCount());
        this.getWriter().println(this.tab() + "Concrete Classes: " + jPackage.getConcreteClassCount());
        this.getWriter().println(this.tab() + "Abstract Classes: " + jPackage.getAbstractClassCount());
        this.getWriter().println("");
        this.getWriter().println(this.tab() + "Ca: " + jPackage.afferentCoupling());
        this.getWriter().println(this.tab() + "Ce: " + jPackage.efferentCoupling());
        this.getWriter().println("");
        this.getWriter().println(this.tab() + "A: " + this.toFormattedString(jPackage.abstractness()));
        this.getWriter().println(this.tab() + "I: " + this.toFormattedString(jPackage.instability()));
        this.getWriter().println(this.tab() + "D: " + this.toFormattedString(jPackage.distance()));
    }

    protected void printClassName(JavaClass jClass) {
        this.getWriter().println(this.tab() + jClass.getName());
    }

    protected void printPackageName(JavaPackage jPackage) {
        this.getWriter().println(this.tab() + jPackage.getName());
    }

    protected void printAbstractClassesHeader() {
        this.getWriter().println("Abstract Classes:");
    }

    protected void printAbstractClassesFooter() {
    }

    protected void printConcreteClassesHeader() {
        this.getWriter().println("Concrete Classes:");
    }

    protected void printConcreteClassesFooter() {
    }

    protected void printEfferentsHeader() {
        this.getWriter().println("Depends Upon:");
    }

    protected void printEfferentsFooter() {
    }

    protected void printEfferentsError() {
        this.getWriter().println(this.tab() + "Not dependent on any packages.");
    }

    protected void printAfferentsHeader() {
        this.getWriter().println("Used By:");
    }

    protected void printAfferentsFooter() {
    }

    protected void printAfferentsError() {
        this.getWriter().println(this.tab() + "Not used by any packages.");
    }

    protected void printCyclesHeader() {
        this.printSectionBreak();
        this.getWriter().println("\n--------------------------------------------------");
        this.getWriter().println("- Package Dependency Cycles:");
        this.getWriter().println("--------------------------------------------------\n");
    }

    protected void printCyclesFooter() {
    }

    protected void printCycleHeader(JavaPackage jPackage) {
        this.getWriter().println(jPackage.getName());
        this.getWriter().println(this.tab() + "|");
    }

    protected void printCycleTarget(JavaPackage jPackage) {
        this.getWriter().println(this.tab() + "|-> " + jPackage.getName());
    }

    protected void printCycleContributor(JavaPackage jPackage) {
        this.getWriter().println(this.tab() + "|   " + jPackage.getName());
    }

    protected void printCycleFooter() {
        this.printSectionBreak();
    }

    protected void printSummary(Collection packages) {
        this.getWriter().println("\n--------------------------------------------------");
        this.getWriter().println("- Summary:");
        this.getWriter().println("--------------------------------------------------\n");
        this.getWriter().println("Name, Class Count, Abstract Class Count, Ca, Ce, A, I, D, V:\n");
        for (JavaPackage jPackage : packages) {
            this.getWriter().print(jPackage.getName() + ",");
            this.getWriter().print(jPackage.getClassCount() + ",");
            this.getWriter().print(jPackage.getAbstractClassCount() + ",");
            this.getWriter().print(jPackage.afferentCoupling() + ",");
            this.getWriter().print(jPackage.efferentCoupling() + ",");
            this.getWriter().print(this.toFormattedString(jPackage.abstractness()) + ",");
            this.getWriter().print(this.toFormattedString(jPackage.instability()) + ",");
            this.getWriter().print(this.toFormattedString(jPackage.distance()) + ",");
            this.getWriter().println(jPackage.getVolatility());
        }
    }

    protected void printSectionBreak() {
        this.getWriter().println("");
    }

    protected String toFormattedString(float f) {
        return this.formatter.format(f);
    }

    protected String tab() {
        return "    ";
    }

    protected String tab(int n) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            s.append(this.tab());
        }
        return s.toString();
    }

    protected void usage(String message) {
        if (message != null) {
            System.err.println("\n" + message);
        }
        String baseUsage = "\nJDepend ";
        System.err.println("");
        System.err.println("usage: ");
        System.err.println(baseUsage + "[-components <components>] [-file <output file>] <directory> [directory2 [directory 3] ...]");
        System.exit(1);
    }

    protected void instanceMain(String[] args) {
        if (args.length < 1) {
            this.usage("Must specify at least one directory.");
        }
        int directoryCount = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase("-file")) {
                    if (args.length <= i + 1) {
                        this.usage("Output file name not specified.");
                    }
                    try {
                        this.setWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(args[++i]), "UTF8")));
                    }
                    catch (IOException ioe) {
                        this.usage(ioe.getMessage());
                    }
                    continue;
                }
                if (args[i].equalsIgnoreCase("-components")) {
                    if (args.length <= i + 1) {
                        this.usage("Components not specified.");
                    }
                    this.setComponents(args[++i]);
                    continue;
                }
                this.usage("Invalid argument: " + args[i]);
                continue;
            }
            try {
                this.addDirectory(args[i]);
                ++directoryCount;
                continue;
            }
            catch (IOException ioe) {
                this.usage("Directory does not exist: " + args[i]);
            }
        }
        if (directoryCount == 0) {
            this.usage("Must specify at least one directory.");
        }
        this.analyze();
    }

    public static void main(String[] args) {
        new JDepend().instanceMain(args);
    }
}

