/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanRegistration;
import io.micronaut.context.Qualifier;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface BeanDefinitionRegistry {
    public <T> boolean containsBean(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2);

    @Nonnull
    public <T> BeanDefinitionRegistry registerSingleton(@Nonnull Class<T> var1, @Nonnull T var2, @Nullable Qualifier<T> var3, boolean var4);

    @Nonnull
    public Optional<BeanConfiguration> findBeanConfiguration(@Nonnull String var1);

    @Nonnull
    public <T> Optional<BeanDefinition<T>> findBeanDefinition(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2);

    @Nonnull
    public <T> Optional<BeanRegistration<T>> findBeanRegistration(@Nonnull T var1);

    @Nonnull
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(@Nonnull Class<T> var1);

    @Nonnull
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2);

    @Nonnull
    public Collection<BeanDefinition<?>> getBeanDefinitions(@Nonnull Qualifier<Object> var1);

    @Nonnull
    public Collection<BeanDefinition<?>> getAllBeanDefinitions();

    @Nonnull
    public Collection<BeanDefinitionReference<?>> getBeanDefinitionReferences();

    @Nonnull
    public Collection<BeanRegistration<?>> getActiveBeanRegistrations(@Nonnull Qualifier<?> var1);

    @Nonnull
    public <T> Collection<BeanRegistration<T>> getActiveBeanRegistrations(@Nonnull Class<T> var1);

    @Nonnull
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(@Nonnull Class<T> var1);

    @Nonnull
    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2);

    @Nonnull
    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2);

    @Nonnull
    default public <T> BeanDefinitionRegistry registerSingleton(@Nonnull Class<T> type, @Nonnull T singleton, @Nullable Qualifier<T> qualifier) {
        return this.registerSingleton(type, singleton, qualifier, true);
    }

    default public <T> BeanDefinitionRegistry registerSingleton(@Nonnull Class<T> type, @Nonnull T singleton) {
        return this.registerSingleton(type, singleton, null);
    }

    @Nonnull
    default public <T> BeanDefinition<T> getBeanDefinition(@Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findBeanDefinition(beanType, qualifier).orElseThrow(() -> new NoSuchBeanException(beanType, qualifier));
    }

    @Nonnull
    default public <T> BeanDefinition<T> getProxyTargetBeanDefinition(@Nonnull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findProxyTargetBeanDefinition(beanType, qualifier).orElseThrow(() -> new NoSuchBeanException(beanType, qualifier));
    }

    @Nonnull
    default public <T> BeanDefinition<T> getBeanDefinition(@Nonnull Class<T> beanType) {
        return this.findBeanDefinition(beanType, null).orElseThrow(() -> new NoSuchBeanException(beanType));
    }

    @Nonnull
    default public <T> Optional<BeanDefinition<T>> findBeanDefinition(@Nonnull Class<T> beanType) {
        return this.findBeanDefinition(beanType, null);
    }

    @Nonnull
    default public BeanDefinitionRegistry registerSingleton(@Nonnull Object singleton) {
        ArgumentUtils.requireNonNull((String)"singleton", (Object)singleton);
        Class<?> type = singleton.getClass();
        return this.registerSingleton(type, singleton);
    }

    @Nonnull
    default public BeanDefinitionRegistry registerSingleton(@Nonnull Object singleton, boolean inject) {
        ArgumentUtils.requireNonNull((String)"singleton", (Object)singleton);
        Class<?> type = singleton.getClass();
        return this.registerSingleton(type, singleton, null, inject);
    }

    default public boolean containsBean(@Nonnull Class beanType) {
        return beanType != null && this.containsBean(beanType, null);
    }
}

