/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;

public class ContentRange {
    private final String units;
    private final long start;
    private final long end;
    private final long length;

    public ContentRange(String string, long l, long l2, long l3) {
        this.units = string;
        this.start = l;
        this.end = l2;
        this.length = l3;
    }

    public String getUnits() {
        return this.units;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLength() {
        return this.length;
    }

    public static ContentRange parse(StringReader stringReader) throws IOException {
        String string = HttpParser.readToken(stringReader);
        if (string == null || string.length() == 0) {
            return null;
        }
        if (HttpParser.skipConstant(stringReader, "=") == SkipResult.NOT_FOUND) {
            return null;
        }
        long l = HttpParser.readLong(stringReader);
        if (HttpParser.skipConstant(stringReader, "-") == SkipResult.NOT_FOUND) {
            return null;
        }
        long l2 = HttpParser.readLong(stringReader);
        if (HttpParser.skipConstant(stringReader, "/") == SkipResult.NOT_FOUND) {
            return null;
        }
        long l3 = HttpParser.readLong(stringReader);
        SkipResult skipResult = HttpParser.skipConstant(stringReader, "X");
        if (skipResult != SkipResult.EOF) {
            return null;
        }
        return new ContentRange(string, l, l2, l3);
    }
}

