/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

class NodeIterators {
    private NodeIterators() {
    }

    static class LocalVarMotion
    implements Iterator<Node> {
        private final AbstractCompiler compiler;
        private final boolean valueHasSideEffects;
        private final FunctionlessLocalScope iterator;
        private final String varName;
        private Node lookAhead;

        static LocalVarMotion forVar(AbstractCompiler compiler, Node name, Node var, Node block) {
            Preconditions.checkArgument(NodeUtil.isNameDeclaration(var));
            Preconditions.checkArgument(NodeUtil.isStatement(var));
            return new LocalVarMotion(compiler, name, new FunctionlessLocalScope(name, var, block));
        }

        static LocalVarMotion forAssign(AbstractCompiler compiler, Node name, Node assign, Node expr, Node block) {
            Preconditions.checkArgument(assign.isAssign());
            Preconditions.checkArgument(expr.isExprResult());
            return new LocalVarMotion(compiler, name, new FunctionlessLocalScope(assign, expr, block));
        }

        private LocalVarMotion(AbstractCompiler compiler, Node nameNode, FunctionlessLocalScope iterator) {
            Preconditions.checkArgument(nameNode.isName());
            Node valueNode = NodeUtil.getAssignedValue(nameNode);
            this.compiler = Preconditions.checkNotNull(compiler);
            this.varName = nameNode.getString();
            this.valueHasSideEffects = valueNode != null && compiler.getAstAnalyzer().mayHaveSideEffects(valueNode);
            this.iterator = iterator;
            this.advanceLookAhead(true);
        }

        @Override
        public boolean hasNext() {
            return this.lookAhead != null;
        }

        @Override
        public Node next() {
            Node next = this.lookAhead;
            this.advanceLookAhead(false);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }

        private void advanceLookAhead(boolean atStart) {
            if (!atStart) {
                if (this.lookAhead == null) {
                    return;
                }
                Node curNode = this.iterator.current();
                if (curNode.isName() && this.varName.equals(curNode.getString())) {
                    this.lookAhead = null;
                    return;
                }
            }
            if (!this.iterator.hasNext()) {
                this.lookAhead = null;
                return;
            }
            Node nextNode = this.iterator.next();
            Node nextParent = this.iterator.currentParent();
            Token type = nextNode.getToken();
            if (this.valueHasSideEffects) {
                boolean readsState = false;
                if (nextNode.isName() && !this.varName.equals(nextNode.getString()) || nextNode.isGetProp() || nextNode.isGetElem()) {
                    if (nextParent == null || !NodeUtil.isNameDeclOrSimpleAssignLhs(nextNode, nextParent)) {
                        readsState = true;
                    }
                } else if (nextNode.isCall() || nextNode.isNew()) {
                    readsState = true;
                }
                if (readsState) {
                    this.lookAhead = null;
                    return;
                }
            }
            if (this.compiler.getAstAnalyzer().nodeTypeMayHaveSideEffects(nextNode) && type != Token.NAME || type == Token.NAME && nextParent.isCatch()) {
                this.lookAhead = null;
                return;
            }
            this.lookAhead = nextNode;
        }
    }

    static class FunctionlessLocalScope
    implements Iterator<Node> {
        private final Deque<Node> ancestors = new ArrayDeque<Node>();

        FunctionlessLocalScope(Node ... ancestors) {
            Preconditions.checkArgument(ancestors.length > 0);
            for (Node n : ancestors) {
                if (n.isFunction()) break;
                this.ancestors.addFirst(n);
            }
        }

        @Override
        public boolean hasNext() {
            return this.ancestors.size() != 1 || this.ancestors.peekLast().getNext() != null;
        }

        @Override
        public Node next() {
            Node current = this.ancestors.removeLast();
            if (current.getNext() == null) {
                current = this.ancestors.peekLast();
                if (current.isFunction()) {
                    return this.next();
                }
            } else {
                current = current.getNext();
                this.ancestors.addLast(current);
                if (current.isFunction()) {
                    return this.next();
                }
                while (current.hasChildren()) {
                    current = current.getFirstChild();
                    this.ancestors.addLast(current);
                    if (!current.isFunction()) continue;
                    return this.next();
                }
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }

        protected Node current() {
            return this.ancestors.peekLast();
        }

        protected Node currentParent() {
            return this.ancestors.size() >= 2 ? this.current().getParent() : null;
        }

        List<Node> currentAncestors() {
            ArrayList<Node> list = new ArrayList<Node>(this.ancestors);
            Collections.reverse(list);
            return list;
        }
    }
}

