/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring.examples;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.refactoring.Match;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.refactoring.Scanner;
import com.google.javascript.refactoring.SuggestedFix;
import com.google.javascript.rhino.Node;

public final class GoogBindToArrow
extends Scanner {
    private static boolean isGoogBind(Node n) {
        return n.isGetProp() && n.matchesQualifiedName("goog.bind");
    }

    @Override
    public boolean matches(Node node, NodeMetadata metadata) {
        if (!node.isCall()) {
            return false;
        }
        Node callee = node.getFirstChild();
        if (!GoogBindToArrow.isGoogBind(callee)) {
            return false;
        }
        Node firstArg = callee.getNext();
        if (firstArg == null || !firstArg.isFunction()) {
            return false;
        }
        Node secondArg = firstArg.getNext();
        return secondArg != null && secondArg.isThis() && secondArg.getNext() == null;
    }

    public ImmutableList<SuggestedFix> processMatch(Match match) {
        Node returnNode;
        AbstractCompiler compiler = match.getMetadata().getCompiler();
        Node googBindCall = match.getNode();
        Node function = googBindCall.getFirstChild().getNext();
        Node arrowFunction = function.cloneTree();
        arrowFunction.setIsArrowFunction(true);
        Node body = function.getLastChild();
        if (body.hasOneChild() && (returnNode = body.getFirstChild()).isReturn()) {
            arrowFunction.replaceChild(arrowFunction.getLastChild(), returnNode.getFirstChild().detach());
        }
        SuggestedFix.Builder fix = new SuggestedFix.Builder();
        fix.replace(googBindCall, arrowFunction, compiler);
        return ImmutableList.of(fix.build());
    }
}

