/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.hyperlink;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import org.jdesktop.swingx.hyperlink.AbstractHyperlinkAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkAction
extends AbstractHyperlinkAction<URI> {
    private static final Logger LOG = Logger.getLogger(HyperlinkAction.class.getName());
    private Desktop.Action desktopAction;
    private URIVisitor visitor;

    public static HyperlinkAction createHyperlinkAction(URI uri) {
        Desktop.Action type = HyperlinkAction.isMailURI(uri) ? Desktop.Action.MAIL : Desktop.Action.BROWSE;
        return HyperlinkAction.createHyperlinkAction(uri, type);
    }

    public static HyperlinkAction createHyperlinkAction(URI uri, Desktop.Action type) {
        return new HyperlinkAction(uri, type);
    }

    private static boolean isMailURI(URI uri) {
        return uri != null && "mailto".equalsIgnoreCase(uri.getScheme());
    }

    public HyperlinkAction() {
        this(Desktop.Action.BROWSE);
    }

    public HyperlinkAction(Desktop.Action desktopAction) {
        this(null, desktopAction);
    }

    public HyperlinkAction(URI uri, Desktop.Action desktopAction) {
        if (!Desktop.isDesktopSupported()) {
            throw new UnsupportedOperationException("Desktop API is not supported on the current platform");
        }
        if (desktopAction != Desktop.Action.BROWSE && desktopAction != Desktop.Action.MAIL) {
            throw new IllegalArgumentException("Illegal action type: " + (Object)((Object)desktopAction) + ". Must be BROWSE or MAIL");
        }
        this.desktopAction = desktopAction;
        this.getURIVisitor();
        this.setTarget(uri);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getURIVisitor().visit((URI)this.getTarget());
    }

    public Desktop.Action getDesktopAction() {
        return this.desktopAction;
    }

    @Override
    protected void installTarget() {
        if (this.visitor == null) {
            return;
        }
        super.installTarget();
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.setEnabled(this.getURIVisitor().isEnabled((URI)this.getTarget()));
    }

    private URIVisitor getURIVisitor() {
        if (this.visitor == null) {
            this.visitor = this.createURIVisitor();
        }
        return this.visitor;
    }

    private URIVisitor createURIVisitor() {
        return this.getDesktopAction() == Desktop.Action.BROWSE ? new BrowseVisitor() : new MailVisitor();
    }

    private class MailVisitor
    extends URIVisitor {
        private MailVisitor() {
        }

        protected void doVisit(URI uri) throws IOException {
            if (uri == null) {
                Desktop.getDesktop().mail();
            } else {
                Desktop.getDesktop().mail(uri);
            }
        }

        protected boolean isActionSupported() {
            return Desktop.getDesktop().isSupported(Desktop.Action.MAIL);
        }
    }

    private class BrowseVisitor
    extends URIVisitor {
        private BrowseVisitor() {
        }

        protected void doVisit(URI uri) throws IOException {
            Desktop.getDesktop().browse(uri);
        }

        protected boolean isActionSupported() {
            return Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
        }

        public boolean isEnabled(URI uri) {
            return uri != null && super.isEnabled(uri);
        }
    }

    private abstract class URIVisitor {
        protected boolean desktopSupported = Desktop.isDesktopSupported();

        private URIVisitor() {
        }

        public boolean isEnabled(URI uri) {
            return this.desktopSupported && this.isActionSupported();
        }

        public void visit(URI uri) {
            if (!this.isEnabled(uri)) {
                return;
            }
            try {
                this.doVisit(uri);
            }
            catch (IOException e) {
                LOG.fine("cant visit Desktop " + e);
            }
        }

        protected abstract boolean isActionSupported();

        protected abstract void doVisit(URI var1) throws IOException;
    }
}

