/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import org.fibs.geotag.util.JavaFileFilter;

public final class TodoRemover {
    private TodoRemover() {
    }

    public static void main(String[] args) {
        JFileChooser chooser = new JFileChooser();
        String rootDirectoryName = System.getProperty("user.dir");
        File rootDirectory = new File(rootDirectoryName = String.valueOf(rootDirectoryName) + "/src/com");
        if (rootDirectory.exists() && rootDirectory.isDirectory()) {
            chooser.setSelectedFile(rootDirectory);
        }
        System.out.println(rootDirectoryName);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(null) == 0) {
            File directory = chooser.getSelectedFile();
            TodoRemover.processDirectory(directory);
        }
    }

    private static void processDirectory(File directory) {
        File[] files = directory.listFiles(new JavaFileFilter());
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                TodoRemover.processDirectory(file);
            } else if (file.getPath().indexOf("org/fibs") == -1) {
                TodoRemover.processFile(file);
            }
            ++i;
        }
    }

    private static void processFile(File file) {
        File tmpFile;
        block24: {
            System.out.println(file.getPath());
            tmpFile = new File(String.valueOf(file.getPath()) + ".tmp");
            BufferedReader bufferedReader = null;
            PrintStream printStream = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                printStream = new PrintStream(tmpFile);
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.indexOf("TODO") != -1) {
                        line = line.replaceAll("TODO", "SEP");
                        System.out.println(line);
                    }
                    printStream.println(line);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (printStream != null) {
                    printStream.close();
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                break block24;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block24;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (printStream != null) {
                        printStream.close();
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
            }
            if (printStream != null) {
                printStream.close();
            }
            if (bufferedReader == null) break block24;
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (tmpFile.renameTo(file)) {
            System.out.println("Done. " + file.getName());
        } else {
            System.out.println("Couldn't rename " + tmpFile.getName());
        }
    }
}

