/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.function.DoubleProcedure;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.doublealgo.Sorting;
import cern.colt.matrix.impl.AbstractMatrix1D;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;
import cern.jet.math.PlusMult;

public abstract class DoubleMatrix1D
extends AbstractMatrix1D {
    protected DoubleMatrix1D() {
    }

    public double aggregate(DoubleDoubleFunction doubleDoubleFunction, DoubleFunction doubleFunction) {
        if (this.size == 0) {
            return Double.NaN;
        }
        double d = doubleFunction.apply(this.getQuick(this.size - 1));
        int n = this.size - 1;
        while (--n >= 0) {
            d = doubleDoubleFunction.apply(d, doubleFunction.apply(this.getQuick(n)));
        }
        return d;
    }

    public double aggregate(DoubleMatrix1D doubleMatrix1D, DoubleDoubleFunction doubleDoubleFunction, DoubleDoubleFunction doubleDoubleFunction2) {
        this.checkSize(doubleMatrix1D);
        if (this.size == 0) {
            return Double.NaN;
        }
        double d = doubleDoubleFunction2.apply(this.getQuick(this.size - 1), doubleMatrix1D.getQuick(this.size - 1));
        int n = this.size - 1;
        while (--n >= 0) {
            d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(this.getQuick(n), doubleMatrix1D.getQuick(n)));
        }
        return d;
    }

    public DoubleMatrix1D assign(double[] dArray) {
        if (dArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + dArray.length + "size()=" + this.size());
        }
        int n = this.size;
        while (--n >= 0) {
            this.setQuick(n, dArray[n]);
        }
        return this;
    }

    public DoubleMatrix1D assign(double d) {
        int n = this.size;
        while (--n >= 0) {
            this.setQuick(n, d);
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleFunction doubleFunction) {
        int n = this.size;
        while (--n >= 0) {
            this.setQuick(n, doubleFunction.apply(this.getQuick(n)));
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D == this) {
            return this;
        }
        this.checkSize(doubleMatrix1D);
        if (this.haveSharedCells(doubleMatrix1D)) {
            doubleMatrix1D = doubleMatrix1D.copy();
        }
        int n = this.size;
        while (--n >= 0) {
            this.setQuick(n, doubleMatrix1D.getQuick(n));
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D doubleMatrix1D, DoubleDoubleFunction doubleDoubleFunction) {
        this.checkSize(doubleMatrix1D);
        int n = this.size;
        while (--n >= 0) {
            this.setQuick(n, doubleDoubleFunction.apply(this.getQuick(n), doubleMatrix1D.getQuick(n)));
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D doubleMatrix1D, DoubleDoubleFunction doubleDoubleFunction, IntArrayList intArrayList) {
        this.checkSize(doubleMatrix1D);
        int[] nArray = intArrayList.elements();
        if (doubleDoubleFunction == Functions.mult) {
            int n = 0;
            int n2 = intArrayList.size();
            while (--n2 >= 0) {
                int n3 = nArray[n2];
                while (n < n3) {
                    this.setQuick(n, 0.0);
                    ++n;
                }
                this.setQuick(n3, this.getQuick(n3) * doubleMatrix1D.getQuick(n3));
                ++n;
            }
        } else if (doubleDoubleFunction instanceof PlusMult) {
            double d = ((PlusMult)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            if (d == 1.0) {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n4 = nArray[n];
                    this.setQuick(n4, this.getQuick(n4) + doubleMatrix1D.getQuick(n4));
                }
            } else if (d == -1.0) {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n5 = nArray[n];
                    this.setQuick(n5, this.getQuick(n5) - doubleMatrix1D.getQuick(n5));
                }
            } else {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n6 = nArray[n];
                    this.setQuick(n6, this.getQuick(n6) + d * doubleMatrix1D.getQuick(n6));
                }
            }
        } else {
            return this.assign(doubleMatrix1D, doubleDoubleFunction);
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = this.size;
        while (--n2 >= 0) {
            if (this.getQuick(n2) == 0.0) continue;
            ++n;
        }
        return n;
    }

    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.size;
        while (--n3 >= 0 && n2 < n) {
            if (this.getQuick(n3) == 0.0) continue;
            ++n2;
        }
        return n2;
    }

    public DoubleMatrix1D copy() {
        DoubleMatrix1D doubleMatrix1D = this.like();
        doubleMatrix1D.assign(this);
        return doubleMatrix1D;
    }

    public boolean equals(double d) {
        return Property.DEFAULT.equals(this, d);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DoubleMatrix1D)) {
            return false;
        }
        return Property.DEFAULT.equals(this, (DoubleMatrix1D)object);
    }

    public double get(int n) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        return this.getQuick(n);
    }

    protected DoubleMatrix1D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList intArrayList, DoubleArrayList doubleArrayList) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = doubleArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            doubleArrayList.clear();
        }
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            double d = this.getQuick(i);
            if (d == 0.0) continue;
            if (bl2) {
                intArrayList.add(i);
            }
            if (!bl) continue;
            doubleArrayList.add(d);
        }
    }

    public void getNonZeros(IntArrayList intArrayList, DoubleArrayList doubleArrayList, int n) {
        boolean bl = intArrayList != null;
        boolean bl2 = doubleArrayList != null;
        int n2 = this.cardinality(n);
        if (bl) {
            intArrayList.setSize(n2);
        }
        if (bl2) {
            doubleArrayList.setSize(n2);
        }
        if (n2 >= n) {
            return;
        }
        if (bl) {
            intArrayList.setSize(0);
        }
        if (bl2) {
            doubleArrayList.setSize(0);
        }
        int n3 = this.size;
        for (int i = 0; i < n3; ++i) {
            double d = this.getQuick(i);
            if (d == 0.0) continue;
            if (bl) {
                intArrayList.add(i);
            }
            if (!bl2) continue;
            doubleArrayList.add(d);
        }
    }

    public abstract double getQuick(int var1);

    protected boolean haveSharedCells(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D == null) {
            return false;
        }
        if (this == doubleMatrix1D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(doubleMatrix1D.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D doubleMatrix1D) {
        return false;
    }

    public DoubleMatrix1D like() {
        return this.like(this.size);
    }

    public abstract DoubleMatrix1D like(int var1);

    public abstract DoubleMatrix2D like2D(int var1, int var2);

    public void set(int n, double d) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        this.setQuick(n, d);
    }

    public abstract void setQuick(int var1, double var2);

    public void swap(DoubleMatrix1D doubleMatrix1D) {
        this.checkSize(doubleMatrix1D);
        int n = this.size;
        while (--n >= 0) {
            double d = this.getQuick(n);
            this.setQuick(n, doubleMatrix1D.getQuick(n));
            doubleMatrix1D.setQuick(n, d);
        }
    }

    public double[] toArray() {
        double[] dArray = new double[this.size];
        this.toArray(dArray);
        return dArray;
    }

    public void toArray(double[] dArray) {
        if (dArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int n = this.size;
        while (--n >= 0) {
            dArray[n] = this.getQuick(n);
        }
    }

    public String toString() {
        return new Formatter().toString(this);
    }

    protected DoubleMatrix1D view() {
        return (DoubleMatrix1D)this.clone();
    }

    public DoubleMatrix1D viewFlip() {
        return (DoubleMatrix1D)this.view().vFlip();
    }

    public DoubleMatrix1D viewPart(int n, int n2) {
        return (DoubleMatrix1D)this.view().vPart(n, n2);
    }

    public DoubleMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        int[] nArray2 = new int[nArray.length];
        int n = nArray.length;
        while (--n >= 0) {
            nArray2[n] = this.index(nArray[n]);
        }
        return this.viewSelectionLike(nArray2);
    }

    public DoubleMatrix1D viewSelection(DoubleProcedure doubleProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.size; ++i) {
            if (!doubleProcedure.apply(this.getQuick(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements());
    }

    protected abstract DoubleMatrix1D viewSelectionLike(int[] var1);

    public DoubleMatrix1D viewSorted() {
        return Sorting.mergeSort.sort(this);
    }

    public DoubleMatrix1D viewStrides(int n) {
        return (DoubleMatrix1D)this.view().vStrides(n);
    }

    private boolean xforEach(DoubleProcedure doubleProcedure) {
        int n = this.size;
        while (--n >= 0) {
            if (doubleProcedure.apply(this.getQuick(n))) continue;
            return false;
        }
        return true;
    }

    public double zDotProduct(DoubleMatrix1D doubleMatrix1D) {
        return this.zDotProduct(doubleMatrix1D, 0, this.size);
    }

    public double zDotProduct(DoubleMatrix1D doubleMatrix1D, int n, int n2) {
        if (n < 0 || n2 <= 0) {
            return 0.0;
        }
        int n3 = n + n2;
        if (this.size < n3) {
            n3 = this.size;
        }
        if (doubleMatrix1D.size < n3) {
            n3 = doubleMatrix1D.size;
        }
        n2 = n3 - n;
        double d = 0.0;
        int n4 = n3 - 1;
        int n5 = n2;
        while (--n5 >= 0) {
            d += this.getQuick(n4) * doubleMatrix1D.getQuick(n4);
            --n4;
        }
        return d;
    }

    public double zDotProduct(DoubleMatrix1D doubleMatrix1D, int n, int n2, IntArrayList intArrayList) {
        int n3;
        int n4;
        if (n < 0 || n2 <= 0) {
            return 0.0;
        }
        int n5 = n + n2;
        if (this.size < n5) {
            n5 = this.size;
        }
        if (doubleMatrix1D.size < n5) {
            n5 = doubleMatrix1D.size;
        }
        if ((n2 = n5 - n) <= 0) {
            return 0.0;
        }
        int[] nArray = intArrayList.elements();
        int n6 = intArrayList.size();
        for (n4 = 0; n4 < n6 && nArray[n4] < n; ++n4) {
        }
        double d = 0.0;
        while (--n2 >= 0 && n4 < n6 && (n3 = nArray[n4]) < n5) {
            d += this.getQuick(n3) * doubleMatrix1D.getQuick(n3);
            ++n4;
        }
        return d;
    }

    protected double zDotProduct(DoubleMatrix1D doubleMatrix1D, IntArrayList intArrayList) {
        return this.zDotProduct(doubleMatrix1D, 0, this.size, intArrayList);
    }

    public double zSum() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.aggregate(Functions.plus, Functions.identity);
    }
}

