/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.function.SearchOsmPoisXmlHandler;
import tim.prune.function.search.GenericDownloaderFunction;
import tim.prune.function.search.SearchResult;

public class SearchOsmPoisFunction
extends GenericDownloaderFunction {
    private static final int MAX_DISTANCE = 250;
    private double _searchLatitude = 0.0;
    private double _searchLongitude = 0.0;

    public SearchOsmPoisFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.searchosmpois";
    }

    @Override
    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.osmpois.column.name";
        }
        return "dialog.osmpois.column.type";
    }

    @Override
    public void run() {
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        if (dataPoint == null) {
            double[] dArray = this._app.getViewport().getBounds();
            this._searchLatitude = (dArray[0] + dArray[2]) / 2.0;
            this._searchLongitude = (dArray[1] + dArray[3]) / 2.0;
        } else {
            this._searchLatitude = dataPoint.getLatitude().getDouble();
            this._searchLongitude = dataPoint.getLongitude().getDouble();
        }
        this.submitSearch(this._searchLatitude, this._searchLongitude);
        if (this._errorMessage == null && this._trackListModel.isEmpty()) {
            this._errorMessage = I18nManager.getText("dialog.osmpois.nonefound");
        }
        this._statusLabel.setText(this._errorMessage == null ? "" : this._errorMessage);
    }

    private void submitSearch(double d, double d2) {
        Object object;
        Object object2;
        String string = "around:250," + d + "," + d2;
        String string2 = "http://overpass-api.de/api/interpreter?data=(node(" + string + ")[\"amenity\"][\"name\"];" + "node(" + string + ")[\"railway\"][\"name\"];" + "node(" + string + ")[\"highway\"][\"name\"];" + ");out%20qt;";
        SearchOsmPoisXmlHandler searchOsmPoisXmlHandler = new SearchOsmPoisXmlHandler();
        InputStream inputStream = null;
        try {
            object2 = new URL(string2);
            object = SAXParserFactory.newInstance().newSAXParser();
            inputStream = ((URL)object2).openStream();
            ((SAXParser)object).parse(inputStream, (DefaultHandler)searchOsmPoisXmlHandler);
        }
        catch (Exception exception) {
            this._errorMessage = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = new DataPoint(new Latitude(this._searchLatitude, 17), new Longitude(this._searchLongitude, 17), null);
        Object object3 = searchOsmPoisXmlHandler.getPointList().iterator();
        while (object3.hasNext()) {
            object = object3.next();
            Latitude latitude = new Latitude(((SearchResult)object).getLatitude());
            Longitude longitude = new Longitude(((SearchResult)object).getLongitude());
            DataPoint dataPoint = new DataPoint(latitude, longitude, null);
            double d3 = DataPoint.calculateRadiansBetween((DataPoint)object2, dataPoint);
            ((SearchResult)object).setLength(Distance.convertRadiansToDistance(d3));
        }
        object = searchOsmPoisXmlHandler.getPointList();
        this._trackListModel.addTracks((ArrayList<SearchResult>)object, true);
        this._trackListModel.setShowPointTypes(true);
        if (this._trackListModel.isEmpty() && (object3 = searchOsmPoisXmlHandler.getErrorMessage()) != null && !((String)object3).equals("")) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), (String)object3);
            this._errorMessage = object3;
        }
    }

    @Override
    protected void loadSelected() {
        int n = this._trackTable.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this._trackTable.getSelectedRows();
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 >= 0 && n3 < this._trackListModel.getRowCount()) {
                String string = this._trackListModel.getTrack(n3).getLatitude();
                String string2 = this._trackListModel.getTrack(n3).getLongitude();
                if (string != null && string2 != null) {
                    DataPoint dataPoint = new DataPoint(new Latitude(string), new Longitude(string2), null);
                    dataPoint.setFieldValue(Field.WAYPT_NAME, this._trackListModel.getTrack(n3).getTrackName(), false);
                    this._app.createPoint(dataPoint);
                }
            }
            ++n2;
        }
        this._cancelled = true;
        this._dialog.dispose();
    }
}

