/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.io.IOException;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.util.Log;

public class LastModifiedWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        LastModifiedWidget lastModifiedWidget = new LastModifiedWidget(view);
        return lastModifiedWidget;
    }

    public static class LastModifiedWidget
    implements Widget {
        private final JLabel lastModifiedLabel;
        private final View view;
        private static final SimpleDateFormat sdf = new SimpleDateFormat();

        LastModifiedWidget(View view) {
            this.view = view;
            this.lastModifiedLabel = new JLabel(){

                @Override
                public void addNotify() {
                    super.addNotify();
                    this.update();
                    EditBus.addToBus(this);
                }

                @Override
                public void removeNotify() {
                    super.removeNotify();
                    EditBus.removeFromBus(this);
                }
            };
            this.lastModifiedLabel.setToolTipText(jEdit.getProperty("fileprop.lastmod"));
            this.update();
        }

        @Override
        public JComponent getComponent() {
            return this.lastModifiedLabel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            String string = buffer.getPath();
            VFS vFS = VFSManager.getVFSForPath(string);
            Object object = vFS.createVFSSession(string, this.view);
            try {
                VFSFile vFSFile = vFS._getFile(object, string, this.view);
                if (vFSFile == null) {
                    this.lastModifiedLabel.setText("");
                } else {
                    this.lastModifiedLabel.setText(vFSFile.getExtendedAttribute("modified"));
                }
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
            }
            finally {
                try {
                    vFS._endVFSSession(object, this.view);
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public void propertiesChanged() {
        }

        @EditBus.EBHandler
        public void handleMessage(EditPaneUpdate editPaneUpdate) {
            if (editPaneUpdate.getWhat() == EditPaneUpdate.BUFFER_CHANGED && editPaneUpdate.getEditPane().getView() == this.view) {
                this.update();
            }
        }

        @EditBus.EBHandler
        public void handleMessage(BufferUpdate bufferUpdate) {
            if (bufferUpdate.getBuffer() == this.view.getBuffer()) {
                this.update();
            }
        }
    }
}

