/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.ParserRule;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XModeHandler
extends DefaultHandler {
    private final String modeName;
    private final TokenMarker marker;
    private KeywordMap keywords;
    private final Stack<TagDecl> stateStack;
    private String propName;
    private String propValue;
    private Hashtable<String, String> props;
    private Hashtable<String, String> modeProps;
    private ParserRuleSet rules;
    private Vector<Mode> reloadModes;

    public XModeHandler(String string) {
        this.modeName = string;
        this.marker = new TokenMarker();
        this.marker.addRuleSet(new ParserRuleSet(string, "MAIN"));
        this.stateStack = new Stack();
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        return XMLUtilities.findEntity(string2, "xmode.dtd", XModeHandler.class);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.peekElement().setText(cArray, n, n2);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        TagDecl tagDecl = this.pushElement(string3, attributes);
        if (string3.equals("WHITESPACE")) {
            Log.log(7, this, this.modeName + ": WHITESPACE rule no longer needed");
        } else if (string3.equals("KEYWORDS")) {
            this.keywords = new KeywordMap(this.rules.getIgnoreCase());
        } else if (string3.equals("RULES")) {
            if (tagDecl.lastSetName == null) {
                tagDecl.lastSetName = "MAIN";
            }
            this.rules = this.marker.getRuleSet(tagDecl.lastSetName);
            if (this.rules == null) {
                this.rules = new ParserRuleSet(this.modeName, tagDecl.lastSetName);
                this.marker.addRuleSet(this.rules);
            }
            this.rules.setIgnoreCase(tagDecl.lastIgnoreCase);
            this.rules.setHighlightDigits(tagDecl.lastHighlightDigits);
            if (tagDecl.lastDigitRE != null) {
                try {
                    this.rules.setDigitRegexp(Pattern.compile(tagDecl.lastDigitRE, tagDecl.lastIgnoreCase ? 2 : 0));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.error("regexp", patternSyntaxException);
                }
            }
            if (tagDecl.lastEscape != null) {
                this.rules.setEscapeRule(ParserRule.createEscapeRule(tagDecl.lastEscape));
            }
            this.rules.setDefault(tagDecl.lastDefaultID);
            this.rules.setNoWordSep(tagDecl.lastNoWordSep);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        block54: {
            TagDecl tagDecl = this.popElement();
            if (string3.equals(tagDecl.tagName)) {
                byte by;
                Mode mode;
                if (!(tagDecl.lastDelegateSet == null || tagDecl.tagName.equals("IMPORT") || tagDecl.lastDelegateSet.getModeName().equals(this.modeName) || this.reloadModes.contains(mode = ModeProvider.instance.getMode(tagDecl.lastDelegateSet.getModeName())))) {
                    this.reloadModes.add(mode);
                }
                if (tagDecl.tagName.equals("PROPERTY")) {
                    this.props.put(this.propName, this.propValue);
                } else if (tagDecl.tagName.equals("PROPS")) {
                    if (this.peekElement().tagName.equals("RULES")) {
                        this.rules.setProperties(this.props);
                    } else {
                        this.modeProps = this.props;
                    }
                    this.props = new Hashtable();
                } else if (tagDecl.tagName.equals("RULES")) {
                    this.rules.setKeywords(this.keywords);
                    this.keywords = null;
                    this.rules = null;
                } else if (tagDecl.tagName.equals("IMPORT")) {
                    if (!this.rules.equals(tagDecl.lastDelegateSet)) {
                        this.rules.addRuleSet(tagDecl.lastDelegateSet);
                    }
                } else if (tagDecl.tagName.equals("TERMINATE")) {
                    this.rules.setTerminateChar(tagDecl.termChar);
                } else if (tagDecl.tagName.equals("SEQ")) {
                    if (tagDecl.lastStart == null) {
                        this.error("empty-tag", "SEQ");
                        return;
                    }
                    this.rules.addRule(ParserRule.createSequenceRule(tagDecl.lastStartPosMatch, tagDecl.lastStart.toString(), tagDecl.lastDelegateSet, tagDecl.lastTokenID));
                } else if (tagDecl.tagName.equals("SEQ_REGEXP")) {
                    if (tagDecl.lastStart == null) {
                        this.error("empty-tag", "SEQ_REGEXP");
                        return;
                    }
                    try {
                        if (null != tagDecl.lastHashChars) {
                            this.rules.addRule(ParserRule.createRegexpSequenceRule(tagDecl.lastStartPosMatch, tagDecl.lastHashChars.toCharArray(), tagDecl.lastStart.toString(), tagDecl.lastDelegateSet, tagDecl.lastTokenID, this.findParent((String)"RULES").lastIgnoreCase));
                            break block54;
                        }
                        this.rules.addRule(ParserRule.createRegexpSequenceRule(tagDecl.lastHashChar, tagDecl.lastStartPosMatch, tagDecl.lastStart.toString(), tagDecl.lastDelegateSet, tagDecl.lastTokenID, this.findParent((String)"RULES").lastIgnoreCase));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        this.error("regexp", patternSyntaxException);
                    }
                } else if (tagDecl.tagName.equals("SPAN")) {
                    if (tagDecl.lastStart == null) {
                        this.error("empty-tag", "BEGIN");
                        return;
                    }
                    if (tagDecl.lastEnd == null) {
                        this.error("empty-tag", "END");
                        return;
                    }
                    this.rules.addRule(ParserRule.createSpanRule(tagDecl.lastStartPosMatch, tagDecl.lastStart.toString(), tagDecl.lastEndPosMatch, tagDecl.lastEnd.toString(), tagDecl.lastDelegateSet, tagDecl.lastTokenID, tagDecl.lastMatchType, tagDecl.lastNoLineBreak, tagDecl.lastNoWordBreak, tagDecl.lastEscape));
                } else if (tagDecl.tagName.equals("SPAN_REGEXP")) {
                    if (tagDecl.lastStart == null) {
                        this.error("empty-tag", "BEGIN");
                        return;
                    }
                    if (tagDecl.lastEnd == null) {
                        this.error("empty-tag", "END");
                        return;
                    }
                    try {
                        if (null != tagDecl.lastHashChars) {
                            this.rules.addRule(ParserRule.createRegexpSpanRule(tagDecl.lastStartPosMatch, tagDecl.lastHashChars.toCharArray(), tagDecl.lastStart.toString(), tagDecl.lastEndPosMatch, tagDecl.lastEnd.toString(), tagDecl.lastDelegateSet, tagDecl.lastTokenID, tagDecl.lastMatchType, tagDecl.lastNoLineBreak, tagDecl.lastNoWordBreak, this.findParent((String)"RULES").lastIgnoreCase, tagDecl.lastEscape, tagDecl.lastEndRegexp));
                            break block54;
                        }
                        this.rules.addRule(ParserRule.createRegexpSpanRule(tagDecl.lastHashChar, tagDecl.lastStartPosMatch, tagDecl.lastStart.toString(), tagDecl.lastEndPosMatch, tagDecl.lastEnd.toString(), tagDecl.lastDelegateSet, tagDecl.lastTokenID, tagDecl.lastMatchType, tagDecl.lastNoLineBreak, tagDecl.lastNoWordBreak, this.findParent((String)"RULES").lastIgnoreCase, tagDecl.lastEscape, tagDecl.lastEndRegexp));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        this.error("regexp", patternSyntaxException);
                    }
                } else if (tagDecl.tagName.equals("EOL_SPAN")) {
                    if (tagDecl.lastStart == null) {
                        this.error("empty-tag", "EOL_SPAN");
                        return;
                    }
                    this.rules.addRule(ParserRule.createEOLSpanRule(tagDecl.lastStartPosMatch, tagDecl.lastStart.toString(), tagDecl.lastDelegateSet, tagDecl.lastTokenID, tagDecl.lastMatchType));
                } else if (tagDecl.tagName.equals("EOL_SPAN_REGEXP")) {
                    if (tagDecl.lastStart == null) {
                        this.error("empty-tag", "EOL_SPAN_REGEXP");
                        return;
                    }
                    try {
                        if (null != tagDecl.lastHashChars) {
                            this.rules.addRule(ParserRule.createRegexpEOLSpanRule(tagDecl.lastStartPosMatch, tagDecl.lastHashChars.toCharArray(), tagDecl.lastStart.toString(), tagDecl.lastDelegateSet, tagDecl.lastTokenID, tagDecl.lastMatchType, this.findParent((String)"RULES").lastIgnoreCase));
                            break block54;
                        }
                        this.rules.addRule(ParserRule.createRegexpEOLSpanRule(tagDecl.lastHashChar, tagDecl.lastStartPosMatch, tagDecl.lastStart.toString(), tagDecl.lastDelegateSet, tagDecl.lastTokenID, tagDecl.lastMatchType, this.findParent((String)"RULES").lastIgnoreCase));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        this.error("regexp", patternSyntaxException);
                    }
                } else if (tagDecl.tagName.equals("MARK_FOLLOWING")) {
                    if (tagDecl.lastStart == null) {
                        this.error("empty-tag", "MARK_FOLLOWING");
                        return;
                    }
                    this.rules.addRule(ParserRule.createMarkFollowingRule(tagDecl.lastStartPosMatch, tagDecl.lastStart.toString(), tagDecl.lastTokenID, tagDecl.lastMatchType));
                } else if (tagDecl.tagName.equals("MARK_PREVIOUS")) {
                    if (tagDecl.lastStart == null) {
                        this.error("empty-tag", "MARK_PREVIOUS");
                        return;
                    }
                    this.rules.addRule(ParserRule.createMarkPreviousRule(tagDecl.lastStartPosMatch, tagDecl.lastStart.toString(), tagDecl.lastTokenID, tagDecl.lastMatchType));
                } else if (!(tagDecl.tagName.equals("END") || tagDecl.tagName.equals("BEGIN") || tagDecl.tagName.equals("KEYWORDS") || tagDecl.tagName.equals("MODE") || (by = Token.stringToToken(tagDecl.tagName)) == -1)) {
                    if (tagDecl.lastKeyword == null || tagDecl.lastKeyword.length() == 0) {
                        this.error("empty-keyword", null);
                    } else {
                        this.addKeyword(tagDecl.lastKeyword.toString(), by);
                    }
                }
            } else {
                throw new InternalError();
            }
        }
    }

    @Override
    public void startDocument() {
        this.props = new Hashtable();
        this.pushElement(null, null);
        this.reloadModes = new Vector();
    }

    @Override
    public void endDocument() {
        ParserRuleSet[] parserRuleSetArray = this.marker.getRuleSets();
        for (int i = 0; i < parserRuleSetArray.length; ++i) {
            parserRuleSetArray[i].resolveImports();
        }
        for (Mode mode : this.reloadModes) {
            mode.setTokenMarker(null);
            mode.loadIfNecessary();
        }
    }

    public TokenMarker getTokenMarker() {
        return this.marker;
    }

    public Hashtable<String, String> getModeProperties() {
        return this.modeProps;
    }

    protected abstract void error(String var1, Object var2);

    protected abstract TokenMarker getTokenMarker(String var1);

    private void addKeyword(String string, byte by) {
        if (this.keywords == null) {
            return;
        }
        this.keywords.add(string, by);
    }

    private TagDecl pushElement(String string, Attributes attributes) {
        if (string != null) {
            TagDecl tagDecl = new TagDecl(string, attributes);
            this.stateStack.push(tagDecl);
            return tagDecl;
        }
        this.stateStack.push(null);
        return null;
    }

    private TagDecl peekElement() {
        return this.stateStack.peek();
    }

    private TagDecl popElement() {
        return this.stateStack.pop();
    }

    private TagDecl findParent(String string) {
        for (int i = this.stateStack.size() - 1; i >= 0; --i) {
            TagDecl tagDecl = (TagDecl)this.stateStack.get(i);
            if (!tagDecl.tagName.equals(string)) continue;
            return tagDecl;
        }
        return null;
    }

    private class TagDecl {
        public String tagName;
        public StringBuffer lastStart;
        public StringBuffer lastEnd;
        public StringBuffer lastKeyword;
        public String lastSetName;
        public String lastEscape;
        public ParserRuleSet lastDelegateSet;
        public String lastNoWordSep = "_";
        public ParserRuleSet rules;
        public byte lastDefaultID = 0;
        public byte lastTokenID;
        public byte lastMatchType;
        public int termChar = -1;
        public boolean lastNoLineBreak;
        public boolean lastNoWordBreak;
        public boolean lastIgnoreCase = true;
        public boolean lastHighlightDigits;
        public boolean lastAtLineStart;
        public boolean lastAtWhitespaceEnd;
        public boolean lastAtWordStart;
        public boolean lastRegexp;
        public boolean lastEndRegexp;
        public int lastStartPosMatch;
        public int lastEndPosMatch;
        public String lastDigitRE;
        public String lastHashChar;
        public String lastHashChars;

        TagDecl(String string, Attributes attributes) {
            this.tagName = string;
            XModeHandler.this.propName = attributes.getValue("NAME");
            XModeHandler.this.propValue = attributes.getValue("VALUE");
            String string2 = attributes.getValue("TYPE");
            if (string2 != null) {
                this.lastTokenID = Token.stringToToken(string2);
                if (this.lastTokenID == -1) {
                    XModeHandler.this.error("token-invalid", string2);
                }
            }
            this.lastMatchType = (byte)-2;
            string2 = attributes.getValue("EXCLUDE_MATCH");
            if (string2 != null) {
                Log.log(7, this, XModeHandler.this.modeName + ": EXCLUDE_MATCH is deprecated");
                if ("TRUE".equalsIgnoreCase(string2)) {
                    this.lastMatchType = (byte)-1;
                }
            }
            if ((string2 = attributes.getValue("MATCH_TYPE")) != null) {
                if ("CONTEXT".equals(string2)) {
                    this.lastMatchType = (byte)-1;
                } else if ("RULE".equals(string2)) {
                    this.lastMatchType = (byte)-2;
                } else {
                    this.lastMatchType = Token.stringToToken(string2);
                    if (this.lastMatchType == -1) {
                        XModeHandler.this.error("token-invalid", string2);
                    }
                }
            }
            this.lastAtLineStart = "TRUE".equals(attributes.getValue("AT_LINE_START"));
            this.lastAtWhitespaceEnd = "TRUE".equals(attributes.getValue("AT_WHITESPACE_END"));
            this.lastAtWordStart = "TRUE".equals(attributes.getValue("AT_WORD_START"));
            this.lastNoLineBreak = "TRUE".equals(attributes.getValue("NO_LINE_BREAK"));
            this.lastNoWordBreak = "TRUE".equals(attributes.getValue("NO_WORD_BREAK"));
            this.lastIgnoreCase = attributes.getValue("IGNORE_CASE") == null || "TRUE".equals(attributes.getValue("IGNORE_CASE"));
            this.lastHighlightDigits = "TRUE".equals(attributes.getValue("HIGHLIGHT_DIGITS"));
            this.lastRegexp = "TRUE".equals(attributes.getValue("REGEXP"));
            this.lastDigitRE = attributes.getValue("DIGIT_RE");
            string2 = attributes.getValue("NO_WORD_SEP");
            if (string2 != null) {
                this.lastNoWordSep = string2;
            }
            if ((string2 = attributes.getValue("AT_CHAR")) != null) {
                try {
                    this.termChar = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    XModeHandler.this.error("termchar-invalid", string2);
                    this.termChar = -1;
                }
            }
            this.lastEscape = attributes.getValue("ESCAPE");
            this.lastSetName = attributes.getValue("SET");
            string2 = attributes.getValue("DELEGATE");
            if (string2 != null) {
                String string3;
                String string4;
                int n = string2.indexOf("::");
                if (n != -1) {
                    string4 = string2.substring(0, n);
                    string3 = string2.substring(n + 2);
                } else {
                    string4 = XModeHandler.this.modeName;
                    string3 = string2;
                }
                TokenMarker tokenMarker = XModeHandler.this.getTokenMarker(string4);
                if (tokenMarker == null) {
                    XModeHandler.this.error("delegate-invalid", string2);
                } else {
                    this.lastDelegateSet = tokenMarker.getRuleSet(string3);
                    if (tokenMarker == XModeHandler.this.marker && this.lastDelegateSet == null) {
                        this.lastDelegateSet = new ParserRuleSet(string4, string3);
                        this.lastDelegateSet.setDefault((byte)7);
                        XModeHandler.this.marker.addRuleSet(this.lastDelegateSet);
                    } else if (this.lastDelegateSet == null) {
                        XModeHandler.this.error("delegate-invalid", string2);
                    }
                }
            }
            if ((string2 = attributes.getValue("DEFAULT")) != null) {
                this.lastDefaultID = Token.stringToToken(string2);
                if (this.lastDefaultID == -1) {
                    XModeHandler.this.error("token-invalid", string2);
                    this.lastDefaultID = 0;
                }
            }
            this.lastHashChar = attributes.getValue("HASH_CHAR");
            this.lastHashChars = attributes.getValue("HASH_CHARS");
            if (null != this.lastHashChar && null != this.lastHashChars) {
                XModeHandler.this.error("hash-char-and-hash-chars-mutually-exclusive", null);
                this.lastHashChars = null;
            }
        }

        public void setText(char[] cArray, int n, int n2) {
            if (this.tagName.equals("EOL_SPAN") || this.tagName.equals("EOL_SPAN_REGEXP") || this.tagName.equals("MARK_PREVIOUS") || this.tagName.equals("MARK_FOLLOWING") || this.tagName.equals("SEQ") || this.tagName.equals("SEQ_REGEXP") || this.tagName.equals("BEGIN")) {
                TagDecl tagDecl = this;
                if (this.tagName.equals("BEGIN")) {
                    tagDecl = (TagDecl)XModeHandler.this.stateStack.get(XModeHandler.this.stateStack.size() - 2);
                }
                if (tagDecl.lastStart == null) {
                    tagDecl.lastStart = new StringBuffer();
                    tagDecl.lastStart.append(cArray, n, n2);
                    tagDecl.lastStartPosMatch = (tagDecl.lastAtLineStart ? 2 : 0) | (tagDecl.lastAtWhitespaceEnd ? 4 : 0) | (tagDecl.lastAtWordStart ? 8 : 0);
                    tagDecl.lastAtLineStart = false;
                    tagDecl.lastAtWordStart = false;
                    tagDecl.lastAtWhitespaceEnd = false;
                } else {
                    tagDecl.lastStart.append(cArray, n, n2);
                }
            } else if (this.tagName.equals("END")) {
                TagDecl tagDecl = (TagDecl)XModeHandler.this.stateStack.get(XModeHandler.this.stateStack.size() - 2);
                if (tagDecl.lastEnd == null) {
                    tagDecl.lastEnd = new StringBuffer();
                    tagDecl.lastEnd.append(cArray, n, n2);
                    tagDecl.lastEndPosMatch = (this.lastAtLineStart ? 2 : 0) | (this.lastAtWhitespaceEnd ? 4 : 0) | (this.lastAtWordStart ? 8 : 0);
                    tagDecl.lastEndRegexp = this.lastRegexp;
                    tagDecl.lastAtLineStart = false;
                    tagDecl.lastAtWordStart = false;
                    tagDecl.lastAtWhitespaceEnd = false;
                } else {
                    tagDecl.lastEnd.append(cArray, n, n2);
                }
            } else {
                if (this.lastKeyword == null) {
                    this.lastKeyword = new StringBuffer();
                }
                this.lastKeyword.append(cArray, n, n2);
            }
        }
    }
}

