/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.BufferHandler;
import org.gjt.sp.jedit.textarea.ElasticTabStopBufferListener;
import org.gjt.sp.jedit.textarea.FirstLine;
import org.gjt.sp.jedit.textarea.RangeMap;
import org.gjt.sp.jedit.textarea.ScreenLineManager;
import org.gjt.sp.jedit.textarea.ScrollLineCount;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public class DisplayManager {
    private static final Map<JEditBuffer, List<DisplayManager>> bufferMap = new HashMap<JEditBuffer, List<DisplayManager>>();
    final FirstLine firstLine;
    final ScrollLineCount scrollLineCount;
    final ScreenLineManager screenLineMgr;
    final RangeMap folds;
    private boolean initialized;
    private boolean inUse;
    private final JEditBuffer buffer;
    private final TextArea textArea;
    private final BufferHandler bufferHandler;
    private final ElasticTabStopBufferListener elasticTabStopListener;

    static DisplayManager getDisplayManager(JEditBuffer jEditBuffer2, TextArea textArea) {
        DisplayManager displayManager;
        List list = bufferMap.computeIfAbsent(jEditBuffer2, jEditBuffer -> new LinkedList());
        DisplayManager displayManager2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            displayManager2 = displayManager = (DisplayManager)iterator.next();
            if (displayManager.inUse || displayManager.textArea != textArea) continue;
            displayManager.inUse = true;
            return displayManager;
        }
        displayManager = new DisplayManager(jEditBuffer2, textArea, displayManager2);
        displayManager.inUse = true;
        list.add(displayManager);
        return displayManager;
    }

    void release() {
        this.inUse = false;
    }

    public static void bufferClosed(JEditBuffer jEditBuffer) {
        bufferMap.remove(jEditBuffer);
    }

    static void textAreaDisposed(TextArea textArea) {
        for (List<DisplayManager> list : bufferMap.values()) {
            Iterator<DisplayManager> iterator = list.iterator();
            while (iterator.hasNext()) {
                DisplayManager displayManager = iterator.next();
                if (displayManager.textArea != textArea) continue;
                displayManager.dispose();
                iterator.remove();
            }
        }
    }

    public JEditBuffer getBuffer() {
        return this.buffer;
    }

    public boolean isLineVisible(int n) {
        return this.folds.search(n) % 2 == 0;
    }

    public boolean isOutsideNarrowing(int n) {
        if (n < this.getFirstVisibleLine()) {
            return true;
        }
        if (n > this.getLastVisibleLine()) {
            int n2 = this.getLastVisibleLine();
            int n3 = this.buffer.getFoldLevel(n2);
            if (this.buffer.getFoldLevel(n) <= n3) {
                return true;
            }
            for (int i = n2 + 1; i <= n; ++i) {
                if (this.buffer.getFoldLevel(i) > n3) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public int getFirstVisibleLine() {
        return this.folds.first();
    }

    public int getLastVisibleLine() {
        return this.folds.last();
    }

    public int getNextVisibleLine(int n) {
        if (n < 0 || n >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.folds.next(n);
    }

    public int getPrevVisibleLine(int n) {
        if (n < 0 || n >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.folds.prev(n);
    }

    public int getScreenLineCount(int n) {
        this.updateScreenLineCount(n);
        return this.screenLineMgr.getScreenLineCount(n);
    }

    public int getScrollLineCount() {
        return this.scrollLineCount.getScrollLine();
    }

    public void collapseFold(int n) {
        int n2 = this.buffer.getLineCount();
        int n3 = n2 - 1;
        if (n != 0 && n != n2 - 1 && this.buffer.isFoldStart(n) && !this.isLineVisible(n + 1)) {
            --n;
        }
        int n4 = this.buffer.getFoldLevel(n);
        int n5 = 0;
        if (n != n2 - 1 && this.buffer.getFoldLevel(n + 1) > n4) {
            n5 = n + 1;
            for (int i = n + 1; i < n2; ++i) {
                if (this.buffer.getFoldLevel(i) > n4) continue;
                n3 = i - 1;
                break;
            }
        } else {
            int n6;
            boolean bl = false;
            for (n6 = n - 1; n6 >= 0; --n6) {
                if (this.buffer.getFoldLevel(n6) >= n4) continue;
                n5 = n6 + 1;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            for (n6 = n + 1; n6 < n2; ++n6) {
                if (this.buffer.getFoldLevel(n6) >= n4) continue;
                n3 = n6 - 1;
                break;
            }
        }
        this.hideLineRange(n5, n3);
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public int expandFold(int n, boolean bl) {
        MutableInteger mutableInteger = new MutableInteger(-1);
        boolean bl2 = this._expandFold(n, bl, mutableInteger);
        if (bl2) {
            this.textArea.foldStructureChanged();
        }
        return mutableInteger.get();
    }

    public void expandAllFolds() {
        this.showLineRange(0, this.buffer.getLineCount() - 1);
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public void expandFolds(char c) {
        if (c < '1' || c > '9') {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        } else {
            this.expandFolds(c - 49 + 1);
        }
    }

    public void expandFolds(int n, boolean bl) {
        if (this.buffer.getFoldHandler() instanceof IndentFoldHandler) {
            n = (n - 1) * this.buffer.getIndentSize() + 1;
        }
        int n2 = this.buffer.getLineCount();
        int n3 = n2 - 1;
        this.showLineRange(0, n3);
        int n4 = -1;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = this.buffer.getFoldLevel(i);
            if (n4 == -1 || n6 < n4) {
                n4 = n6;
            }
            if (n6 >= n && n6 != n4) continue;
            if (n5 != i) {
                this.hideLineRange(n5, i - 1);
            }
            n5 = i + 1;
        }
        if (n5 != n2) {
            this.hideLineRange(n5, n3);
        }
        this.notifyScreenLineChanges();
        if (bl && this.textArea.getDisplayManager() == this) {
            this.textArea.foldStructureChanged();
        }
    }

    public void expandFolds(int n) {
        this.expandFolds(n, true);
    }

    public void narrow(int n, int n2) {
        int n3 = this.buffer.getLineCount();
        if (n > n2 || n < 0 || n2 >= n3) {
            throw new ArrayIndexOutOfBoundsException(n + ", " + n2);
        }
        if (n < this.getFirstVisibleLine() || n2 > this.getLastVisibleLine()) {
            this.expandAllFolds();
        }
        if (n != 0) {
            this.hideLineRange(0, n - 1);
        }
        if (n2 != n3 - 1) {
            this.hideLineRange(n2 + 1, n3 - 1);
        }
        if (n != n3 - 1 && !this.isLineVisible(n + 1)) {
            this.expandFold(n, false);
        }
        this.textArea.fireNarrowActive();
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    void init() {
        assert (this.textArea.getDisplayManager() == this);
        if (this.buffer.isLoading()) {
            return;
        }
        if (!this.initialized) {
            this.folds.reset(this.buffer.getLineCount());
            this.resetAnchors();
            int n = this.buffer.getIntegerProperty("collapseFolds", 0);
            if (n != 0) {
                this.expandFolds(n);
            }
            this.initialized = true;
        } else {
            this.resetAnchors();
        }
    }

    void notifyScreenLineChanges() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "notifyScreenLineChanges()");
        }
        assert (this.textArea.getDisplayManager() == this);
        try {
            if (this.firstLine.isCallReset()) {
                this.firstLine.reset();
            } else if (this.firstLine.isCallChanged()) {
                this.firstLine.changed();
            }
            if (this.scrollLineCount.isCallReset()) {
                this.scrollLineCount.reset();
                this.firstLine.ensurePhysicalLineIsVisible();
            } else if (this.scrollLineCount.isCallChanged()) {
                this.scrollLineCount.changed();
            }
            if (this.firstLine.isCallChanged() || this.scrollLineCount.isCallReset() || this.scrollLineCount.isCallChanged()) {
                this.textArea.updateScrollBar();
                this.textArea.recalculateLastPhysicalLine();
            }
        }
        finally {
            this.firstLine.resetCallState();
            this.scrollLineCount.resetCallState();
        }
    }

    void setFirstLine(int n, int n2) {
        int n3 = this.textArea.getVisibleLines();
        if (n2 >= n + n3) {
            this.firstLine.scrollDown(n2 - n);
            this.textArea.chunkCache.invalidateAll();
        } else if (n2 <= n - n3) {
            this.firstLine.scrollUp(n - n2);
            this.textArea.chunkCache.invalidateAll();
        } else if (n2 > n) {
            this.firstLine.scrollDown(n2 - n);
            this.textArea.chunkCache.scrollDown(n2 - n);
        } else if (n2 < n) {
            this.firstLine.scrollUp(n - n2);
            this.textArea.chunkCache.scrollUp(n - n2);
        }
        this.notifyScreenLineChanges();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setFirstPhysicalLine(int n, int n2) {
        int n3 = this.textArea.getFirstLine();
        if (n == 0) {
            if ((n2 -= this.firstLine.getSkew()) < 0) {
                this.firstLine.scrollUp(-n2);
            } else {
                if (n2 <= 0) return;
                this.firstLine.scrollDown(n2);
            }
        } else if (n > 0) {
            this.firstLine.physDown(n, n2);
        } else {
            this.firstLine.physUp(-n, n2);
        }
        int n4 = this.textArea.getFirstLine();
        int n5 = this.textArea.getVisibleLines();
        if (n4 != n3) {
            if (n4 >= n3 + n5 || n4 <= n3 - n5) {
                this.textArea.chunkCache.invalidateAll();
            } else if (n4 > n3) {
                this.textArea.chunkCache.scrollDown(n4 - n3);
            } else {
                this.textArea.chunkCache.scrollUp(n3 - n4);
            }
        }
        this.notifyScreenLineChanges();
    }

    void invalidateScreenLineCounts() {
        this.screenLineMgr.invalidateScreenLineCounts();
        this.firstLine.setCallReset(true);
        this.scrollLineCount.setCallReset(true);
    }

    void updateScreenLineCount(int n) {
        assert (this.textArea.getDisplayManager() == this);
        if (!this.screenLineMgr.isScreenLineCountValid(n)) {
            this.textArea.chunkCache.reset();
            int n2 = this.textArea.chunkCache.getLineSubregionCount(n);
            assert (n2 > 0);
            this.setScreenLineCount(n, n2);
        }
    }

    void bufferLoaded() {
        this.initialized = false;
        this.folds.reset(this.buffer.getLineCount());
        this.screenLineMgr.reset();
        if (this.textArea.getDisplayManager() == this) {
            this.textArea.propertiesChanged();
            this.init();
        }
    }

    void foldHandlerChanged() {
        if (this.buffer.isLoading()) {
            return;
        }
        this.initialized = false;
        this.folds.reset(this.buffer.getLineCount());
        if (this.textArea.getDisplayManager() == this) {
            this.init();
        }
    }

    private DisplayManager(JEditBuffer jEditBuffer, TextArea textArea, DisplayManager displayManager) {
        this.buffer = jEditBuffer;
        this.screenLineMgr = new ScreenLineManager(jEditBuffer);
        this.textArea = textArea;
        this.scrollLineCount = new ScrollLineCount(this, textArea);
        this.firstLine = new FirstLine(this, textArea);
        this.bufferHandler = new BufferHandler(this, textArea, jEditBuffer);
        this.elasticTabStopListener = new ElasticTabStopBufferListener(textArea);
        jEditBuffer.addBufferListener(this.elasticTabStopListener, 1);
        jEditBuffer.addBufferListener(this.bufferHandler, 1);
        if (displayManager != null) {
            this.folds = new RangeMap(displayManager.folds);
            this.initialized = true;
        } else {
            this.folds = new RangeMap();
            this.folds.reset(0);
        }
    }

    private void resetAnchors() {
        this.firstLine.setCallReset(true);
        this.scrollLineCount.setCallReset(true);
        this.notifyScreenLineChanges();
    }

    private void dispose() {
        this.buffer.removeBufferListener(this.bufferHandler);
        this.buffer.removeBufferListener(this.elasticTabStopListener);
    }

    private void showLineRange(int n, int n2) {
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "showLineRange(" + n + "," + n2 + ")");
        }
        for (int i = n; i <= n2; ++i) {
            if (this.isLineVisible(i)) continue;
            int n3 = this.getScreenLineCount(i);
            if (this.firstLine.getPhysicalLine() >= i) {
                this.firstLine.moveScrollLine(n3);
            }
            this.scrollLineCount.moveScrollLine(n3);
        }
        this.folds.show(n, n2);
    }

    private void hideLineRange(int n, int n2) {
        int n3;
        int n4;
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "hideLineRange(" + n + "," + n2 + ")");
        }
        if (!this.isLineVisible(n4 = n)) {
            n4 = this.getNextVisibleLine(n4);
        }
        int n5 = 0;
        while (n4 != -1 && n4 <= n2) {
            n3 = this.getScreenLineCount(n4);
            if (n4 < this.firstLine.getPhysicalLine()) {
                this.firstLine.setSkew(0);
                this.firstLine.moveScrollLine(-n3);
            }
            n5 -= n3;
            n4 = this.getNextVisibleLine(n4);
        }
        this.scrollLineCount.moveScrollLine(n5);
        this.folds.hide(n, n2);
        if (!this.isLineVisible(this.firstLine.getPhysicalLine())) {
            n3 = this.getFirstVisibleLine();
            if (this.firstLine.getPhysicalLine() < n3) {
                this.firstLine.setPhysicalLine(n3);
                this.firstLine.setScrollLine(0);
            } else {
                this.firstLine.setPhysicalLine(this.getPrevVisibleLine(this.firstLine.getPhysicalLine()));
                this.firstLine.moveScrollLine(-this.getScreenLineCount(this.firstLine.getPhysicalLine()));
            }
        }
    }

    private void setScreenLineCount(int n, int n2) {
        assert (n2 > 0);
        this.screenLineMgr.setScreenLineCount(n, n2);
    }

    private boolean _expandFold(int n, boolean bl, MutableInteger mutableInteger) {
        int n2;
        int n3;
        boolean bl2 = false;
        int n4 = this.buffer.getLineCount();
        int n5 = n4 - 1;
        while (!this.isLineVisible(n)) {
            n3 = this.folds.lookup(this.folds.search(n)) - 1;
            if (!this.isLineVisible(n3)) {
                return bl2;
            }
            bl2 |= this._expandFold(n3, bl, mutableInteger);
            if (this.isLineVisible(n3 + 1)) continue;
            return bl2;
        }
        if (n == n4 - 1 || this.isLineVisible(n + 1) && !bl) {
            return bl2;
        }
        int n6 = this.buffer.getFoldLevel(n);
        if (this.buffer.getFoldLevel(n + 1) > n6) {
            n3 = n;
            if (!this.isLineVisible(n + 1) && this.folds.search(n + 1) != this.folds.count() - 1) {
                n2 = this.folds.search(n + 1);
                n5 = this.folds.lookup(n2 + 1) - 1;
            } else {
                for (n2 = n + 1; n2 < n4; ++n2) {
                    if (this.buffer.getFoldLevel(n2) > n6) continue;
                    n5 = n2 - 1;
                    break;
                }
            }
        } else {
            if (!bl) {
                return bl2;
            }
            for (n3 = n; n3 > 0 && this.buffer.getFoldLevel(n3) >= n6; --n3) {
            }
            n6 = this.buffer.getFoldLevel(n3);
            for (n2 = n + 1; n2 < n4; ++n2) {
                if (this.buffer.getFoldLevel(n2) > n6) continue;
                n5 = n2 - 1;
                break;
            }
        }
        if (bl) {
            this.showLineRange(n3, n5);
        } else {
            n2 = 0;
            int n7 = n3 + 1;
            while (n7 <= n5) {
                if (n2 == 0 && this.buffer.isFoldStart(n7)) {
                    mutableInteger.set(n7);
                    n2 = 1;
                }
                this.showLineRange(n7, n7);
                int n8 = this.buffer.getFoldLevel(n7);
                ++n7;
                while (n7 <= n5 && this.buffer.getFoldLevel(n7) > n8) {
                    ++n7;
                }
            }
        }
        bl2 = true;
        this.notifyScreenLineChanges();
        return bl2;
    }

    private static class MutableInteger {
        private int value;

        MutableInteger(int n) {
            this.value = n;
        }

        public void set(int n) {
            this.value = n;
        }

        public int get() {
            return this.value;
        }
    }
}

