/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.font.TextLayout;
import java.util.Vector;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.ColumnBlock;
import org.gjt.sp.jedit.textarea.ColumnBlockLine;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaPainter;

public class ElasticTabstopsTabExpander
implements TabExpander {
    private final TextArea textArea;
    private final TextAreaPainter painter;

    public ElasticTabstopsTabExpander(TextArea textArea) {
        this.textArea = textArea;
        this.painter = textArea.getPainter();
    }

    @Override
    public float nextTabStop(float f, int n) {
        float f2 = 0.0f;
        JEditBuffer jEditBuffer = this.textArea.getBuffer();
        if (jEditBuffer.getBooleanProperty("elasticTabstops") && jEditBuffer.getColumnBlock() != null) {
            int n2 = jEditBuffer.getLineOfOffset(n);
            f2 = this.getTabSize(jEditBuffer.getColumnBlock().getColumnBlock(n2, n), n2);
            if (f2 < 0.0f) {
                throw new IllegalArgumentException("Unaccounted tab at line " + jEditBuffer.getLineOfOffset(n) + " at index " + n);
            }
        }
        return f + (f2 += this.textArea.tabSize);
    }

    private float getTabSize(ColumnBlock columnBlock, int n) {
        float f = -5.0f;
        if (columnBlock != null) {
            Vector<ColumnBlockLine> vector = columnBlock.getLines();
            if (columnBlock.areTabSizesDirty()) {
                float f2 = -1.0f;
                JEditBuffer jEditBuffer = this.textArea.getBuffer();
                for (int i = 0; i < vector.size(); ++i) {
                    ColumnBlockLine columnBlockLine = vector.elementAt(i);
                    int n2 = columnBlockLine.getColumnStartIndex() + jEditBuffer.getLineStartOffset(columnBlockLine.getLine());
                    String string = jEditBuffer.getText(n2, columnBlockLine.getColumnEndIndex() - columnBlockLine.getColumnStartIndex());
                    float f3 = 0.0f;
                    if (!string.isEmpty()) {
                        TextLayout textLayout = new TextLayout(string, this.painter.getFont(), this.painter.getFontRenderContext());
                        f3 = textLayout.getAdvance();
                    }
                    columnBlockLine.lineLength = f3;
                    if (!(f2 < 0.0f) && !(columnBlockLine.lineLength > f2)) continue;
                    f2 = columnBlockLine.lineLength;
                }
                columnBlock.columnBlockWidth = f2;
                columnBlock.setTabSizeDirtyStatus(false, false);
            }
            f = columnBlock.columnBlockWidth - vector.get((int)(n - columnBlock.startLine)).lineLength;
        }
        return f;
    }
}

