/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.CU;
import javajs.util.P3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class NffReader
extends PolygonFileReader {
    protected int nPolygons;
    private final Map<String, Integer> vertexMap = new Hashtable<String, Integer>();
    private final P3 pt = new P3();

    NffReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2PFR(sg, br);
    }

    protected void setHeader() {
        this.jvxlFileHeaderBuffer.append("NFF file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    @Override
    void getSurfaceData() throws Exception {
        if (this.readVerticesAndPolygons()) {
            Logger.info("NFF file contains " + this.nVertices + " vertices and " + this.nTriangles + " triangles");
        } else {
            Logger.error(this.params.fileName + ": Error reading Nff data ");
        }
    }

    protected boolean readVerticesAndPolygons() {
        int color = 0xFF0000;
        try {
            block7: while (this.rd() != null) {
                if (this.line.length() == 0) continue;
                String[] tokens = this.getTokens();
                switch (this.line.charAt(0)) {
                    case '#': {
                        this.vertexMap.clear();
                        continue block7;
                    }
                    case 'f': {
                        color = CU.colorTriadToFFRGB(this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[2]), this.parseFloatStr(tokens[3]));
                        continue block7;
                    }
                    case 'p': {
                        if (!this.line.equals("pp 3")) continue block7;
                        int i1 = this.getVertex();
                        int i2 = this.getVertex();
                        int i3 = this.getVertex();
                        ++this.nTriangles;
                        this.addTriangleCheck(i1, i2, i3, 7, 0, false, color);
                        continue block7;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private int getVertex() throws Exception {
        Integer i = this.vertexMap.get(this.rd());
        if (i == null) {
            String[] tokens = this.getTokens();
            this.pt.set(this.parseFloatStr(tokens[0]), this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[2]));
            if (!Float.isNaN(this.params.scale)) {
                this.pt.scale(this.params.scale);
            }
            if (this.isAnisotropic) {
                this.setVertexAnisotropy(this.pt);
            }
            i = this.addVertexCopy(this.pt, 0.0f, this.nVertices++, true);
            this.vertexMap.put(this.line, i);
        }
        return i;
    }
}

