/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import org.bouncycastle.tls.ByteQueue;
import org.bouncycastle.tls.DTLSEpoch;
import org.bouncycastle.tls.DTLSHandshakeRetransmit;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DatagramSender;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.HeartbeatMessage;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.Timeout;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsTimeoutException;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsNullNullCipher;
import org.bouncycastle.util.Arrays;

class DTLSRecordLayer
implements DatagramTransport {
    private static final int RECORD_HEADER_LENGTH = 13;
    private static final int MAX_FRAGMENT_LENGTH = 16384;
    private static final long TCP_MSL = 120000L;
    private static final long RETRANSMIT_TIMEOUT = 240000L;
    private final TlsContext context;
    private final TlsPeer peer;
    private final DatagramTransport transport;
    private final ByteQueue recordQueue = new ByteQueue();
    private final Object writeLock = new Object();
    private volatile boolean closed = false;
    private volatile boolean failed = false;
    private volatile ProtocolVersion readVersion = null;
    private volatile ProtocolVersion writeVersion = null;
    private volatile boolean inConnection;
    private volatile boolean inHandshake;
    private volatile int plaintextLimit;
    private DTLSEpoch currentEpoch;
    private DTLSEpoch pendingEpoch;
    private DTLSEpoch readEpoch;
    private DTLSEpoch writeEpoch;
    private DTLSHandshakeRetransmit retransmit = null;
    private DTLSEpoch retransmitEpoch = null;
    private Timeout retransmitTimeout = null;
    private TlsHeartbeat heartbeat = null;
    private boolean heartBeatResponder = false;
    private HeartbeatMessage heartbeatInFlight = null;
    private Timeout heartbeatTimeout = null;
    private int heartbeatResendMillis = -1;
    private Timeout heartbeatResendTimeout = null;

    static byte[] receiveClientHelloRecord(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 13) {
            return null;
        }
        short s = TlsUtils.readUint8(byArray, n + 0);
        if (22 != s) {
            return null;
        }
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byArray, n + 1);
        if (!ProtocolVersion.DTLSv10.isEqualOrEarlierVersionOf(protocolVersion)) {
            return null;
        }
        int n3 = TlsUtils.readUint16(byArray, n + 3);
        if (0 != n3) {
            return null;
        }
        int n4 = TlsUtils.readUint16(byArray, n + 11);
        if (n2 < 13 + n4) {
            return null;
        }
        if (n4 > 16384) {
            return null;
        }
        return TlsUtils.copyOfRangeExact(byArray, n + 13, n + 13 + n4);
    }

    static void sendHelloVerifyRequestRecord(DatagramSender datagramSender, long l, byte[] byArray) throws IOException {
        TlsUtils.checkUint16(byArray.length);
        byte[] byArray2 = new byte[13 + byArray.length];
        TlsUtils.writeUint8((short)22, byArray2, 0);
        TlsUtils.writeVersion(ProtocolVersion.DTLSv10, byArray2, 1);
        TlsUtils.writeUint16(0, byArray2, 3);
        TlsUtils.writeUint48(l, byArray2, 5);
        TlsUtils.writeUint16(byArray.length, byArray2, 11);
        System.arraycopy(byArray, 0, byArray2, 13, byArray.length);
        DTLSRecordLayer.sendDatagram(datagramSender, byArray2, 0, byArray2.length);
    }

    private static void sendDatagram(DatagramSender datagramSender, byte[] byArray, int n, int n2) throws IOException {
        try {
            datagramSender.send(byArray, n, n2);
        }
        catch (InterruptedIOException interruptedIOException) {
            interruptedIOException.bytesTransferred = 0;
            throw interruptedIOException;
        }
    }

    DTLSRecordLayer(TlsContext tlsContext, TlsPeer tlsPeer, DatagramTransport datagramTransport) {
        this.context = tlsContext;
        this.peer = tlsPeer;
        this.transport = datagramTransport;
        this.inHandshake = true;
        this.currentEpoch = new DTLSEpoch(0, TlsNullNullCipher.INSTANCE);
        this.pendingEpoch = null;
        this.readEpoch = this.currentEpoch;
        this.writeEpoch = this.currentEpoch;
        this.setPlaintextLimit(16384);
    }

    boolean isClosed() {
        return this.closed;
    }

    void resetAfterHelloVerifyRequestClient() {
        this.currentEpoch.getReplayWindow().reset();
    }

    void resetAfterHelloVerifyRequestServer(long l) {
        this.inConnection = true;
        this.currentEpoch.setSequenceNumber(l);
    }

    void setPlaintextLimit(int n) {
        this.plaintextLimit = n;
    }

    int getReadEpoch() {
        return this.readEpoch.getEpoch();
    }

    ProtocolVersion getReadVersion() {
        return this.readVersion;
    }

    void setReadVersion(ProtocolVersion protocolVersion) {
        this.readVersion = protocolVersion;
    }

    void setWriteVersion(ProtocolVersion protocolVersion) {
        this.writeVersion = protocolVersion;
    }

    void initPendingEpoch(TlsCipher tlsCipher) {
        if (this.pendingEpoch != null) {
            throw new IllegalStateException();
        }
        this.pendingEpoch = new DTLSEpoch(this.writeEpoch.getEpoch() + 1, tlsCipher);
    }

    void handshakeSuccessful(DTLSHandshakeRetransmit dTLSHandshakeRetransmit) {
        if (this.readEpoch == this.currentEpoch || this.writeEpoch == this.currentEpoch) {
            throw new IllegalStateException();
        }
        if (null != dTLSHandshakeRetransmit) {
            this.retransmit = dTLSHandshakeRetransmit;
            this.retransmitEpoch = this.currentEpoch;
            this.retransmitTimeout = new Timeout(240000L);
        }
        this.inHandshake = false;
        this.currentEpoch = this.pendingEpoch;
        this.pendingEpoch = null;
    }

    void initHeartbeat(TlsHeartbeat tlsHeartbeat, boolean bl) {
        if (this.inHandshake) {
            throw new IllegalStateException();
        }
        this.heartbeat = tlsHeartbeat;
        this.heartBeatResponder = bl;
        if (null != tlsHeartbeat) {
            this.resetHeartbeat();
        }
    }

    void resetWriteEpoch() {
        this.writeEpoch = null != this.retransmitEpoch ? this.retransmitEpoch : this.currentEpoch;
    }

    public int getReceiveLimit() throws IOException {
        return Math.min(this.plaintextLimit, this.readEpoch.getCipher().getPlaintextLimit(this.transport.getReceiveLimit() - 13));
    }

    public int getSendLimit() throws IOException {
        return Math.min(this.plaintextLimit, this.writeEpoch.getCipher().getPlaintextLimit(this.transport.getSendLimit() - 13));
    }

    public int receive(byte[] byArray, int n, int n2, int n3) throws IOException {
        long l = System.currentTimeMillis();
        Timeout timeout = Timeout.forWaitMillis(n3, l);
        byte[] byArray2 = null;
        while (n3 >= 0) {
            int n4;
            int n5;
            if (null != this.retransmitTimeout && this.retransmitTimeout.remainingMillis(l) < 1L) {
                this.retransmit = null;
                this.retransmitEpoch = null;
                this.retransmitTimeout = null;
            }
            if (Timeout.hasExpired(this.heartbeatTimeout, l)) {
                if (null != this.heartbeatInFlight) {
                    throw new TlsTimeoutException("Heartbeat timed out");
                }
                this.heartbeatInFlight = HeartbeatMessage.create(this.context, (short)1, this.heartbeat.generatePayload());
                this.heartbeatTimeout = new Timeout(this.heartbeat.getTimeoutMillis(), l);
                this.heartbeatResendMillis = 1000;
                this.heartbeatResendTimeout = new Timeout(this.heartbeatResendMillis, l);
                this.sendHeartbeatMessage(this.heartbeatInFlight);
            } else if (Timeout.hasExpired(this.heartbeatResendTimeout, l)) {
                this.heartbeatResendMillis = DTLSReliableHandshake.backOff(this.heartbeatResendMillis);
                this.heartbeatResendTimeout = new Timeout(this.heartbeatResendMillis, l);
                this.sendHeartbeatMessage(this.heartbeatInFlight);
            }
            n3 = Timeout.constrainWaitMillis(n3, this.heartbeatTimeout, l);
            n3 = Timeout.constrainWaitMillis(n3, this.heartbeatResendTimeout, l);
            if (n3 < 0) {
                n3 = 1;
            }
            int n6 = Math.min(n2, this.getReceiveLimit()) + 13;
            if (null == byArray2 || byArray2.length < n6) {
                byArray2 = new byte[n6];
            }
            if ((n5 = this.processRecord(n4 = this.receiveRecord(byArray2, 0, n6, n3), byArray2, byArray, n)) >= 0) {
                return n5;
            }
            l = System.currentTimeMillis();
            n3 = Timeout.getWaitMillis(timeout, l);
        }
        return -1;
    }

    public void send(byte[] byArray, int n, int n2) throws IOException {
        short s = 23;
        if (this.inHandshake || this.writeEpoch == this.retransmitEpoch) {
            s = 22;
            short s2 = TlsUtils.readUint8(byArray, n);
            if (s2 == 20) {
                DTLSEpoch dTLSEpoch = null;
                if (this.inHandshake) {
                    dTLSEpoch = this.pendingEpoch;
                } else if (this.writeEpoch == this.retransmitEpoch) {
                    dTLSEpoch = this.currentEpoch;
                }
                if (dTLSEpoch == null) {
                    throw new IllegalStateException();
                }
                byte[] byArray2 = new byte[]{1};
                this.sendRecord((short)20, byArray2, 0, byArray2.length);
                this.writeEpoch = dTLSEpoch;
            }
        }
        this.sendRecord(s, byArray, n, n2);
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (this.inHandshake && this.inConnection) {
                this.warn((short)90, "User canceled handshake");
            }
            this.closeTransport();
        }
    }

    void fail(short s) {
        if (!this.closed) {
            if (this.inConnection) {
                try {
                    this.raiseAlert((short)2, s, null, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.failed = true;
            this.closeTransport();
        }
    }

    void failed() {
        if (!this.closed) {
            this.failed = true;
            this.closeTransport();
        }
    }

    void warn(short s, String string) throws IOException {
        this.raiseAlert((short)1, s, string, null);
    }

    private void closeTransport() {
        if (!this.closed) {
            try {
                if (!this.failed) {
                    this.warn((short)0, null);
                }
                this.transport.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.closed = true;
        }
    }

    private void raiseAlert(short s, short s2, String string, Throwable throwable) throws IOException {
        this.peer.notifyAlertRaised(s, s2, string, throwable);
        byte[] byArray = new byte[]{(byte)s, (byte)s2};
        this.sendRecord((short)21, byArray, 0, 2);
    }

    private int receiveDatagram(byte[] byArray, int n, int n2, int n3) throws IOException {
        try {
            return this.transport.receive(byArray, n, n2, n3);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return -1;
        }
        catch (InterruptedIOException interruptedIOException) {
            interruptedIOException.bytesTransferred = 0;
            throw interruptedIOException;
        }
    }

    private int processRecord(int n, byte[] byArray, byte[] byArray2, int n2) throws IOException {
        if (n < 13) {
            return -1;
        }
        int n3 = TlsUtils.readUint16(byArray, 11);
        if (n != n3 + 13) {
            return -1;
        }
        short s = TlsUtils.readUint8(byArray, 0);
        switch (s) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            default: {
                return -1;
            }
        }
        int n4 = TlsUtils.readUint16(byArray, 3);
        DTLSEpoch dTLSEpoch = null;
        if (n4 == this.readEpoch.getEpoch()) {
            dTLSEpoch = this.readEpoch;
        } else if (s == 22 && null != this.retransmitEpoch && n4 == this.retransmitEpoch.getEpoch()) {
            dTLSEpoch = this.retransmitEpoch;
        }
        if (null == dTLSEpoch) {
            return -1;
        }
        long l = TlsUtils.readUint48(byArray, 5);
        if (dTLSEpoch.getReplayWindow().shouldDiscard(l)) {
            return -1;
        }
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byArray, 1);
        if (!protocolVersion.isDTLS()) {
            return -1;
        }
        if (null != this.readVersion && !this.readVersion.equals(protocolVersion)) {
            boolean bl;
            boolean bl2 = bl = this.getReadEpoch() == 0 && n3 > 0 && 22 == s && 1 == TlsUtils.readUint8(byArray, 13);
            if (!bl) {
                return -1;
            }
        }
        long l2 = DTLSRecordLayer.getMacSequenceNumber(dTLSEpoch.getEpoch(), l);
        TlsDecodeResult tlsDecodeResult = dTLSEpoch.getCipher().decodeCiphertext(l2, s, protocolVersion, byArray, 13, n3);
        dTLSEpoch.getReplayWindow().reportAuthenticated(l);
        if (tlsDecodeResult.len > this.plaintextLimit) {
            return -1;
        }
        if (tlsDecodeResult.len < 1 && tlsDecodeResult.contentType != 23) {
            return -1;
        }
        if (null == this.readVersion) {
            this.readVersion = protocolVersion;
        }
        switch (tlsDecodeResult.contentType) {
            case 21: {
                if (tlsDecodeResult.len == 2) {
                    short s2 = TlsUtils.readUint8(tlsDecodeResult.buf, tlsDecodeResult.off);
                    short s3 = TlsUtils.readUint8(tlsDecodeResult.buf, tlsDecodeResult.off + 1);
                    this.peer.notifyAlertReceived(s2, s3);
                    if (s2 == 2) {
                        this.failed();
                        throw new TlsFatalAlert(s3);
                    }
                    if (s3 == 0) {
                        this.closeTransport();
                    }
                }
                return -1;
            }
            case 23: {
                if (!this.inHandshake) break;
                return -1;
            }
            case 20: {
                for (int i = 0; i < tlsDecodeResult.len; ++i) {
                    short s4 = TlsUtils.readUint8(tlsDecodeResult.buf, tlsDecodeResult.off + i);
                    if (s4 != 1 || this.pendingEpoch == null) continue;
                    this.readEpoch = this.pendingEpoch;
                }
                return -1;
            }
            case 22: {
                if (this.inHandshake) break;
                if (null != this.retransmit) {
                    this.retransmit.receivedHandshakeRecord(n4, tlsDecodeResult.buf, tlsDecodeResult.off, tlsDecodeResult.len);
                }
                return -1;
            }
            case 24: {
                if (null != this.heartbeatInFlight || this.heartBeatResponder) {
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(tlsDecodeResult.buf, tlsDecodeResult.off, tlsDecodeResult.len);
                        HeartbeatMessage heartbeatMessage = HeartbeatMessage.parse(byteArrayInputStream);
                        if (null != heartbeatMessage) {
                            switch (heartbeatMessage.getType()) {
                                case 1: {
                                    if (!this.heartBeatResponder) break;
                                    HeartbeatMessage heartbeatMessage2 = HeartbeatMessage.create(this.context, (short)2, heartbeatMessage.getPayload());
                                    this.sendHeartbeatMessage(heartbeatMessage2);
                                    break;
                                }
                                case 2: {
                                    if (null == this.heartbeatInFlight || !Arrays.areEqual((byte[])heartbeatMessage.getPayload(), (byte[])this.heartbeatInFlight.getPayload())) break;
                                    this.resetHeartbeat();
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return -1;
            }
            default: {
                return -1;
            }
        }
        if (!this.inHandshake && null != this.retransmit) {
            this.retransmit = null;
            this.retransmitEpoch = null;
            this.retransmitTimeout = null;
        }
        System.arraycopy(tlsDecodeResult.buf, tlsDecodeResult.off, byArray2, n2, tlsDecodeResult.len);
        return tlsDecodeResult.len;
    }

    private int receiveRecord(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (this.recordQueue.available() > 0) {
            int n4 = 0;
            if (this.recordQueue.available() >= 13) {
                byte[] byArray2 = new byte[2];
                this.recordQueue.read(byArray2, 0, 2, 11);
                n4 = TlsUtils.readUint16(byArray2, 0);
            }
            int n5 = Math.min(this.recordQueue.available(), 13 + n4);
            this.recordQueue.removeData(byArray, n, n5, 0);
            return n5;
        }
        int n6 = this.receiveDatagram(byArray, n, n2, n3);
        if (n6 >= 13) {
            this.inConnection = true;
            int n7 = TlsUtils.readUint16(byArray, n + 11);
            int n8 = 13 + n7;
            if (n6 > n8) {
                this.recordQueue.addData(byArray, n + n8, n6 - n8);
                n6 = n8;
            }
        }
        return n6;
    }

    private void resetHeartbeat() {
        this.heartbeatInFlight = null;
        this.heartbeatResendMillis = -1;
        this.heartbeatResendTimeout = null;
        this.heartbeatTimeout = new Timeout(this.heartbeat.getIdleMillis());
    }

    private void sendHeartbeatMessage(HeartbeatMessage heartbeatMessage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        heartbeatMessage.encode(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.sendRecord((short)24, byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRecord(short s, byte[] byArray, int n, int n2) throws IOException {
        if (this.writeVersion == null) {
            return;
        }
        if (n2 > this.plaintextLimit) {
            throw new TlsFatalAlert(80);
        }
        if (n2 < 1 && s != 23) {
            throw new TlsFatalAlert(80);
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n3 = this.writeEpoch.getEpoch();
            long l = this.writeEpoch.allocateSequenceNumber();
            long l2 = DTLSRecordLayer.getMacSequenceNumber(n3, l);
            ProtocolVersion protocolVersion = this.writeVersion;
            TlsEncodeResult tlsEncodeResult = this.writeEpoch.getCipher().encodePlaintext(l2, s, protocolVersion, 13, byArray, n, n2);
            int n4 = tlsEncodeResult.len - 13;
            TlsUtils.checkUint16(n4);
            TlsUtils.writeUint8(tlsEncodeResult.recordType, tlsEncodeResult.buf, tlsEncodeResult.off + 0);
            TlsUtils.writeVersion(protocolVersion, tlsEncodeResult.buf, tlsEncodeResult.off + 1);
            TlsUtils.writeUint16(n3, tlsEncodeResult.buf, tlsEncodeResult.off + 3);
            TlsUtils.writeUint48(l, tlsEncodeResult.buf, tlsEncodeResult.off + 5);
            TlsUtils.writeUint16(n4, tlsEncodeResult.buf, tlsEncodeResult.off + 11);
            DTLSRecordLayer.sendDatagram(this.transport, tlsEncodeResult.buf, tlsEncodeResult.off, tlsEncodeResult.len);
        }
    }

    private static long getMacSequenceNumber(int n, long l) {
        return ((long)n & 0xFFFFFFFFL) << 48 | l;
    }
}

