/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc;

import com.sun.tools.jxc.Messages;
import com.sun.tools.jxc.gen.config.NGCCRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class NGCCRuntimeEx
extends NGCCRuntime {
    private final ErrorHandler errorHandler;

    public NGCCRuntimeEx(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public File getBaseDir(String baseDir) throws SAXException {
        File dir = new File(baseDir);
        if (dir.exists()) {
            return dir;
        }
        SAXParseException e = new SAXParseException(Messages.BASEDIR_DOESNT_EXIST.format(dir.getAbsolutePath()), this.getLocator());
        this.errorHandler.error(e);
        throw e;
    }

    public List<Pattern> getIncludePatterns(List<String> includeContent) {
        ArrayList<Pattern> includeRegexList = new ArrayList<Pattern>();
        for (String includes : includeContent) {
            String regex = this.convertToRegex(includes);
            Pattern pattern = Pattern.compile(regex);
            includeRegexList.add(pattern);
        }
        return includeRegexList;
    }

    public List getExcludePatterns(List<String> excludeContent) {
        ArrayList<Pattern> excludeRegexList = new ArrayList<Pattern>();
        for (String excludes : excludeContent) {
            String regex = this.convertToRegex(excludes);
            Pattern pattern = Pattern.compile(regex);
            excludeRegexList.add(pattern);
        }
        return excludeRegexList;
    }

    private String convertToRegex(String pattern) {
        StringBuilder regex = new StringBuilder();
        int nc = 32;
        if (pattern.length() > 0) {
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                nc = 32;
                if (i + 1 != pattern.length()) {
                    nc = pattern.charAt(i + 1);
                }
                if (c == '.' && nc != 46) {
                    regex.append('\\');
                    regex.append('.');
                    continue;
                }
                if (c == '.') continue;
                if (c == '*' && nc == 42) {
                    regex.append(".*");
                    break;
                }
                if (c == '*') {
                    regex.append("[^\\.]+");
                    continue;
                }
                if (c == '?') {
                    regex.append("[^\\.]");
                    continue;
                }
                regex.append(c);
            }
        }
        return regex.toString();
    }

    @Override
    protected void unexpectedX(String token) throws SAXException {
        this.errorHandler.error(new SAXParseException(Messages.UNEXPECTED_NGCC_TOKEN.format(token, this.getLocator().getLineNumber(), this.getLocator().getColumnNumber()), this.getLocator()));
    }
}

