/* io.elementary.music-core.vapi generated by valac 0.48.3, do not modify. */

namespace Music {
	namespace Compare {
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static int album_artists (Music.Media a, Music.Media b);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static int albums (Music.Media a, Music.Media b);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static int artists (Music.Media a, Music.Media b);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static int genres (Music.Media a, Music.Media b);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static int standard (int a, int b);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static int standard_64 (int64 a, int64 b);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static int standard_unsigned (uint a, uint b);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static int titles (Music.Media a, Music.Media b);
	}
	namespace FileUtils {
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static int count_music_files (GLib.File music_folder, Gee.Collection<string> files);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static GLib.File get_data_directory ();
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static GLib.File? get_new_destination (Music.Media s);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static uint64 get_size (GLib.File file, GLib.Cancellable? cancellable = null);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static bool is_valid_content_type (string file_content_type, string[]? content_types = null);
	}
	namespace PlaylistsUtils {
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static void export_playlist (Music.Playlist p);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static string get_new_playlist_name (Gee.Collection<Music.Playlist> playlists, string? name = null);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static string get_playlist_m3u_file (Music.Playlist p, string without_path);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static Gee.HashMap<string,Gee.LinkedList<string>> get_playlists_to_import (string? set_title = "Playlist") throws GLib.Error;
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static void import_from_playlist_file_info (Gee.HashMap<string,Gee.LinkedList<string>> playlists, Music.Library library);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static bool save_playlist_m3u (Music.Playlist p, string folder_uri, string without_path);
	}
	namespace Plugins {
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public class Interface : GLib.Object {
			public enum Hook {
				CONTEXT,
				SIDEBAR,
				MAIN_MENU,
				ADDONS_MENU,
				BOTTOMBAR,
				TOOLBAR,
				SOURCE_VIEW,
				SETTINGS_WINDOW,
				WINDOW
			}
			public delegate void HookFunction ();
			public delegate void HookFunctionArg (GLib.Object object);
			public Interface (Music.Plugins.Manager manager);
			public void register_function (Music.Plugins.Interface.Hook hook, Music.Plugins.Interface.HookFunction hook_function);
			public void register_function_arg (Music.Plugins.Interface.Hook hook, Music.Plugins.Interface.HookFunctionArg hook_function);
			public void register_function_signal (Music.Plugins.Interface.Hook hook, string signal_name, GLib.Object obj);
			public Gtk.Menu addons_menu { get; private set; }
			public weak GLib.List<Gtk.TextView> all_source_view { get; private set; }
			public string? argument { get; internal set; }
			public Gtk.Notebook bottombar { get; internal set; }
			public Gtk.Notebook context { get; internal set; }
			public Gtk.Menu main_menu { get; private set; }
			public Gtk.Application noise_app { get; internal set; }
			public string set_name { get; internal set; }
			public Gtk.Notebook sidebar { get; internal set; }
			public Gtk.Toolbar toolbar { get; internal set; }
			public Gtk.Window window { get; private set; }
		}
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public class Manager : GLib.Object {
			public static Music.Plugins.Manager get_default ();
			public Gtk.Widget get_view ();
			public void hook_app (Gtk.Application app);
			public void hook_example (string arg);
			public Gtk.Notebook context { set; }
			public Gtk.Application noise_app { set; }
			public Music.Plugins.Interface plugin_iface { get; private set; }
			public Gtk.Notebook sidebar { set; }
			public Gtk.Toolbar toolbar { set; }
			public signal void hook_addons_menu (Gtk.Menu menu);
			public signal void hook_main_menu (Gtk.Menu menu);
			public signal void hook_new_window (Gtk.Window window);
			public signal void hook_notebook_bottom (Gtk.Notebook notebook);
			public signal void hook_notebook_context ();
			public signal void hook_notebook_sidebar ();
			public signal void hook_preferences_window (Gtk.Window window);
			public signal void hook_set_arg (string set_name, string? set_arg);
			public signal void hook_source_view (Gtk.TextView view);
			public signal void hook_toolbar ();
			public signal void hook_toolbar_context_menu (Gtk.Menu menu);
		}
	}
	namespace Search {
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static bool match_fields_to_media (Music.Media media, string album_artist = "", string album = "", string genre = "", string grouping = "", string composer = "", int year = -1, int rating = -1);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static bool match_string_to_media (Music.Media m, string search);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static void search_in_media_list (Gee.Collection<Music.Media> to_search, out Gee.Collection<Music.Media> results, string album_artist = "", string album = "", string genre = "", string grouping = "", string composer = "", int year = -1, int rating = -1, GLib.Cancellable? cancellable = null);
	}
	namespace Settings {
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public class Equalizer : Granite.Services.Settings {
			public static Music.Settings.Equalizer get_default ();
			public Gee.Collection<Music.EqualizerPreset> get_presets ();
			public bool auto_switch_preset { get; set; }
			public string[] custom_presets { get; set; }
			public bool equalizer_enabled { get; set; }
			public string selected_preset { get; set; }
		}
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public class Main : Granite.Services.Settings {
			public static Music.Settings.Main get_default ();
			public bool privacy_mode_enabled ();
			public string music_folder { get; set; }
			public string music_mount_name { get; set; }
			public string path_string { get; set; }
			public string[] plugins_disabled { get; set; }
			public Music.Settings.Repeat repeat_mode { get; set; }
			public Music.Settings.Shuffle shuffle_mode { get; set; }
		}
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public enum Repeat {
			OFF,
			MEDIA,
			ALL,
			ALBUM,
			ARTIST
		}
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public enum Shuffle {
			OFF,
			ALL
		}
	}
	namespace String {
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static void base_search_method (string search, out uint parsed_rating, out string parsed_search_string);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static int compare (string? a, string? b);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static bool is_empty (string? text, bool check_white_space);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static bool is_white_space (string text);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static uint64 uint_from_string (string str);
	}
	namespace TimeUtils {
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public const uint64 MILI_INV;
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public const uint64 NANO_INV;
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static uint nanoseconds_to_miliseconds (uint64 nanoseconds);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static uint nanoseconds_to_seconds (uint64 nanoseconds);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static string pretty_timestamp_from_time (GLib.Time dt);
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public static uint64 seconds_to_nanoseconds (uint64 seconds);
	}
	namespace Widgets {
		[CCode (cheader_filename = "io.elementary.music-core.h")]
		public class AlbumImage : Gtk.Grid {
			public Gtk.Image image;
			public AlbumImage ();
			public override void get_preferred_height_for_width (int width, out int minimum_height, out int natural_height);
			public override Gtk.SizeRequestMode get_request_mode ();
		}
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class Album : GLib.Object {
		public Album (string name, string artist);
		public void add_media (Music.Media m);
		public Album.from_media (Music.Media media);
		public GLib.File? get_cached_cover_file ();
		public Gdk.Pixbuf? get_cached_cover_pixbuf (int scale);
		public string get_display_artist ();
		public string get_display_name ();
		public uint get_hashkey ();
		public Gee.Collection<Music.Media> get_media (uint n_disc = 1);
		public bool is_compatible (Music.Media m);
		public void remove_media (Music.Media m);
		public void save_cover_file (GLib.File file);
		public void save_cover_pixbuf (Gdk.Pixbuf pixbuf);
		public string artist { get; set construct; }
		public GLib.Icon? cover_icon { get; set; }
		public bool is_empty { get; }
		public string name { get; set construct; }
		public uint year { get; set construct; }
		public signal void cover_rendered ();
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class DeviceManager : GLib.Object {
		public void device_initialized (Music.Device d);
		public Gee.Collection<weak GLib.Mount> get_available_mounts ();
		public static Music.DeviceManager get_default ();
		public Gee.Collection<weak Music.Device> get_initialized_devices ();
		public async void get_pre_existing_mounts ();
		public virtual void mount_changed (GLib.Mount mount);
		public virtual void mount_pre_unmount (GLib.Mount mount);
		public signal void device_added (Music.Device d);
		public signal void device_name_changed (Music.Device d);
		public signal void device_removed (Music.Device d);
		public signal void mount_added (GLib.Mount mount);
		public signal void mount_removed (GLib.Mount mount);
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class Equalizer : GLib.Object {
		public Gst.Element element;
		public Equalizer ();
		public static Gee.Collection<Music.EqualizerPreset> get_default_presets ();
		public void set_gain (int index, double gain);
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class EqualizerPreset : GLib.Object {
		public Gee.ArrayList<int> gains;
		public EqualizerPreset ();
		public EqualizerPreset.basic (string name);
		public EqualizerPreset.from_string (string data);
		public int get_gain (int index);
		public void set_gain (int index, int val);
		public string to_string ();
		public EqualizerPreset.with_gains (string name, int[] items);
		public bool is_default { get; set; }
		public string name { get; set construct; }
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class Icon : GLib.Object {
		public Icon (string name);
		public GLib.File? get_file (int size = 16);
		public Gdk.Pixbuf? render (Gtk.IconSize size, Gtk.StyleContext? style_context = null);
		public GLib.Icon gicon { get; private set; }
		public string? name { get; private set; }
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class LibrariesManager : GLib.Object {
		public string current_operation;
		public Music.Library local_library;
		public double progress;
		public LibrariesManager ();
		public void add_library (Music.Library library);
		public bool do_progress_notification_with_timeout ();
		public Music.Library? get_library_from_index (int index);
		public void remove_library (Music.Library library);
		public void search_for_string (string search);
		public async void transfer_medias_async (Gee.Collection<Music.Media> list);
		public void transfer_to_local_library (Gee.Collection<Music.Media> to_transfer);
		public signal void add_headless_playlist (Music.StaticPlaylist playlist);
		public signal void cancel_transfer ();
		public signal void library_added (Music.Library library);
		public signal void library_removed (Music.Library library);
		public signal void operation_terminated ();
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public abstract class Library : GLib.Object {
		protected Library ();
		public abstract void add_files_to_library (Gee.Collection<string> files);
		public abstract void add_media (Music.Media s);
		public abstract void add_medias (Gee.Collection<Music.Media> new_media);
		public abstract void add_playlist (Music.StaticPlaylist p);
		public abstract void add_smart_playlist (Music.SmartPlaylist p);
		public abstract bool doing_file_operations ();
		public abstract Music.Media? find_media (Music.Media to_find);
		public abstract void finish_file_operations ();
		public abstract Gee.Collection<Music.Media> get_medias ();
		public abstract Gee.Collection<Music.StaticPlaylist> get_playlists ();
		public abstract Gee.Collection<Music.Media> get_search_result ();
		public abstract Gee.Collection<Music.SmartPlaylist> get_smart_playlists ();
		public abstract void initialize_library ();
		public abstract Music.Media? media_from_file (GLib.File file);
		public abstract Music.Media? media_from_id (int64 id);
		public void media_from_name (Gee.Collection<Music.Media> tests, Gee.Collection<int64?> found, Gee.Collection<Music.Media> not_found);
		public abstract Music.Media? media_from_uri (string uri);
		public abstract Gee.Collection<Music.Media> medias_from_ids (Gee.Collection<int64?> ids);
		public abstract Gee.Collection<Music.Media> medias_from_uris (Gee.Collection<string> uris);
		public int playlist_count_without_read_only ();
		public abstract Music.StaticPlaylist? playlist_from_id (int64 id);
		public abstract Music.StaticPlaylist? playlist_from_name (string name);
		public abstract void remove_media (Music.Media s, bool trash);
		public abstract void remove_medias (Gee.Collection<Music.Media> to_remove, bool trash);
		public abstract void remove_playlist (int64 id);
		public abstract void remove_smart_playlist (int64 id);
		public abstract void search_medias (string search);
		public abstract Music.SmartPlaylist? smart_playlist_from_id (int64 id);
		public abstract Music.SmartPlaylist? smart_playlist_from_name (string name);
		public abstract bool start_file_operations (string? message);
		public abstract bool support_playlists ();
		public abstract bool support_smart_playlists ();
		public abstract void update_media (Music.Media s, bool update_meta, bool record_time);
		public abstract void update_medias (Gee.Collection<Music.Media> updates, bool update_meta, bool record_time);
		public signal void file_operations_done ();
		public signal void file_operations_started ();
		public signal void media_added (Gee.Collection<Music.Media> medias);
		public signal void media_imported (Gee.Collection<Music.Media> medias);
		public signal void media_removed (Gee.Collection<Music.Media> medias);
		public signal void media_updated (Gee.Collection<Music.Media> medias);
		public signal void playlist_added (Music.StaticPlaylist playlist);
		public signal void playlist_name_updated (Music.StaticPlaylist playlist);
		public signal void playlist_removed (Music.StaticPlaylist playlist);
		public signal void search_finished ();
		public signal void smartplaylist_added (Music.SmartPlaylist smartplaylist);
		public signal void smartplaylist_name_updated (Music.SmartPlaylist smartplaylist);
		public signal void smartplaylist_removed (Music.SmartPlaylist smartplaylist);
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class Media : GLib.Object {
		protected static string UNKNOWN;
		protected uint _rating;
		public Media (string uri);
		public Music.Media copy ();
		public Media.from_file (GLib.File file);
		public uint get_album_hashkey ();
		public string get_display_album ();
		public string get_display_album_artist (bool use_artist_fallback = true);
		public string get_display_artist ();
		public string get_display_composer ();
		public string get_display_filename ();
		public string get_display_genre ();
		public string get_display_location ();
		public string get_display_title ();
		public string get_title_markup ();
		public static bool is_valid_string_field (string? text);
		public virtual string album { get; set; }
		public virtual string album_artist { get; set; }
		public virtual uint album_count { get; set; }
		public virtual weak Music.Album album_info { get; set; }
		public virtual uint album_number { get; set; }
		public virtual string artist { get; set; }
		public virtual uint bitrate { get; set; }
		public virtual uint bpm { get; set; }
		public virtual string comment { get; set; }
		public virtual string composer { get; set; }
		public virtual uint date_added { get; set; }
		public virtual GLib.File file { get; set; }
		public virtual bool file_exists { get; }
		public virtual uint64 file_size { get; set; }
		public virtual string genre { get; set; }
		public virtual string grouping { get; set; }
		public virtual bool has_embedded { get; set; }
		public virtual bool is_preview { get; set; }
		public virtual bool is_temporary { get; set; }
		public virtual uint last_modified { get; set; }
		public virtual uint last_played { get; set; }
		public virtual uint length { get; set; }
		public virtual bool location_unknown { get; set; }
		public virtual string lyrics { get; set; }
		public virtual uint play_count { get; set; }
		public virtual uint rating { get; set; }
		public virtual int resume_pos { get; set; }
		public int64 rowid { get; set construct; }
		public virtual uint samplerate { get; set; }
		public virtual bool show { get; set; }
		public virtual bool show_indicator { get; set; }
		public virtual uint skip_count { get; set; }
		public virtual string title { get; set; }
		public virtual uint track { get; set; }
		public virtual uint track_count { get; set; }
		public virtual GLib.Icon unique_status_image { get; set; }
		public virtual string uri { owned get; set; }
		public virtual uint year { get; set; }
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class NotificationManager : GLib.Object {
		public NotificationManager ();
		public static Music.NotificationManager get_default ();
		public signal void progress_canceled ();
		public signal void show_alert (string title, string message);
		public signal void update_progress (string? message, double progress);
		public signal void update_track (string message);
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class Pipeline : GLib.Object {
		public Gst.Element audiobin;
		public Gst.Element audiosink;
		public Gst.Element audiosinkqueue;
		public Gst.Element audiotee;
		public Gst.Bus bus;
		public Music.Equalizer eq;
		public Gst.Element eq_audioconvert;
		public Gst.Element eq_audioconvert2;
		public Gst.Pad pad;
		public Gst.Pipeline pipe;
		public Gst.Element playbin;
		public Gst.Element preamp;
		public Pipeline ();
		public void disable_equalizer ();
		public void enable_equalizer ();
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public abstract class Playlist : GLib.Object {
		public GLib.Icon icon;
		protected Playlist ();
		public abstract void add_media (Music.Media to_remove);
		public abstract void add_medias (Gee.Collection<Music.Media> to_add);
		public abstract void clear ();
		public new Music.Media @get (int index);
		public bool is_empty ();
		public Gee.Iterator<Music.Media> iterator ();
		public abstract void remove_media (Music.Media to_remove);
		public abstract void remove_medias (Gee.Collection<Music.Media> to_remove);
		public new void @set (int index, Music.Media m);
		public virtual Gee.ArrayList<Music.Media> medias { get; internal set; }
		public virtual string name { get; set; }
		public int64 rowid { get; set construct; }
		public signal void cleared ();
		public signal void media_added (Gee.Collection<Music.Media> media);
		public signal void media_removed (Gee.Collection<Music.Media> media);
		public signal void request_play ();
		public signal void updated (string? old_name = null);
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class SmartPlaylist : Music.Playlist {
		public enum ConditionalType {
			ALL,
			ANY
		}
		public Gee.TreeSet<Music.SmartQuery> queries;
		public SmartPlaylist (Music.Library library);
		public override void add_media (Music.Media m);
		public override void add_medias (Gee.Collection<Music.Media> to_add);
		public virtual void add_queries (Gee.Collection<Music.SmartQuery> queries);
		public virtual void add_query (Music.SmartQuery s);
		public virtual void analyse_all ();
		public override void clear ();
		public virtual void clear_queries ();
		public virtual Gee.Collection<Music.SmartQuery> get_queries ();
		public static bool media_matches_query (Music.SmartQuery q, Music.Media s);
		public override void remove_media (Music.Media to_remove);
		public override void remove_medias (Gee.Collection<Music.Media> to_remove);
		public virtual Music.SmartPlaylist.ConditionalType conditional { get; set; }
		public Music.Library library { get; set construct; }
		public virtual bool limit { get; set; }
		public virtual uint limit_amount { get; set; }
		public int query_count { get; set; }
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class SmartQuery : GLib.Object {
		public enum ComparatorType {
			IS,
			IS_NOT,
			CONTAINS,
			NOT_CONTAINS,
			IS_EXACTLY,
			IS_AT_MOST,
			IS_AT_LEAST,
			IS_WITHIN,
			IS_BEFORE
		}
		public enum FieldType {
			ALBUM,
			ARTIST,
			BITRATE,
			COMMENT,
			COMPOSER,
			DATE_ADDED,
			GENRE,
			GROUPING,
			LAST_PLAYED,
			LENGTH,
			PLAYCOUNT,
			RATING,
			SKIPCOUNT,
			TITLE,
			YEAR,
			URI
		}
		public SmartQuery ();
		public SmartQuery.with_info (Music.SmartQuery.FieldType field, Music.SmartQuery.ComparatorType comparator, GLib.Value value);
		public Music.SmartQuery.ComparatorType comparator { get; set; }
		public Music.SmartQuery.FieldType field { get; set; }
		public int rowid { get; set; }
		public GLib.Value value { get; set; }
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public class StaticPlaylist : Music.Playlist {
		public StaticPlaylist ();
		public override void add_media (Music.Media m);
		public override void add_medias (Gee.Collection<Music.Media> to_add);
		public override void clear ();
		public override void remove_media (Music.Media to_remove);
		public override void remove_medias (Gee.Collection<Music.Media> to_remove);
		public StaticPlaylist.with_info (int rowid, string name);
		public bool allow_duplicate { get; set; }
		public bool read_only { get; set; }
		public bool show_badge { get; set; }
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public interface Device : GLib.Object {
		public Gee.Collection<Music.Media> delete_doubles (Gee.Collection<Music.Media> source_list, Gee.Collection<Music.Media> to_remove);
		public abstract void eject ();
		public abstract void finish_initialization ();
		public abstract uint64 get_capacity ();
		public abstract string get_content_type ();
		public abstract Gtk.Widget? get_custom_view ();
		public abstract string get_display_name ();
		public abstract string get_empty_device_description ();
		public abstract string get_empty_device_title ();
		public abstract string get_fancy_capacity ();
		public abstract string get_fancy_description ();
		public abstract uint64 get_free_space ();
		public abstract GLib.Icon get_icon ();
		public abstract Music.Library get_library ();
		public abstract GLib.Mount? get_mount ();
		public virtual string get_unique_identifier ();
		public abstract string get_uri ();
		public abstract uint64 get_used_space ();
		public abstract bool only_use_custom_view ();
		public abstract bool read_only ();
		public abstract void set_display_name (string name);
		public abstract void set_icon (GLib.Icon icon);
		public abstract void set_mount (GLib.Mount mount);
		public abstract bool start_initialization ();
		public abstract void synchronize ();
		public abstract void unmount ();
		public bool will_fit (Gee.Collection<Music.Media> list);
		public signal void device_unmounted ();
		public signal void infobar_message (string label, Gtk.MessageType message_type);
		public signal void initialized (Music.Device d);
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public interface LibraryWindowInterface : GLib.Object {
		public abstract async void update_sensitivities ();
		public signal void media_half_played (Music.Media m);
		public signal void source_list_added (GLib.Object o, int view_number);
		public signal void update_media_info (Music.Media m);
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public interface Playback : GLib.Object {
		public abstract void disable_equalizer ();
		public abstract void enable_equalizer ();
		public abstract int64 get_duration ();
		public abstract int64 get_position ();
		public abstract Gee.Collection<string> get_supported_uri ();
		public abstract double get_volume ();
		public abstract void pause ();
		public abstract void play ();
		public abstract void set_equalizer_gain (int index, int val);
		public abstract void set_media (Music.Media media);
		public abstract void set_position (int64 pos);
		public abstract void set_state (Gst.State s);
		public abstract void set_volume (double val);
		public abstract bool update_position ();
		public signal void current_position_update (int64 position);
		public signal void end_of_stream ();
		public signal void error_occured ();
	}
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public static Music.LibrariesManager libraries_manager;
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public const string[] MEDIA_CONTENT_TYPES;
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public const string MUSIC_PLAYLIST;
}
namespace Build {
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public const string APP_ID;
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public const string DATADIR;
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public const string EXEC_NAME;
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public const string GETTEXT_PACKAGE;
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public const string PLUGIN_DIR;
	[CCode (cheader_filename = "io.elementary.music-core.h")]
	public const string VERSION;
}
