/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.board;

import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.board.BArray;
import net.sourceforge.plantuml.board.BNode;
import net.sourceforge.plantuml.board.BoardDiagram;
import net.sourceforge.plantuml.board.CardBox;
import net.sourceforge.plantuml.board.PostIt;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Activity {
    private final BNode node;
    private final ISkinParam skinParam;
    private BNode cursor;
    private final BoardDiagram boardDiagram;
    private BArray array;

    public Activity(BoardDiagram boardDiagram, String name, ISkinParam skinParam) {
        this.boardDiagram = boardDiagram;
        this.node = new BNode(0, name);
        this.skinParam = skinParam;
        this.cursor = this.node;
    }

    public TextBlock getBox() {
        return new CardBox(Display.create(this.node.getName()), this.skinParam);
    }

    public void addRelease(int stage, String label) {
        if (stage <= 0) {
            throw new IllegalArgumentException();
        }
        BNode newNode = new BNode(stage, label);
        while (true) {
            if (stage > this.cursor.getStage()) {
                this.cursor.addChild(newNode);
                this.cursor = newNode;
                return;
            }
            this.cursor = this.cursor.getParent();
        }
    }

    private BArray getArray() {
        if (this.array == null) {
            this.node.computeX(new AtomicInteger());
            this.array = new BArray();
            this.node.initBarray(this.array);
        }
        return this.array;
    }

    public double getFullWidth() {
        BArray array = this.getArray();
        return (double)(array.getMaxX() + 1) * PostIt.getWidth();
    }

    public int getMaxStage() {
        BArray array = this.getArray();
        return array.getMaxY();
    }

    public void drawMe(UGraphic ug) {
        this.getBox().drawU(ug);
        BArray array = this.getArray();
        for (BNode node : array) {
            double dx = (double)node.getX() * PostIt.getWidth();
            double dy = (double)node.getStage() * PostIt.getHeight();
            ug.apply(new UTranslate(dx, dy));
            CardBox box = new CardBox(Display.create(node.getName()), this.skinParam);
            box.drawU(ug.apply(new UTranslate(dx, dy)));
        }
    }
}

