/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.entity;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.protege.editor.core.ui.menu.MenuButton;
import org.protege.editor.owl.model.entity.EntityBannerView;

public class EntityBannerViewImpl
implements EntityBannerView {
    private final MenuButton menuButton = new MenuButton();
    private final JLabel entityLabel = new JLabel();
    private final JPanel container = new JPanel(new BorderLayout(7, 7));
    private Optional<JPopupMenu> popupMenu = Optional.empty();

    public EntityBannerViewImpl() {
        this.container.add((Component)this.menuButton, "West");
        this.menuButton.setVerticalAlignment(0);
        this.container.add(this.entityLabel);
        this.entityLabel.setVerticalAlignment(0);
        this.menuButton.addActionListener(this::handleMenuButtonClicked);
    }

    @Override
    @Nonnull
    public JComponent asJComponent() {
        return this.container;
    }

    @Override
    public void setIcon(@Nonnull Icon icon) {
        this.entityLabel.setIcon((Icon)Preconditions.checkNotNull((Object)icon));
    }

    @Override
    public void setText(@Nonnull String text) {
        this.entityLabel.setText((String)Preconditions.checkNotNull((Object)text));
    }

    @Override
    public void clear() {
        this.entityLabel.setIcon(null);
        this.entityLabel.setText("");
    }

    @Override
    public void setMenuVisible(boolean visible) {
        this.menuButton.setVisible(visible);
    }

    @Override
    public void setMenuEnabled(boolean enabled) {
        this.menuButton.setEnabled(enabled);
    }

    @Override
    public void setPopupMenu(@Nonnull JPopupMenu popupMenu) {
        this.popupMenu = Optional.of(popupMenu);
    }

    private void handleMenuButtonClicked(ActionEvent e) {
        this.popupMenu.ifPresent(menu -> menu.show((Component)this.menuButton, 0, this.menuButton.getHeight() + 2));
    }
}

