/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.deprecation;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.AbstractOWLWizardPanel;
import org.protege.editor.owl.ui.deprecation.DeprecateEntityWizardState;
import org.protege.editor.owl.ui.deprecation.DeprecationWizardEntityRenderer;
import org.semanticweb.owlapi.model.OWLEntity;

public class DeprecationSummaryPage
extends AbstractOWLWizardPanel {
    public static final String ID = "DeprecationSummaryPage";
    @Nonnull
    private final OWLEntity entityToDeprecate;
    @Nonnull
    private final DeprecateEntityWizardState state;

    public DeprecationSummaryPage(@Nonnull OWLEditorKit owlEditorKit, @Nonnull OWLEntity entityToDeprecate, @Nonnull DeprecateEntityWizardState state) {
        super(ID, "Summary", owlEditorKit);
        this.entityToDeprecate = entityToDeprecate;
        this.state = state;
        StringBuilder instructions = new StringBuilder();
        instructions.append("Prot\u00e9g\u00e9 will deprecate ");
        instructions.append(DeprecationWizardEntityRenderer.renderer(this.getOWLModelManager()).getHtmlRendering(entityToDeprecate));
        instructions.append(".");
        state.getReplacementEntity().ifPresent(repl -> {
            instructions.append("  This entity will be replaced with ");
            instructions.append(DeprecationWizardEntityRenderer.renderer(this.getOWLModelManager()).getHtmlRendering((OWLEntity)repl));
            instructions.append(".");
        });
        instructions.append("\n\nPress Finish to close the wizard and perform the deprecation.");
        this.setInstructions(instructions.toString());
    }

    @Nullable
    public Object getNextPanelDescriptor() {
        return FINISH;
    }

    @Nullable
    public Object getBackPanelDescriptor() {
        if (this.state.getReplacementEntity().isPresent()) {
            return "DeprecationReplacementEntityPage";
        }
        return "AlternateEntitiesPage";
    }
}

