/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.BaseboardChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BaseboardChoiceComponent
extends JPanel
implements View {
    private NullableCheckBox visibleCheckBox;
    private JRadioButton sameColorAsWallRadioButton;
    private JRadioButton colorRadioButton;
    private ColorButton colorButton;
    private JRadioButton textureRadioButton;
    private JComponent textureComponent;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private JLabel thicknessLabel;
    private JSpinner thicknessSpinner;

    public BaseboardChoiceComponent(UserPreferences userPreferences, BaseboardChoiceController baseboardChoiceController) {
        super(new GridBagLayout());
        this.createComponents(userPreferences, baseboardChoiceController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences);
    }

    private void createComponents(UserPreferences userPreferences, final BaseboardChoiceController baseboardChoiceController) {
        this.visibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, BaseboardChoiceComponent.class, "visibleCheckBox.text", new Object[0]));
        this.visibleCheckBox.setNullable(baseboardChoiceController.getVisible() == null);
        this.visibleCheckBox.setValue(baseboardChoiceController.getVisible());
        this.visibleCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                baseboardChoiceController.setVisible(BaseboardChoiceComponent.this.visibleCheckBox.getValue());
            }
        });
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Boolean bl = baseboardChoiceController.getVisible();
                BaseboardChoiceComponent.this.visibleCheckBox.setValue(bl);
                boolean bl2 = bl != Boolean.FALSE;
                BaseboardChoiceComponent.this.sameColorAsWallRadioButton.setEnabled(bl2);
                BaseboardChoiceComponent.this.colorRadioButton.setEnabled(bl2);
                BaseboardChoiceComponent.this.textureRadioButton.setEnabled(bl2);
                BaseboardChoiceComponent.this.colorButton.setEnabled(bl2);
                ((JComponent)((Object)baseboardChoiceController.getTextureController().getView())).setEnabled(bl2);
                BaseboardChoiceComponent.this.heightSpinner.setEnabled(bl2);
                BaseboardChoiceComponent.this.thicknessSpinner.setEnabled(bl2);
            }
        };
        baseboardChoiceController.addPropertyChangeListener(BaseboardChoiceController.Property.VISIBLE, propertyChangeListener);
        this.sameColorAsWallRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, BaseboardChoiceComponent.class, "sameColorAsWallRadioButton.text", new Object[0]));
        this.sameColorAsWallRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (BaseboardChoiceComponent.this.sameColorAsWallRadioButton.isSelected()) {
                    baseboardChoiceController.setPaint(BaseboardChoiceController.BaseboardPaint.DEFAULT);
                }
            }
        });
        baseboardChoiceController.addPropertyChangeListener(BaseboardChoiceController.Property.PAINT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BaseboardChoiceComponent.this.updateColorRadioButtons(baseboardChoiceController);
            }
        });
        this.colorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, BaseboardChoiceComponent.class, "colorRadioButton.text", new Object[0]));
        this.colorRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (BaseboardChoiceComponent.this.colorRadioButton.isSelected()) {
                    baseboardChoiceController.setPaint(BaseboardChoiceController.BaseboardPaint.COLORED);
                }
            }
        });
        baseboardChoiceController.addPropertyChangeListener(BaseboardChoiceController.Property.PAINT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BaseboardChoiceComponent.this.updateColorRadioButtons(baseboardChoiceController);
            }
        });
        this.colorButton = new ColorButton(userPreferences);
        this.colorButton.setColorDialogTitle(userPreferences.getLocalizedString(BaseboardChoiceComponent.class, "colorDialog.title", new Object[0]));
        this.colorButton.setColor(baseboardChoiceController.getColor());
        this.colorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                baseboardChoiceController.setColor(BaseboardChoiceComponent.this.colorButton.getColor());
                baseboardChoiceController.setPaint(BaseboardChoiceController.BaseboardPaint.COLORED);
            }
        });
        baseboardChoiceController.addPropertyChangeListener(BaseboardChoiceController.Property.COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BaseboardChoiceComponent.this.colorButton.setColor(baseboardChoiceController.getColor());
            }
        });
        this.textureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, BaseboardChoiceComponent.class, "textureRadioButton.text", new Object[0]));
        this.textureRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (BaseboardChoiceComponent.this.textureRadioButton.isSelected()) {
                    baseboardChoiceController.setPaint(BaseboardChoiceController.BaseboardPaint.TEXTURED);
                }
            }
        });
        this.textureComponent = (JComponent)((Object)baseboardChoiceController.getTextureController().getView());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.colorRadioButton);
        buttonGroup.add(this.textureRadioButton);
        buttonGroup.add(this.sameColorAsWallRadioButton);
        this.updateColorRadioButtons(baseboardChoiceController);
        String string = userPreferences.getLengthUnit().getName();
        float f = userPreferences.getLengthUnit().getMinimumLength();
        this.heightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, BaseboardChoiceComponent.class, "heightLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, baseboardChoiceController.getMaxHeight() == null ? userPreferences.getLengthUnit().getMaximumLength() / 10.0f : baseboardChoiceController.getMaxHeight().floatValue());
        this.heightSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.setNullable(baseboardChoiceController.getHeight() == null);
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        baseboardChoiceController.addPropertyChangeListener(BaseboardChoiceController.Property.HEIGHT, propertyChangeListener2);
        if (baseboardChoiceController.getHeight() != null && baseboardChoiceController.getMaxHeight() != null) {
            nullableSpinnerLengthModel.setLength(Float.valueOf(Math.min(baseboardChoiceController.getHeight().floatValue(), baseboardChoiceController.getMaxHeight().floatValue())));
        } else {
            nullableSpinnerLengthModel.setLength(baseboardChoiceController.getHeight());
        }
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                baseboardChoiceController.removePropertyChangeListener(BaseboardChoiceController.Property.HEIGHT, propertyChangeListener2);
                baseboardChoiceController.setHeight(nullableSpinnerLengthModel.getLength());
                baseboardChoiceController.addPropertyChangeListener(BaseboardChoiceController.Property.HEIGHT, propertyChangeListener2);
            }
        });
        baseboardChoiceController.addPropertyChangeListener(BaseboardChoiceController.Property.MAX_HEIGHT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getOldValue() == null || baseboardChoiceController.getMaxHeight() != null && ((Number)((Object)nullableSpinnerLengthModel.getMaximum())).floatValue() < baseboardChoiceController.getMaxHeight().floatValue()) {
                    nullableSpinnerLengthModel.setMaximum(baseboardChoiceController.getMaxHeight());
                }
            }
        });
        this.thicknessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, BaseboardChoiceComponent.class, "thicknessLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f, 2.0f);
        this.thicknessSpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.setNullable(baseboardChoiceController.getThickness() == null);
        nullableSpinnerLengthModel2.setLength(baseboardChoiceController.getThickness());
        final PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel2.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        baseboardChoiceController.addPropertyChangeListener(BaseboardChoiceController.Property.THICKNESS, propertyChangeListener3);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                baseboardChoiceController.removePropertyChangeListener(BaseboardChoiceController.Property.THICKNESS, propertyChangeListener3);
                baseboardChoiceController.setThickness(nullableSpinnerLengthModel2.getLength());
                baseboardChoiceController.addPropertyChangeListener(BaseboardChoiceController.Property.THICKNESS, propertyChangeListener3);
            }
        });
        propertyChangeListener.propertyChange(null);
    }

    private void updateColorRadioButtons(BaseboardChoiceController baseboardChoiceController) {
        if (baseboardChoiceController.getPaint() == BaseboardChoiceController.BaseboardPaint.COLORED) {
            this.colorRadioButton.setSelected(true);
        } else if (baseboardChoiceController.getPaint() == BaseboardChoiceController.BaseboardPaint.TEXTURED) {
            this.textureRadioButton.setSelected(true);
        } else if (baseboardChoiceController.getPaint() == BaseboardChoiceController.BaseboardPaint.DEFAULT) {
            this.sameColorAsWallRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.colorRadioButton, this.textureRadioButton, this.sameColorAsWallRadioButton);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.visibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BaseboardChoiceComponent.class, "visibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.sameColorAsWallRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BaseboardChoiceComponent.class, "sameColorAsWallRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.colorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BaseboardChoiceComponent.class, "colorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.textureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BaseboardChoiceComponent.class, "textureRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BaseboardChoiceComponent.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
            this.heightLabel.setLabelFor(this.heightSpinner);
            this.thicknessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(BaseboardChoiceComponent.class, "thicknessLabel.mnemonic", new Object[0])).getKeyCode());
            this.thicknessLabel.setLabelFor(this.thicknessSpinner);
        }
    }

    private void layoutComponents(UserPreferences userPreferences) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        this.add((Component)this.visibleCheckBox, new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.sameColorAsWallRadioButton, new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, n2), 0, 0));
        this.add((Component)this.colorRadioButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 2, n2), 0, 0));
        this.add((Component)this.colorButton, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.textureRadioButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, n2), 0, 0));
        this.add((Component)this.textureComponent, new GridBagConstraints(4, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(3, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, Math.round(3.0f * SwingTools.getResolutionScale()), 0), 0, 0));
        this.add((Component)this.heightLabel, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        int n3 = OperatingSystem.isMacOSX() ? -20 : -10;
        this.add((Component)this.heightSpinner, new GridBagConstraints(4, 5, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, n2, 0), n3, 0));
        this.add((Component)this.thicknessLabel, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, n2), 0, 0));
        this.add((Component)this.thicknessSpinner, new GridBagConstraints(4, 6, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), n3, 0));
        this.setOpaque(false);
    }
}

