/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class PolygonAttributesRetained
extends NodeComponentRetained {
    static final int POLYGON_MODE_CHANGED = 1;
    static final int POLYGON_CULL_CHANGED = 2;
    static final int POLYGON_OFFSET_CHANGED = 4;
    static final int POLYGON_BACKFACENORMALFLIP_CHANGED = 8;
    static final int POLYGON_OFFSETFACTOR_CHANGED = 16;
    int polygonMode = 2;
    int cullFace = 1;
    boolean backFaceNormalFlip = false;
    float polygonOffset;
    float polygonOffsetFactor;

    PolygonAttributesRetained() {
    }

    final void initCullFace(int n) {
        this.cullFace = n;
    }

    final void setCullFace(int n) {
        this.initCullFace(n);
        this.sendMessage(2, new Integer(n));
    }

    final int getCullFace() {
        return this.cullFace;
    }

    final void initBackFaceNormalFlip(boolean bl) {
        this.backFaceNormalFlip = bl;
    }

    final void setBackFaceNormalFlip(boolean bl) {
        this.initBackFaceNormalFlip(bl);
        this.sendMessage(8, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getBackFaceNormalFlip() {
        return this.backFaceNormalFlip;
    }

    final void initPolygonMode(int n) {
        this.polygonMode = n;
    }

    final void setPolygonMode(int n) {
        this.initPolygonMode(n);
        this.sendMessage(1, new Integer(n));
    }

    final int getPolygonMode() {
        return this.polygonMode;
    }

    final void initPolygonOffset(float f) {
        this.polygonOffset = f;
    }

    final void setPolygonOffset(float f) {
        this.initPolygonOffset(f);
        this.sendMessage(4, new Float(f));
    }

    final float getPolygonOffset() {
        return this.polygonOffset;
    }

    final void initPolygonOffsetFactor(float f) {
        this.polygonOffsetFactor = f;
    }

    final void setPolygonOffsetFactor(float f) {
        this.initPolygonOffsetFactor(f);
        this.sendMessage(16, new Float(f));
    }

    final float getPolygonOffsetFactor() {
        return this.polygonOffsetFactor;
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                PolygonAttributesRetained polygonAttributesRetained = new PolygonAttributesRetained();
                polygonAttributesRetained.set(this);
                polygonAttributesRetained.source = this.source;
                this.mirror = polygonAttributesRetained;
            }
        } else {
            ((PolygonAttributesRetained)this.mirror).set(this);
        }
    }

    void updateNative(Context context) {
        Pipeline.getPipeline().updatePolygonAttributes(context, this.polygonMode, this.cullFace, this.backFaceNormalFlip, this.polygonOffset, this.polygonOffsetFactor);
    }

    @Override
    synchronized void initMirrorObject() {
        ((PolygonAttributesRetained)this.mirror).set(this);
    }

    @Override
    synchronized void updateMirrorObject(int n, Object object) {
        PolygonAttributesRetained polygonAttributesRetained = (PolygonAttributesRetained)this.mirror;
        if ((n & 1) != 0) {
            polygonAttributesRetained.polygonMode = (Integer)object;
        } else if ((n & 2) != 0) {
            polygonAttributesRetained.cullFace = (Integer)object;
        } else if ((n & 8) != 0) {
            polygonAttributesRetained.backFaceNormalFlip = (Boolean)object;
        } else if ((n & 4) != 0) {
            polygonAttributesRetained.polygonOffset = ((Float)object).floatValue();
        } else if ((n & 0x10) != 0) {
            polygonAttributesRetained.polygonOffsetFactor = ((Float)object).floatValue();
        }
    }

    boolean equivalent(PolygonAttributesRetained polygonAttributesRetained) {
        return polygonAttributesRetained != null && polygonAttributesRetained.cullFace == this.cullFace && polygonAttributesRetained.backFaceNormalFlip == this.backFaceNormalFlip && polygonAttributesRetained.polygonOffset == this.polygonOffset && polygonAttributesRetained.polygonMode == this.polygonMode && polygonAttributesRetained.polygonOffsetFactor == this.polygonOffsetFactor;
    }

    protected void set(PolygonAttributesRetained polygonAttributesRetained) {
        super.set(polygonAttributesRetained);
        this.cullFace = polygonAttributesRetained.cullFace;
        this.backFaceNormalFlip = polygonAttributesRetained.backFaceNormalFlip;
        this.polygonMode = polygonAttributesRetained.polygonMode;
        this.polygonOffset = polygonAttributesRetained.polygonOffset;
        this.polygonOffsetFactor = polygonAttributesRetained.polygonOffsetFactor;
    }

    final void sendMessage(int n, Object object) {
        ArrayList<VirtualUniverse> arrayList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 9;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 9;
            j3dMessage.universe = arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList<GeometryAtom> arrayList3 = arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    @Override
    void handleFrequencyChange(int n) {
        if (n == 1 || n == 7 || n == 3 || n == 5) {
            this.setFrequencyChangeMask(n, 1);
        }
    }
}

