/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.MAC;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;

public class KnownHosts
implements HostKeyRepository {
    private static final String _known_hosts = "known_hosts";
    private JSch jsch = null;
    private String known_hosts = null;
    private Vector pool = null;
    private MAC hmacsha1 = null;
    private static final byte[] space = new byte[]{32};
    private static final byte[] cr = Util.str2byte("\n");

    KnownHosts(JSch jSch) {
        this.jsch = jSch;
        this.pool = new Vector();
    }

    void setKnownHosts(String string) throws JSchException {
        try {
            this.known_hosts = string;
            FileInputStream fileInputStream = new FileInputStream(Util.checkTilde(string));
            this.setKnownHosts(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JSchException(fileNotFoundException.toString(), fileNotFoundException);
        }
    }

    void setKnownHosts(InputStream inputStream) throws JSchException {
        this.pool.removeAllElements();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            InputStream inputStream2 = inputStream;
            String string = null;
            byte[] byArray = new byte[1024];
            int n = 0;
            block9: while (true) {
                byte by;
                Object object;
                int n2;
                n = 0;
                while (true) {
                    if ((n2 = inputStream2.read()) == -1) {
                        if (n != 0) break;
                        break block9;
                    }
                    if (n2 == 13) continue;
                    if (n2 == 10) break;
                    if (byArray.length <= n) {
                        if (n > 10240) break;
                        object = new byte[byArray.length * 2];
                        System.arraycopy(byArray, 0, object, 0, byArray.length);
                        byArray = object;
                    }
                    byArray[n++] = (byte)n2;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    by = byArray[n2];
                    if (by == 32 || by == 9) {
                        continue;
                    }
                    if (by != 35) break;
                    this.addInvalidLine(Util.byte2str(byArray, 0, n));
                    continue block9;
                }
                if (n2 >= n) {
                    this.addInvalidLine(Util.byte2str(byArray, 0, n));
                    continue;
                }
                stringBuffer.setLength(0);
                while (n2 < n && (by = byArray[n2++]) != 32 && by != 9) {
                    stringBuffer.append((char)by);
                }
                String string2 = stringBuffer.toString();
                if (n2 >= n || string2.length() == 0) {
                    this.addInvalidLine(Util.byte2str(byArray, 0, n));
                    continue;
                }
                while (n2 < n && ((by = byArray[n2]) == 32 || by == 9)) {
                    ++n2;
                }
                object = "";
                if (string2.charAt(0) == '@') {
                    object = string2;
                    stringBuffer.setLength(0);
                    while (n2 < n && (by = byArray[n2++]) != 32 && by != 9) {
                        stringBuffer.append((char)by);
                    }
                    string2 = stringBuffer.toString();
                    if (n2 >= n || string2.length() == 0) {
                        this.addInvalidLine(Util.byte2str(byArray, 0, n));
                        continue;
                    }
                    while (n2 < n && ((by = byArray[n2]) == 32 || by == 9)) {
                        ++n2;
                    }
                }
                stringBuffer.setLength(0);
                int n3 = -1;
                while (n2 < n && (by = byArray[n2++]) != 32 && by != 9) {
                    stringBuffer.append((char)by);
                }
                String string3 = stringBuffer.toString();
                if (HostKey.name2type(string3) != 6) {
                    n3 = HostKey.name2type(string3);
                } else {
                    n2 = n;
                }
                if (n2 >= n) {
                    this.addInvalidLine(Util.byte2str(byArray, 0, n));
                    continue;
                }
                while (n2 < n && ((by = byArray[n2]) == 32 || by == 9)) {
                    ++n2;
                }
                stringBuffer.setLength(0);
                while (n2 < n) {
                    if ((by = byArray[n2++]) == 13) continue;
                    if (by == 10 || by == 32 || by == 9) break;
                    stringBuffer.append((char)by);
                }
                if ((string = stringBuffer.toString()).length() == 0) {
                    this.addInvalidLine(Util.byte2str(byArray, 0, n));
                    continue;
                }
                while (n2 < n && ((by = byArray[n2]) == 32 || by == 9)) {
                    ++n2;
                }
                String string4 = null;
                if (n2 < n) {
                    stringBuffer.setLength(0);
                    while (n2 < n) {
                        if ((by = byArray[n2++]) == 13) continue;
                        if (by == 10) break;
                        stringBuffer.append((char)by);
                    }
                    string4 = stringBuffer.toString();
                }
                HashedHostKey hashedHostKey = null;
                hashedHostKey = new HashedHostKey((String)object, string2, n3, Util.fromBase64(Util.str2byte(string), 0, string.length()), string4);
                this.pool.addElement(hashedHostKey);
            }
            if (bl) {
                throw new JSchException("KnownHosts: invalid format");
            }
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new JSchException(iOException.toString(), iOException);
            }
        }
    }

    private void addInvalidLine(String string) throws JSchException {
        HostKey hostKey = new HostKey(string, 6, null);
        this.pool.addElement(hostKey);
    }

    String getKnownHostsFile() {
        return this.known_hosts;
    }

    @Override
    public String getKnownHostsRepositoryID() {
        return this.known_hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int check(String string, byte[] byArray) {
        int n = 1;
        if (string == null) {
            return n;
        }
        HostKey hostKey = null;
        try {
            hostKey = new HostKey(string, 0, byArray);
        }
        catch (JSchException jSchException) {
            return n;
        }
        Vector vector = this.pool;
        synchronized (vector) {
            for (int i = 0; i < this.pool.size(); ++i) {
                HostKey hostKey2 = (HostKey)this.pool.elementAt(i);
                if (!hostKey2.isMatched(string) || hostKey2.type != hostKey.type) continue;
                if (Util.array_equals(hostKey2.key, byArray)) {
                    return 0;
                }
                n = 2;
            }
        }
        if (n == 1 && string.startsWith("[") && string.indexOf("]:") > 1) {
            return this.check(string.substring(1, string.indexOf("]:")), byArray);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(HostKey hostKey, UserInfo userInfo) {
        int n;
        int n2 = hostKey.type;
        String string = hostKey.getHost();
        byte[] byArray = hostKey.key;
        HostKey hostKey2 = null;
        Object object = this.pool;
        synchronized (object) {
            for (n = 0; n < this.pool.size(); ++n) {
                hostKey2 = (HostKey)this.pool.elementAt(n);
                if (hostKey2.isMatched(string) && hostKey2.type != n2) continue;
            }
        }
        hostKey2 = hostKey;
        this.pool.addElement(hostKey2);
        object = this.getKnownHostsRepositoryID();
        if (object != null) {
            n = 1;
            File file = new File(Util.checkTilde((String)object));
            if (!file.exists()) {
                n = 0;
                if (userInfo != null) {
                    n = userInfo.promptYesNo((String)object + " does not exist.\nAre you sure you want to create it?") ? 1 : 0;
                    file = file.getParentFile();
                    if (n != 0 && file != null && !file.exists() && (n = (int)(userInfo.promptYesNo("The parent directory " + file + " does not exist.\nAre you sure you want to create it?") ? 1 : 0)) != 0) {
                        if (!file.mkdirs()) {
                            userInfo.showMessage(file + " has not been created.");
                            n = 0;
                        } else {
                            userInfo.showMessage(file + " has been succesfully created.\nPlease check its access permission.");
                        }
                    }
                    if (file == null) {
                        n = 0;
                    }
                }
            }
            if (n != 0) {
                try {
                    this.sync((String)object);
                }
                catch (Exception exception) {
                    System.err.println("sync known_hosts: " + exception);
                }
            }
        }
    }

    @Override
    public HostKey[] getHostKey() {
        return this.getHostKey(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostKey[] getHostKey(String string, String string2) {
        Vector vector = this.pool;
        synchronized (vector) {
            HostKey[] hostKeyArray;
            ArrayList<HostKey> arrayList = new ArrayList<HostKey>();
            for (int i = 0; i < this.pool.size(); ++i) {
                HostKey hostKey = (HostKey)this.pool.elementAt(i);
                if (hostKey.type == 6 || string != null && (!hostKey.isMatched(string) || string2 != null && !hostKey.getType().equals(string2))) continue;
                arrayList.add(hostKey);
            }
            HostKey[] hostKeyArray2 = new HostKey[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                hostKeyArray2[i] = (HostKey)arrayList.get(i);
            }
            if (string != null && string.startsWith("[") && string.indexOf("]:") > 1 && (hostKeyArray = this.getHostKey(string.substring(1, string.indexOf("]:")), string2)).length > 0) {
                HostKey[] hostKeyArray3 = new HostKey[hostKeyArray2.length + hostKeyArray.length];
                System.arraycopy(hostKeyArray2, 0, hostKeyArray3, 0, hostKeyArray2.length);
                System.arraycopy(hostKeyArray, 0, hostKeyArray3, hostKeyArray2.length, hostKeyArray.length);
                hostKeyArray2 = hostKeyArray3;
            }
            return hostKeyArray2;
        }
    }

    @Override
    public void remove(String string, String string2) {
        this.remove(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String string, String string2, byte[] byArray) {
        boolean bl = false;
        Vector vector = this.pool;
        synchronized (vector) {
            for (int i = 0; i < this.pool.size(); ++i) {
                HostKey hostKey = (HostKey)this.pool.elementAt(i);
                if (string != null && (!hostKey.isMatched(string) || string2 != null && (!hostKey.getType().equals(string2) || byArray != null && !Util.array_equals(byArray, hostKey.key)))) continue;
                String string3 = hostKey.getHost();
                if (string3.equals(string) || hostKey instanceof HashedHostKey && ((HashedHostKey)hostKey).isHashed()) {
                    this.pool.removeElement(hostKey);
                } else {
                    hostKey.host = this.deleteSubString(string3, string);
                }
                bl = true;
            }
        }
        if (bl) {
            try {
                this.sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void sync() throws IOException {
        if (this.known_hosts != null) {
            this.sync(this.known_hosts);
        }
    }

    protected synchronized void sync(String string) throws IOException {
        if (string == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(Util.checkTilde(string));
        this.dump(fileOutputStream);
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(OutputStream outputStream) throws IOException {
        try {
            Vector vector = this.pool;
            synchronized (vector) {
                for (int i = 0; i < this.pool.size(); ++i) {
                    HostKey hostKey = (HostKey)this.pool.elementAt(i);
                    String string = hostKey.getMarker();
                    String string2 = hostKey.getHost();
                    String string3 = hostKey.getType();
                    String string4 = hostKey.getComment();
                    if (string3.equals("UNKNOWN")) {
                        outputStream.write(Util.str2byte(string2));
                        outputStream.write(cr);
                        continue;
                    }
                    if (string.length() != 0) {
                        outputStream.write(Util.str2byte(string));
                        outputStream.write(space);
                    }
                    outputStream.write(Util.str2byte(string2));
                    outputStream.write(space);
                    outputStream.write(Util.str2byte(string3));
                    outputStream.write(space);
                    outputStream.write(Util.str2byte(hostKey.getKey()));
                    if (string4 != null) {
                        outputStream.write(space);
                        outputStream.write(Util.str2byte(string4));
                    }
                    outputStream.write(cr);
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private String deleteSubString(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = string2.length();
        int n4 = string.length();
        while (n2 < n4 && (n = string.indexOf(44, n2)) != -1) {
            if (!string2.equals(string.substring(n2, n))) {
                n2 = n + 1;
                continue;
            }
            return string.substring(0, n2) + string.substring(n + 1);
        }
        if (string.endsWith(string2) && n4 - n2 == n3) {
            return string.substring(0, n3 == n4 ? 0 : n4 - n3 - 1);
        }
        return string;
    }

    private synchronized MAC getHMACSHA1() {
        if (this.hmacsha1 == null) {
            try {
                Class<?> clazz = Class.forName(JSch.getConfig("hmac-sha1"));
                this.hmacsha1 = (MAC)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("hmacsha1: " + exception);
            }
        }
        return this.hmacsha1;
    }

    HostKey createHashedHostKey(String string, byte[] byArray) throws JSchException {
        HashedHostKey hashedHostKey = new HashedHostKey(string, byArray);
        hashedHostKey.hash();
        return hashedHostKey;
    }

    class HashedHostKey
    extends HostKey {
        private static final String HASH_MAGIC = "|1|";
        private static final String HASH_DELIM = "|";
        private boolean hashed;
        byte[] salt;
        byte[] hash;

        HashedHostKey(String string, byte[] byArray) throws JSchException {
            this(string, 0, byArray);
        }

        HashedHostKey(String string, int n, byte[] byArray) throws JSchException {
            this("", string, n, byArray, null);
        }

        HashedHostKey(String string, String string2, int n, byte[] byArray, String string3) throws JSchException {
            super(string, string2, n, byArray, string3);
            this.hashed = false;
            this.salt = null;
            this.hash = null;
            if (this.host.startsWith(HASH_MAGIC) && this.host.substring(HASH_MAGIC.length()).indexOf(HASH_DELIM) > 0) {
                String string4 = this.host.substring(HASH_MAGIC.length());
                String string5 = string4.substring(0, string4.indexOf(HASH_DELIM));
                String string6 = string4.substring(string4.indexOf(HASH_DELIM) + 1);
                this.salt = Util.fromBase64(Util.str2byte(string5), 0, string5.length());
                this.hash = Util.fromBase64(Util.str2byte(string6), 0, string6.length());
                if (this.salt.length != 20 || this.hash.length != 20) {
                    this.salt = null;
                    this.hash = null;
                    return;
                }
                this.hashed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean isMatched(String string) {
            if (!this.hashed) {
                return super.isMatched(string);
            }
            MAC mAC = KnownHosts.this.getHMACSHA1();
            try {
                MAC mAC2 = mAC;
                synchronized (mAC2) {
                    mAC.init(this.salt);
                    byte[] byArray = Util.str2byte(string);
                    mAC.update(byArray, 0, byArray.length);
                    byte[] byArray2 = new byte[mAC.getBlockSize()];
                    mAC.doFinal(byArray2, 0);
                    return Util.array_equals(this.hash, byArray2);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                return false;
            }
        }

        boolean isHashed() {
            return this.hashed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void hash() {
            Object object;
            Object object2;
            if (this.hashed) {
                return;
            }
            MAC mAC = KnownHosts.this.getHMACSHA1();
            if (this.salt == null) {
                object = object2 = Session.random;
                synchronized (object) {
                    this.salt = new byte[mAC.getBlockSize()];
                    object2.fill(this.salt, 0, this.salt.length);
                }
            }
            try {
                object2 = mAC;
                synchronized (object2) {
                    mAC.init(this.salt);
                    object = Util.str2byte(this.host);
                    mAC.update((byte[])object, 0, ((Object)object).length);
                    this.hash = new byte[mAC.getBlockSize()];
                    mAC.doFinal(this.hash, 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.host = HASH_MAGIC + Util.byte2str(Util.toBase64(this.salt, 0, this.salt.length)) + HASH_DELIM + Util.byte2str(Util.toBase64(this.hash, 0, this.hash.length));
            this.hashed = true;
        }
    }
}

